/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.dms.http.SimpleRequest;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.NounDumperThread;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.NounTypeListener;
import oracle.dms.instrument.Rollup;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTrace;
import oracle.dms.reporter.Agency;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SimpleAgency;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Spy;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Noun
extends TreeNode
implements NounIntf {
    private static final String RU_SUFFIX = "_rollup";
    private static final String RU_DESCENDENTS = "descendents";
    private static final String RU_DESCENDENTS_DESC = "which descendents are canditate nouns for rollup";
    private static final String RU_COUNT = "rolled";
    private static final String RU_UNITS = "nouns";
    private static final String RU_COUNT_DESC = "number of nouns rolled up in aggregated metrics";
    private static final Level INITIAL_LOG_LEVEL = Level.NOTIFICATION;
    private Level _enabledLogLevel = Level.OFF;
    private HashMap _logProperties = null;
    private ArrayList _logWriters = new ArrayList();
    private ArrayList _cachedRefs = null;
    private static Hashtable _nounCache = new Hashtable();
    private static Vector _nounTypeListeners = new Vector(3);
    private static Hashtable _descMap = new Hashtable();
    private NounDescriptor _descptor = null;
    private long _createTime = System.currentTimeMillis();
    private static Noun _rootNoun = new Noun();
    private static int _status = 0;
    private Vector _childNouns = new Vector();
    private Vector _sensors = new Vector();
    private NounDumperThread _dumperThread = null;
    private boolean definitelyNotTraceable = false;
    private static final String NOUN_DESC = "Noun";
    private static final String ROOT_TYPE = "DMS_ROOT";
    private static final String DRILLDOWN_TYPE_PREFIX = "xxx_";
    private static final String DRILLDOWN_INDICATOR = "CALLS_TO";
    private String _type = "n/a";
    private static HashMap<String, ArrayList> _bucketTypes;
    private ArrayList<String> _bucketKeys = null;
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER";
    private static final String PARAM_ERROR = "PARAM_ERROR";
    private static final String PARAM_ERROR3 = "PARAM_ERROR3";
    private static final String NOUN_ROOT = "NOUN_ROOT";
    private static final String NOUN_INIT_ERROR = "NOUN_INIT_ERROR";
    private static final String NOT_ALIVE = "NOT_ALIVE";
    private static final String ALREADY_REMOVED = "ALREADY_REMOVED";
    private static final String CANT_DELETE_ROOT = "CANT_DELETE_ROOT";

    private Noun() {
        super(null, "Process" + DMSUtil.getProcessID(), NOUN_DESC);
        this._type = ROOT_TYPE;
        _rootNoun = this;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Level", Level.DEBUG.toString());
        this._logProperties = properties;
        this._enabledLogLevel = INITIAL_LOG_LEVEL;
        if (_status != 2) {
            try {
                Spy.init();
                _status = 1;
            }
            catch (Exception e) {
                System.err.println(DMSNLSupport.getMessage(NOUN_INIT_ERROR, new Object[]{e.toString()}, "Noun Could not initialize: " + e.toString()));
                e.printStackTrace();
            }
        }
    }

    public Noun(Noun parent, String name, String type) {
        super(parent, name, NOUN_DESC);
        Event evt;
        HashMap<String, Object> prop;
        if (type != null && type.length() > 0 && !type.equals("n/a")) {
            this._type = DMSUtil.sanitize(type, 511, true, true);
            if (_bucketTypes == null) {
                _bucketTypes = new HashMap();
            } else {
                this._bucketKeys = _bucketTypes.get(this._type);
            }
        }
        if (parent == null || name.length() < 1) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), parent, name, type}, "Malformed Noun: " + parent + ":" + name + ":" + type));
        }
        this._parent.childAdded(this);
        this._enabledLogLevel = INITIAL_LOG_LEVEL;
        if (DMSProperties.hasNounProperties() && (prop = DMSProperties.getNounProperties(this.toString())) != null) {
            List logwriters;
            String strLev = (String)prop.get("loglevel");
            if (strLev != null) {
                this.setLogLevel(Level.getLevel(strLev), false);
            }
            if ((logwriters = (List)prop.get("logwriter")) != null) {
                for (int i = 0; i < logwriters.size(); ++i) {
                    String lwName = (String)logwriters.get(i);
                    LogWriter lw = Log.getLogWriter(lwName);
                    if (lw == null) continue;
                    this.addLogWriter(lw);
                }
            }
        }
        if ((evt = StatisticsProducer._nounCreate) != null) {
            evt.occurred(new Object[]{this});
        } else {
            ++StatisticsProducer._nounCreateCount;
        }
        this.rememberType(null);
        if (TransTrace._isEnabled() && this.isTraceable()) {
            Tracer tr;
            if (this._type.equals("oc4j_servlet") && this._name.equals("jsp")) {
                this.definitelyNotTraceable = true;
            }
            if ((tr = ExecutionContext.get().getTracer()) != null) {
                tr.append(this, 7);
            }
        }
    }

    public static Noun create(String pathname, String type) {
        if (pathname == null || type == null || pathname.length() == 0) {
            throw new InstrumentationException(DMSNLSupport.getMessage(PARAM_ERROR3, new Object[]{"Noun.create()", pathname, type}, "Noun.create(): parameter check failed: pathname =" + pathname + ", type = " + type));
        }
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n;
        }
        String cleanpath = DMSUtil.removeTrailingDelimFromPath(pathname);
        String my_name = DMSUtil.getLeafFromPath(cleanpath);
        String parentName = DMSUtil.getParentFromPath(cleanpath);
        Noun parent = parentName.length() > 0 ? Noun.create(parentName) : Noun.getRoot();
        return Noun.create(parent, my_name, type);
    }

    public static Noun create(String pathname) {
        return Noun.create(pathname, "n/a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun create(Noun parent, String name, String type) {
        if (parent == null || type == null || name == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage(PARAM_ERROR, new Object[]{"Noun.create()", parent, name, type}, "Noun.create(): parameter check failed: parent= " + parent + ", name= " + name + ", type= " + type));
        }
        Noun noun = parent;
        synchronized (noun) {
            Noun n = parent.getChild(name);
            if (n != null) {
                return n;
            }
            return new Noun(parent, name, type);
        }
    }

    public static String getType(String pathname) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n.getType();
        }
        return null;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public boolean isTraceable() {
        return !this.definitelyNotTraceable && this._descptor != null && this._descptor.isTraceable();
    }

    public static void setType(String pathname, String type) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            n.setType(type);
        }
    }

    @Override
    public synchronized void setType(String type) {
        if (type != null && type.trim().length() > 0) {
            if ((type = DMSUtil.sanitize(type, 511, true, true)).equals(this._type)) {
                return;
            }
            NounDescriptor removedNounDescriptor = this.forgetType();
            if (!type.equals("n/a")) {
                this._type = type;
            }
            this.rememberType(removedNounDescriptor);
        }
    }

    public NounDescriptor getDescriptor() {
        return this._descptor;
    }

    public static Noun get(String pathname) {
        int nextDelim;
        if (pathname == null || pathname.length() == 0) {
            return null;
        }
        Noun noun = (Noun)_nounCache.get(pathname);
        if (noun != null) {
            return noun;
        }
        String sanitizedPathname = DMSUtil.sanitize(pathname, 511, false, false);
        if (sanitizedPathname.length() == 1) {
            return Noun.getRoot();
        }
        char delim = sanitizedPathname.charAt(0);
        Noun n = Noun.getRoot();
        int index = 1;
        boolean done = false;
        do {
            String name;
            if ((nextDelim = sanitizedPathname.indexOf(delim, index)) == index) {
                return null;
            }
            if (nextDelim < 0) {
                name = sanitizedPathname.substring(index);
                done = true;
            } else {
                name = sanitizedPathname.substring(index, nextDelim);
            }
            n = n.getChild(name);
            if (n == null) {
                return null;
            }
            if (!done) continue;
            n.addToCache(pathname);
            if (!pathname.equals(sanitizedPathname)) {
                n.addToCache(sanitizedPathname);
            }
            return n;
        } while ((index = nextDelim + 1) < sanitizedPathname.length());
        n.addToCache(pathname);
        if (!pathname.equals(sanitizedPathname)) {
            n.addToCache(sanitizedPathname);
        }
        return n;
    }

    private synchronized void addToCache(String pathname) {
        if (!this._alive) {
            return;
        }
        Noun prev = _nounCache.put(pathname, this);
        if (prev != null) {
            return;
        }
        if (this._cachedRefs == null) {
            this._cachedRefs = new ArrayList();
        }
        this._cachedRefs.add(pathname);
    }

    private synchronized void cleanupCache() {
        if (this._cachedRefs == null) {
            return;
        }
        for (int i = 0; i < this._cachedRefs.size(); ++i) {
            String key = (String)this._cachedRefs.get(i);
            _nounCache.remove(key);
        }
        this._cachedRefs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberType(NounDescriptor descriptor) {
        if (this == _rootNoun || "n/a".equals(this._type) || this._type.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return;
        }
        boolean createNounType = false;
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            if (descriptor == null) {
                this._descptor = (NounDescriptor)_descMap.get(this._type);
            } else {
                this._descptor = descriptor;
                this._descptor.setName(this._type);
            }
            if (this._descptor == null) {
                this._descptor = new NounDescriptor(this._type);
                _descMap.put(this._type, this._descptor);
                createNounType = true;
            } else if (!_descMap.containsKey(this._type)) {
                _descMap.put(this._type, this._descptor);
                createNounType = true;
            } else {
                this._descptor = (NounDescriptor)_descMap.get(this._type);
            }
            this._descptor.addNoun(this);
        }
        this._descptor.addAncestorTypes(this._parent);
        if (createNounType) {
            Vector listeners = (Vector)_nounTypeListeners.clone();
            Enumeration iter = listeners.elements();
            while (iter.hasMoreElements()) {
                NounTypeListener listener = (NounTypeListener)iter.nextElement();
                listener.created(this._type);
            }
            listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NounDescriptor forgetType() {
        if (this == _rootNoun || "n/a".equals(this._type) || this._type.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return null;
        }
        boolean removeNounType = false;
        NounDescriptor removedNounDescriptor = null;
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            this._descptor = (NounDescriptor)_descMap.get(this._type);
            if (this._descptor != null) {
                this._descptor.removeNoun(this);
                if (this._descptor.getNounCount() == 0) {
                    removedNounDescriptor = (NounDescriptor)_descMap.remove(this._type);
                    removeNounType = true;
                } else {
                    removedNounDescriptor = this._descptor.duplicateWithoutNouns();
                }
            }
        }
        if (removeNounType) {
            Vector listeners = (Vector)_nounTypeListeners.clone();
            Enumeration iter = listeners.elements();
            while (iter.hasMoreElements()) {
                NounTypeListener listener = (NounTypeListener)iter.nextElement();
                listener.removed(this._type);
            }
            listeners.clear();
        }
        return removedNounDescriptor;
    }

    public synchronized Sensor[] getSensors() {
        if (!this._alive) {
            return new Sensor[0];
        }
        Object[] retval = new Sensor[this._sensors.size()];
        this._sensors.copyInto(retval);
        return retval;
    }

    public synchronized Vector getMetrics() {
        Vector retval = new Vector();
        if (!this._alive) {
            return retval;
        }
        for (int i = this._sensors.size() - 1; i >= 0; --i) {
            Sensor sensor = (Sensor)this._sensors.elementAt(i);
            sensor.getMetrics(retval);
        }
        return retval;
    }

    @Override
    public synchronized Vector getNouns() {
        if (!this._alive) {
            return new Vector(0);
        }
        return (Vector)this._childNouns.clone();
    }

    int getNumChildNouns() {
        return this._childNouns.size();
    }

    protected synchronized void childAdded(Noun child) {
        int i;
        if (!this._alive) {
            return;
        }
        int numChildren = this._childNouns.size();
        String childName = child.getName();
        for (i = 0; i < numChildren; ++i) {
            Noun n = (Noun)this._childNouns.elementAt(i);
            if (childName.compareTo(n._name) <= 0) break;
        }
        this._childNouns.insertElementAt(child, i);
    }

    protected synchronized void sensorAdded(Sensor sensor) {
        Sensor s;
        int i;
        if (!this._alive) {
            return;
        }
        int numSensors = this._sensors.size();
        String sensorName = sensor.getName();
        for (i = 0; i < numSensors && sensorName.compareTo((s = (Sensor)this._sensors.elementAt(i)).getName()) > 0; ++i) {
        }
        this._sensors.insertElementAt(sensor, i);
    }

    protected synchronized void childDestroyed(Noun child) {
        if (!this._childNouns.removeElement(child)) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ALREADY_REMOVED, new Object[]{child.getClass().getName()}));
        }
    }

    protected synchronized void sensorDestroyed(Sensor sensor) {
        if (!this._sensors.removeElement(sensor)) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ALREADY_REMOVED, new Object[]{sensor.getClass().getName()}));
        }
    }

    public static Noun getRoot() {
        return _rootNoun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            Noun parent;
            Noun noun = parent = this.getParent();
            synchronized (noun) {
                Noun noun2 = this;
                synchronized (noun2) {
                    if (!this._alive) {
                        return;
                    }
                    super.destroy();
                    this._alive = false;
                    this.cleanupCache();
                    Event evt = StatisticsProducer._nounDestroy;
                    if (evt != null) {
                        evt.occurred(new Object[]{this});
                    }
                    this.forgetType();
                    this._parent.childDestroyed(this);
                    this.invalidateSubtree();
                }
            }
            this.disableDumping();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void invalidateSubtree() {
        while (this._sensors.size() > 0) {
            Sensor sensor = (Sensor)this._sensors.firstElement();
            sensor.destroy();
        }
        while (this._childNouns.size() > 0) {
            Noun child = (Noun)this._childNouns.firstElement();
            child.destroy();
        }
    }

    public TreeNode search(TreeNode previous, String matchStr) {
        TreeNode[] nodes = this.search(matchStr);
        return nodes == null ? null : nodes[0];
    }

    public TreeNode[] search(String matchStr) {
        Vector holder = new Vector();
        this.doSearch(matchStr, holder);
        if (holder.size() == 0) {
            return null;
        }
        Object[] retval = new TreeNode[holder.size()];
        holder.copyInto(retval);
        return retval;
    }

    private void doSearch(String matchStr, Vector holder) {
        int i;
        Vector mets;
        if (this._name.indexOf(matchStr) != -1) {
            holder.addElement(this);
        }
        if ((mets = this.getMetrics()) != null) {
            for (i = mets.size() - 1; i >= 0; --i) {
                Metric met = (Metric)mets.elementAt(i);
                String metname = met.getName();
                if (metname.indexOf(matchStr) == -1) continue;
                holder.addElement(met);
            }
        }
        if (this._childNouns != null) {
            for (i = this._childNouns.size() - 1; i >= 0; --i) {
                Noun child = (Noun)this._childNouns.elementAt(i);
                child.doSearch(matchStr, holder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Noun[] getDescendants(boolean recurse, String type) {
        if (recurse) {
            return this.getDescendants(type);
        }
        int j = 0;
        int kids = 0;
        Noun[] all = null;
        Noun noun = this;
        synchronized (noun) {
            kids = this._childNouns.size();
            all = new Noun[kids];
            Noun kid = null;
            for (int i = 0; i < kids; ++i) {
                kid = (Noun)this._childNouns.elementAt(i);
                if (!type.equals(kid.getType())) continue;
                all[j++] = kid;
            }
        }
        if (j == 0) {
            return null;
        }
        kids = j;
        Noun[] type_nouns = new Noun[kids];
        for (int i = 0; i < kids; ++i) {
            type_nouns[i] = all[i];
        }
        return type_nouns;
    }

    public synchronized TreeNode[] getDescendants(boolean recurse) {
        if (!this._alive) {
            return new TreeNode[0];
        }
        Vector<Noun> holder = new Vector<Noun>();
        if (!recurse) {
            int i;
            holder.addElement(this);
            Vector mets = this.getMetrics();
            for (i = mets.size() - 1; i >= 0; --i) {
                holder.addElement((Noun)mets.elementAt(i));
            }
            for (i = this._childNouns.size() - 1; i >= 0; --i) {
                holder.addElement((Noun)this._childNouns.elementAt(i));
            }
        } else {
            this.getDescendants(holder);
        }
        Object[] array = new TreeNode[holder.size()];
        holder.copyInto(array);
        return array;
    }

    public synchronized void getDescendants(Vector holder) {
        int i;
        if (!this._alive) {
            return;
        }
        holder.addElement(this);
        Vector mets = this.getMetrics();
        for (i = mets.size() - 1; i >= 0; --i) {
            holder.addElement(mets.elementAt(i));
        }
        for (i = this._childNouns.size() - 1; i >= 0; --i) {
            Noun noun = (Noun)this._childNouns.elementAt(i);
            noun.getDescendants(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun[] getNounsByType(String type) {
        if (type == null || type.length() == 0 || "n/a".equals(type)) {
            return null;
        }
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            NounDescriptor ndesc = (NounDescriptor)_descMap.get(type);
            if (ndesc != null) {
                return ndesc.getNouns();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAllTypes() {
        String[] ret = null;
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            ret = new String[_descMap.size()];
            _descMap.keySet().toArray(ret);
        }
        return ret;
    }

    public static int getTypeCount() {
        return _descMap.size();
    }

    public static NounDescriptor getDescriptorByType(String type) {
        if (type == null || type.length() == 0) {
            return null;
        }
        return (NounDescriptor)_descMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNounTypeListener(NounTypeListener listener) {
        if (listener == null) {
            return;
        }
        Cloneable cloneable = _nounTypeListeners;
        synchronized (cloneable) {
            if (_nounTypeListeners.contains(listener)) {
                return;
            }
            _nounTypeListeners.add(listener);
        }
        cloneable = _descMap;
        synchronized (cloneable) {
            Enumeration iter = _descMap.keys();
            while (iter.hasMoreElements()) {
                String nounType = (String)iter.nextElement();
                listener.created(nounType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNounTypeListener(NounTypeListener listener) {
        if (listener == null) {
            return;
        }
        Cloneable cloneable = _nounTypeListeners;
        synchronized (cloneable) {
            if (!_nounTypeListeners.contains(listener)) {
                return;
            }
            _nounTypeListeners.remove(listener);
        }
        cloneable = _descMap;
        synchronized (cloneable) {
            Enumeration iter = _descMap.keys();
            while (iter.hasMoreElements()) {
                String nounType = (String)iter.nextElement();
                listener.removed(nounType);
            }
        }
    }

    public Noun[] getDescendants(String type) {
        if (type == null) {
            return null;
        }
        Vector holder = this.getDescendantsByType(type);
        int size = holder.size();
        if (size == 0) {
            return null;
        }
        Object[] nouns = new Noun[size];
        holder.copyInto(nouns);
        return nouns;
    }

    private Vector getDescendantsByType(String type) {
        Vector<Noun> descendants = new Vector<Noun>();
        if (type == null || type.length() == 0 || "n/a".equals(type)) {
            return descendants;
        }
        Noun[] nouns = Noun.getNounsByType(type);
        if (nouns == null) {
            return descendants;
        }
        block0: for (int i = nouns.length - 1; i >= 0; --i) {
            if (this == _rootNoun || nouns[i] == this) {
                descendants.addElement(nouns[i]);
                continue;
            }
            Noun n = nouns[i];
            while (n != _rootNoun) {
                if (n == this) {
                    descendants.addElement(nouns[i]);
                    continue block0;
                }
                n = n._parent;
            }
        }
        return descendants;
    }

    public synchronized Noun getChild(String name) {
        for (int i = 0; i < this._childNouns.size(); ++i) {
            Noun n = (Noun)this._childNouns.elementAt(i);
            if (!n._name.equals(name)) continue;
            return n;
        }
        return null;
    }

    @Override
    public synchronized Sensor getSensor(String name) {
        for (int i = 0; i < this._sensors.size(); ++i) {
            Sensor s = (Sensor)this._sensors.elementAt(i);
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public static Noun create(String pathname, String type, Properties properties) {
        Noun n = Noun.create(pathname, type);
        if (n != null) {
            n.setLoggingProperties(properties);
        }
        return n;
    }

    public static Noun create(Noun parent, String name, String type, Properties properties) {
        Noun n = Noun.create(parent, name, type);
        if (n != null) {
            n.setLoggingProperties(properties);
        }
        return n;
    }

    @Override
    public void setLogLevel(Level level, boolean recurse) {
        if (!this._alive) {
            return;
        }
        if (level == null) {
            return;
        }
        this._enabledLogLevel = level;
        if (recurse) {
            int i;
            for (i = this._childNouns.size() - 1; i >= 0; --i) {
                Noun child = (Noun)this._childNouns.elementAt(i);
                child.setLogLevel(level, true);
            }
            for (i = this._sensors.size() - 1; i >= 0; --i) {
                Sensor sensor = (Sensor)this._sensors.elementAt(i);
                sensor.setLogLevel(level);
            }
        } else {
            for (int i = this._sensors.size() - 1; i >= 0; --i) {
                Sensor sensor = (Sensor)this._sensors.elementAt(i);
                sensor.notifyLogLevel(this._enabledLogLevel);
            }
        }
    }

    @Override
    public void setLogLevel(LogLevel level, boolean recurse) {
        this.setLogLevel((Level)level, recurse);
    }

    @Override
    public Level getLogLevel() {
        return this._enabledLogLevel;
    }

    public static void setLogLevel(String pathname, Level level, boolean recurse) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            n.setLogLevel(level, recurse);
        }
    }

    public static void setLogLevel(String pathname, LogLevel level, boolean recurse) {
        Noun.setLogLevel(pathname, (Level)level, recurse);
    }

    public static Level getLogLevel(String pathname) {
        Noun n = Noun.get(pathname);
        if (n != null) {
            return n.getLogLevel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogWriter(LogWriter writer) {
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            if (!this._logWriters.contains(writer)) {
                this._logWriters.add(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogWriter(LogWriter writer) {
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            this._logWriters.remove(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogWriter[] getLogWriters() {
        LogWriter[] writers;
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            writers = this._logWriters.toArray(new LogWriter[this._logWriters.size()]);
        }
        return writers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(LogMessage msg, boolean flush) {
        for (Noun n = this; n != null; n = n.getParent()) {
            ArrayList arrayList = n._logWriters;
            synchronized (arrayList) {
                for (int i = 0; i < n._logWriters.size(); ++i) {
                    ((LogWriter)n._logWriters.get(i)).write(msg, flush);
                    Log.logMsgEventOccurred();
                }
                continue;
            }
        }
    }

    @Override
    public void setLoggingProperties(Properties properties) {
        this._logProperties = new HashMap<Object, Object>(properties);
    }

    protected String getLogProperty(String name) {
        String value = null;
        for (Noun n = this; n != null; n = n.getParent()) {
            HashMap properties = n._logProperties;
            if (properties == null || (value = (String)properties.get(name)) == null) continue;
            return value;
        }
        return value;
    }

    public void disableDumping() {
        if (this._dumperThread != null) {
            try {
                this._dumperThread.interrupt();
                this._dumperThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void enableDumping(int interval, String dumpdir, int max, NounDumpListener lsnr) {
        if (!this._alive) {
            return;
        }
        if (interval <= 0 || dumpdir == null || dumpdir.equals("") || max <= 0) {
            return;
        }
        if (this._dumperThread != null) {
            return;
        }
        this._dumperThread = new NounDumperThread(this, interval, dumpdir, max, lsnr);
        this._dumperThread.setDaemon(true);
        this._dumperThread.start();
    }

    Noun getCousin(Noun pre) {
        if (pre == null) {
            return pre;
        }
        Vector<Noun> ancestors = new Vector<Noun>();
        Noun anc = this;
        while (anc != _rootNoun) {
            ancestors.addElement(anc);
            anc = anc._parent;
        }
        pre = Noun.create(pre, DRILLDOWN_INDICATOR, "n/a");
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            anc = (Noun)ancestors.elementAt(i);
            String cousinType = anc.getType();
            if (!cousinType.equals("n/a")) {
                cousinType = DRILLDOWN_TYPE_PREFIX + cousinType;
            }
            pre = Noun.create(pre, anc.getName(), cousinType);
            Sensor[] sArray = anc.getSensors();
            for (int s = 0; s < sArray.length; ++s) {
                Sensor sens = sArray[s];
                if (!(sens instanceof State)) continue;
                State.create(pre, sens.getName(), "", "cousin", sens.getValue());
            }
        }
        return pre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw, String format) {
        SimpleAgency agency = new SimpleAgency();
        SimpleRequest req = new SimpleRequest();
        req.addParameter("name", this.toString());
        req.addParameter("format", format);
        req.addParameter("operation", "get");
        req.addParameter("units", "true");
        req.addParameter("value", "true");
        req.addParameter("description", "false");
        req.addParameter("recurse", "all");
        try {
            Reporter reporter = ((Agency)agency).getReporter(req);
            try {
                reporter.printResponse(pw);
            }
            catch (Exception e) {
            }
            finally {
                reporter.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String filename, String format, boolean append) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        PrintWriter pw = null;
        try {
            fos = new FileOutputStream(filename, append);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            pw = new PrintWriter(bw);
            this.dump(pw, format);
        }
        catch (Exception e) {
        }
        finally {
            try {
                pw.close();
                bw.close();
                osw.close();
                fos.close();
            }
            catch (Exception e2) {}
        }
    }

    public Noun rollup(String type, byte descendents) throws InstrumentationException {
        boolean recurse;
        String ru_name;
        if (type == null || type.length() <= 0 || type.equals("n/a")) {
            return null;
        }
        type = DMSUtil.sanitize(type, 511, true, true);
        String ru_type = ru_name = type + RU_SUFFIX;
        Noun ru_noun = Noun.create(this, ru_name, ru_type);
        State desc = State.create(ru_noun, RU_DESCENDENTS, (byte)5, "", RU_DESCENDENTS_DESC);
        if (descendents == 2) {
            desc.update("all");
            recurse = true;
        } else {
            desc.update("direct");
            recurse = false;
        }
        State count = State.create(ru_noun, RU_COUNT, (byte)3, RU_UNITS, RU_COUNT_DESC);
        count.update(0);
        Rollup ru = new Rollup(ru_noun, count, type, recurse);
        count.setRefresh(ru);
        return ru_noun;
    }

    public static void bucket(String type, String key) {
        if (type == null || key == null) {
            return;
        }
        ArrayList<String> keys = _bucketTypes.get(type);
        if (keys == null) {
            keys = new ArrayList<String>();
        }
        keys.add(key);
        _bucketTypes.put(type, keys);
    }

    ArrayList<String> getBucketKeys() {
        return this._bucketKeys;
    }

    public static synchronized void shutdown() {
        _status = 2;
        _rootNoun = new Noun();
        _nounCache.clear();
        _nounTypeListeners.clear();
        if (_bucketTypes != null) {
            _bucketTypes.clear();
        }
        _descMap.clear();
        _status = 2;
    }
}

