/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.console.DMSError;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.LoggerFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.SensorFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.http.SimpleRequest;
import oracle.dms.instrument.CorrelationContext;
import oracle.dms.instrument.EventFactory;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.LoggerFactory;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounFactory;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventFactory;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorFactory;
import oracle.dms.instrument.StateFactory;
import oracle.dms.instrument.TransTrace;
import oracle.dms.instrument.TransTraceIntf;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SimpleAgency;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.jvmmon.management.Manager;

public class DMSConsole
extends oracle.dms.console.DMSConsole {
    public static final int NONE = 0;
    public static final int NORMAL = 5;
    public static final int HEAVY = 10;
    public static final int ALL = Integer.MAX_VALUE;
    private static int SENSOR_WEIGHT = 5;
    public static long UNITS = 1000L;
    private static Clock _clock = null;
    public static final int PRE_INIT = 0;
    public static final int ACTIVE = 1;
    public static final int SHUTDOWN = 2;
    public static final int INCONSISTENT = 3;
    private static int _status = 0;
    private static EventFactoryIntf _eventFactory;
    private static NounFactoryIntf _nounFactory;
    private static PhaseEventFactoryIntf _phaseEventFactory;
    private static SensorFactoryIntf _sensorFactory;
    private static StateFactoryIntf _stateFactory;
    private static LoggerFactoryIntf _loggerFactory;
    private static TransTraceIntf _transTrace;

    public EventFactoryIntf newEventFactory() {
        _eventFactory = new EventFactory();
        return _eventFactory;
    }

    public NounFactoryIntf newNounFactory() {
        _nounFactory = new NounFactory();
        return _nounFactory;
    }

    public PhaseEventFactoryIntf newPhaseEventFactory() {
        _phaseEventFactory = new PhaseEventFactory();
        return _phaseEventFactory;
    }

    public SensorFactoryIntf newSensorFactory() {
        _sensorFactory = new SensorFactory();
        return _sensorFactory;
    }

    public StateFactoryIntf newStateFactory() {
        _stateFactory = new StateFactory();
        return _stateFactory;
    }

    public LoggerFactoryIntf newLoggerFactory() {
        _loggerFactory = new LoggerFactory();
        return _loggerFactory;
    }

    public synchronized EventFactoryIntf getEventFactory() {
        if (_eventFactory == null) {
            _eventFactory = new EventFactory();
        }
        return _eventFactory;
    }

    public synchronized NounFactoryIntf getNounFactory() {
        if (_nounFactory == null) {
            _nounFactory = new NounFactory();
        }
        return _nounFactory;
    }

    public synchronized PhaseEventFactoryIntf getPhaseEventFactory() {
        if (_phaseEventFactory == null) {
            _phaseEventFactory = new PhaseEventFactory();
        }
        return _phaseEventFactory;
    }

    public synchronized SensorFactoryIntf getSensorFactory() {
        if (_sensorFactory == null) {
            _sensorFactory = new SensorFactory();
        }
        return _sensorFactory;
    }

    public synchronized StateFactoryIntf getStateFactory() {
        if (_stateFactory == null) {
            _stateFactory = new StateFactory();
        }
        return _stateFactory;
    }

    public synchronized LoggerFactoryIntf getLoggerFactory() {
        if (_loggerFactory == null) {
            _loggerFactory = new LoggerFactory();
        }
        return _loggerFactory;
    }

    public synchronized TransTraceIntf getTransTrace() {
        if (_transTrace == null) {
            _transTrace = new TransTrace();
        }
        return _transTrace;
    }

    public void setProcessID(int pid) {
        DMSUtil.setProcessID(pid);
    }

    public void setProcessID(String uid) {
        DMSUtil.setProcessID(uid);
    }

    public String getProcessID() {
        return DMSUtil.getProcessID();
    }

    public void init(String name) throws DMSError {
        this.init(name, null);
    }

    public void init(String name, Properties properties) throws DMSError {
        try {
            DMSConsole.initClock(properties);
            this.initWeight();
            Spy.init(name, properties);
            Manager.initialize();
        }
        catch (Exception e) {
            throw new DMSError(e.toString());
        }
        _status = 1;
    }

    public void setName(String name) {
        Spy.setName(name);
    }

    public String getName() {
        return Spy.getName();
    }

    public Object getMetricValue(String name) {
        return Spy.getMetricValue(name);
    }

    public void exit() {
        this.exit(true);
    }

    public synchronized void exit(boolean dumpResults) {
        if (dumpResults) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Spy.exit();
                    return null;
                }
            });
        } else {
            Spy.exit(false);
        }
        CorrelationContext.shutdown();
        ExecutionContext.shutdown();
        Noun.shutdown();
        PhaseEvent.shutdown();
        Sensor.shutdown();
        TransTrace.shutdown();
        ClockManager.shutdown();
        _clock = null;
        SENSOR_WEIGHT = 5;
        _status = 2;
    }

    public boolean isActive() {
        return Spy.isActive();
    }

    public void setDumpFile(String name) {
        Spy.setDumpFile(name);
    }

    public String getDumpFile() {
        return Spy.getDumpFile();
    }

    public void dump() {
        Spy.dump();
    }

    public void dump(String filename, boolean pretty, boolean append) {
        Spy.dump(filename, pretty, append);
    }

    public void dump(PrintWriter pw, boolean pretty) throws IOException {
        Spy.dump(pw, pretty);
    }

    public void dump(PrintWriter pw, String format) {
        Noun.getRoot().dump(pw, format);
    }

    public void dump(String filename, String format, boolean append) {
        Noun.getRoot().dump(filename, format, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(PrintWriter pw, String queryString) {
        if (queryString == null || queryString.trim().length() == 0 || pw == null) {
            return;
        }
        SimpleAgency agency = new SimpleAgency();
        SimpleRequest request = new SimpleRequest();
        Reporter reporter = null;
        try {
            request.parseQueryStrings(queryString);
            reporter = agency.getReporter(request);
            reporter.printResponse(pw);
        }
        catch (Exception e) {
        }
        finally {
            if (reporter != null) {
                reporter.clear();
            }
        }
    }

    private void initWeight() {
        block8: {
            String weight = null;
            try {
                weight = DMSProperties.getProperty("oracle.dms.sensors");
                if (weight == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            try {
                SENSOR_WEIGHT = Integer.parseInt(weight);
            }
            catch (Exception e) {
                if (weight.equalsIgnoreCase("ALL")) {
                    SENSOR_WEIGHT = Integer.MAX_VALUE;
                }
                if (weight.equalsIgnoreCase("NONE")) {
                    SENSOR_WEIGHT = 0;
                }
                if (weight.equalsIgnoreCase("NORMAL")) {
                    SENSOR_WEIGHT = 5;
                }
                if (!weight.equalsIgnoreCase("HEAVY")) break block8;
                SENSOR_WEIGHT = 10;
            }
        }
    }

    public static boolean setSensorWeightOff() {
        if (_clock != null) {
            return false;
        }
        SENSOR_WEIGHT = 0;
        return true;
    }

    public static int getSensorWeight() {
        return SENSOR_WEIGHT;
    }

    private static void initClock(Properties props) {
        String clockname = null;
        String units = null;
        if (props != null) {
            clockname = props.getProperty("oracle.dms.clock");
            units = props.getProperty("oracle.dms.clock.units");
        }
        if (clockname == null) {
            clockname = DMSProperties.getProperty("oracle.dms.clock");
        }
        if (units == null) {
            units = DMSProperties.getProperty("oracle.dms.clock.units");
        }
        if (clockname == null) {
            clockname = "default";
        }
        _clock = ClockManager.setClock(clockname);
        UNITS = units == null || _clock.getName().equals("logical") ? _clock.getReportedFrequency() : ClockManager.getFrequency(units);
    }

    public static Clock getClock() {
        if (_clock == null) {
            DMSConsole.initClock(null);
        }
        return _clock;
    }

    public void debug(String msg) {
        DMSConsole._debug(msg);
    }

    public static void _debug(String msg) {
        try {
            System.err.println("<DMSDEBUG> " + msg + " </DMSDEBUG>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getStatus() {
        if (_status == 0 || _status == 2) {
            if (Spy.isActive()) {
                return 3;
            }
            if (_clock != null || _eventFactory != null || _phaseEventFactory != null || _sensorFactory != null || _stateFactory != null || _loggerFactory != null || _transTrace != null || _nounFactory != null) {
                return 3;
            }
            return _status;
        }
        if (_status == 1) {
            if (!Spy.isActive() || Noun.getRoot() == null) {
                return 3;
            }
            if (_clock == null) {
                return 3;
            }
            return _status;
        }
        return 3;
    }
}

