/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.impl.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import oracle.dms.http.Request;
import oracle.dms.impl.reporter.TableReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.Row;
import oracle.dms.table.RowComparator;
import oracle.dms.table.Schema;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.NetUtil;
import oracle.dms.util.QueryOptions;

class MetricTableReporter
extends TableReporter {
    private static final String TIME = ".time";
    private static final String VALUE = ".value";
    static final String SPACE = "&nbsp;";
    static final String RAW_FORMAT = "?format=raw";
    static final String HTML_FORMAT = "?format=html";
    static final String LIST_FORMAT = "?format=metriclist";
    static final String TABLE_FORMAT = "?format=metrictable";
    static final String HELP_FORMAT = "?format=metrichelp";
    static final String SPY_FORMAT = "?format=spytable";
    private static final String BYPASS_CACHE = "&cache=false&interval=6400000";
    public static final String METRIC_TABLE_FRAME = "metricTableFrame";
    private static NumberFormat s_numFormat0 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat1 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat2 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat3 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private boolean m_tableContents = true;
    boolean m_isCollector = true;

    MetricTableReporter(TableSource tableSource, Request request, boolean isCollector) {
        super(tableSource, request);
        this.m_isCollector = isCollector;
    }

    protected void setQueryOptions() {
        super.setQueryOptions();
        this.m_options.setQueryType(QueryOptions.QueryType.ALL);
    }

    void printHeading(PrintWriter out) {
        MetricTableReporter.printHTMLStart(out);
        out.println("</head><body bgcolor=\"#ffffff\">");
        Collection oldTables = this.m_tables;
        this.m_tables = new TreeSet(this.m_tables);
        oldTables.clear();
        if (this.m_tables.size() > 1) {
            this.m_tableContents = false;
            MetricTableReporter.printBanner("<font size=+2><a name=top>" + DMSNLSupport.getString("TV_CONTENTS", "Contents") + "</a></font></td><td align=right>" + this.m_request.getRequestURL() + ':' + SPACE + DMSUtil.getProcessName(), out);
            out.print("<ol>");
            for (Table table : this.m_tables) {
                String name = table.getName();
                out.print("<li><a");
                this.printTableSort(name, out);
                out.print(" target=");
                out.print(METRIC_TABLE_FRAME);
                out.print('>');
                out.print(name);
                out.println("</a>");
            }
            out.println("</ol><p>");
        }
    }

    void printEnding(PrintWriter out) {
        out.print("<hr style=\"color:#cccc99\">");
        out.print(new Date());
        out.println("</body></html>");
    }

    void printTable(Table table, PrintWriter out) {
        if (!this.m_tableContents) {
            return;
        }
        String name = table.getName();
        Schema schema = table.getSchema();
        Object[] sensors = schema.getColumnGroupNames();
        String[][] metrics = null;
        if (sensors != null) {
            Arrays.sort(sensors);
            metrics = new String[sensors.length][];
        }
        String[] properties = this.getTableHeader(schema, (String[])sensors, metrics);
        this.printTableName(name, out);
        MetricTableReporter.printTableStart(1, 1, out);
        this.printDataHeader(table, schema, (String[])sensors, metrics, properties, out);
        this.printDataRows(table, schema, (String[])sensors, metrics, properties, out);
        out.print("</table><a href=\"#top\">");
        out.print(DMSNLSupport.getString("TV_TOP", "Top"));
        out.print("</a> | ");
        if (!this.m_isCollector) {
            this.printTextFormat(name, null, out);
            out.print(" | ");
        }
        this.printMetricHelp(name, out);
        out.println("<p>");
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    String getFormat() {
        return "metrictable";
    }

    String[] getTableHeader(Schema schema, String[] sensors, String[][] metrics) {
        Arrays.sort(sensors);
        TreeSet<String> propertySet = new TreeSet<String>();
        Enumeration<? extends ColumnDefinition> iter = schema.enumerateColumnDefinitions(false);
        while (iter.hasMoreElements()) {
            ColumnDefinition cdef = iter.nextElement();
            propertySet.add(cdef.getName());
        }
        if (sensors != null) {
            for (int i = 0; i < sensors.length; ++i) {
                if (sensors[i] == null) continue;
                ColumnGroup group = schema.getColumnGroup(sensors[i]);
                metrics[i] = group.getMemberNames();
                if (metrics[i] == null) continue;
                Arrays.sort(metrics[i]);
                for (String metric : metrics[i]) {
                    propertySet.remove(metric);
                }
            }
        }
        propertySet.remove("Name");
        propertySet.remove("Host");
        propertySet.remove("Process");
        if (schema.containsColumn("Name") && schema.containsColumn("Host") && schema.containsColumn("Process")) {
            propertySet.remove("Parent");
        }
        String[] properties = new String[propertySet.size()];
        propertySet.toArray(properties);
        return properties;
    }

    public void printTableName(String table, PrintWriter out) {
        if (this.m_tableContents) {
            MetricTableReporter.printBanner("<font size=+2><a name=top>" + table + "</a></font></td><td align=right>" + this.m_request.getRequestURL() + ':' + SPACE + DMSUtil.getProcessName(), out);
        } else {
            out.print("<a name=\"");
            out.print(table);
            out.print("\"><font style=\"font-weight:bold\" size=+2>");
            out.print(table);
            out.println("</font></a><p>");
        }
    }

    private void printMetricHelp(String table, PrintWriter out) {
        out.print("<a");
        this.printTableLink(table, "metrichelp", out);
        out.println("\" ");
        MetricTableReporter.printStatusLine(DMSNLSupport.getString("TV_METRICS_DEFS", "Metric Definitions"), out);
        out.print('>');
        out.print(DMSNLSupport.getString("TV_METRICS_DEFS", "Metric Definitions"));
        out.println("</a>");
    }

    public void printDataRows(Table table, Schema schema, String[] sensors, String[][] metrics, String[] properties, PrintWriter out) {
        boolean lightBG = false;
        RowComparator orderBy = this.getComparator(schema);
        Enumeration<? extends Row> iter = table.enumerateRows(orderBy);
        while (iter.hasMoreElements()) {
            Row row = iter.nextElement();
            int maxMetrics = 1;
            if (metrics != null) {
                for (String[] metric : metrics) {
                    if (metric == null || metric.length <= maxMetrics) continue;
                    maxMetrics = metric.length;
                }
            }
            this.printDataRow(row, schema, lightBG, sensors, metrics, maxMetrics, properties, out);
            lightBG = !lightBG;
        }
    }

    private void printDataRow(Row row, Schema schema, boolean lightBG, String[] sensors, String[][] metrics, int maxMetrics, String[] properties, PrintWriter out) {
        for (int i = 0; i < maxMetrics; ++i) {
            MetricTableReporter.printRowStart(lightBG, out);
            if (i == 0) {
                if (schema.containsColumn("Name")) {
                    MetricTableReporter.printDataCell(row.getValue("Name"), maxMetrics, out);
                }
                if (schema.containsColumn("Host")) {
                    MetricTableReporter.printDataCell(row.getValue("Host"), maxMetrics, out);
                }
                if (schema.containsColumn("Process")) {
                    MetricTableReporter.printDataCell(row.getValue("Process"), maxMetrics, out);
                }
            }
            if (sensors != null) {
                for (int j = 0; j < sensors.length; ++j) {
                    int size;
                    if (sensors[j] == null || metrics[j] == null || (size = metrics[j].length) == 0 || i >= size) continue;
                    Serializable value = row.getValue(metrics[j][i]);
                    ColumnDefinition mdesc = schema.getColumnDefinition(metrics[j][i]);
                    String unit = null;
                    if (mdesc != null) {
                        unit = mdesc.getUnit();
                    }
                    String displayName = metrics[j][i];
                    int index = metrics[j][i].indexOf(sensors[j]);
                    if (index >= 0 && index < metrics[j][i].length() - sensors[j].length()) {
                        displayName = metrics[j][i].substring(index + sensors[j].length());
                    }
                    if (displayName.startsWith(".")) {
                        displayName = displayName.substring(1);
                    }
                    if (unit != null && unit.trim().length() > 0) {
                        displayName = displayName + ", " + unit;
                    }
                    int rowspan = 1;
                    if (size == i + 1) {
                        rowspan = maxMetrics - i;
                    }
                    if (size > 1) {
                        MetricTableReporter.printDataCell(displayName, rowspan, out);
                    }
                    MetricTableReporter.printDataCell(value, rowspan, out);
                }
            }
            if (i == 0) {
                for (String property : properties) {
                    if (property == null) continue;
                    Serializable propertyVal = row.getValue(property);
                    MetricTableReporter.printDataCell(propertyVal, maxMetrics, out);
                }
            }
            out.print("</tr>");
        }
    }

    public void printDataHeader(Table table, Schema schema, String[] sensors, String[][] metrics, String[] properties, PrintWriter out) {
        String description;
        String tableName = table.getName();
        out.print("<tr>");
        if (schema.containsColumn("Name")) {
            this.printHeaderCell("Name", DMSNLSupport.getString("QU_Name"), tableName, "Name", 1, this.isSortable(table, "Name"), out);
        }
        if (schema.containsColumn("Host")) {
            this.printHeaderCell("Host", DMSNLSupport.getString("QU_Host"), tableName, "Host", 1, this.isSortable(table, "Host"), out);
        }
        if (schema.containsColumn("Process")) {
            this.printHeaderCell("Process", DMSNLSupport.getString("QU_Process"), tableName, "Process", 1, this.isSortable(table, "Process"), out);
        }
        if (sensors != null) {
            for (int i = 0; i < sensors.length; ++i) {
                boolean isSortable;
                ColumnDefinition mdesc;
                String orderBy;
                int colspan;
                int size;
                if (sensors[i] == null || metrics[i] == null || (size = metrics[i].length) == 0) continue;
                String name = sensors[i];
                description = null;
                if (size == 1) {
                    colspan = 1;
                    orderBy = metrics[i][0];
                    mdesc = schema.getColumnDefinition(orderBy);
                    String unit = null;
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                        unit = mdesc.getUnit();
                    }
                    if (unit != null && unit.trim().length() > 0) {
                        name = sensors[i] + ", " + unit;
                    }
                    isSortable = this.isSortable(table, orderBy);
                } else {
                    colspan = 2;
                    orderBy = this.getOrderByMetric(metrics[i]);
                    mdesc = schema.getColumnDefinition(orderBy);
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                    }
                    isSortable = this.isSortable(table, orderBy);
                }
                this.printHeaderCell(name, description, tableName, orderBy, colspan, isSortable, out);
            }
        }
        for (String property : properties) {
            if (property == null) continue;
            ColumnDefinition mdesc = schema.getColumnDefinition(property);
            description = null;
            if (mdesc != null) {
                description = mdesc.getDescription();
            }
            this.printHeaderCell(property, description, tableName, property, 1, this.isSortable(table, property), out);
        }
        out.print("</tr>");
    }

    private void printTableSort(String table, String orderBy, PrintWriter out) {
        String format = this.getFormat();
        if (format == null || format.trim().length() == 0) {
            format = "metrictable";
        }
        if ("metrictable".equals(format)) {
            format = format + BYPASS_CACHE;
        }
        this.printTableLink(table, format + '&' + "orderby" + '=' + orderBy, out);
        out.print("\"  onClick=\"top.orderby='");
        out.print(orderBy);
        out.println("';\" ");
    }

    void printTableLink(String table, String format, PrintWriter out) {
        out.print(" href=\"");
        out.print(this.m_request.getRequestURI());
        out.print('?');
        out.print("format");
        out.print('=');
        out.print(format);
        if (table != null && table.trim().length() > 0) {
            out.print('&');
            out.print("table");
            out.print('=');
            out.print(table);
        }
    }

    void printTableSort(String table, PrintWriter out) {
        String link = this.getTableSort(table);
        out.println(link);
    }

    public String getTableSort(String table) {
        StringBuffer buf = new StringBuffer(" href=\"#\" onClick=\"this.href='");
        buf.append(this.m_request.getRequestURI());
        buf.append(TABLE_FORMAT);
        buf.append(BYPASS_CACHE);
        if (table != null) {
            buf.append('&');
            buf.append("table");
            buf.append('=');
            buf.append(table);
        }
        buf.append('&');
        buf.append("orderby");
        buf.append("='+top.orderby;\" ");
        return buf.toString();
    }

    static void printBanner(String banner, PrintWriter out) {
        MetricTableReporter.printTableStart(0, 0, out);
        MetricTableReporter.printRowStart(false, out);
        out.print("<td class=banner valign=bottom>");
        out.print(banner);
        out.println("</td></tr></table><p>");
    }

    static void printStyleSheet(PrintWriter out) {
        out.println("<style type=\"text/css\">\n<!--");
        out.print("td.dataCell {color:#000000; ");
        out.print("border-left-color:#cccc99; border-style:solid; ");
        out.print("border-right-color:#f7f7e7; border-bottom-color:#cccc99; ");
        out.print("border-top-color:#f7f7e7; ");
        out.println("vertical-align:baseline;}");
        out.println("td.banner {color:#306090; font-weight:bold;}");
        out.print("th {background:#cccc99; text-align:left; font-weight:bold; ");
        out.print("border-left-color:#f7f7e7; border-style:solid; ");
        out.print("border-right-color:#cccc99; border-bottom-color:#cccc99; ");
        out.println("border-top-color:#cccc99; vertical-align:baseline;} ");
        out.print("th.headerCellGrey {color:#505050; } ");
        out.println("th.headerCell {color:#306090; } ");
        out.print("a.headerCell:link {color:#306090;} ");
        out.print("a.headerCell:visited {color:#306090;} ");
        out.println("a.headerCell:hover {color:#0000ff;}");
        out.println("-->\n</style>");
    }

    static void printStatusLine(String status, PrintWriter out) {
        out.print(" onMouseOver=\"status='");
        out.print(status);
        out.println("';return true;\" onMouseOut=\"status='';\" ");
    }

    static void printHTMLStart(PrintWriter out) {
        out.print("<html><head><title>");
        out.print(DMSUtil.getProcessName());
        out.print(' ');
        out.print(DMSNLSupport.getString("TV_METRICS", "DMS Metrics"));
        out.println("</title>");
        MetricTableReporter.printJavaScriptDefs(out);
        MetricTableReporter.printStyleSheet(out);
    }

    public static void printTableStart(int border, int cellpadding, PrintWriter out) {
        out.print("<table border=");
        out.print(border);
        out.print(" cellpadding=");
        out.print(cellpadding);
        out.println(" cellspacing=0 width=\"100%\">");
    }

    public static void printRowStart(boolean lightBG, PrintWriter out) {
        out.print("<tr bgcolor=\"#");
        out.print(lightBG ? "ffffff" : "f7f7e7");
        out.println("\">");
    }

    public static void printDataCell(Object data, int rowspan, PrintWriter out) {
        boolean alignright = false;
        String text = SPACE;
        if (data instanceof Number) {
            alignright = true;
            long value = ((Number)data).longValue();
            text = data instanceof Double && value > 100000000L ? data.toString() : (value > 100L ? s_numFormat0.format(data) : (value > 10L ? s_numFormat1.format(data) : (value > 0L ? s_numFormat2.format(data) : s_numFormat3.format(data))));
        } else if (!(data == null || data instanceof String && ((String)data).trim().length() <= 0)) {
            text = NetUtil.addSoftBreak(data.toString());
        }
        MetricTableReporter.printStringDataCell(text, rowspan, alignright, out);
    }

    public static void printStringDataCell(String data, int rowspan, boolean alignright, PrintWriter out) {
        out.print("<td class=dataCell valign=top");
        if (rowspan > 1) {
            out.print(" rowspan=");
            out.print(rowspan);
        }
        if (alignright) {
            out.print(" align=right");
        }
        out.print(">");
        if (data == null || data.trim().length() == 0) {
            data = SPACE;
        }
        out.print(data);
        out.println("</td>");
    }

    static void printHeaderCellGrey(String header, int colspan, PrintWriter out) {
        out.print("<th class=headerCellGrey");
        if (colspan > 1) {
            out.print(" colspan=");
            out.print(colspan);
        }
        out.print('>');
        out.print(NetUtil.addSoftBreak(header));
        out.println("</th>");
    }

    public void printHeaderCell(String header, String status, String table, String orderBy, int colspan, boolean isSortable, PrintWriter out) {
        if (!(isSortable || status != null && status.trim().length() != 0)) {
            MetricTableReporter.printHeaderCellGrey(header, colspan, out);
            return;
        }
        out.print("<th class=headerCell");
        if (colspan > 1) {
            out.print(" colspan=");
            out.print(colspan);
        }
        out.print("><a class=headerCell");
        if (isSortable) {
            this.printTableSort(table, orderBy, out);
        } else {
            out.print(" style=\"text-decoration:none\" ");
            out.print("href=\"#\" onClick=\"return false;\" ");
        }
        if (status != null && status.trim().length() > 1) {
            MetricTableReporter.printStatusLine(status, out);
        }
        out.print('>');
        out.print(NetUtil.addSoftBreak(header));
        out.println("</a></th>");
    }

    void printTextFormat(String table, String target, PrintWriter out) {
        out.print("<a href=\"");
        String uri = this.m_request.getRequestURI();
        if (!uri.endsWith("/Spy")) {
            uri = "/dmsoc4j/Spy";
        }
        out.print(uri);
        out.print(RAW_FORMAT);
        if (table != null && table.trim().length() > 0) {
            out.print('&');
            out.print("table");
            out.print('=');
            out.print(table);
        }
        out.println("\" ");
        MetricTableReporter.printStatusLine(DMSNLSupport.getString("TV_TEXT_DESC", "Show metrics in text format"), out);
        if (target != null && target.trim().length() > 0) {
            out.print(" target=");
            out.print(target);
        }
        out.print('>');
        out.print(DMSNLSupport.getString("TV_TEXT", "Text Format"));
        out.println("</a>");
    }

    public String getSpyLink(String address, String process, String target) {
        StringBuffer buf = new StringBuffer("<a href=\"");
        String uri = this.m_request.getRequestURI();
        buf.append(uri);
        buf.append(RAW_FORMAT);
        buf.append('&');
        buf.append("address");
        buf.append('=');
        buf.append(address);
        if (target != null && target.trim().length() > 0) {
            buf.append("\" target=\"");
            buf.append(target);
        }
        buf.append("\" title=\"");
        buf.append(process);
        buf.append(' ');
        buf.append(DMSNLSupport.getString("TV_METRICS", "DMS Metrics"));
        buf.append("\">");
        buf.append(DMSNLSupport.getString("TV_TEXT", "Text"));
        buf.append("</a>");
        return buf.toString();
    }

    static void printJavaScriptDefs(PrintWriter out) {
        out.println("<script language=\"javascript\">\n<!--");
        out.println("var orderby='Name';");
        out.println("// -->\n</script>");
    }

    private String getOrderByMetric(String[] metrics) {
        if (metrics == null || metrics.length == 0) {
            return null;
        }
        for (String metric : metrics) {
            if (!metric.endsWith(TIME) && !metric.endsWith(VALUE)) continue;
            return metric;
        }
        return metrics[0];
    }

    public RowComparator getComparator(Schema schema) {
        String orderBy = this.m_request.getOrderBy();
        if (orderBy != null && orderBy.trim().length() > 0 && schema.containsColumn(orderBy)) {
            return new RowComparator(orderBy, true);
        }
        if (schema.containsColumn("Name")) {
            return new RowComparator("Name", true);
        }
        return null;
    }

    public boolean isSortable(Table table, String metric) {
        if (table == null || metric == null || metric.trim().length() == 0) {
            return false;
        }
        Serializable oldValue = null;
        Enumeration<? extends Row> iter = table.enumerateRows();
        while (iter.hasMoreElements()) {
            Row row = iter.nextElement();
            Serializable value = row.getValue(metric);
            if (value instanceof ErrorObject) {
                value = null;
            }
            if (!(oldValue == null || value != null && oldValue.equals(value))) {
                return true;
            }
            if (value == null) continue;
            oldValue = value;
        }
        return false;
    }

    static {
        s_numFormat0.setMaximumFractionDigits(0);
        s_numFormat1.setMaximumFractionDigits(1);
        s_numFormat2.setMaximumFractionDigits(2);
        s_numFormat3.setMaximumFractionDigits(3);
        s_numFormat0.setGroupingUsed(false);
        s_numFormat1.setGroupingUsed(false);
        s_numFormat2.setGroupingUsed(false);
        s_numFormat3.setGroupingUsed(false);
    }
}

