/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.impl.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.impl.reporter.MetricTableReporter;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.Schema;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.DMSNLSupport;

class MetricHelpReporter
extends MetricTableReporter {
    MetricHelpReporter(TableSource tableSource, Request request) {
        super(tableSource, request, false);
    }

    void printHeading(PrintWriter out) {
        String title = DMSNLSupport.getString("TV_METRICS_HELP", "DMS Metrics Help");
        out.print("<html><head><title>");
        out.print(title);
        out.println("</title>");
        MetricHelpReporter.printStyleSheet(out);
        out.println("</head><body bgcolor=\"#ffffff\">");
    }

    void printEnding(PrintWriter out) {
        out.println("<hr style=\"color:#cccc99\">");
        out.print(new Date());
        out.println("</body></html>");
    }

    void printTable(Table table, PrintWriter out) {
        String name = table.getName();
        Schema schema = table.getSchema();
        MetricHelpReporter.printBanner("<font size=+2><a" + this.getTableSort(name) + '>' + name + "</a></font>", out);
        MetricHelpReporter.printTableStart(1, 1, out);
        out.print("<tr>");
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_NAME", "Names"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_DESCRIPTION", "Descriptions"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("TV_DERIVS", "Derivatives"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_UNITS", "Units"), 1, out);
        out.print("</tr>");
        boolean lightBG = false;
        if (schema.containsColumn("Name")) {
            this.printHelpRow("Name", DMSNLSupport.getString("QU_Name", "Name of metric instance"), "&nbsp;", lightBG, out);
            boolean bl = lightBG = !lightBG;
        }
        if (schema.containsColumn("Host")) {
            this.printHelpRow("Host", DMSNLSupport.getString("QU_Host", "Host where metrics come"), "&nbsp;", lightBG, out);
            boolean bl = lightBG = !lightBG;
        }
        if (schema.containsColumn("Process")) {
            this.printHelpRow("Process", DMSNLSupport.getString("QU_Process", "Process where metrics come"), "&nbsp;", lightBG, out);
            lightBG = !lightBG;
        }
        String[] sensors = schema.getColumnGroupNames();
        String[][] metrics = null;
        if (sensors != null) {
            metrics = new String[sensors.length][];
        }
        String[] properties = this.getTableHeader(schema, sensors, metrics);
        this.printHelpRows(schema, sensors, metrics, properties, lightBG, out);
        out.println("</table><p>");
    }

    private void printHelpRows(Schema schema, String[] sensors, String[][] metrics, String[] properties, boolean lightBG, PrintWriter out) {
        int i;
        if (sensors != null) {
            for (i = 0; i < sensors.length; ++i) {
                int size;
                if (sensors[i] == null || metrics[i] == null || (size = metrics[i].length) == 0) continue;
                ColumnGroup group = schema.getColumnGroup(sensors[i]);
                String groupDesc = null;
                if (group != null) {
                    groupDesc = group.getDescription();
                }
                MetricHelpReporter.printRowStart(lightBG, out);
                MetricHelpReporter.printDataCell(sensors[i], size, out);
                if (groupDesc != null && groupDesc.trim().length() > 0) {
                    MetricHelpReporter.printDataCell(groupDesc, size, out);
                }
                for (int j = 0; j < metrics[i].length; ++j) {
                    ColumnDefinition mdesc = schema.getColumnDefinition(metrics[i][j]);
                    String description = null;
                    String unit = null;
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                        unit = mdesc.getUnit();
                    }
                    if (j > 0) {
                        MetricHelpReporter.printRowStart(lightBG, out);
                    }
                    if (groupDesc == null || groupDesc.trim().length() == 0) {
                        if (description == null || description.trim().length() == 0) {
                            description = "&nbsp;";
                        }
                        MetricHelpReporter.printDataCell(description, 1, out);
                    }
                    String extension = metrics[i][j];
                    int index = metrics[i][j].indexOf(sensors[i]);
                    if (index >= 0 && index < metrics[i][j].length() - sensors[i].length()) {
                        extension = metrics[i][j].substring(index + sensors[i].length());
                    }
                    if (extension.startsWith(".")) {
                        extension = extension.substring(1);
                    }
                    MetricHelpReporter.printDataCell(extension, 1, out);
                    if (unit == null || unit.trim().length() == 0) {
                        unit = "&nbsp;";
                    }
                    MetricHelpReporter.printDataCell(unit, 1, out);
                    out.print("</tr>");
                }
                lightBG = !lightBG;
            }
        }
        for (i = 0; i < properties.length; ++i) {
            if (properties[i] == null) continue;
            ColumnDefinition mdesc = schema.getColumnDefinition(properties[i]);
            String description = null;
            String unit = null;
            if (mdesc != null) {
                description = mdesc.getDescription();
                unit = mdesc.getUnit();
            }
            this.printHelpRow(properties[i], description, unit, lightBG, out);
            lightBG = !lightBG;
        }
    }

    private void printHelpRow(String name, String description, String unit, boolean lightBG, PrintWriter out) {
        if (name == null || name.trim().length() == 0) {
            name = "&nbsp;";
        }
        if (unit == null || unit.trim().length() == 0) {
            unit = "&nbsp;";
        }
        MetricHelpReporter.printRowStart(lightBG, out);
        MetricHelpReporter.printDataCell(name, 1, out);
        MetricHelpReporter.printDataCell(description, 1, out);
        MetricHelpReporter.printDataCell("&nbsp;", 1, out);
        MetricHelpReporter.printDataCell(unit, 1, out);
        out.print("</tr>");
    }
}

