/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import oracle.core.ojdl.LogMessage;
import oracle.dms.http.HttpRequest;
import oracle.dms.http.Httpd;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;

public class HttpResponse {
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_UTF8 = "charset=UTF-8";
    public static final String TEXT_HTML = "text/html; charset=UTF-8";
    public static final String TEXT_PLAIN = "text/plain; charset=UTF-8";
    private static final String SERVER_ID = "Oracle_DMS_Listener/3.1";
    private static final String HEADER_ENCODING = "ISO8859_1";
    private static final String BODY_ENCODING = "UTF-8";
    private static final int HTTP_NOT_IMPLEMENTED = 501;
    private HttpRequest m_request = null;
    private OutputStream m_output = null;
    private HashMap<String, String> m_headerTable = new HashMap();
    private int m_code = 200;
    private State m_responseDataState = null;
    private static final String DATE_FORMAT = "EEE, d MMM yyyy hh:mm:ss z";
    private static final String TIME_ZONE = "GMT";
    static SimpleDateFormat s_dateFormater = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
    private static final String TOTAL_RESPONSE_DATA = "totalResponseData";

    public HttpResponse(HttpRequest request, OutputStream out) {
        if (request == null || out == null) {
            throw new IllegalArgumentException(this.toString() + ": request=" + request + ": out=" + out);
        }
        this.m_request = request;
        this.m_output = new BufferedOutputStream(out);
        Noun listRoot = Noun.create(DMSUtil.genCompNounPath("HTTP"), "n/a");
        this.m_responseDataState = State.create(listRoot, TOTAL_RESPONSE_DATA, (byte)2, DMSNLSupport.getString("BYTES"), DMSNLSupport.getString("HTTP_totalResponseData"));
        this.m_responseDataState.deriveMetric(511);
    }

    void close() {
        this.m_headerTable.clear();
        try {
            this.m_output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCode(int status) {
        this.m_code = status;
    }

    public void setHeader(String header, String value) {
        if (header == null || value == null) {
            return;
        }
        this.m_headerTable.put(header, value);
    }

    void print(String responseBody) throws IOException {
        if (responseBody == null || responseBody.trim().length() == 0) {
            this.m_code = 204;
            responseBody = "";
        }
        byte[] responseBytes = null;
        if (this.m_request.getHttpMethod() != 3) {
            try {
                responseBytes = responseBody.getBytes(BODY_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                    Httpd.LOGGER.logp(Level.FINEST, this.toString(), "print", "could not get byte array for " + responseBody + " encoding=" + BODY_ENCODING);
                }
                responseBytes = responseBody.getBytes();
            }
        }
        this.print(responseBytes);
    }

    void print(byte[] responseBytes) throws IOException {
        int responseLen = 0;
        if (this.m_request.getHttpVersion() >= 1.0f) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("HTTP/1.0 ");
            sb.append(this.m_code);
            sb.append(' ');
            sb.append(HttpResponse.getHttpCodeMessage(this.m_code));
            sb.append("\r\nServer: ");
            sb.append(SERVER_ID);
            sb.append("\r\nAllow: GET, POST, HEAD\r\nConnection: close\r\nDate: ");
            sb.append(s_dateFormater.format(new Date()));
            sb.append("\r\nExpires: 0\r\nCache-Control: no-cache\r\n");
            LogMessage.InstanceId instId = this.m_request.getInstanceID();
            if (instId != null) {
                sb.append("Oracle-ECID: ");
                sb.append(instId.getUniqueId());
                sb.append(", ");
                sb.append(instId.getSequenceNumber());
                sb.append("\r\n");
            }
            if (this.m_request.getHttpMethod() != 3) {
                sb.append("Content-Length: ");
                if (responseBytes == null) {
                    sb.append('0');
                } else {
                    sb.append(responseBytes.length);
                }
                sb.append("\r\n");
            }
            for (Map.Entry<String, String> entry : this.m_headerTable.entrySet()) {
                sb.append(entry.getKey());
                sb.append(": ");
                sb.append(entry.getValue());
                sb.append("\r\n");
            }
            sb.append("\r\n");
            byte[] headerBytes = null;
            try {
                headerBytes = sb.toString().getBytes(HEADER_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                    Httpd.LOGGER.logp(Level.FINEST, this.toString(), "print", "could not get byte array for " + sb + " encoding=" + HEADER_ENCODING);
                }
                headerBytes = sb.toString().getBytes();
            }
            this.m_output.write(headerBytes);
            responseLen += headerBytes.length;
        }
        if (responseBytes != null && this.m_request.getHttpMethod() != 3) {
            this.m_output.write(responseBytes);
            responseLen += responseBytes.length;
        }
        this.m_output.flush();
        this.m_responseDataState.increment(responseLen);
    }

    public static String getHttpCodeMessage(int code) {
        switch (code) {
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 204: {
                return "No Content";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 304: {
                return "Not Modified";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Not Allowed";
            }
            case 411: {
                return "Length Required";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad GateWay";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 505: {
                return "HTTP version not supported";
            }
        }
        return null;
    }

    public void setContentType(String contentType) {
        this.setHeader(CONTENT_TYPE, contentType);
    }

    static {
        s_dateFormater.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
    }
}

