/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InheritedContext<T>
extends InheritableThreadLocal<T> {
    InheritedContext() {
    }

    @Override
    protected T childValue(T parentValue) {
        if (!DMSContextManager.isInitialized() || parentValue == null) {
            return null;
        }
        ExecutionContext pctx = null;
        ExecutionContext ctx = null;
        Logger logger = DMSContextManager.getLogger();
        if (parentValue instanceof ExecutionContext) {
            pctx = (ExecutionContext)parentValue;
            ctx = pctx.createChild();
            if (ctx == null) {
                logger.log(Level.WARNING, "CTX-00014", pctx.getIDasString());
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                Object[] msg = new String[]{pctx.getRIDasString(), ctx.getRIDasString()};
                logger.log(Level.FINE, "CTX-00009", msg);
            }
        } else {
            logger.log(Level.WARNING, "CTX-00025");
            return null;
        }
        if (ctx instanceof ExecutionContext) {
            return (T)ctx;
        }
        return null;
    }
}

