/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.LogManager;
import oracle.dms.context.ContextContent;
import oracle.dms.context.ContextFamily;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ECForJDBC;
import oracle.dms.context.ExecutionContextListener;
import oracle.dms.context.RID;
import oracle.dms.instrument.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext {
    public static final String KEY = "ECID-Context";
    public static final String URI = "URI";
    public static final int RAW = 0;
    public static final int XML = 0;
    public static final String ECID = "ECID";
    public static final long RID_FACTOR = 512L;
    private static final String LOG_KEY = "ctxLogLevel";
    public static final String TRACE_KEY = "ctxTrace";
    public static final String LOCALE = "ctxLocale";
    public static final int KEEP = -1;
    public static final int TOSS = 0;
    public static final int EXPIRE = -2;
    private ContextFamily m_ctf = null;
    private String m_ecid = null;
    private RID m_rid = null;
    private String m_idStr = null;
    private Tracer m_defaultTracer = null;
    private Tracer m_tracer = null;
    private ECForJDBC m_jctx = null;
    private boolean m_activating = false;
    private static Logger s_logger = DMSContextManager.getLogger();
    private HashSet<ExecutionContextListener> m_listeners = null;
    private HashMap<String, String> m_ctxGlobalMap = null;
    private HashMap<String, String> m_ctxLocalMap = null;
    private HashMap<String, ContextContent> m_ctxContentMap = null;
    private ECForJDBC m_jdbcCtx = null;
    private boolean m_active = false;
    private boolean m_init = false;
    private int m_kids = 0;
    private ExecutionContext m_parent = null;
    private ExecutionContext m_pusher = null;
    private long m_lastPushedTime = 0L;
    public static final Character SEP_ID = Character.valueOf(',');
    private static final char SEP_START_STD = '@';
    private static final char SEP_START_LOG = '#';
    private static final char PLAIN = '%';
    private static final char ENCODED = '~';
    private static final String SEP_PLAIN_STD = "@%";
    private static final String SEP_PLAIN_LOG = "#%";
    private static final String SEP_ENCODED_STD = "@~";
    private static final String SEP_ENCODED_LOG = "#~";
    private static final char LOW_BITS = '\u000f';
    private static final char NIBBLE_BIT = '\u0004';
    private static final char ASCII_PRINT_SET = '@';
    private static final int MIN_CHAR = 32;
    private static final int MAX_CHAR = 126;
    private static final int ROTATE_MIN = 13;
    private static final int ROTATE_START = 23;
    private static final int ROTATE_MAX = 47;
    private static final int ROTATE_INC = 2;
    private static boolean s_encode = true;
    private static boolean s_rotate = true;
    public static final long ROOT = 0L;
    private boolean m_updateSqlText = false;

    private ExecutionContext() {
    }

    private static ExecutionContext create() {
        ContextFamily ctf = ContextFamily.create();
        if (ctf == null) {
            return null;
        }
        return ExecutionContext.create(ctf, null);
    }

    static ExecutionContext create(ContextFamily ctf, RID rid) {
        if (ctf == null) {
            s_logger.log(Level.WARNING, "CTX-00004");
            return null;
        }
        ExecutionContext ctx = new ExecutionContext();
        if (ctx == null) {
            s_logger.log(Level.WARNING, "CTX-00013");
            return null;
        }
        ctx.setECID(ctf.getECID());
        if (rid == null) {
            rid = new RID();
        }
        ctx.setRID(rid);
        ctx.setContextFamily(ctf);
        ctf.addContext(ctx);
        if (ctx.getParent() == null) {
            ctx.setGlobalMap();
        }
        return ctx;
    }

    private void setContextFamily(ContextFamily ctf) {
        this.m_ctf = ctf;
    }

    private ContextFamily getContextFamily() {
        return this.m_ctf;
    }

    public ExecutionContext createChild() {
        ++this.m_kids;
        RID kid_rid = this.generateKidRID(this.m_rid, this.m_kids);
        ContextFamily ctf = DMSContextManager.getFamily(this.m_ecid);
        if (ctf == null) {
            s_logger.log(Level.WARNING, "CTX-00005");
            return null;
        }
        ExecutionContext ctx = ExecutionContext.create(ctf, kid_rid);
        if (ctx != null) {
            ctx.setGlobalMap(this.m_ctxGlobalMap);
            ctx.setLocalMap(this.m_ctxLocalMap);
            ctx.setParent(this);
        }
        return ctx;
    }

    private void setParent(ExecutionContext parent) {
        this.m_parent = parent;
    }

    public ExecutionContext getParent() {
        return this.m_parent;
    }

    private void setGlobalMap(HashMap<String, String> pmap) {
        this.m_ctxGlobalMap = pmap;
    }

    private void setGlobalMap() {
        this.m_ctxGlobalMap = new HashMap();
    }

    private void setLocalMap(HashMap<String, String> pmap) {
        if (pmap == null) {
            return;
        }
        this.m_ctxLocalMap = new HashMap();
        this.m_ctxLocalMap.putAll(pmap);
    }

    private void setRID(RID rid) {
        this.m_rid = rid;
    }

    private void setECID(String ecid) {
        this.m_ecid = ecid;
    }

    private RID generateKidRID(RID prid, int count) {
        if (prid != null) {
            return prid.createChildRID();
        }
        return new RID();
    }

    public static ExecutionContext get() {
        ExecutionContext ctx;
        if (!DMSContextManager.isInitialized()) {
            DMSContextManager.init(null, 0);
        }
        if ((ctx = DMSContextManager.getContext()) == null) {
            ctx = ExecutionContext.create();
            if (ctx == null) {
                s_logger.log(Level.WARNING, "CTX-00013");
            } else {
                s_logger.log(Level.FINE, "CTX-00003", ctx);
                ctx.activate();
            }
        }
        return ctx;
    }

    public static ExecutionContext get(Object obj) {
        ExecutionContext ctx = null;
        if (obj == null) {
            s_logger.log(Level.WARNING, "CTX-00022");
        } else {
            ctx = DMSContextManager.get(obj);
        }
        if (ctx != null) {
            ctx.activate();
            ContextFamily ctf = ctx.getContextFamily();
            ctf.decrementStashed();
            return ctx;
        }
        s_logger.log(Level.INFO, "CTX-00024");
        return ExecutionContext.get();
    }

    public static void stash(Object obj) {
        if (obj == null) {
            s_logger.log(Level.WARNING, "CTX-00020");
            return;
        }
        ExecutionContext pctx = ExecutionContext.get();
        if (pctx == null) {
            s_logger.log(Level.WARNING, "CTX-00026");
            return;
        }
        ExecutionContext ctx = pctx.createChild();
        if (ctx == null) {
            s_logger.log(Level.WARNING, "CTX-00013");
            return;
        }
        ContextFamily ctf = pctx.getContextFamily();
        ctf.incrementStashed();
        DMSContextManager.stash(obj, ctx);
    }

    public String getECID() {
        return this.m_ecid;
    }

    Tracer getTracer() {
        if (this.m_tracer == null) {
            if (this.m_defaultTracer == null) {
                this.m_defaultTracer = new Tracer();
            }
            this.m_tracer = this.m_defaultTracer;
        }
        return this.m_tracer;
    }

    void setTracer(Tracer t) {
        this.m_tracer = t;
    }

    public String toString() {
        return this.getIDasString();
    }

    public String getIDasString() {
        if (this.m_idStr != null) {
            return this.m_idStr;
        }
        if (this.m_ecid == null || this.m_rid == null) {
            s_logger.log(Level.INFO, "CTX-00010");
            return null;
        }
        StringBuffer ret = null;
        ret = new StringBuffer();
        if (ret != null) {
            ret.append(this.m_ecid);
            ret.append(',');
            ret.append(this.m_rid.toString());
            this.m_idStr = ret.toString();
        }
        return this.m_idStr;
    }

    public static String extractECID(String ecidStr) {
        if (ecidStr != null && !ecidStr.equals("")) {
            int idx = ecidStr.indexOf(44);
            if (idx > 0) {
                return ecidStr.substring(0, idx - 1);
            }
            return ecidStr;
        }
        return null;
    }

    public String getRIDasString() {
        return this.m_rid.toString();
    }

    public static boolean unwrap(String dmsParams) {
        int last = 0;
        String ecid = null;
        String ridStr = null;
        RID rid = null;
        boolean keysAttached = true;
        boolean retval = true;
        String dmsKeys = null;
        if (!DMSContextManager.isInitialized()) {
            DMSContextManager.init(null, 0);
        }
        if (dmsParams != null) {
            int idx;
            if (s_rotate) {
                dmsParams = ExecutionContext.unrotate(dmsParams);
            }
            if ((idx = dmsParams.indexOf(SEP_ID.charValue())) > 0) {
                ecid = dmsParams.substring(0, idx);
            } else {
                retval = false;
            }
            last = idx + 1;
            idx = dmsParams.indexOf(SEP_ID.charValue(), last);
            if (idx > 0) {
                ridStr = dmsParams.substring(last, idx);
            } else {
                ridStr = dmsParams.substring(last);
                keysAttached = false;
            }
            if (ridStr != null) {
                rid = RID.createRID(ridStr);
            }
            if (keysAttached) {
                dmsKeys = dmsParams.substring(idx + 1);
            }
        }
        ContextFamily ctf = null;
        ExecutionContext ctx = null;
        if (ecid != null && rid != null) {
            ctf = DMSContextManager.getFamily(ecid);
            if (ctf != null) {
                ctx = ExecutionContext.create(ctf, rid);
            } else {
                ctf = ContextFamily.create(ecid, rid);
                ctx = ctf.getExecutionContext(rid);
            }
            if (ctx != null) {
                ctx.setGlobalMap();
                ctx.activate();
            } else {
                s_logger.log(Level.WARNING, "CTX-00013");
                retval = false;
            }
        } else {
            s_logger.log(Level.WARNING, "CTX-00030", dmsParams);
            ctx = ExecutionContext.get();
            return false;
        }
        if (ctx == null || !keysAttached) {
            return retval;
        }
        ctx.setValues(dmsKeys);
        return retval;
    }

    private void setValues(String params) {
        if (params == null) {
            return;
        }
        String key = null;
        String value = null;
        String extract = null;
        int end = params.length() - 1;
        int prev = 0;
        int nprev = 0;
        int idx = 1;
        boolean done = false;
        while (idx > 0) {
            prev = nprev;
            boolean delimiter = false;
            boolean encoding = false;
            boolean logging = false;
            block5: while (!delimiter) {
                idx = params.indexOf(64, nprev);
                int ndx = params.indexOf(35, nprev);
                if (ndx >= 0 && ndx < end && (ndx < idx || idx < 0)) {
                    idx = ndx;
                    logging = true;
                } else if (idx < 0 || idx >= end) {
                    done = true;
                    break;
                }
                char nchar = params.charAt(idx + 1);
                switch (nchar) {
                    case '%': {
                        delimiter = true;
                        nprev = idx + 2;
                        continue block5;
                    }
                    case '~': {
                        delimiter = true;
                        nprev = idx + 2;
                        encoding = true;
                        continue block5;
                    }
                }
                nprev = idx + 1;
            }
            if (done) break;
            extract = params.substring(prev, idx);
            if (s_encode && encoding) {
                extract = ExecutionContext.decode(extract);
            }
            if (key == null) {
                key = extract;
                this.m_ctf.addPropagateKey(key);
                if (!logging) continue;
                this.m_ctf.addLogKey(key);
                continue;
            }
            value = extract;
            if (key.equals(LOG_KEY)) {
                this.m_ctf.setLogLevel(Level.parse(extract));
            } else {
                this.setGlobalValue(key, extract);
            }
            key = null;
        }
    }

    public static String wrapContext() {
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx != null) {
            return ctx.wrap();
        }
        return null;
    }

    public String wrap() {
        StringBuffer sb = null;
        int maxBytes = DMSContextManager.getMaxBytes();
        sb = maxBytes > 0 ? new StringBuffer(maxBytes) : new StringBuffer();
        this.insertID(sb);
        HashSet<String> propKeys = this.getPropagateKeys();
        HashSet<String> logKeys = this.getLogKeys();
        for (String key : propKeys) {
            String value = this.getValue(key);
            if (value == null) continue;
            if (logKeys.contains(key)) {
                ExecutionContext.insert(sb, key, value, true);
                continue;
            }
            ExecutionContext.insert(sb, key, value, false);
        }
        Level level = this.m_ctf.getLogLevel();
        if (level != null) {
            ExecutionContext.insert(sb, LOG_KEY, level.toString(), false);
        }
        String wrapped = sb.toString();
        if (s_rotate) {
            return ExecutionContext.rotate(wrapped);
        }
        return wrapped;
    }

    private void insertID(StringBuffer sb) {
        sb.append(this.getECID());
        sb.append(SEP_ID);
        ++this.m_kids;
        RID kid_rid = this.generateKidRID(this.m_rid, this.m_kids);
        sb.append(kid_rid.toString());
        sb.append(SEP_ID);
    }

    private static String rotate(String in) {
        if (in == null) {
            return null;
        }
        int rotate = 23;
        char[] chars = in.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int nchar = chars[i];
            if (nchar < 32 || nchar >= 126) continue;
            if ((nchar += rotate) >= 126) {
                nchar -= 94;
            }
            chars[i] = (char)nchar;
            if (rotate >= 47) {
                rotate = 13;
                continue;
            }
            rotate += 2;
        }
        return new String(chars);
    }

    private static String unrotate(String in) {
        if (in == null) {
            return null;
        }
        int rotate = 23;
        char[] chars = in.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int nchar = chars[i];
            if (nchar < 32 || nchar >= 126) continue;
            if ((nchar -= rotate) < 32) {
                nchar += 94;
            }
            chars[i] = (char)nchar;
            if (rotate >= 47) {
                rotate = 13;
                continue;
            }
            rotate += 2;
        }
        return new String(chars);
    }

    String getChildRIDasString() {
        ++this.m_kids;
        RID kid_rid = this.generateKidRID(this.m_rid, this.m_kids);
        return kid_rid.toString();
    }

    private static void insert(StringBuffer sb, String key, String value, boolean toLog) {
        String encKeySep = SEP_ENCODED_STD;
        String plainKeySep = SEP_PLAIN_STD;
        if (toLog) {
            encKeySep = SEP_ENCODED_LOG;
            plainKeySep = SEP_PLAIN_LOG;
        }
        if (s_encode && ExecutionContext.mustEncode(key)) {
            sb.append(ExecutionContext.encode(key));
            sb.append(encKeySep);
        } else {
            sb.append(key);
            sb.append(plainKeySep);
        }
        if (s_encode && ExecutionContext.mustEncode(value)) {
            sb.append(ExecutionContext.encode(value));
            sb.append(SEP_ENCODED_STD);
        } else {
            sb.append(value);
            sb.append(SEP_PLAIN_STD);
        }
    }

    private static boolean mustEncode(String in) {
        StringBuffer sb = new StringBuffer(in);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char nc;
            char c = sb.charAt(i);
            if (c < ' ' || c > '~' || c == '\n' || c == '\r') {
                return true;
            }
            if (c != '@' && c != '#' || i + 1 >= len || (nc = sb.charAt(i + 1)) != '%' && nc != '~') continue;
            return true;
        }
        return false;
    }

    private static String encode(String in) {
        if (in == null) {
            return null;
        }
        char[] chars = in.toCharArray();
        int len = chars.length;
        char[] new_chars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            new_chars[j++] = (char)(chars[i] >>> 4 | 0x40);
            new_chars[j++] = (char)(chars[i] & 0xF | 0x40);
        }
        return new String(new_chars);
    }

    private static String decode(String in) {
        if (in == null) {
            return null;
        }
        char[] chars = in.toCharArray();
        int len = chars.length;
        char[] new_chars = new char[len / 2];
        int j = 0;
        int i = 0;
        while (i + 1 < len) {
            char high = (char)(chars[i++] ^ 0x40);
            char low = (char)(chars[i] ^ 0x40);
            new_chars[j++] = (char)(high << 4 | low);
            ++i;
        }
        return new String(new_chars);
    }

    public long getParentRID() {
        return 0L;
    }

    public RID getRID() {
        return this.m_rid;
    }

    public long[] getChildren() {
        return null;
    }

    public synchronized boolean isActive() {
        return this.m_active;
    }

    boolean isInitialized() {
        return this.m_init;
    }

    public synchronized void deactivate() {
        boolean unset = DMSContextManager.unsetContext(this);
        if (this.isActive()) {
            this.m_ctf.delActive(this);
            s_logger.log(Level.FINEST, "CTX-00001", this);
            if (this.m_pusher != null) {
                this.m_pusher.cancel();
            }
            this.m_active = false;
        } else if (this.m_kids == 0) {
            this.m_ctf.eliminate(this);
        } else {
            this.m_ctf.decrNewKids();
        }
    }

    public static void deactivateContext() {
        if (!DMSContextManager.hasContext()) {
            return;
        }
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx != null) {
            ctx.deactivate();
        }
    }

    public synchronized void activate() {
        this.m_activating = true;
        DMSContextManager.setContext(this);
        if (!this.m_init) {
            this.m_init = true;
            this.m_ctf.decrNewKids();
        }
        this.m_ctf.addActive(this);
        this.m_active = true;
        s_logger.log(Level.FINEST, "CTX-00001", this);
        this.m_activating = false;
    }

    private void cancel() {
        if (this.m_activating) {
            return;
        }
        this.m_ctf.decrNewKids();
        if (this.m_pusher != null) {
            this.m_pusher.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalValue(String key, String value) {
        if (key == null) {
            return;
        }
        HashMap<String, String> hashMap = this.m_ctxGlobalMap;
        synchronized (hashMap) {
            this.m_ctxGlobalMap.put(key, value);
        }
        if (this.m_listeners != null) {
            for (ExecutionContextListener lsnr : this.m_listeners) {
                lsnr.keyTouched(key);
            }
        }
    }

    public void setLocalValue(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.m_ctxLocalMap == null) {
            this.m_ctxLocalMap = new HashMap();
        }
        if (value != null) {
            this.m_ctxLocalMap.put(key, value);
        } else {
            String val = this.m_ctxLocalMap.remove(key);
            if (val == null) {
                return;
            }
        }
        if (this.m_listeners != null) {
            for (ExecutionContextListener lsnr : this.m_listeners) {
                lsnr.keyTouched(key);
            }
        }
    }

    public void setValue(String key, String value) {
        this.setLocalValue(key, value);
    }

    public void setLogLevel(Level level) {
        this.m_ctf.setLogLevel(level);
    }

    public Level getLogLevel() {
        return this.m_ctf.getLogLevel();
    }

    public HashSet<String> getLogKeys() {
        HashSet<String> keys = this.m_ctf.getLogKeys();
        if (keys == null) {
            return DMSContextManager.s_logKeys;
        }
        keys.addAll(DMSContextManager.s_logKeys);
        return keys;
    }

    public HashSet<String> getPropagateKeys() {
        HashSet<String> keys = this.m_ctf.getPropagateKeys();
        if (keys == null) {
            return DMSContextManager.s_propagateKeys;
        }
        keys.addAll(DMSContextManager.s_propagateKeys);
        return keys;
    }

    public String getValue(String key) {
        String value = this.getLocalValue(key);
        if (value != null) {
            return value;
        }
        return this.m_ctxGlobalMap.get(key);
    }

    boolean hasKey(String key) {
        return this.m_ctxLocalMap.containsKey(key) || this.m_ctxGlobalMap.containsKey(key);
    }

    public String getGlobalValue(String key) {
        if (key == null) {
            return null;
        }
        return this.m_ctxGlobalMap.get(key);
    }

    public String getLocalValue(String key) {
        if (key == null || this.m_ctxLocalMap == null) {
            return null;
        }
        return this.m_ctxLocalMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String key, ContextContent content) {
        if (key == null) {
            s_logger.log(Level.WARNING, "CTX-00027");
            return;
        }
        if (content == null) {
            s_logger.log(Level.WARNING, "CTX-00028", key);
            return;
        }
        ExecutionContext executionContext = this;
        synchronized (executionContext) {
            if (this.m_ctxContentMap == null) {
                this.m_ctxContentMap = new HashMap();
                this.m_ctxContentMap.put(key, content);
            }
        }
    }

    public ContextContent getContent(String key) {
        if (this.m_ctxContentMap == null) {
            return null;
        }
        return this.m_ctxContentMap.get(key);
    }

    public String dump(int format) {
        return this.rawDump();
    }

    private String rawDump() {
        Level level;
        StringBuffer sb = new StringBuffer();
        sb.append("Dumping Context for ECID,RID: ");
        sb.append(this.toString());
        sb.append("\nGLOBAL KEYS: ");
        for (String key : this.m_ctxGlobalMap.keySet()) {
            sb.append(key + "=" + this.m_ctxGlobalMap.get(key) + "; ");
        }
        if (this.m_ctxLocalMap != null) {
            sb.append("\nLOCAL KEYS: ");
            for (String key : this.m_ctxLocalMap.keySet()) {
                sb.append(key + "=" + this.m_ctxLocalMap.get(key) + ",");
            }
        }
        if ((level = this.getLogLevel()) != null) {
            sb.append("\nLOG LEVEL: " + level);
        }
        if (this.m_listeners != null) {
            sb.append("\nLISTENERS: ");
            for (ExecutionContextListener lsnr : this.m_listeners) {
                sb.append("\n" + lsnr.getClass().getName() + ": " + lsnr.toString());
            }
        }
        if (this.m_ctxContentMap != null) {
            sb.append("\nCONTEXT CONTENT: ");
            for (String key : this.m_ctxContentMap.keySet()) {
                ContextContent content = this.m_ctxContentMap.get(key);
                sb.append("ContextContent(" + key + ")=" + ((Object)content).toString() + ",");
            }
        }
        return sb.toString();
    }

    ECForJDBC getECForJDBC() {
        if (this.m_jctx == null) {
            this.m_jctx = new ECForJDBC(this);
            if (this.m_listeners == null) {
                this.m_listeners = new HashSet();
            }
            this.m_listeners.add(this.m_jctx);
            s_logger.log(Level.FINE, "CTX-00007", this.m_jctx.toString());
        }
        return this.m_jctx;
    }

    boolean updateSqlText() {
        return this.m_updateSqlText;
    }

    static void setEncode(boolean encode) {
        s_encode = encode;
    }

    static void setRotate(boolean rotate) {
        s_rotate = rotate;
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public static String generateNewWrappedContext() {
        ExecutionContext ctx = new ExecutionContext();
        ctx.m_ecid = LogManager.getLogManager().getUniqueId();
        ctx.m_rid = new RID();
        StringBuffer sb = new StringBuffer();
        ctx.insertID(sb);
        String wrapped = sb.toString();
        if (s_rotate) {
            return ExecutionContext.rotate(wrapped);
        }
        return wrapped;
    }

    public static String getChildWrappedContext(String wrapped) {
        int idx = 0;
        int last = 0;
        String ecid = null;
        String ridStr = null;
        Object rid = null;
        boolean keysAttached = true;
        String dmsKeys = null;
        if (!DMSContextManager.isInitialized()) {
            DMSContextManager.init(null, 0);
        }
        if (wrapped != null) {
            if (s_rotate) {
                wrapped = ExecutionContext.unrotate(wrapped);
            }
            if ((idx = wrapped.indexOf(SEP_ID.charValue())) <= 0) {
                return ExecutionContext.generateNewWrappedContext();
            }
            ecid = wrapped.substring(0, idx);
            last = idx + 1;
            idx = wrapped.indexOf(SEP_ID.charValue(), last);
            if (idx > 0) {
                ridStr = wrapped.substring(last, idx);
            } else {
                ridStr = wrapped.substring(last);
                keysAttached = false;
            }
        }
        if (ridStr == null) {
            return ExecutionContext.generateNewWrappedContext();
        }
        ridStr = ridStr + ":" + RID.getUniqueHexChild();
        String newWrapped = ecid + SEP_ID + ridStr + SEP_ID;
        if (keysAttached) {
            dmsKeys = wrapped.substring(idx + 1);
            newWrapped = newWrapped + dmsKeys;
        }
        if (s_rotate) {
            return ExecutionContext.rotate(newWrapped);
        }
        return newWrapped;
    }

    public static ExecutionContext pushChild() {
        ExecutionContext parent = null;
        ExecutionContext ctx = null;
        if (DMSContextManager.hasContext()) {
            parent = ExecutionContext.get();
            ctx = parent.createChild();
            ctx.setPusher(parent);
            parent.addToPendingChildren();
            ctx.activate();
        } else {
            ctx = ExecutionContext.get();
        }
        return ctx;
    }

    public static ExecutionContext pushNewContext() {
        ExecutionContext pusher = null;
        if (DMSContextManager.hasContext()) {
            pusher = ExecutionContext.get();
            pusher.addToPendingChildren();
            pusher.deactivate();
        }
        ExecutionContext ctx = ExecutionContext.get();
        ctx.setPusher(pusher);
        return ctx;
    }

    private void setPusher(ExecutionContext pusher) {
        this.m_pusher = pusher;
    }

    private void addToPendingChildren() {
        this.m_ctf.incrNewKids();
    }

    private ExecutionContext getPusher() {
        return this.m_pusher;
    }

    public static void pop() {
        ExecutionContext ctx;
        ExecutionContext pusher;
        if (DMSContextManager.hasContext() && (pusher = (ctx = ExecutionContext.get()).getPusher()) != null) {
            pusher.activate();
        }
    }
}

