/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import oracle.dms.console.DMSConsoleException;
import oracle.dms.console.DMSError;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.LoggerFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.SensorFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.instrument.TransTraceIntf;
import oracle.dms.util.DMSProperties;

public abstract class DMSConsole {
    private static DMSConsole s_console = null;

    protected DMSConsole() {
    }

    public static DMSConsole getConsole() {
        Class<Object> consoleClass;
        if (s_console != null) {
            return s_console;
        }
        String consoleClassName = DMSProperties.getProperty("oracle.dms.console.DMSConsole", "oracle.dms.instrument.DMSConsole");
        try {
            consoleClass = Class.forName(consoleClassName);
        }
        catch (ClassNotFoundException ex) {
            consoleClass = oracle.dms.instrument.DMSConsole.class;
        }
        try {
            s_console = (DMSConsole)consoleClass.newInstance();
            return s_console;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            throw new DMSConsoleException(ex.toString());
        }
        catch (InstantiationError ex) {
            ex.printStackTrace();
            throw new DMSConsoleException(ex.toString());
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new DMSConsoleException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new DMSConsoleException(ex.toString());
        }
    }

    public abstract void debug(String var1);

    public abstract EventFactoryIntf newEventFactory();

    public abstract NounFactoryIntf newNounFactory();

    public abstract PhaseEventFactoryIntf newPhaseEventFactory();

    public abstract SensorFactoryIntf newSensorFactory();

    public abstract StateFactoryIntf newStateFactory();

    public abstract LoggerFactoryIntf newLoggerFactory();

    public abstract EventFactoryIntf getEventFactory();

    public abstract NounFactoryIntf getNounFactory();

    public abstract PhaseEventFactoryIntf getPhaseEventFactory();

    public abstract SensorFactoryIntf getSensorFactory();

    public abstract StateFactoryIntf getStateFactory();

    public abstract LoggerFactoryIntf getLoggerFactory();

    public abstract TransTraceIntf getTransTrace();

    public abstract void setProcessID(int var1);

    public abstract void setProcessID(String var1);

    public abstract String getProcessID();

    public abstract void init(String var1) throws DMSError;

    public abstract void init(String var1, Properties var2) throws DMSError;

    public abstract void setName(String var1);

    public abstract String getName();

    public abstract Object getMetricValue(String var1);

    public abstract void exit();

    public abstract void exit(boolean var1);

    public abstract boolean isActive();

    public abstract void setDumpFile(String var1);

    public abstract String getDumpFile();

    public abstract void dump();

    public abstract void dump(String var1, boolean var2, boolean var3);

    public abstract void dump(PrintWriter var1, boolean var2) throws IOException;

    public abstract void dump(PrintWriter var1, String var2);

    public abstract void dump(String var1, String var2, boolean var3);
}

