/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.incident.Incident;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloodController
implements Runnable,
DiagnosticsListener {
    private boolean m_isEnabled;
    private boolean m_stop = false;
    private boolean m_reset = true;
    private Object m_sync = new Object();
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private Map<String, FloodIncident> m_incidents = Collections.synchronizedMap(new HashMap());
    private int m_incidentCount = 1;
    private long m_incidentTimePeriod = 900000L;
    private static final long SLEEP_INTERVAL = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloodController(DiagnosticsConfiguration diagConfig) {
        Object object = this.m_sync;
        synchronized (object) {
            Thread floodThread = new Thread(this);
            floodThread.setDaemon(true);
            floodThread.setName("FloodController");
            floodThread.start();
            this.setConfig(diagConfig);
        }
        DiagnosticsEventManager.registerListener(this);
    }

    boolean isFloodControlled(Incident incident) {
        if (!this.m_isEnabled) {
            return false;
        }
        boolean isFloodControlled = false;
        FloodIncident floodIncident = this.m_incidents.get(incident.getProblemKey());
        if (floodIncident != null) {
            isFloodControlled = floodIncident.getAccessCount() >= this.m_incidentCount;
            floodIncident.accessed();
        } else {
            this.m_incidents.put(incident.getProblemKey(), new FloodIncident());
        }
        return isFloodControlled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_logger.fine("Flood control daemon started");
        while (true) {
            Object object = this.m_sync;
            synchronized (object) {
                try {
                    this.m_reset = false;
                    if (this.m_isEnabled) {
                        this.m_sync.wait(60000L);
                    } else {
                        if (this.m_logger.isLoggable(Level.FINEST)) {
                            this.m_logger.log(Level.FINEST, "Flood control is disabled, flood controller daemon is going to sleep indefinitely");
                        }
                        this.m_sync.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.m_reset = true;
                }
                if (this.m_stop) {
                    break;
                }
                if (!this.m_isEnabled || this.m_reset) {
                    continue;
                }
            }
            ArrayList<String> expiredIncidents = new ArrayList<String>();
            Map<String, FloodIncident> map = this.m_incidents;
            synchronized (map) {
                for (String problemKey : this.m_incidents.keySet()) {
                    FloodIncident floodIncident = this.m_incidents.get(problemKey);
                    if (System.currentTimeMillis() - floodIncident.getCreationTime() > this.m_incidentTimePeriod) {
                        expiredIncidents.add(problemKey);
                    }
                    for (String key : expiredIncidents) {
                        this.m_incidents.remove(key);
                        this.m_logger.fine("Removed incident problem key from flood control: " + key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfig(DiagnosticsConfiguration config) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.log(Level.FINEST, "Resetting the configuration of flood control daemon");
        }
        Object object = this.m_sync;
        synchronized (object) {
            this.m_isEnabled = config.isFloodControlEnabled();
            if (!this.m_isEnabled) {
                this.m_incidents.clear();
            }
            this.m_incidentCount = config.getFloodControlIncidentCount();
            this.m_incidentTimePeriod = config.getFloodControlIncidentTimePeriod() * 60 * 1000;
            this.m_reset = true;
            this.m_sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DiagnosticsEventManager.deregisterListener(this);
        Object object = this.m_sync;
        synchronized (object) {
            this.m_stop = true;
            this.m_sync.notify();
        }
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            this.setConfig(((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration());
        }
    }

    @Override
    public Class<DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    private class FloodIncident {
        private long m_creationTime = System.currentTimeMillis();
        private int m_accessCount = 1;

        FloodIncident() {
        }

        synchronized void accessed() {
            ++this.m_accessCount;
        }

        synchronized int getAccessCount() {
            return this.m_accessCount;
        }

        long getCreationTime() {
            return this.m_creationTime;
        }
    }
}

