/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.as.management.translation.NLSupport;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.dfw.common.AdvancedTopologyInfo;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.dump.DumpCatalog;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpManager;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.impl.incident.DiagnosticRulesManagerImpl;
import oracle.dfw.impl.incident.IncidentDumpImpl;
import oracle.dfw.impl.incident.IncidentImpl;
import oracle.dfw.incident.DiagnosticRulesManager;
import oracle.dfw.incident.DumpExecutor;
import oracle.dfw.incident.FloodController;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentActions;
import oracle.dfw.incident.IncidentCreationCallback;
import oracle.dfw.incident.IncidentCreationCallbackResult;
import oracle.dfw.incident.IncidentCreationEvent;
import oracle.dfw.incident.IncidentDump;
import oracle.dfw.incident.IncidentException;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentIdGenerator;
import oracle.dfw.resource.DiagnosticsResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticsDataExtractor {
    private String m_oracleInstancePath;
    private String m_incidentRootPath;
    private DumpCatalog m_dumpCatalog;
    private Logger m_logger;
    private IncidentCreationCallback m_incidentCreationCallback;
    private IncidentIdGenerator m_incidentIdGenerator;
    private DiagnosticRulesManagerImpl m_rulesManager;
    private DumpExecutor m_dumpExecutor;
    private AdvancedTopologyInfo m_topoInfo;
    private FloodController m_floodController;
    private NLSupport m_nlSupport;
    private boolean m_shutdown;
    private static final String INCIDENT_SUB_PATH = "diagnostics" + File.separatorChar + "incidents";
    private static final String INCIDENT_FILE = "incident.xml";
    private static final String CLASS_NAME = DiagnosticsDataExtractor.class.getName();
    private static final String PROCESS_DUMP_ACTIONS = "processDumpActions";
    private static final int DEFAULT_TIMEOUT = 120000;
    private List<IncidentCreatorThread.IncidentFactsIDPair> m_queue = new ArrayList<IncidentCreatorThread.IncidentFactsIDPair>();
    private IncidentCreatorThread m_incidentCreatorThread;

    public DiagnosticsDataExtractor(String oracleInstancePath, DumpCatalog catalog, IncidentIdGenerator generator, AdvancedTopologyInfo topoInfo, DiagnosticsConfiguration diagConfig) throws DiagnosticsException {
        if (oracleInstancePath == null || oracleInstancePath.length() == 0 || catalog == null || generator == null) {
            throw new IllegalArgumentException("Invalid arguments oracleInstancePath=" + oracleInstancePath + " catalog=" + catalog + " generator=" + generator);
        }
        String incidentRootPath = oracleInstancePath + File.separatorChar + INCIDENT_SUB_PATH;
        File checkPath = new File(incidentRootPath);
        try {
            if (!checkPath.exists() && !checkPath.mkdirs()) {
                this.m_logger.log(Level.WARNING, "40359", incidentRootPath);
                throw new DiagnosticsException("40359", incidentRootPath);
            }
            this.m_incidentRootPath = incidentRootPath;
        }
        catch (SecurityException e) {
            this.m_logger.log(Level.WARNING, "40359", incidentRootPath);
            throw new DiagnosticsException("40359", incidentRootPath, e);
        }
        this.m_logger = LoggerFactory.getFrameworkLogger();
        this.m_oracleInstancePath = oracleInstancePath;
        this.m_incidentIdGenerator = generator;
        this.m_dumpCatalog = catalog;
        this.m_topoInfo = topoInfo;
        this.m_rulesManager = new DiagnosticRulesManagerImpl(topoInfo, this.m_dumpCatalog);
        this.m_floodController = new FloodController(diagConfig);
        this.m_nlSupport = NLSupport.getNLSupport(DiagnosticsResourceBundle.class.getName(), Thread.currentThread().getContextClassLoader());
    }

    public void setIncidentCreationCallback(IncidentCreationCallback callback) {
        this.m_incidentCreationCallback = callback;
    }

    public void setDumpExecutor(DumpExecutor executor) {
        this.m_dumpExecutor = executor;
    }

    public String signalIncident(IncidentFacts facts, boolean immediately) throws IncidentException {
        String id = this.m_incidentIdGenerator.generateId();
        if (immediately) {
            this.signalIncident(facts, id);
        } else {
            if (this.m_incidentCreatorThread == null) {
                this.m_incidentCreatorThread = new IncidentCreatorThread();
            }
            this.m_incidentCreatorThread.add(id, facts);
        }
        return id;
    }

    public Incident signalIncident(IncidentFacts facts) throws IncidentException {
        return this.signalIncident(facts, this.m_incidentIdGenerator.generateId());
    }

    private Incident signalIncident(IncidentFacts facts, String incidentId) throws IncidentException {
        IncidentImpl incident;
        block21: {
            block20: {
                if (facts == null || incidentId == null) {
                    throw new IllegalArgumentException("facts=" + facts + " incidentId=" + incidentId);
                }
                if (this.m_logger.isLoggable(Level.INFO)) {
                    this.m_logger.log(Level.INFO, "MAS-40360", facts.toString());
                }
                incident = null;
                try {
                    IncidentActions actions = this.m_rulesManager.evaluateRules(facts);
                    incident = new IncidentImpl(incidentId, facts);
                    if (incident.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM) && this.m_floodController.isFloodControlled(incident)) {
                        incident.setStatus(Incident.IncidentStatus.FLOOD_CONTROLLED);
                        break block20;
                    }
                    ArrayList<IncidentDump> incidentDumps = new ArrayList<IncidentDump>();
                    if (actions != null && actions.getDumpContextList() != null && actions.getDumpContextList().size() > 0) {
                        List<IncidentDump> executedDumps;
                        if (this.m_logger.isLoggable(Level.FINER)) {
                            this.m_logger.finer("Incident facts resulted in " + actions.getDumpContextList().size() + " dump actions being evaluated");
                        }
                        if ((executedDumps = this.processDumpActions(actions.getDumpContextList(), incident)) != null) {
                            incidentDumps.addAll(executedDumps);
                        }
                    }
                    if (this.m_incidentCreationCallback != null) {
                        try {
                            IncidentCreationCallbackResult result = new IncidentCreationCallbackResult();
                            this.m_incidentCreationCallback.incidentCreated(facts, incident.getIncidentId(), actions.getUnresolvedDumpContextList(), result);
                            for (DumpResult dump : result.getDumpResults()) {
                                incidentDumps.add(new IncidentDumpImpl(dump, incident.getIncidentSource()));
                            }
                        }
                        catch (Throwable e) {
                            this.m_logger.log(Level.WARNING, "MAS-40361", e.getMessage());
                        }
                    }
                    for (IncidentDump dump : incidentDumps) {
                        incident.addIncidentDump(dump);
                    }
                }
                catch (Throwable e) {
                    this.m_logger.log(Level.WARNING, "MAS-40362", e.getMessage());
                    throw new IncidentException("40362", e.getMessage(), e);
                }
            }
            if (incident != null) {
                try {
                    this.persistIncident(incident);
                    if (!this.m_logger.isLoggable(Level.INFO)) break block21;
                    String msg = null;
                    try {
                        msg = this.m_nlSupport.getTranslation("MAS-40365", new Object[]{incident.getIncidentId()});
                    }
                    catch (Exception e) {
                        msg = "Incident \"" + incident.getIncidentId() + "\" created";
                    }
                    ODLLogRecord logRec = new ODLLogRecord(Level.INFO, msg);
                    logRec.setMessageId("MAS-40365");
                    logRec.setProblemKey(incident.getProblemKey());
                    logRec.setErrorInstanceId(incident.getIncidentId());
                    this.m_logger.log(logRec);
                }
                catch (Throwable e) {
                    this.m_logger.log(Level.SEVERE, "MAS-40363", e.getMessage());
                    if (e instanceof IncidentException) {
                        throw (IncidentException)e;
                    }
                    throw new IncidentException("40363", e.getMessage(), e);
                }
            }
        }
        if (incident != null) {
            DiagnosticsEventManager.notifyListeners(new IncidentCreationEvent(incident), false);
        }
        return incident;
    }

    private void persistIncident(Incident incident) throws IncidentException {
        String xml;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "Persisting incident " + incident.getIncidentId());
        }
        if ((xml = incident.toXML()) == null) {
            throw new IncidentException("40364");
        }
        String incidentDirectory = this.m_incidentRootPath + File.separatorChar + incident.getIncidentId();
        File incidentFile = new File(incidentDirectory);
        try {
            if (!incidentFile.exists() && !incidentFile.mkdir()) {
                this.m_logger.log(Level.WARNING, "MAS-40359", incidentDirectory);
                throw new IncidentException("40359", incidentDirectory);
            }
        }
        catch (SecurityException e) {
            this.m_logger.log(Level.WARNING, "MAS-40359", incidentDirectory);
            throw new IncidentException("40359", incidentDirectory, e);
        }
        String filePath = incidentDirectory + File.separatorChar + INCIDENT_FILE;
        try {
            PrintWriter pw = new PrintWriter(filePath);
            pw.print(xml);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "MAS-40366", filePath);
            throw new IncidentException("40366", filePath, e);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, "Incident " + incident.getIncidentId() + " to file " + filePath);
        }
    }

    public DiagnosticRulesManager getDiagnosticRulesManager() {
        return this.m_rulesManager;
    }

    private List<IncidentDump> processDumpActions(List<DumpContext> actions, Incident incident) {
        ArrayList<IncidentDump> executedDumps = new ArrayList<IncidentDump>();
        String incidentId = incident.getIncidentId();
        ArrayList<SingleDumpExecutor> dumpers = new ArrayList<SingleDumpExecutor>(actions.size());
        for (DumpContext ctx : actions) {
            ctx.setIncidentId(incidentId);
            dumpers.add(new SingleDumpExecutor(ctx));
        }
        ExecutorService pool = Executors.newFixedThreadPool(3);
        List futures = null;
        try {
            futures = pool.invokeAll(dumpers);
        }
        catch (Throwable t) {
            this.m_logger.log(Level.FINE, "Failed to execute diagnostic dumps", t);
        }
        if (futures != null) {
            for (Future future : futures) {
                try {
                    DumpResult result = (DumpResult)future.get(120000L, TimeUnit.MILLISECONDS);
                    if (result == null) continue;
                    executedDumps.add(new IncidentDumpImpl(result, incident.getIncidentSource()));
                    if (!this.m_logger.isLoggable(Level.FINEST)) continue;
                    this.m_logger.logp(Level.FINEST, CLASS_NAME, PROCESS_DUMP_ACTIONS, "Dump executed successfully: " + result.getDumpContext().getDumpName());
                }
                catch (Throwable t) {
                    if (!this.m_logger.isLoggable(Level.FINE)) continue;
                    this.m_logger.log(Level.FINE, "MAS-40367", new String[]{"", incidentId, t.getMessage()});
                }
            }
            if (pool != null && !pool.isShutdown()) {
                pool.shutdownNow();
            }
        }
        return executedDumps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        DiagnosticsDataExtractor diagnosticsDataExtractor = this;
        synchronized (diagnosticsDataExtractor) {
            if (this.m_shutdown) {
                return;
            }
            this.m_shutdown = true;
        }
        this.m_rulesManager.shutdown();
    }

    private class IncidentCreatorThread
    implements Runnable {
        protected IncidentCreatorThread() {
            Thread th = new Thread(this);
            th.setDaemon(true);
            th.setName("IncidentCreatorThread");
            th.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                IncidentFactsIDPair pair;
                List list = DiagnosticsDataExtractor.this.m_queue;
                synchronized (list) {
                    if (DiagnosticsDataExtractor.this.m_queue.size() == 0) {
                        try {
                            DiagnosticsDataExtractor.this.m_queue.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    pair = (IncidentFactsIDPair)DiagnosticsDataExtractor.this.m_queue.remove(0);
                }
                try {
                    DiagnosticsDataExtractor.this.signalIncident(pair.m_facts, pair.m_id);
                }
                catch (Throwable t) {
                    DiagnosticsDataExtractor.this.m_logger.log(Level.WARNING, "MAS-40390", t.getMessage());
                }
                Object var1_1 = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(String id, IncidentFacts facts) {
            List list = DiagnosticsDataExtractor.this.m_queue;
            synchronized (list) {
                DiagnosticsDataExtractor.this.m_queue.add(new IncidentFactsIDPair(id, facts));
                DiagnosticsDataExtractor.this.m_queue.notify();
            }
        }

        class IncidentFactsIDPair {
            String m_id;
            IncidentFacts m_facts;

            IncidentFactsIDPair(String id, IncidentFacts facts) {
                this.m_id = id;
                this.m_facts = facts;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleDumpExecutor
    implements Callable<DumpResult> {
        private DumpContext m_context;

        SingleDumpExecutor(DumpContext context) {
            this.m_context = context;
        }

        @Override
        public DumpResult call() {
            DumpResult result;
            block3: {
                if (DiagnosticsDataExtractor.this.m_logger.isLoggable(Level.FINEST)) {
                    DiagnosticsDataExtractor.this.m_logger.logp(Level.FINEST, CLASS_NAME, DiagnosticsDataExtractor.PROCESS_DUMP_ACTIONS, "Executing dump " + this.m_context.getDumpName());
                }
                result = null;
                try {
                    result = DiagnosticsDataExtractor.this.m_dumpExecutor != null ? DiagnosticsDataExtractor.this.m_dumpExecutor.executeDump(this.m_context) : DumpManager.getInstance().executeDump(this.m_context);
                }
                catch (Throwable t) {
                    if (!DiagnosticsDataExtractor.this.m_logger.isLoggable(Level.INFO)) break block3;
                    DiagnosticsDataExtractor.this.m_logger.log(Level.INFO, "MAS-40367", new String[]{this.m_context.getDumpName(), this.m_context.getIncidentID(), t.getMessage()});
                }
            }
            return result;
        }
    }
}

