/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.impl.incident.DateFormat;
import oracle.dfw.impl.incident.IncidentDumpImpl;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentDump;
import oracle.dfw.incident.IncidentException;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentRulesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentImpl
implements Incident,
Serializable {
    private Exception m_errorParsing;
    private String m_problemKey;
    private String m_description;
    private String m_executionContextId;
    private ErrorMessage m_errorMessage;
    private String m_incidentId;
    private Incident.IncidentSource m_incidentSource;
    private Incident.IncidentStatus m_incidentStatus;
    private List<DiagnosticsCategory> m_problemImpacts;
    private long m_incidentTime;
    private List<IncidentDump> m_incidentDumps = new ArrayList<IncidentDump>();
    private transient DocumentBuilderFactory m_schemaFactory = DocumentBuilderFactory.newInstance();
    private static final transient String SCHEMA_FILE = "/oracle/dfw/incident/diagnostics_incident.xsd";
    private static final transient String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final transient String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public IncidentImpl(String incidentId, IncidentFacts facts) {
        if (incidentId == null || incidentId.length() == 0) {
            throw new IllegalArgumentException("incidentId=" + incidentId);
        }
        this.m_incidentId = incidentId;
        this.m_incidentTime = facts.getIncidentTime();
        this.m_errorMessage = facts.getErrorMessage();
        this.m_incidentSource = facts.getIncidentSource();
        this.m_executionContextId = facts.getExecutionContextId();
        this.m_incidentStatus = Incident.IncidentStatus.CREATED;
        this.m_description = facts.getDescription();
        List<String> impacts = facts.getIncidentFactPropertyValues(IncidentFacts.IncidentFactProperty.PROBLEM_IMPACT_PROP);
        if (impacts != null) {
            this.m_problemImpacts = new ArrayList<DiagnosticsCategory>(impacts.size());
            for (String impact : impacts) {
                DiagnosticsCategory category = DiagnosticsCategory.getDiagnosticsCategory(impact);
                if (category == null) continue;
                this.m_problemImpacts.add(category);
            }
        }
        this.generateProblemKey();
    }

    public IncidentImpl(Reader incidentXML) throws IncidentException {
        this.m_schemaFactory.setNamespaceAware(true);
        this.m_schemaFactory.setValidating(true);
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = this.getClass().getResource(SCHEMA_FILE);
        if (defaultSchema == null) {
            throw new IncidentRulesException("40379", SCHEMA_FILE);
        }
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
        try {
            this.parseIncidentXML(incidentXML);
        }
        catch (Exception e) {
            if (e instanceof IncidentException) {
                throw (IncidentException)e;
            }
            throw new IncidentException("40380", e);
        }
    }

    @Override
    public String getIncidentId() {
        return this.m_incidentId;
    }

    @Override
    public long getTimeOfIncident() {
        return this.m_incidentTime;
    }

    @Override
    public List<DiagnosticsCategory> getProblemImpacts() {
        return this.m_problemImpacts;
    }

    @Override
    public String getExecutionContextId() {
        return this.m_executionContextId;
    }

    @Override
    public Incident.IncidentSource getIncidentSource() {
        return this.m_incidentSource;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.m_errorMessage;
    }

    @Override
    public List<IncidentDump> getIncidentDumps() {
        return this.m_incidentDumps;
    }

    @Override
    public Incident.IncidentStatus getStatus() {
        return this.m_incidentStatus;
    }

    public void setStatus(Incident.IncidentStatus status) {
        this.m_incidentStatus = status;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getProblemKey() {
        return this.m_problemKey;
    }

    public void addIncidentDump(IncidentDump dump) {
        if (dump == null) {
            return;
        }
        this.m_incidentDumps.add(dump);
    }

    public void removeIncidentDump(IncidentDump dump) {
        if (dump == null) {
            return;
        }
        this.m_incidentDumps.remove(dump);
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        buf.append("<incident xmlns=\"http://www.oracle.com/MAS/DiagnosticsFrameworkIncident\" ");
        buf.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        buf.append("id=\"");
        buf.append(this.m_incidentId);
        buf.append("\" dateCreated=\"");
        new DateFormat().format(this.m_incidentTime, buf);
        buf.append("\" source=\"");
        buf.append((Object)this.m_incidentSource);
        buf.append("\" problemKey=\"");
        buf.append(this.m_problemKey);
        buf.append("\" status=\"");
        buf.append((Object)this.m_incidentStatus);
        if (this.m_executionContextId != null) {
            buf.append("\" ecid=\"");
            buf.append(this.m_executionContextId);
        }
        if (this.m_errorMessage != null) {
            if (this.m_errorMessage.getErrorFacility() != null) {
                buf.append("\" facility=\"");
                buf.append(this.m_errorMessage.getErrorFacility());
            }
            buf.append("\" errorCode=\"");
            buf.append(this.m_errorMessage.getErrorNumber());
        }
        buf.append("\">\n");
        if (this.m_description != null) {
            buf.append("<description><![CDATA[");
            buf.append(this.m_description);
            buf.append("]]></description>\n");
        }
        if (this.m_problemImpacts != null) {
            for (DiagnosticsCategory impact : this.m_problemImpacts) {
                buf.append("<problemImpact impact=\"");
                buf.append((Object)impact);
                buf.append("\"/>\n");
            }
        }
        for (IncidentDump dump : this.m_incidentDumps) {
            buf.append(dump.toXML());
        }
        buf.append("</incident>");
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[Incident Id=");
        buf.append(this.m_incidentId);
        buf.append("]");
        return buf.toString();
    }

    private void parseIncidentXML(Reader incidentXML) throws Exception {
        NodeList dumpList;
        NodeList impacts;
        Element desc;
        NodeList cdata;
        this.m_errorParsing = null;
        DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
        InputSource source = new InputSource(incidentXML);
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) {
            }

            public void error(SAXParseException exception) {
                IncidentImpl.this.m_errorParsing = exception;
            }

            public void fatalError(SAXParseException exception) {
                IncidentImpl.this.m_errorParsing = exception;
            }
        });
        Document document = parser.parse(source);
        if (this.m_errorParsing != null) {
            throw new IncidentException("40381", this.m_errorParsing);
        }
        if (document == null) {
            throw new IncidentException("40381");
        }
        Element incident = document.getDocumentElement();
        if (incident == null) {
            throw new IncidentException("40381");
        }
        this.m_incidentId = incident.getAttribute("id");
        String incidentTime = incident.getAttribute("dateCreated");
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar cal = factory.newXMLGregorianCalendar(incidentTime);
        this.m_incidentTime = cal.toGregorianCalendar().getTime().getTime();
        this.m_problemKey = incident.getAttribute("problemKey");
        this.m_incidentSource = Incident.IncidentSource.getIncidentSource(incident.getAttribute("source"));
        this.m_incidentStatus = Incident.IncidentStatus.getIncidentStatus(incident.getAttribute("status"));
        this.m_executionContextId = incident.getAttribute("ecid");
        String facility = incident.getAttribute("facility");
        String errorCode = incident.getAttribute("errorCode");
        if (facility != null && facility.length() > 0 && errorCode != null && errorCode.length() > 0) {
            this.m_errorMessage = ErrorMessage.getErrorMessage(facility, errorCode);
        } else if (errorCode != null && errorCode.length() > 0) {
            this.m_errorMessage = ErrorMessage.getErrorMessage(errorCode);
        }
        NodeList description = incident.getElementsByTagName("description");
        if (description != null && description.getLength() == 1 && (cdata = (desc = (Element)description.item(0)).getChildNodes()) != null && cdata.getLength() == 1) {
            this.m_description = cdata.item(0).getNodeValue();
        }
        if ((impacts = incident.getElementsByTagName("problemImpact")) != null && impacts.getLength() > 0) {
            int len = impacts.getLength();
            this.m_problemImpacts = new ArrayList<DiagnosticsCategory>(len);
            for (int i = 0; i < len; ++i) {
                Element impact = (Element)impacts.item(i);
                DiagnosticsCategory category = DiagnosticsCategory.getDiagnosticsCategory(impact.getAttribute("impact"));
                if (category == null) continue;
                this.m_problemImpacts.add(category);
            }
        }
        if ((dumpList = incident.getElementsByTagName("diagnosticDump")) != null && dumpList.getLength() > 0) {
            int len = dumpList.getLength();
            for (int i = 0; i < len; ++i) {
                Element dump = (Element)dumpList.item(i);
                this.m_incidentDumps.add(new IncidentDumpImpl(dump));
            }
        }
    }

    private void generateProblemKey() {
        if (this.m_incidentSource.equals((Object)Incident.IncidentSource.SYSTEM)) {
            this.m_problemKey = this.m_errorMessage.toString();
        } else {
            StringBuilder buf = new StringBuilder();
            if (this.m_problemImpacts != null && this.m_problemImpacts.size() > 0) {
                buf.append((Object)this.m_problemImpacts.get(0));
            } else {
                buf.append(DiagnosticsCategory.OTHER.toString());
            }
            buf.append(" [");
            buf.append(this.m_incidentId);
            buf.append("]");
            this.m_problemKey = buf.toString();
        }
    }
}

