/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.HashMap;
import java.util.Map;
import oracle.dfw.impl.incident.TopologyNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpAction {
    private String m_dumpName;
    private TopologyNodeType m_tnType;
    private HashMap<String, String> m_factArguments = new HashMap();
    private HashMap<String, String> m_literalArguments = new HashMap();

    DumpAction(String dumpName, TopologyNodeType tnType) {
        this.m_dumpName = dumpName;
        this.m_tnType = tnType;
        if (this.m_tnType == null) {
            this.m_tnType = TopologyNodeType.THIS;
        }
    }

    public String getDumpName() {
        return this.m_dumpName;
    }

    public TopologyNodeType getTopologyNodeType() {
        return this.m_tnType;
    }

    public Map<String, String> getFactBasedArguments() {
        return this.m_factArguments;
    }

    public Map<String, String> getLiteralBasedArguments() {
        return this.m_literalArguments;
    }

    void addFactBasedArgument(String name, String fact) {
        this.m_factArguments.put(name, fact);
    }

    void addLiteralBasedArgument(String name, String value) {
        this.m_literalArguments.put(name, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[name=");
        buf.append(this.m_dumpName);
        buf.append(" literalArgs={");
        for (Map.Entry<String, String> arg : this.m_literalArguments.entrySet()) {
            buf.append(" ");
            buf.append(arg.getKey());
            buf.append("=");
            buf.append(arg.getValue());
        }
        buf.append("} factsArgs={");
        for (Map.Entry<String, String> arg : this.m_factArguments.entrySet()) {
            buf.append(" ");
            buf.append(arg.getKey());
            buf.append("=");
            buf.append(arg.getValue());
        }
        buf.append("}]");
        return buf.toString();
    }
}

