/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dfw.impl.incident.DumpAction;
import oracle.dfw.impl.incident.RuleActions;
import oracle.dfw.impl.incident.TopologyNodeType;
import oracle.dfw.incident.IncidentRulesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class DiagnosticRules {
    private RuleActions m_defaultActions;
    private Exception m_errorParsing;
    private DocumentBuilderFactory m_schemaFactory = DocumentBuilderFactory.newInstance();
    private static final String SCHEMA_FILE = "/oracle/dfw/incident/diagnostic_rules.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    private DiagnosticRules() throws IncidentRulesException {
        this.m_schemaFactory.setNamespaceAware(true);
        this.m_schemaFactory.setValidating(true);
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = this.getClass().getResource(SCHEMA_FILE);
        if (defaultSchema == null) {
            throw new IncidentRulesException("40368", SCHEMA_FILE);
        }
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
    }

    static DiagnosticRules createRules(Reader rules) throws IncidentRulesException {
        DiagnosticRules diagRules = new DiagnosticRules();
        try {
            diagRules.parseRules(rules);
        }
        catch (Exception e) {
            if (e instanceof IncidentRulesException) {
                throw (IncidentRulesException)e;
            }
            throw new IncidentRulesException("40369", e);
        }
        return diagRules;
    }

    private void parseRules(Reader rules) throws Exception {
        this.m_errorParsing = null;
        DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) {
            }

            public void error(SAXParseException exception) {
                DiagnosticRules.this.m_errorParsing = exception;
            }

            public void fatalError(SAXParseException exception) {
                DiagnosticRules.this.m_errorParsing = exception;
            }
        });
        InputSource source = new InputSource(rules);
        Document document = parser.parse(source);
        if (this.m_errorParsing != null) {
            throw new IncidentRulesException("40370", this.m_errorParsing);
        }
        if (document == null) {
            throw new IncidentRulesException("40370");
        }
        Element diagnosticRules = document.getDocumentElement();
        if (diagnosticRules == null) {
            throw new IncidentRulesException("40370");
        }
        NodeList defaultActionsList = diagnosticRules.getElementsByTagName("defaultActions");
        if (defaultActionsList != null && defaultActionsList.getLength() > 0) {
            Element defaultAction = (Element)defaultActionsList.item(0);
            this.m_defaultActions = new RuleActions();
            this.updateRuleActions(defaultAction, this.m_defaultActions);
        }
    }

    private void updateRuleActions(Element ruleActionNode, RuleActions actions) {
        NodeList dumpActionList = ruleActionNode.getElementsByTagName("dumpAction");
        if (dumpActionList != null && dumpActionList.getLength() > 0) {
            int len = dumpActionList.getLength();
            for (int i = 0; i < len; ++i) {
                Element dumpAction = (Element)dumpActionList.item(i);
                String tn = dumpAction.getAttribute("tn");
                TopologyNodeType tnType = TopologyNodeType.THIS;
                if (tn != null) {
                    tnType = TopologyNodeType.getType(tn);
                }
                DumpAction dump = new DumpAction(dumpAction.getAttribute("name"), tnType);
                this.updateDumpArguments(dumpAction.getElementsByTagName("argument"), dump);
                actions.addDumpAction(dump);
            }
        }
    }

    private void updateDumpArguments(NodeList arguments, DumpAction dump) {
        int len = arguments.getLength();
        for (int i = 0; i < len; ++i) {
            Element arg = (Element)arguments.item(i);
            String name = arg.getAttribute("name");
            String value = arg.getAttribute("value");
            String type = arg.getAttribute("valueType");
            if (type == null || type.equalsIgnoreCase("Literal")) {
                dump.addLiteralBasedArgument(name, value);
                continue;
            }
            dump.addFactBasedArgument(name, value);
        }
    }

    RuleActions getDefaultActions() {
        return this.m_defaultActions;
    }
}

