/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.dfw.common.ArgumentDescriptor;
import oracle.dfw.common.ArgumentDescriptorMap;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpDescriptor;
import oracle.dfw.impl.common.ArgumentDescriptorMapImpl;
import oracle.dfw.resource.DiagnosticConstants;
import oracle.dfw.resource.DiagnosticTranslation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpDescriptorImpl
implements DumpDescriptor,
Comparable<DumpDescriptor>,
Serializable,
DiagnosticConstants {
    private static ResourceBundle RBL = new DiagnosticTranslation();
    private String m_dumpName;
    private ArgumentDescriptorMap m_mandatoryArguments;
    private ArgumentDescriptorMap m_optionalArguments;
    private Set<String> m_applicableTopologyNodes;
    private Set<String> m_applicableTopologyNodeTypes;
    private EnumSet<DiagnosticsCategory> m_dumpCategories;
    private DumpDescriptor.DUMP_TYPE m_dumpType;
    private String m_dumpDescription;
    private static final String EMPTY_STRING = "";
    private static final Set<String> EMPTY_SET;
    private static final String[] COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELD_DESCRIPTIONS;
    private static final String[] ARGUMENT_DESCRIPTOR_TYPE_FIELDS;
    private static final String DFWT_NAME;
    private static final String DFWT_SYNOPSIS;
    private static final String DFWT_DESCRIPTION;
    private static final String DFWT_ARGUMENTS;
    private static final String DFWT_TYPE;
    private static final String DFWT_APPLICABLE_TOPOLOGY_NODES;
    private static final String DFWT_APPLICABLE_TOPOLOGY_NODE_TYPES;
    private static final String DFWT_ARGUMENT_DESCRIPTOR;
    private static final String DFWT_ARGUMENT_DESCRIPTORS;
    private static final String DFWT_DUMP_DESCRIPTOR;
    private static CompositeType TMP;
    private static TabularType TMP2;
    private static ArrayType TMP3;
    private static final CompositeType COMPOSITE_ARGUMENT_DESCRIPTOR_TYPE;
    private static final TabularType TABULAR_ARGUMENT_DESCRIPTORS_TYPE;
    private static final ArrayType STRING_ARRAY_TYPE;
    private static final String[] COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELDS;
    private static final CompositeType COMPOSITE_DUMP_DESCRIPTOR_TYPE;

    public DumpDescriptorImpl(DiagnosticDump dump, DumpDescriptor.DUMP_TYPE dumpType) {
        this.m_dumpName = dump.getFullDumpName();
        this.m_mandatoryArguments = dump.getMandatoryArguments();
        this.m_optionalArguments = dump.getOptionalArguments();
        this.m_dumpDescription = dump.getDumpDescription();
        this.m_dumpType = dumpType;
        if (dump.getDumpCategories() != null) {
            this.m_dumpCategories = EnumSet.copyOf(dump.getDumpCategories());
        }
    }

    protected DumpDescriptorImpl(CompositeData cd) {
        Object[] values = cd.getAll(COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELDS);
        if (values.length != 8) {
            throw new IllegalArgumentException("CompositeData with 8 elements was expected");
        }
        try {
            this.m_dumpName = (String)values[0];
            this.m_dumpDescription = (String)values[1];
            this.m_dumpType = Enum.valueOf(DumpDescriptor.DUMP_TYPE.class, (String)values[2]);
            String[] categories = (String[])values[3];
            String[] applicableTn = (String[])values[6];
            String[] applicableTnTypes = (String[])values[7];
            this.m_dumpCategories = EnumSet.noneOf(DiagnosticsCategory.class);
            for (String cat : categories) {
                this.m_dumpCategories.add(Enum.valueOf(DiagnosticsCategory.class, cat));
            }
            this.m_applicableTopologyNodes = new TreeSet<String>();
            this.m_applicableTopologyNodeTypes = new TreeSet<String>();
            for (String n : applicableTn) {
                this.m_applicableTopologyNodes.add(n);
            }
            for (String n : applicableTnTypes) {
                this.m_applicableTopologyNodeTypes.add(n);
            }
            Collection[] args = new Collection[]{((TabularDataSupport)values[4]).values(), ((TabularDataSupport)values[5]).values()};
            ArgumentDescriptorMapImpl[] maps = new ArgumentDescriptorMapImpl[]{new ArgumentDescriptorMapImpl(), new ArgumentDescriptorMapImpl()};
            this.m_mandatoryArguments = maps[0];
            this.m_optionalArguments = maps[1];
            for (int i = 0; i < maps.length; ++i) {
                for (CompositeDataSupport cds : args[i]) {
                    Object[] obj = cds.getAll(ARGUMENT_DESCRIPTOR_TYPE_FIELDS);
                    maps[i].put((String)obj[0], Enum.valueOf(ArgumentType.class, (String)obj[1]), (String)obj[2]);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Incompatible CompositeData");
        }
    }

    public static DumpDescriptorImpl fromCompositeData(CompositeData cd) {
        return new DumpDescriptorImpl(cd);
    }

    @Override
    public String getDumpName() {
        return this.m_dumpName;
    }

    @Override
    public DumpDescriptor.DUMP_TYPE getDumpType() {
        return this.m_dumpType;
    }

    @Override
    public String getDumpDescription() {
        return this.m_dumpDescription;
    }

    @Override
    public ArgumentDescriptorMap getMandatoryArguments() {
        return this.m_mandatoryArguments;
    }

    @Override
    public ArgumentDescriptorMap getOptionalArguments() {
        return this.m_optionalArguments;
    }

    @Override
    public Set<String> getApplicableTopologyNodes() {
        return this.m_applicableTopologyNodes != null ? this.m_applicableTopologyNodes : EMPTY_SET;
    }

    @Override
    public Set<String> getApplicableTopologyNodeTypes() {
        return this.m_applicableTopologyNodeTypes != null ? this.m_applicableTopologyNodeTypes : EMPTY_SET;
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return this.m_dumpCategories != null ? this.m_dumpCategories : EnumSet.of(DiagnosticsCategory.OTHER);
    }

    public void addApplicableTopologyNode(String topoCanonicalPath) {
        if (this.m_applicableTopologyNodes == null) {
            this.m_applicableTopologyNodes = new TreeSet<String>();
        }
        this.m_applicableTopologyNodes.add(topoCanonicalPath);
    }

    public void addApplicableTopologyNodeType(String topoNodeType) {
        if (this.m_applicableTopologyNodeTypes == null) {
            this.m_applicableTopologyNodeTypes = new TreeSet<String>();
        }
        this.m_applicableTopologyNodeTypes.add(topoNodeType);
    }

    @Override
    public void printDescriptor(Writer out) {
        PrintWriter pw = new PrintWriter(out);
        StringBuffer sb = new StringBuffer();
        pw.println(DFWT_NAME);
        pw.println(EMPTY_STRING);
        pw.println(this.getDumpName());
        pw.println(EMPTY_STRING);
        pw.println(DFWT_SYNOPSIS);
        pw.println(EMPTY_STRING);
        sb.append("executeDump( \"");
        sb.append(this.getDumpName());
        sb.append("\"");
        TreeMap<String, ArgumentDescriptor> args = new TreeMap<String, ArgumentDescriptor>();
        if (this.m_mandatoryArguments.size() > 0 || this.m_optionalArguments.size() > 0) {
            sb.append(", args={");
            ArgumentDescriptorMap[] maps = new ArgumentDescriptorMap[]{this.m_mandatoryArguments, this.m_optionalArguments};
            boolean isFirstArg = true;
            boolean mandatory = true;
            for (ArgumentDescriptorMap m : maps) {
                Enumeration<String> keys = m.enumerateKeys();
                while (keys.hasMoreElements()) {
                    if (!mandatory) {
                        sb.append(" [");
                    }
                    if (!isFirstArg) {
                        sb.append(", ");
                    } else {
                        sb.append(" ");
                    }
                    String argName = keys.nextElement();
                    sb.append("\"");
                    sb.append(argName);
                    sb.append("\": \"<");
                    sb.append(argName);
                    sb.append(">\"");
                    if (!mandatory) {
                        sb.append(" ]");
                    }
                    isFirstArg = false;
                    args.put(argName, m.get(argName));
                }
                mandatory = false;
            }
            sb.append(" }");
        }
        if (this.getApplicableTopologyNodeTypes().size() > 0 || this.getApplicableTopologyNodes().size() > 0) {
            sb.append(", [toponode=<toponode>]");
        }
        sb.append(" )");
        pw.println(sb.toString());
        pw.println(EMPTY_STRING);
        pw.println(DFWT_DESCRIPTION);
        pw.println(EMPTY_STRING);
        pw.println(this.getDumpDescription());
        pw.println(EMPTY_STRING);
        pw.println(DFWT_ARGUMENTS);
        pw.println(EMPTY_STRING);
        pw.println(String.format("%1$-12s %2$-10s %3$s", DFWT_NAME, DFWT_TYPE, DFWT_DESCRIPTION));
        for (Map.Entry argvalues : args.entrySet()) {
            ArgumentDescriptor desc = (ArgumentDescriptor)argvalues.getValue();
            String argdesc = String.format("%1$-12s %2$-10s %3$s", desc.getName(), desc.getType().toString(), desc.getDescription());
            pw.println(argdesc);
        }
        pw.println(EMPTY_STRING);
        pw.println(DFWT_APPLICABLE_TOPOLOGY_NODES);
        pw.println(EMPTY_STRING);
        for (String node : this.getApplicableTopologyNodes()) {
            int pos = node.indexOf(47);
            if (pos != -1 && (pos = node.indexOf(47, pos + 1)) != -1) {
                node = node.substring(pos);
            }
            pw.println(node);
        }
        pw.println(EMPTY_STRING);
        pw.println(DFWT_APPLICABLE_TOPOLOGY_NODE_TYPES);
        pw.println(EMPTY_STRING);
        for (String node : this.getApplicableTopologyNodeTypes()) {
            pw.println(node);
        }
    }

    @Override
    public int compareTo(DumpDescriptor dump) {
        if (dump == null) {
            return -1;
        }
        return this.getDumpName().compareTo(dump.getDumpName());
    }

    @Override
    public CompositeData toCompositeData() throws OpenDataException {
        TabularDataSupport mandatoryArgs = new TabularDataSupport(TABULAR_ARGUMENT_DESCRIPTORS_TYPE);
        Enumeration<String> keys = this.m_mandatoryArguments.enumerateKeys();
        while (keys.hasMoreElements()) {
            ArgumentDescriptor arg = this.m_mandatoryArguments.get(keys.nextElement());
            CompositeDataSupport compositeArg = new CompositeDataSupport(COMPOSITE_ARGUMENT_DESCRIPTOR_TYPE, ARGUMENT_DESCRIPTOR_TYPE_FIELDS, new Object[]{arg.getName(), arg.getType().toString(), arg.getDescription()});
            mandatoryArgs.put(compositeArg);
        }
        TabularDataSupport optionalArgs = new TabularDataSupport(TABULAR_ARGUMENT_DESCRIPTORS_TYPE);
        keys = this.m_optionalArguments.enumerateKeys();
        while (keys.hasMoreElements()) {
            ArgumentDescriptor arg = this.m_optionalArguments.get(keys.nextElement());
            CompositeDataSupport compositeArg = new CompositeDataSupport(COMPOSITE_ARGUMENT_DESCRIPTOR_TYPE, ARGUMENT_DESCRIPTOR_TYPE_FIELDS, new Object[]{arg.getName(), arg.getType().toString(), arg.getDescription()});
            optionalArgs.put(compositeArg);
        }
        String[] topologyNodes = this.getApplicableTopologyNodes().toArray(new String[0]);
        String[] topologyNodeTypes = this.getApplicableTopologyNodeTypes().toArray(new String[0]);
        String[] categories = new String[this.m_dumpCategories.size()];
        int i = 0;
        for (DiagnosticsCategory dc : this.m_dumpCategories) {
            categories[i++] = dc.toString();
        }
        CompositeDataSupport dumpDescriptor = new CompositeDataSupport(COMPOSITE_DUMP_DESCRIPTOR_TYPE, COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELDS, new Object[]{this.m_dumpName, this.m_dumpDescription, this.m_dumpType.toString(), categories, mandatoryArgs, optionalArgs, topologyNodes, topologyNodeTypes});
        return dumpDescriptor;
    }

    static {
        try {
            RBL = ResourceBundle.getBundle(DiagnosticTranslation.class.getName());
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        EMPTY_SET = Collections.emptySet();
        COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELD_DESCRIPTIONS = RBL.getStringArray("DFW_COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELD_DESCRIPTIONS");
        ARGUMENT_DESCRIPTOR_TYPE_FIELDS = RBL.getStringArray("DFW_ARGUMENT_DESCRIPTOR_TYPE_FIELDS");
        DFWT_NAME = RBL.getString("DFW_NAME");
        DFWT_SYNOPSIS = RBL.getString("DFW_SYNOPSIS");
        DFWT_DESCRIPTION = RBL.getString("DFW_DESCRIPTION");
        DFWT_ARGUMENTS = RBL.getString("DFW_ARGUMENTS");
        DFWT_TYPE = RBL.getString("DFW_TYPE");
        DFWT_APPLICABLE_TOPOLOGY_NODES = RBL.getString("DFW_APPLICABLE_TOPOLOGY_NODES");
        DFWT_APPLICABLE_TOPOLOGY_NODE_TYPES = RBL.getString("DFW_APPLICABLE_TOPOLOGY_NODE_TYPES");
        DFWT_ARGUMENT_DESCRIPTOR = RBL.getString("DFW_ARGUMENT_DESCRIPTOR");
        DFWT_ARGUMENT_DESCRIPTORS = RBL.getString("DFW_ARGUMENT_DESCRIPTORS");
        DFWT_DUMP_DESCRIPTOR = RBL.getString("DFW_DUMP_DESCRIPTOR");
        try {
            TMP = new CompositeType("ArgumentDescriptorType", DFWT_ARGUMENT_DESCRIPTOR, ARGUMENT_DESCRIPTOR_TYPE_FIELDS, ARGUMENT_DESCRIPTOR_TYPE_FIELDS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        }
        catch (Exception e) {
            // empty catch block
        }
        COMPOSITE_ARGUMENT_DESCRIPTOR_TYPE = TMP;
        try {
            TMP2 = new TabularType("ArgumentDescriptorsType", DFWT_ARGUMENT_DESCRIPTORS, COMPOSITE_ARGUMENT_DESCRIPTOR_TYPE, new String[]{"Name"});
            TMP3 = new ArrayType(1, SimpleType.STRING);
        }
        catch (Exception e) {
            // empty catch block
        }
        TABULAR_ARGUMENT_DESCRIPTORS_TYPE = TMP2;
        STRING_ARRAY_TYPE = TMP3;
        COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELDS = new String[]{"Name", "Description", "Type", "Categories", "MandatoryArguments", "OptionalArguments", "ApplicableTopologyNodes", "ApplicableTopologyNodeTypes"};
        try {
            TMP = new CompositeType("DumpDescriptorType", DFWT_DUMP_DESCRIPTOR, COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELDS, COMPOSITE_DUMP_DESCRIPTOR_TYPE_FIELD_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, STRING_ARRAY_TYPE, TABULAR_ARGUMENT_DESCRIPTORS_TYPE, TABULAR_ARGUMENT_DESCRIPTORS_TYPE, STRING_ARRAY_TYPE, STRING_ARRAY_TYPE});
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMPOSITE_DUMP_DESCRIPTOR_TYPE = TMP;
    }
}

