/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dfw.common.ArgumentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentMapImpl
implements ArgumentMap {
    private HashMap<String, Serializable> m_arguments = new HashMap();

    public void put(String argName, Serializable argValue) {
        if (argName == null || argName.length() == 0 || argValue == null) {
            return;
        }
        this.m_arguments.put(argName, argValue);
    }

    @Override
    public Serializable get(String argName) {
        if (argName == null || argName.length() == 0) {
            return null;
        }
        return this.m_arguments.get(argName);
    }

    @Override
    public int size() {
        return this.m_arguments.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_arguments.isEmpty();
    }

    @Override
    public boolean containsKey(String argName) {
        if (argName == null || argName.length() == 0) {
            return false;
        }
        return this.m_arguments.containsKey(argName);
    }

    @Override
    public Enumeration<String> enumerateKeys() {
        return Collections.enumeration(this.m_arguments.keySet());
    }

    @Override
    public String getString(String argName) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public String getString(String argName, String def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        return obj.toString();
    }

    @Override
    public int getInt(String argName, int def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public short getShort(String argName, short def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        try {
            return Short.parseShort(obj.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public long getLong(String argName, long def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public double getDouble(String argName, double def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public float getFloat(String argName, float def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        try {
            return Float.parseFloat(obj.toString());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public boolean getBool(String argName) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    @Override
    public boolean getBool(String argName, boolean def) {
        Serializable obj = this.get(argName);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }
}

