/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringOp {
    public static final int OP_EQUALS = 0;
    public static final int OP_STARTS_WITH = 1;
    public static final int OP_CONTAINS = 2;
    public static final int OP_MATCHES = 3;
    private final int m_opcode;
    private final boolean m_ignoreCase;
    private final String m_value;
    private final Pattern m_pattern;

    public StringOp(int opCode, String value, boolean ignoreCase) throws IllegalArgumentException, PatternSyntaxException {
        if (opCode != 0 && opCode != 1 && opCode != 2 && opCode != 3) {
            throw new IllegalArgumentException("Invalid opcode: " + opCode);
        }
        this.m_opcode = opCode;
        this.m_ignoreCase = ignoreCase;
        if (this.m_opcode == 3) {
            int flags = ignoreCase ? 2 : 0;
            this.m_pattern = Pattern.compile(value, flags);
            this.m_value = null;
        } else {
            this.m_value = value;
            this.m_pattern = null;
        }
    }

    public boolean eval(String s) {
        switch (this.m_opcode) {
            case 0: {
                if (this.m_ignoreCase) {
                    return s.equalsIgnoreCase(this.m_value);
                }
                return s.equals(this.m_value);
            }
            case 1: {
                if (this.m_ignoreCase) {
                    return s.regionMatches(true, 0, this.m_value, 0, this.m_value.length());
                }
                return s.startsWith(this.m_value);
            }
            case 2: {
                if (this.m_ignoreCase) {
                    return s.toLowerCase().indexOf(this.m_value.toLowerCase()) >= 0;
                }
                return s.indexOf(this.m_value) >= 0;
            }
            case 3: {
                return this.m_pattern.matcher(s).matches();
            }
        }
        throw new RuntimeException();
    }
}

