/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.jms.JMSException;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsPropDatum;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class AQjmsProducerProperties {
    Hashtable<String, Object> msg_properties = new Hashtable();

    Hashtable<String, Object> getPropertiesHashtable() {
        return this.msg_properties;
    }

    void clearPropertiesHashtable() {
        this.msg_properties.clear();
    }

    public boolean propertyExists(String name) throws JMSException {
        this.checkPropertyName(name);
        return this.msg_properties.containsKey(name);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertyName(name);
        this.checkValidObject(value);
        if (value == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShortProperty(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongProperty(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleProperty(name, (Double)value);
        } else if (value instanceof String) {
            this.setStringProperty(name, (String)value);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    void setBooleanProperty(String name, boolean value) throws JMSException {
        NUMBER new_value = new NUMBER(value);
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(20, (Datum)new_value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkPropertyName(name);
        NUMBER new_value = new NUMBER(value);
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(21, (Datum)new_value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        NUMBER new_value = new NUMBER(value);
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(22, (Datum)new_value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        NUMBER new_value = new NUMBER(value);
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(23, (Datum)new_value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    void setLongProperty(String name, long value) throws JMSException {
        NUMBER new_value = new NUMBER(value);
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)new_value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        AQjmsPropDatum propDatum = new AQjmsPropDatum(value);
        this.insertPropertyIntoTable(this.msg_properties, name, propDatum);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        AQjmsPropDatum propDatum = new AQjmsPropDatum(value);
        this.insertPropertyIntoTable(this.msg_properties, name, propDatum);
    }

    void setStringProperty(String name, String value) throws JMSException {
        AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, value);
        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
    }

    void insertPropertyIntoTable(Hashtable table, String name, AQjmsPropDatum value) throws JMSException {
        table.put(name, value);
    }

    void checkPropertyName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name can not be null or empty string");
        }
    }

    void checkValidObject(Object value) {
        boolean valid;
        boolean bl = valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            throw new IllegalArgumentException("Only objectified primitive objects and String types are allowed. Given: " + String.valueOf(value) + " type: " + String.valueOf(value.getClass()));
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkPropertyName(name);
        try {
            prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
            if (prop_datum != null) {
                value = prop_datum.getValue();
                int type = prop_datum.getType();
                switch (type) {
                    case 20: {
                        int val1 = ((Datum)value).intValue();
                        return new Boolean(val1 > 0);
                    }
                    case 21: {
                        int val2 = ((Datum)value).intValue();
                        return new Byte((byte)val2);
                    }
                    case 22: {
                        int val3 = ((Datum)value).intValue();
                        return new Short((short)val3);
                    }
                    case 23: {
                        int val4 = ((Datum)value).intValue();
                        return new Integer(val4);
                    }
                    case 24: {
                        long val41 = ((Datum)value).longValue();
                        return new Long(val41);
                    }
                    case 25: {
                        float val5 = ((Float)value).floatValue();
                        return new Float(val5);
                    }
                    case 26: {
                        double val6 = (Double)value;
                        return new Double(val6);
                    }
                    case 27: {
                        return value;
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage(), e);
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value;
        block9: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkPropertyName(name);
            try {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            return val != 0;
                        }
                        case 27: {
                            String str = (String)value;
                            return Boolean.valueOf(str);
                        }
                    }
                    break block9;
                }
                return false;
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value;
        block10: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkPropertyName(name);
            try {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: {
                            int val = ((Datum)value).intValue();
                            return (byte)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Byte.parseByte(str);
                        }
                    }
                    break block10;
                }
                throw new NumberFormatException("getByteProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String name) throws JMSException {
        Object value;
        block10: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkPropertyName(name);
            try {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: {
                            int val = ((Datum)value).intValue();
                            return (short)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Short.parseShort(str);
                        }
                    }
                    break block10;
                }
                throw new NumberFormatException("getShortProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String name) throws JMSException {
        Object value;
        block10: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkPropertyName(name);
            try {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Integer.parseInt(str);
                        }
                    }
                    break block10;
                }
                throw new NumberFormatException("getIntProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String name) throws JMSException {
        Object value;
        block11: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.checkPropertyName(name);
            try {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 24: {
                            return ((Datum)value).longValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Long.parseLong(str);
                        }
                    }
                    break block11;
                }
                throw new NumberFormatException("getLongProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkPropertyName(name);
        try {
            prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
            if (prop_datum != null) {
                value = prop_datum.getValue();
                int type = prop_datum.getType();
                switch (type) {
                    case 25: {
                        return ((Float)value).floatValue();
                    }
                    case 27: {
                        String str = (String)value;
                        return Float.parseFloat(str);
                    }
                }
            }
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkPropertyName(name);
        try {
            prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
            if (prop_datum != null) {
                value = prop_datum.getValue();
                int type = prop_datum.getType();
                switch (type) {
                    case 25: {
                        return ((Float)value).floatValue();
                    }
                    case 26: {
                        return (Double)value;
                    }
                    case 27: {
                        String str = (String)value;
                        return Double.parseDouble(str);
                    }
                }
            }
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.checkPropertyName(name);
        try {
            prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
            if (prop_datum != null) {
                value = prop_datum.getValue();
                int type = prop_datum.getType();
                switch (type) {
                    case 20: {
                        int val = ((Datum)value).intValue();
                        if (val > 0) {
                            return "true";
                        }
                        return "false";
                    }
                    case 25: {
                        return ((Float)value).toString();
                    }
                    case 26: {
                        return ((Double)value).toString();
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        return ((Datum)value).stringValue();
                    }
                }
                return (String)value;
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }
}

