/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObjectInputStream;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;

public class AQjmsObjectMessage
extends AQjmsMessage
implements ObjectMessage {
    private byte[] m_bytesData = null;

    public AQjmsObjectMessage() {
        super(true);
        this.access_mode = 2;
    }

    AQjmsObjectMessage(AQjmsSession session) throws JMSException {
        super(session, true);
        this.access_mode = 2;
    }

    AQjmsObjectMessage(AQjmsMessage headerMsg) throws JMSException {
        super(headerMsg);
    }

    AQjmsObjectMessage(AQjmsSession session, AQjmsObjectMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readObjectMessageContainer(msgCont, false);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession session, AQjmsGenMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readGenMessageContainer(msgCont, false);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession session, AQjmsObjectMessage_C msgCont, boolean xml_receive) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readObjectMessageContainer(msgCont, xml_receive);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container: xml_receive: " + xml_receive, sql_ex);
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsObjectMessage(AQjmsSession session, byte[] bdata, boolean xml_recv) throws JMSException {
        super(session, true);
        this.m_bytesData = bdata;
        this.access_mode = 0;
    }

    byte[] getSerialObject() throws JMSException {
        return this.m_bytesData;
    }

    public void setObject(Serializable object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (object == null) {
            this.m_bytesData = null;
        } else if (object instanceof Serializable) {
            this.m_bytesData = AQjmsObjectMessage.convertSerializableToByteArray(object);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid object type");
        }
    }

    public Serializable getObject() throws JMSException {
        return AQjmsObjectMessage.convertByteArrayToSerializable(this.m_bytesData);
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return (T)this.getObject();
        }
        AQjmsError.throwEx(161);
        return null;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        if (this.getObject() == null) {
            return true;
        }
        return Serializable.class == c || Object.class == c || c.isInstance(this.getObject());
    }

    @Override
    public void clearBody() throws JMSException {
        this.m_bytesData = null;
        this.setAccessMode(2);
    }

    public void setBytesData(byte[] payload) {
        this.m_bytesData = payload;
    }

    public byte[] getBytesData() {
        return this.m_bytesData;
    }

    @Override
    OracleData getMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getMessageCont", "entry");
        AQjmsObjectMessage_C cont = new AQjmsObjectMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 4, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getMessageCont", "exit");
        return cont;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getGenMessageCont", "entry");
        AQjmsGenMessage_C cont = new AQjmsGenMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 4, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.getGenMessageCont", "exit");
        return cont;
    }

    @Override
    void writeLob(AQjmsSession sess, AQjmsDestination dest, byte[] msgid, boolean isAnydataDest) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, sess, dest, msgid, isAnydataDest);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectmessage.writeLob", "exit");
    }

    private void readObjectMessageContainer(AQjmsObjectMessage_C msgCont, boolean xml_receive) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C msgCont, boolean xml_receive) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
    }

    private static byte[] convertSerializableToByteArray(Serializable obj) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "entry");
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(obj);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-1", io_exp);
            AQjmsError.throwEx(157, (Throwable)io_exp);
            return null;
        }
    }

    private static Serializable convertByteArrayToSerializable(byte[] byteArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "entry");
        if (byteArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream baistream = new ByteArrayInputStream(byteArray);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "Before deserializing object using new class loader object input stream");
            ClassLoader suitableLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (suitableLoader == null) {
                suitableLoader = AQjmsObjectMessage.class.getClassLoader();
            }
            Serializable obj = (Serializable)new AQjmsObjectInputStream(baistream, suitableLoader).readObject();
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "After deserializing object using new class loader object input stream");
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "exit");
            return obj;
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsError.throwEx(109, (Throwable)cnf_exp);
        }
        catch (InvalidClassException ic_exp) {
            AQjmsError.throwEx(109, (Throwable)ic_exp);
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-2", io_exp);
            AQjmsError.throwEx(157, (Throwable)io_exp);
        }
        return null;
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        return this.m_bytesData;
    }
}

