/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQQueueProperty;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsDestinationStats;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsDestination
implements Queue,
Topic,
Serializable,
TemporaryQueue,
TemporaryTopic {
    private int type;
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    private AQjmsDestinationProperty property;
    private Hashtable dest_properties;
    private Hashtable trans_list;
    private boolean secure;
    private boolean is_temp;
    private int temp_cons = 0;
    private static final int DEFAULT_MAX_RETRY_FOR_DESTINATION = 5;

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, String table, boolean is_secure) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.pload_type = payload_type;
        this.property = new AQjmsDestinationProperty();
        this.table = table;
        this.trans_list = new Hashtable();
        this.secure = is_secure;
        this.is_temp = false;
    }

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, AQjmsDestinationProperty dest_property, String table, boolean is_secure) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.pload_type = payload_type;
        this.property = dest_property;
        this.table = table;
        this.trans_list = new Hashtable();
        this.secure = is_secure;
        this.is_temp = false;
    }

    public String getQueueName() throws JMSException {
        if (this.type == 10) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getTopicName() throws JMSException {
        if (this.type == 20) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    String getName() {
        return this.name;
    }

    public String getQueueOwner() throws JMSException {
        return this.owner;
    }

    public String getTopicOwner() throws JMSException {
        return this.owner;
    }

    String getAdtType() {
        return this.p_data_type;
    }

    void setAdtType(String adtType) {
        this.p_data_type = adtType;
    }

    int getPloadType() {
        return this.pload_type;
    }

    String getQueueTableName() {
        return this.table;
    }

    AQjmsDestinationProperty getProperty() {
        return this.property;
    }

    public String getCompleteName() {
        Object ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return ret;
    }

    public String getCompleteTableName() {
        Object ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.table : this.table;
        return ret;
    }

    public String toString() {
        Object ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return ret;
    }

    public void start(Session session, boolean enqueue, boolean dequeue) throws JMSException {
        this.start(session, enqueue, dequeue, false);
    }

    public void start(Session session, boolean enqueue, boolean dequeue, boolean autonomous) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.start(enqueue, dequeue, autonomous);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void stop(Session session, boolean enqueue, boolean dequeue, boolean wait) throws JMSException {
        this.stop(session, enqueue, dequeue, wait, false);
    }

    public void stop(Session session, boolean enqueue, boolean dequeue, boolean wait, boolean autonomous) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.stop(enqueue, dequeue, wait, autonomous);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void alter(Session session, AQjmsDestinationProperty destinationProperty) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.alterQueue(destinationProperty);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void drop(Session session) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.drop();
            aq_queue.close();
            ((AQjmsSession)session).disableConsumerExceptionListenerForQ(this.getCompleteName());
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void schedulePropagation(Session session, String destination, Date startTime, Double duration, String nextTime, Double latency) throws JMSException {
        this.schedulePropagation(session, destination, null, startTime, duration, nextTime, latency);
    }

    public void schedulePropagation(Session session, String destination, String destQueue, Date startTime, Double duration, String nextTime, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.schedulePropagation(destination, destQueue, startTime, duration, nextTime, latency);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void unschedulePropagation(Session session, String destination) throws JMSException {
        this.unschedulePropagation(session, destination, null);
    }

    public void unschedulePropagation(Session session, String destination, String destQueue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.unschedulePropagation(destination, destQueue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void alterPropagationSchedule(Session session, String destination, Double duration, String nextTime, Double latency) throws JMSException {
        this.alterPropagationSchedule(session, destination, null, duration, nextTime, latency);
    }

    public void alterPropagationSchedule(Session session, String destination, String destQueue, Double duration, String nextTime, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.alterPropagationSchedule(destination, destQueue, duration, nextTime, latency);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void enablePropagationSchedule(Session session, String destination) throws JMSException {
        this.enablePropagationSchedule(session, destination, null);
    }

    public void enablePropagationSchedule(Session session, String destination, String destQueue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.enablePropagationSchedule(destination, destQueue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void disablePropagationSchedule(Session session, String destination) throws JMSException {
        this.disablePropagationSchedule(session, destination, null);
    }

    public void disablePropagationSchedule(Session session, String destination, String destQueue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.disablePropagationSchedule(destination, destQueue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void grantQueuePrivilege(Session session, String privilege, String grantee, boolean grantOption) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.grantQueuePrivilege(privilege, grantee, grantOption);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void grantTopicPrivilege(Session session, String privilege, String grantee, boolean grantOption) throws JMSException {
        this.grantQueuePrivilege(session, privilege, grantee, grantOption);
    }

    public void revokeQueuePrivilege(Session session, String privilege, String grantee) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.revokeQueuePrivilege(privilege, grantee);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeTopicPrivilege(Session session, String privilege, String grantee) throws JMSException {
        this.revokeQueuePrivilege(session, privilege, grantee);
    }

    boolean isQueue() {
        return this.type == 10;
    }

    boolean isTopic() {
        return this.type == 20;
    }

    public boolean isSecure() {
        return this.secure;
    }

    Hashtable getTransTable() {
        return this.trans_list;
    }

    void setTransTable(Hashtable t_list) {
        this.trans_list = t_list;
    }

    public AQjmsDestination cloneDestination() throws JMSException {
        AQjmsDestination c_dest = null;
        c_dest = new AQjmsDestination(this.owner, this.name, this.type, this.pload_type, this.p_data_type, this.table, this.secure);
        c_dest.setTransTable((Hashtable)this.trans_list.clone());
        return c_dest;
    }

    boolean isTemp() {
        return this.is_temp;
    }

    void makeTemp() {
        this.is_temp = true;
    }

    public void delete() throws JMSException {
        if (this.is_temp) {
            if (this.temp_cons > 0) {
                AQjmsError.throwEx(241);
            }
            AQjmsConnection.findCloseTemp(this);
        }
    }

    synchronized void addConsForTempDest() {
        if (this.is_temp) {
            ++this.temp_cons;
        }
    }

    synchronized void removeConsForTempDest() {
        if (this.is_temp) {
            --this.temp_cons;
        }
    }

    final boolean isSharded() {
        return this.property.isSharded();
    }

    final boolean isMigrating() {
        return this.property.isMigrating();
    }

    final boolean isJson() {
        return this.property.isJson();
    }

    public double getRetryInterval() {
        if (this.property != null) {
            return this.property.getRetryInterval();
        }
        return 0.0;
    }

    public int getMaxRetries() {
        if (this.property != null) {
            return this.property.getMaxRetries();
        }
        return 5;
    }

    public synchronized AQjmsDestinationStats queryStats(AQjmsSession session) throws JMSException {
        AQjmsDestinationStats qStats = this.queryStats(session, 3);
        return qStats;
    }

    public synchronized AQjmsDestinationStats queryStats(AQjmsSession session, int mode) throws JMSException {
        if (this.type == 20) {
            AQjmsError.throwEx(107, "queryStats on TOPIC");
        }
        switch (mode) {
            case 1: {
                return this.queryGVStats(session);
            }
            case 2: {
                return this.queryApproxProc(session);
            }
            case 3: {
                return this.queryAQView(session);
            }
            case 4: {
                return this.queryApproxExactProc(session);
            }
            case 5: {
                return this.queryAQViewFull(session);
            }
        }
        return this.queryGVStats(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryAQView(AQjmsSession session) throws JMSException {
        Connection db_conn = null;
        Statement qStat_stmt = null;
        ResultSet rSet = null;
        String statQuery = null;
        AQjmsDestinationStats qStatsNow = null;
        long enqCnt = 0L;
        long deqCnt = 0L;
        long expCnt = 0L;
        long cnt = 0L;
        int mode = 3;
        int MAX_FLAG = 7;
        int MAX_FLAG_19C = 6;
        int MAX_FLAG_NOW = 7;
        try {
            db_conn = session.getDBConnection();
            statQuery = " select count(*), MSG_STATE from (  SELECT  decode(qt.state, 3, 'EXPIRED',    decode(mod(qt_l.flags  - 1 ,7), 0, 'PROCESSED',                                   1, 'UNDELIVERABLE',                                   2, 'PROCESSED',                                   3, 'PROCESSED',                                   4, 'ROLBACKREADY',                                   5, 'RETRYEXPIRED',                                  -1, 'READY',        decode(qt.state, 0, 'READY','UNDELIVERABLE'))) MSG_STATE FROM " + this.owner + "." + this.name + " qt , " + this.owner + ".AQ$_" + this.name + "_L qt_l  WHERE qt.msgid = qt_l.msgid(+)) qv group by MSG_STATE";
            if (qStat_stmt == null) {
                qStat_stmt = db_conn.prepareStatement(statQuery);
            }
            int reattempt = 0;
            boolean done = false;
            while (reattempt < 2 && !done) {
                try {
                    AQjmsSession aQjmsSession = session;
                    synchronized (aQjmsSession) {
                        rSet = qStat_stmt.executeQuery();
                    }
                    done = true;
                }
                catch (SQLException ex) {
                    AQjmsException exc = new AQjmsException(ex);
                    if (exc.getErrorNumber() == 8103 && reattempt == 0) {
                        ++reattempt;
                        continue;
                    }
                    throw ex;
                }
            }
            while (rSet != null && rSet.next()) {
                cnt = rSet.getLong(1);
                String msgState = rSet.getString(2);
                if (msgState.equalsIgnoreCase("PROCESSED")) {
                    enqCnt += cnt;
                    deqCnt = cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("READY")) {
                    enqCnt += cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("ROLBACKREADY")) {
                    enqCnt += cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("RETRYEXPIRED")) {
                    enqCnt += cnt;
                    expCnt += cnt;
                    continue;
                }
                if (!msgState.equalsIgnoreCase("EXPIRED")) continue;
                enqCnt += cnt;
                expCnt += cnt;
            }
            qStatsNow = new AQjmsDestinationStats(this.name, this.owner, this.type, enqCnt, deqCnt, expCnt, mode);
        }
        catch (SQLException e) {
            AQjmsException aqjmsException = new AQjmsException(e);
            AQOracleDebug.traceEx(3, "AQjmsDestination.queryAQView", e);
            throw aqjmsException;
        }
        finally {
            if (rSet != null) {
                try {
                    rSet.close();
                }
                catch (Exception exception) {}
            }
            if (qStat_stmt != null) {
                try {
                    qStat_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return qStatsNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryAQViewFull(AQjmsSession session) throws JMSException {
        Connection db_conn = null;
        Statement qStat_stmt = null;
        ResultSet rSet = null;
        String statQuery = null;
        AQjmsDestinationStats qStatsNow = null;
        long enqCnt = 0L;
        long deqCnt = 0L;
        long expCnt = 0L;
        long cnt = 0L;
        int mode = 3;
        try {
            db_conn = session.getDBConnection();
            statQuery = "SELECT COUNT(*), MSG_STATE FROM " + this.owner.toUpperCase() + ".AQ$" + this.name.toUpperCase() + " group by MSG_STATE";
            if (qStat_stmt == null) {
                qStat_stmt = db_conn.prepareStatement(statQuery);
            }
            AQjmsSession aQjmsSession = session;
            synchronized (aQjmsSession) {
                rSet = qStat_stmt.executeQuery();
            }
            while (rSet != null && rSet.next()) {
                cnt = rSet.getLong(1);
                String msgState = rSet.getString(2);
                if (msgState.equalsIgnoreCase("PROCESSED")) {
                    enqCnt += cnt;
                    deqCnt = cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("READY")) {
                    enqCnt += cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("ROLBACKREADY")) {
                    enqCnt += cnt;
                    continue;
                }
                if (msgState.equalsIgnoreCase("RETRYEXPIRED")) {
                    enqCnt += cnt;
                    expCnt += cnt;
                    continue;
                }
                if (!msgState.equalsIgnoreCase("EXPIRED")) continue;
                enqCnt += cnt;
                expCnt += cnt;
            }
            qStatsNow = new AQjmsDestinationStats(this.name, this.owner, this.type, enqCnt, deqCnt, expCnt, mode);
        }
        catch (SQLException e) {
            AQjmsException aqjmsException = new AQjmsException(e);
            AQOracleDebug.traceEx(3, "AQjmsDestination.queryAQViewFull", e);
            throw aqjmsException;
        }
        finally {
            if (rSet != null) {
                try {
                    rSet.close();
                }
                catch (Exception exception) {}
            }
            if (qStat_stmt != null) {
                try {
                    qStat_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return qStatsNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryGVStats(AQjmsSession session) throws JMSException {
        AQjmsDestinationStats qStatsNow;
        block22: {
            Connection db_conn = null;
            Statement qStat_stmt = null;
            ResultSet rSet = null;
            String statQuery = null;
            qStatsNow = null;
            long enqCnt = 0L;
            long deqCnt = 0L;
            long expCnt = 0L;
            int mode = 1;
            try {
                db_conn = session.getDBConnection();
                statQuery = "select sum(enqueued_msgs), sum(dequeued_msgs), sum(MSGS_MADE_EXPIRED), queue_name  from gv$persistent_queues where QUEUE_SCHEMA = :1 and  queue_name = :2 group by queue_name";
                if (qStat_stmt == null) {
                    qStat_stmt = db_conn.prepareStatement(statQuery);
                }
                qStat_stmt.setString(1, this.owner.toUpperCase());
                qStat_stmt.setString(2, this.name.toUpperCase());
                AQjmsSession aQjmsSession = session;
                synchronized (aQjmsSession) {
                    rSet = qStat_stmt.executeQuery();
                }
                if (rSet != null && rSet.next()) {
                    enqCnt = rSet.getLong(1);
                    deqCnt = rSet.getLong(2);
                    expCnt = rSet.getLong(3);
                    qStatsNow = new AQjmsDestinationStats(this.name, this.owner, this.type, enqCnt, deqCnt, expCnt, mode);
                    break block22;
                }
                AQjmsException aqjmsException = new AQjmsException("Queue statistics cannot be calculated until next publish or receive operation.", 1403);
                throw aqjmsException;
            }
            catch (SQLException e) {
                AQjmsException aqjmsException = null;
                int errorCode = e.getErrorCode();
                if (errorCode == 942) {
                    String eMessage = "Grant SELECT_CATALOG_ROLE to " + this.owner;
                    aqjmsException = new AQjmsException(eMessage, e);
                    AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + eMessage, e);
                } else {
                    aqjmsException = new AQjmsException(e);
                    AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth", e);
                }
                throw aqjmsException;
            }
            finally {
                if (rSet != null) {
                    try {
                        rSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (qStat_stmt != null) {
                    try {
                        qStat_stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return qStatsNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryApproxExactProc(AQjmsSession session) throws JMSException {
        String queryStat = "Declare   qschm     varchar2(120);   qname     varchar2(120);  enq_count   number(10); deq_count number(10);   subshrows number;  partnum number;  partname varchar2(50);  dqflag number;  qtid number;  q_cursor  integer ;  q_cursor2 integer ; sqlstmt varchar2(500); sqlstmt2 varchar2(500); qdummy   integer ;begin  qschm := ?;   qname := ?;   select TABLE_OBJNO into qtid from system.aq$_queues where name = qname; deq_count := 0;   sqlstmt := 'select distinct partition#, partname, rowmarker from sys.aq$_dequeue_log_partition_map lm where queue = ' || qtid || ' and SUBSHARD <> -1 order by partition#';   q_cursor := dbms_sql.open_cursor ;  dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; dbms_sql.define_column(q_cursor, 1, partnum);  dbms_sql.define_column(q_cursor, 2, partname, 50);  dbms_sql.define_column(q_cursor, 3, dqflag);  qdummy := dbms_sql.execute (q_cursor);  LOOP    if (dbms_sql.fetch_rows(q_cursor) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor, 1, partnum);    dbms_sql.column_value(q_cursor, 2, partname);    dbms_sql.column_value(q_cursor, 3, dqflag);    sqlstmt2 := 'select count(*) from ' || qschm || '.AQ$_' || qname || '_L partition (' ||  partname || ')' ||' where flags = ' || dqflag;    q_cursor2 := dbms_sql.open_cursor ;    dbms_sql.parse(q_cursor2, sqlstmt2, dbms_sql.v7) ;     dbms_sql.define_column(q_cursor2, 1, subshrows);    qdummy := dbms_sql.execute (q_cursor2);    LOOP      if (dbms_sql.fetch_rows(q_cursor2) = 0) then exit;      end if;     dbms_sql.column_value(q_cursor2, 1, subshrows);     deq_count := deq_count + subshrows;    END LOOP;   dbms_sql.close_cursor(q_cursor2);  END LOOP; dbms_sql.close_cursor(q_cursor);  enq_count := 0;  sqlstmt := 'select distinct partition#, partname from sys.aq$_queue_partition_map where queue = ' || qtid  || ' and shard <> -1';  q_cursor := dbms_sql.open_cursor ;  dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ;  dbms_sql.define_column(q_cursor, 1, partnum);  dbms_sql.define_column(q_cursor, 2, partname, 50); qdummy := dbms_sql.execute (q_cursor);  LOOP   if (dbms_sql.fetch_rows(q_cursor) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor, 1, partnum);    dbms_sql.column_value(q_cursor, 2, partname);    sqlstmt2 := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || partname || ')';   q_cursor2 := dbms_sql.open_cursor ;   dbms_sql.parse(q_cursor2, sqlstmt2, dbms_sql.v7) ;   dbms_sql.define_column(q_cursor2, 1, subshrows);  qdummy := dbms_sql.execute (q_cursor2);   LOOP     if (dbms_sql.fetch_rows(q_cursor2) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor2, 1, subshrows);     enq_count := enq_count + subshrows;   END LOOP;   dbms_sql.close_cursor(q_cursor2);  END LOOP;  dbms_sql.close_cursor(q_cursor); ? := enq_count;   ? := deq_count; end; ";
        CallableStatement qryStmt = null;
        Connection db_conn = null;
        AQjmsDestinationStats qStatsNow = null;
        int mode = 2;
        try {
            db_conn = session.getDBConnection();
            qryStmt = db_conn.prepareCall(queryStat);
            qryStmt.setString(1, this.owner.toUpperCase());
            qryStmt.setString(2, this.name.toUpperCase());
            qryStmt.registerOutParameter(3, -5);
            qryStmt.registerOutParameter(4, -5);
            AQjmsSession aQjmsSession = session;
            synchronized (aQjmsSession) {
                qryStmt.execute();
            }
            long enqCnt = qryStmt.getLong(3);
            long deqCnt = qryStmt.getLong(4);
            qStatsNow = new AQjmsDestinationStats(this.name, this.owner, this.type, enqCnt, deqCnt, mode);
        }
        catch (SQLException e) {
            AQjmsException aqjmsException = null;
            int errorCode = e.getErrorCode();
            if (errorCode == 942) {
                String eMessage = "Grant select on system.aq$_queues, sys.aq$_dequeue_log_partition_map and sys.aq$_queue_partition_map to " + this.owner;
                aqjmsException = new AQjmsException(eMessage, e);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + eMessage, e);
            } else {
                aqjmsException = new AQjmsException(e);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth", e);
            }
            throw aqjmsException;
        }
        finally {
            if (qryStmt != null) {
                try {
                    qryStmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return qStatsNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryApproxProc(AQjmsSession session) throws JMSException {
        String queryStat = "Declare TYPE shard_info IS RECORD \n(q_nummapped_subsh number,\n q_maxmapped_subsh number,\n qpartname varchar2(128),\n qunbound_idx number, \n lwm_subsh number, \n dqlog_nummapped_subsh number, \n dqlog_maxmapped_subsh number,\n dqpartname varchar2(128),\n dqunbound_idx number,\n dqflag number); \n TYPE shard_arr IS TABLE OF shard_info INDEX BY VARCHAR2(32);\nqschm  varchar2(120); \nqname  varchar2(120); \nenq_count number; \ndeq_count number; \nshrd     shard_arr; \nshrdelem shard_info; \nq_cursor          integer; \nsqlstmt varchar2(1024); \nqdummy            integer; \nqid        number; \nqtid       number; \nismulti    number; \nsubshardSz number; \nshrdid     number; \npriority   number; \nsubshrdid  number; \nsubid      number; \nlwm        number; \nSUBSHROWS  number; \nqpartname varchar2(128); \nqUNBOUND_IDX number; \ndqpartname varchar2(128); \ndqflag number; \ndqUNBOUND_IDX number; \nitr varchar2(32); \nmultiplyFactor number; \nstrtDqSn number; \nendDqSn number; \nmcon_error   exception; \npragma exception_init (mcon_error, -25257); \n begin \nqschm := ?; \nqname := ?;enq_count := 0;\ndeq_count := 0;\nselect o.object_id, decode(qt.RECIPIENTS, 'SINGLE', 0, 1) into qtid, ismulti \n from user_objects o, user_queue_tables qt\n where o.OBJECT_NAME=qname and o.OBJECT_TYPE='TABLE' and o.OBJECT_NAME = qt.QUEUE_TABLE; \n if ismulti = 1 then \n   raise mcon_error; \n else \n  subid := 0; \n end if; \nselect qid into qid from user_queues where name=qname; \n dbms_aqadm.get_queue_parameter(qname, 'SUBSHARD_SIZE', subshardSz); \n sqlstmt := \n'select q.priority, q.shard, q.subshard, q.partname, q.unbound_idx, dq.partname, dq.rowmarker, dq.unbound_idx \n from sys.aq$_queue_partition_map q, sys.aq$_dequeue_log_partition_map dq \n where q.queue = dq.queue(+) and q.partition# = dq.queue_part#(+) and q.subshard = dq.subshard(+)  and q.queue = '|| qtid ||' and q.shard <> -1 and  (dq.subscriber_id = '|| subid ||' or dq.subscriber_id is null)';\nq_cursor := dbms_sql.open_cursor ; \ndbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \ndbms_sql.define_column(q_cursor, 1, priority); \ndbms_sql.define_column(q_cursor, 2, shrdid); \ndbms_sql.define_column(q_cursor, 3, subshrdid); \ndbms_sql.define_column(q_cursor, 4, qpartname, 128); \ndbms_sql.define_column(q_cursor, 5, qunbound_idx); \ndbms_sql.define_column(q_cursor, 6, dqpartname, 128); \ndbms_sql.define_column(q_cursor, 7, dqflag); \ndbms_sql.define_column(q_cursor, 8, dqunbound_idx); \nqdummy := dbms_sql.execute (q_cursor); \nLOOP \n  if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n  end if; \n  dbms_sql.column_value(q_cursor, 1, priority); \n  dbms_sql.column_value(q_cursor, 2, shrdid); \n  dbms_sql.column_value(q_cursor, 3, subshrdid); \n  dbms_sql.column_value(q_cursor, 4, qpartname); \n  dbms_sql.column_value(q_cursor, 5, qunbound_idx); \n  dbms_sql.column_value(q_cursor, 6, dqpartname); \n  dbms_sql.column_value(q_cursor, 7, dqflag); \n  dbms_sql.column_value(q_cursor, 8, dqunbound_idx); \n if (not shrd.exists(shrdid || ',' || priority)) then \n    shrdelem.q_nummapped_subsh := 1; \n      shrdelem.q_maxmapped_subsh := subshrdid; \n    shrdelem.qpartname := qpartname; \n     shrdelem.qunbound_idx := qunbound_idx; \n    shrdelem.lwm_subsh := 0; \n    if (dqflag is null) then \n      shrdelem.dqlog_nummapped_subsh := 0; \n      shrdelem.dqlog_maxmapped_subsh := -1; \n      shrdelem.dqpartname := ''; \n      shrdelem.dqunbound_idx := 0; \n      shrdelem.dqflag := 0; \n    else \n      shrdelem.dqlog_nummapped_subsh := 1; \n      shrdelem.dqlog_maxmapped_subsh := subshrdid; \n      shrdelem.dqpartname := dqpartname; \n      shrdelem.dqunbound_idx := dqunbound_idx; \n      shrdelem.dqflag := dqflag; \n    end if; \n    shrd(shrdid || ',' || priority) := shrdelem; \n  else \n   shrdelem := shrd(shrdid || ',' || priority); \n      shrd(shrdid || ',' || priority).q_nummapped_subsh := shrdelem.q_nummapped_subsh + 1; \n      if (shrdelem.q_maxmapped_subsh = -1 or shrdelem.q_maxmapped_subsh < subshrdid) then \n        shrd(shrdid || ',' || priority).q_maxmapped_subsh := subshrdid; \n        shrd(shrdid || ',' || priority).qpartname := qpartname; \n        shrd(shrdid || ',' || priority).qunbound_idx := qunbound_idx; \n      end if; \n      if (dqflag is not null) then \n        shrd(shrdid || ',' || priority).dqlog_nummapped_subsh := shrdelem.dqlog_nummapped_subsh + 1; \n        if (shrdelem.dqlog_maxmapped_subsh = -1 or shrdelem.dqlog_maxmapped_subsh < subshrdid) then \n         shrd(shrdid || ',' || priority).dqlog_maxmapped_subsh := subshrdid; \n           shrd(shrdid || ',' || priority).dqpartname := dqpartname; \n         shrd(shrdid || ',' || priority).dqunbound_idx := dqunbound_idx; \n         shrd(shrdid || ',' || priority).dqflag := dqflag; \n       end if; \n     end if; \n end if; \nEND LOOP; \nitr := shrd.first; \nwhile (itr is not null) \nloop \n  shrdelem := shrd(itr); \n  if (shrdelem.q_nummapped_subsh > 0) then \n    if (shrdelem.dqlog_nummapped_subsh > 0) then \n     deq_count := deq_count + ((shrdelem.dqlog_nummapped_subsh -1) * subshardSz); \n      if shrdelem.dqUnbound_Idx = -1 then \n        multiplyFactor := 0; \n      else \n        multiplyFactor := shrdelem.dqUnbound_Idx; \n      end if; \n      strtDqSn := (0 + (subshardSz * (multiplyFactor))); \n      endDqSn := (subshardSz + (subshardSz * (multiplyFactor))); \n      sqlstmt := 'select count(*) from ' || qschm || '.AQ$_' || qname || '_L partition (' ||  shrdelem.dqpartname || ')' \n||' where flags = ' || shrdelem.dqflag || ' and seq_num >= ' || strtDqSn || ' and seq_num < ' || endDqSn; \n      q_cursor := dbms_sql.open_cursor ; \n      dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \n      dbms_sql.define_column(q_cursor, 1, subshrows); \n      qdummy := dbms_sql.execute (q_cursor); \n      LOOP \n        if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n        end if; \n        dbms_sql.column_value(q_cursor, 1, subshrows); \n        deq_count := deq_count + subshrows; \n      END LOOP; \n      dbms_sql.close_cursor(q_cursor); \n    end if; \n    enq_count := enq_count + ((shrdelem.q_nummapped_subsh -1) * subshardSz); \n    if shrdelem.qunbound_Idx = -1 then \n      sqlstmt := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || shrdelem.qpartname || ')'; \n    else \n      sqlstmt := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || shrdelem.qpartname || ') \n where subshard = ' || shrdelem.q_maxmapped_subsh; \n   end if; \n    q_cursor := dbms_sql.open_cursor ; \n    dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \n    dbms_sql.define_column(q_cursor, 1, subshrows); \n    qdummy := dbms_sql.execute (q_cursor); \n    LOOP \n      if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n      end if; \n      dbms_sql.column_value(q_cursor, 1, subshrows); \n      enq_count := enq_count + subshrows; \n    END LOOP; \n    dbms_sql.close_cursor(q_cursor); \n  end if; \n  itr := shrd.next(itr); \nend loop; \n ? := enq_count; \n  ? := deq_count; \nend;";
        CallableStatement qryStmt = null;
        Connection db_conn = null;
        AQjmsDestinationStats qStatsNow = null;
        int mode = 2;
        try {
            db_conn = session.getDBConnection();
            qryStmt = db_conn.prepareCall(queryStat);
            qryStmt.setString(1, this.owner.toUpperCase());
            qryStmt.setString(2, this.name.toUpperCase());
            qryStmt.registerOutParameter(3, -5);
            qryStmt.registerOutParameter(4, -5);
            AQjmsSession aQjmsSession = session;
            synchronized (aQjmsSession) {
                qryStmt.execute();
            }
            long enqCnt = qryStmt.getLong(3);
            long deqCnt = qryStmt.getLong(4);
            qStatsNow = new AQjmsDestinationStats(this.name, this.owner, this.type, enqCnt, deqCnt, mode);
        }
        catch (SQLException e) {
            AQjmsException aqjmsException = null;
            int errorCode = e.getErrorCode();
            if (errorCode == 942) {
                String eMessage = "Grant select on sys.aq$_dequeue_log_partition_map and sys.aq$_queue_partition_map to " + this.owner;
                aqjmsException = new AQjmsException(eMessage, e);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + eMessage, e);
            } else {
                aqjmsException = new AQjmsException(e);
                AQOracleDebug.traceEx(3, "AQjmsDestination.queryApproxProc", e);
            }
            throw aqjmsException;
        }
        finally {
            if (qryStmt != null) {
                try {
                    qryStmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return qStatsNow;
    }
}

