/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleStruct;
import oracle.jms.plsql.ExceptionHandler;
import oracle.jms.plsql.MapMsgEntity;
import oracle.jms.plsql.MsgStore;
import oracle.jms.plsql.ResourceMgr;
import oracle.jms.plsql.TypeConversion;
import oracle.sql.NUMBER;

public class MapMsgHandler {
    private static MsgStore msgStore = new MsgStore(3);

    public static int prepare(int n, int[] nArray, byte[] byArray, OracleBlob oracleBlob) {
        try {
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = byArray;
            } else if (oracleBlob != null) {
                byArray2 = oracleBlob.getBytes(1L, (int)oracleBlob.length());
            }
            nArray[0] = n < 0 ? msgStore.createMsgEntity(byArray2) : msgStore.createMsgEntity(n, byArray2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clear_body(int n, int[] nArray) {
        try {
            nArray[0] = n < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int flush(int n, int[] nArray, byte[][] byArray, OracleBlob[] oracleBlobArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            byte[] byArray2 = mapMsgEntity.flush();
            nArray[0] = byArray2.length;
            if (byArray2.length > 2000) {
                if (oracleBlobArray[0] == null) {
                    oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    oracleBlobArray[0].truncate(0L);
                }
                oracleBlobArray[0].setBytes(1L, byArray2);
            } else {
                byArray[0] = byArray2;
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean(int n) {
        try {
            msgStore.cleanMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_size(int n, int[] nArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            nArray[0] = mapMsgEntity.size();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_names(int n, OracleArray[] oracleArrayArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            String[] stringArray = mapMsgEntity.getNames();
            oracleArrayArray[0] = TypeConversion.arrayToARRAY(stringArray);
            return 0;
        }
        catch (Throwable throwable) {
            try {
                oracleArrayArray[0] = TypeConversion.getNullARRAY();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_names(int n, OracleArray[] oracleArrayArray, int n2, int n3, int[] nArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            String[] stringArray = mapMsgEntity.getNames(n2, n3, nArray);
            oracleArrayArray[0] = TypeConversion.arrayToARRAY(stringArray);
            return 0;
        }
        catch (Throwable throwable) {
            try {
                nArray[0] = 0;
                oracleArrayArray[0] = TypeConversion.getNullARRAY();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int item_exists(int n, String string, NUMBER[] nUMBERArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            nUMBERArray[0] = new NUMBER(mapMsgEntity.itemExists(string));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_object(int n, String string, OracleStruct[] oracleStructArray, int[] nArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            Object object = mapMsgEntity.get(string);
            TypeConversion.objToJmsValue(object, oracleStructArray, nArray);
            return 0;
        }
        catch (Throwable throwable) {
            try {
                nArray[0] = 1;
                oracleStructArray[0] = TypeConversion.getNullSTRUCT();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_number(int n, String string, NUMBER[] nUMBERArray, int n2) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            Object object = mapMsgEntity.get(string, n2);
            nUMBERArray[0] = TypeConversion.objToNumber(object, n2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_bytes(int n, String string, OracleBlob[] oracleBlobArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            Object object = mapMsgEntity.get(string, 9);
            if (object == null) {
                oracleBlobArray[0] = null;
                return 0;
            }
            byte[] byArray = (byte[])object;
            if (oracleBlobArray[0] == null) {
                oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
            } else {
                oracleBlobArray[0].truncate(0L);
            }
            oracleBlobArray[0].setBytes(1L, byArray);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_char(int n, String string, String[] stringArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            Object object = mapMsgEntity.get(string, 7);
            if (object == null) {
                stringArray[0] = null;
                return 0;
            }
            stringArray[0] = ((Character)object).toString();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_string(int n, String string, OracleClob[] oracleClobArray) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            Object object = mapMsgEntity.get(string, 8);
            if (object == null) {
                oracleClobArray[0] = null;
                return 0;
            }
            String string2 = (String)object;
            if (oracleClobArray[0] == null) {
                oracleClobArray[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                oracleClobArray[0].truncate(0L);
            }
            oracleClobArray[0].setString(1L, string2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_number(int n, String string, NUMBER nUMBER, int n2) {
        try {
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            mapMsgEntity.set(string, TypeConversion.numberToObj(nUMBER, n2));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_bytes(int n, String string, byte[] byArray, int n2, int n3) {
        try {
            if (byArray == null) {
                return 0;
            }
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            if (n2 == 0 && n3 == byArray.length) {
                mapMsgEntity.set(string, byArray);
            } else {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                mapMsgEntity.set(string, byArray2);
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_bytes(int n, String string, OracleBlob oracleBlob, int n2, int n3) {
        try {
            if (oracleBlob == null) {
                return 0;
            }
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            if ((long)(n2 + n3) > oracleBlob.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] byArray = oracleBlob.getBytes((long)(n2 + 1), n3);
            mapMsgEntity.set(string, byArray);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_char(int n, String string, String string2) {
        try {
            if (string2 != null && string2.length() > 0) {
                MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
                mapMsgEntity.set(string, new Character(string2.charAt(0)));
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_string(int n, String string, String string2) {
        try {
            if (string2 == null) {
                return 0;
            }
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            mapMsgEntity.set(string, string2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int set_string(int n, String string, OracleClob oracleClob) {
        try {
            if (oracleClob == null) {
                return 0;
            }
            MapMsgEntity mapMsgEntity = (MapMsgEntity)msgStore.getMsgEntity(n);
            mapMsgEntity.set(string, oracleClob.getSubString(1L, (int)oracleClob.length()));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }
}

