/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.EOFException;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jms.plsql.BytesMsgEntity;
import oracle.jms.plsql.ExceptionHandler;
import oracle.jms.plsql.InternalException;
import oracle.jms.plsql.MsgStore;
import oracle.jms.plsql.ResourceMgr;
import oracle.sql.NUMBER;

public class BytesMsgHandler {
    private static MsgStore msgStore = new MsgStore(1);

    public static int prepare(int n, int[] nArray, byte[] byArray, OracleBlob oracleBlob) {
        try {
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = byArray;
            } else if (oracleBlob != null) {
                byArray2 = oracleBlob.getBytes(1L, (int)oracleBlob.length());
            }
            nArray[0] = n < 0 ? msgStore.createMsgEntity(byArray2) : msgStore.createMsgEntity(n, byArray2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clear_body(int n, int[] nArray) {
        try {
            nArray[0] = n < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_mode(int n, int[] nArray) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            nArray[0] = bytesMsgEntity.getMode();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int reset(int n) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            bytesMsgEntity.reset();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int flush(int n, int[] nArray, byte[][] byArray, OracleBlob[] oracleBlobArray) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            byte[] byArray2 = bytesMsgEntity.flush();
            nArray[0] = byArray2.length;
            if (byArray2.length > 2000) {
                if (oracleBlobArray[0] == null) {
                    oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    oracleBlobArray[0].truncate(0L);
                }
                oracleBlobArray[0].setBytes(1L, byArray2);
            } else {
                byArray[0] = byArray2;
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean(int n) {
        try {
            msgStore.cleanMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_number(int n, NUMBER[] nUMBERArray, int n2) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            switch (n2) {
                case 0: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readByte());
                    break;
                }
                case 1: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readShort());
                    break;
                }
                case 2: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readInt());
                    break;
                }
                case 3: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readLong());
                    break;
                }
                case 4: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readFloat());
                    break;
                }
                case 5: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readDouble());
                    break;
                }
                case 6: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readBoolean());
                    break;
                }
                case 10: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readUnsignedByte());
                    break;
                }
                case 11: {
                    nUMBERArray[0] = new NUMBER(bytesMsgEntity.readUnsignedShort());
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
            return 0;
        }
        catch (EOFException eOFException) {
            nUMBERArray[0] = null;
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_bytes(int n, OracleBlob[] oracleBlobArray, int n2, int[] nArray) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            byte[] byArray = new byte[n2];
            nArray[0] = bytesMsgEntity.readBytes(byArray);
            if (nArray[0] == -1) {
                oracleBlobArray[0] = null;
            } else {
                if (oracleBlobArray[0] == null) {
                    oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    oracleBlobArray[0].truncate(0L);
                }
                oracleBlobArray[0].setBytes(1L, byArray);
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_char(int n, String[] stringArray) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            stringArray[0] = String.valueOf(bytesMsgEntity.readChar());
            return 0;
        }
        catch (EOFException eOFException) {
            stringArray[0] = null;
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_utf(int n, OracleClob[] oracleClobArray) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            String string = bytesMsgEntity.readUTF();
            if (string == null) {
                oracleClobArray[0] = null;
                return 0;
            }
            if (oracleClobArray[0] == null) {
                oracleClobArray[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                oracleClobArray[0].truncate(0L);
            }
            oracleClobArray[0].setString(1L, string);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_number(int n, NUMBER nUMBER, int n2) {
        try {
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            switch (n2) {
                case 0: {
                    bytesMsgEntity.writeByte(nUMBER.byteValue());
                    break;
                }
                case 1: {
                    bytesMsgEntity.writeShort(nUMBER.shortValue());
                    break;
                }
                case 2: {
                    bytesMsgEntity.writeInt(nUMBER.intValue());
                    break;
                }
                case 3: {
                    bytesMsgEntity.writeLong(nUMBER.longValue());
                    break;
                }
                case 4: {
                    bytesMsgEntity.writeFloat(nUMBER.floatValue());
                    break;
                }
                case 5: {
                    bytesMsgEntity.writeDouble(nUMBER.doubleValue());
                    break;
                }
                case 6: {
                    bytesMsgEntity.writeBoolean(nUMBER.booleanValue());
                    break;
                }
                default: {
                    throw new InternalException();
                }
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_bytes(int n, byte[] byArray, int n2, int n3) {
        try {
            if (byArray == null) {
                return 0;
            }
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            bytesMsgEntity.writeBytes(byArray, n2, n3);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_bytes(int n, OracleBlob oracleBlob, int n2, int n3) {
        try {
            if (oracleBlob == null) {
                return 0;
            }
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            if ((long)(n2 + n3) > oracleBlob.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] byArray = oracleBlob.getBytes((long)(n2 + 1), n3);
            bytesMsgEntity.writeBytes(byArray, 0, n3);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_char(int n, String string) {
        try {
            if (string != null && string.length() > 0) {
                BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
                bytesMsgEntity.writeChar(string.charAt(0));
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_utf(int n, String string) {
        try {
            if (string == null) {
                return 0;
            }
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            bytesMsgEntity.writeUTF(string);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_utf(int n, OracleClob oracleClob) {
        try {
            if (oracleClob == null) {
                return 0;
            }
            BytesMsgEntity bytesMsgEntity = (BytesMsgEntity)msgStore.getMsgEntity(n);
            bytesMsgEntity.writeUTF(oracleClob.getSubString(1L, (int)oracleClob.length()));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }
}

