/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.Message;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.DispatchScheduler;

public class AQjmsSimpleScheduler
implements DispatchScheduler {
    long m_minSleepTime;
    long m_maxSleepTime;
    long m_duration = 0L;
    String m_id;

    public AQjmsSimpleScheduler() {
        this(null, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsSimpleScheduler(String string) {
        this(string, AQjmsConstants.getMinSleepTime(), AQjmsConstants.getMaxSleepTime());
    }

    public AQjmsSimpleScheduler(String string, long l, long l2) {
        this.m_id = string;
        this.m_minSleepTime = l;
        this.m_maxSleepTime = l2;
    }

    @Override
    public void feedException(int n, Exception exception) {
        this.m_duration = AQjmsConstants.getListenerRetry();
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
    }

    @Override
    public void feedData(Message message) {
        if (message == null) {
            this.doubleDuration();
            AQjmsOracleDebug.trace(3, "AQjmsSimpleScheduler.feedData", "Got a null message, the sleep time is doubled to " + this.m_duration);
        } else {
            this.m_duration = 0L;
            AQjmsOracleDebug.trace(3, "AQjmsSimpleScheduler.feedData", "Got a non null message, the sleep time is reset to 0");
        }
    }

    @Override
    public long getNextSleepTime() {
        long l = this.m_duration < this.m_minSleepTime ? 0L : (this.m_duration > this.m_maxSleepTime ? this.m_maxSleepTime : this.m_duration);
        return l;
    }

    private void doubleDuration() {
        this.m_duration = this.m_duration == 0L ? this.m_minSleepTime : (this.m_duration *= 2L);
        if (this.m_duration > this.m_maxSleepTime) {
            this.m_duration = this.m_maxSleepTime;
        }
    }
}

