/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.jms.JMSException;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParserConstants;
import oracle.jms.AQjmsParserExpr;
import oracle.jms.AQjmsParserTokenManager;
import oracle.jms.JavaCharStream;
import oracle.jms.ParseException;
import oracle.jms.Token;

class AQjmsParser
implements AQjmsParserConstants {
    private static final String JMS_PROPERTY_DELIMETER = "#^$";
    boolean doStrongTypeChecking = AQjmsConstants.isStronglyTypedSelector();
    boolean is_func_call = false;
    int dest_pload_type = 0;
    boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private String v1;
    private String v2v3v4;
    private static String JMS_HEADER = "1)";
    private static String USER_PROP = "0)";
    public AQjmsParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[30];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setDestPayloadType(int n) {
        this.dest_pload_type = n;
    }

    public void setCompliant(boolean bl) {
        this.compliant = bl;
    }

    void initForJmsSharded() {
        this.dest_pload_type = 4;
        this.doStrongTypeChecking = true;
        this.compliant = true;
        this.v1 = ":v1,'";
        this.v2v3v4 = "',:v2,:v3,:v4,";
    }

    public String parseRule(String string) throws JMSException {
        AQjmsParser aQjmsParser = null;
        String string2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "entry");
        aQjmsParser = new AQjmsParser(new StringReader(string));
        try {
            string2 = aQjmsParser.SubscriberRule();
            AQjmsOracleDebug.trace(5, "AQjmsParser.parseRule", "Rule: " + string2);
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException parseException) {
            AQjmsOracleDebug.traceEx(4, "Rule parse error", parseException);
            new AQjmsException("Rule Parse error", 100, parseException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "exit");
        return string2;
    }

    public String mapJMSStringToColumn(String string, int n) throws ParseException {
        String string2 = null;
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSStringToColumn", "Sel type: " + n);
        if (n == 10 || n == 50) {
            string2 = this.dest_pload_type == 4 ? this.mapJMSPropertyNamesSharded(string) : this.mapJMSPropertyNames(string);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String mapJMSPropertyNamesSharded(String string) throws ParseException {
        Object object = null;
        if (string == null) {
            throw new ParseException("input is NULL");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNamesSharded", "Input: " + string);
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("NULL")) {
            return string;
        }
        if (string.startsWith("JMS_Oracle")) {
            if (string.equals("JMS_OracleConnectionID")) return JMS_PROPERTY_DELIMETER + string + JMS_PROPERTY_DELIMETER;
            throw new ParseException("Oracle specific property: " + string + " not supported in message selector");
        }
        if (string.startsWith("JMS") && !string.startsWith("JMSX")) {
            if (string.equals("JMSMessageID")) {
                object = "tab.msgid";
            } else if (string.equals("JMSCorrelationID")) {
                object = "correlation";
            } else if (string.equals("JMSPriority")) {
                object = "priority";
            } else if (string.equals("JMSTimestamp")) {
                object = "enqueue_time";
            } else if (string.equals("JMSType")) {
                object = this.toRulesSyntaxJmsSharded(string, 2, JMS_HEADER);
            } else {
                if (!string.equals("JMSDeliveryMode")) throw new ParseException("Header: " + string + " not supported in message selector");
                object = this.toRulesSyntaxJmsSharded(string, 2, JMS_HEADER);
            }
        } else {
            object = this.is_func_call ? string : JMS_PROPERTY_DELIMETER + string + JMS_PROPERTY_DELIMETER;
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNamesSharded", "New value: " + (String)object);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String mapJMSPropertyNames(String string) throws ParseException {
        Object object = null;
        if (string == null) {
            throw new ParseException("input is NULL");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNames", "Input: " + string);
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("NULL")) {
            return string;
        }
        if (string.startsWith("JMS_Oracle")) {
            if (!string.equals("JMS_OracleConnectionID")) {
                throw new ParseException("Oracle specific property: " + string + " not supported in message selector");
            }
            object = JMS_PROPERTY_DELIMETER + string + JMS_PROPERTY_DELIMETER;
        } else if (string.startsWith("JMS")) {
            if (string.equals("JMSPriority")) {
                object = this.compliant ? "(9 - priority)" : "priority";
            } else if (string.equals("JMSCorrelationID")) {
                object = "corrid";
            } else if (string.equals("JMSTimestamp")) {
                object = "enq_time";
            } else if (string.equals("JMSMessageID")) {
                object = "tab.msgid";
            } else if (string.equals("JMSType")) {
                object = "tab.user_data.header.type";
            } else if (string.equals("JMSXUserID")) {
                object = "tab.user_data.header.userid";
            } else if (string.equals("JMSXAppID")) {
                object = "tab.user_data.header.appid";
            } else if (string.equals("JMSXGroupID")) {
                object = "tab.user_data.header.groupid";
            } else if (string.equals("JMSXGroupSeq")) {
                object = "tab.user_data.header.groupseq";
            } else {
                if (!string.equals("JMSDeliveryMode")) throw new ParseException("System property: " + string + " not supported in message selector");
                object = "#^$JMS_OracleDeliveryMode#^$";
            }
        } else {
            object = this.is_func_call ? string : JMS_PROPERTY_DELIMETER + string + JMS_PROPERTY_DELIMETER;
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNames", "New value: " + (String)object);
        return object;
    }

    String trimIDPrefix(String string) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - entry");
        if (string == null || string.length() < 5 || !string.substring(1, 4).equals("ID:")) {
            AQjmsOracleDebug.trace(3, "AQjmsParser", "trimIDPrefix - parse exception");
            throw new ParseException("Invalid JMSMessageID in selector");
        }
        String string2 = string.substring(0, 1) + string.substring(4);
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - exit");
        return string2;
    }

    String checkForEscapeChars(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "QuotedInput:  " + string);
        if (string == null || string.length() <= 2) {
            return string;
        }
        string2 = string.substring(1, string.length() - 1);
        stringBuffer.append("'");
        if (string2 != null && string2.length() > 0) {
            while (bl2) {
                n2 = string2.indexOf("\\", n);
                if (n2 == -1) {
                    bl2 = false;
                    if (n == 0) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(string2.substring(n));
                    continue;
                }
                if (n2 < string2.length() - 1 && string2.charAt(n2 + 1) == '\'') {
                    stringBuffer.append(string2.substring(n, n2));
                    stringBuffer.append("'");
                    stringBuffer.append(string2.charAt(n2 + 1));
                    n = n2 + 2;
                } else {
                    stringBuffer.append(string2.substring(n, n2 + 1));
                    n = n2 + 1;
                }
                if (n < string2.length()) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append("'");
        string3 = stringBuffer.toString();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "New String:  " + string3);
        return string3;
    }

    private String toRulesSyntax(String string, int n) {
        String string2 = null;
        string2 = this.doStrongTypeChecking && n == 1 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "decode(dbms_aqjms.get_ptype('" + string + "', tab.user_data.header.properties), 200, dbms_aqjms.get_numval('" + string + "', tab.user_data.header.properties), null)") : (this.doStrongTypeChecking && n == 2 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), 100, dbms_aqjms.get_strval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "tab.user_data.header.get_string_property ('" + string + "') ") : (this.doStrongTypeChecking && n == 4 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "tab.user_data.header.get_boolean_property_as_int ('" + string + "') ") : (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), 100, dbms_aqjms.get_strval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "decode(dbms_aqjms.get_ptype('" + string + "', tab.user_data.header.properties), 100, dbms_aqjms.get_strval('" + string + "', tab.user_data.header.properties), 200, dbms_aqjms.get_numval('" + string + "', tab.user_data.header.properties), null)")));
        return string2;
    }

    private String toRulesSyntaxJmsSharded(String string, int n, String string2) {
        Object object = null;
        if (n == 2) {
            object = "sys.dbms_aqjms.search_string_property(";
        } else if (n == 1) {
            object = "sys.dbms_aqjms.search_number_property(";
        } else if ((n & 4) != 0) {
            object = "sys.dbms_aqjms.search_boolean_property(";
        } else {
            throw new RuntimeException("Unsupported");
        }
        object = (String)object + this.v1 + string + this.v2v3v4 + string2;
        return object;
    }

    void promoteToString(AQjmsParserExpr aQjmsParserExpr) throws ParseException {
        this.promoteExpression(aQjmsParserExpr, 2, false);
    }

    void promoteToNumeric(AQjmsParserExpr aQjmsParserExpr) throws ParseException {
        this.promoteExpression(aQjmsParserExpr, 1, false);
    }

    void promoteExpression(AQjmsParserExpr aQjmsParserExpr, int n, boolean bl) throws ParseException {
        String string = aQjmsParserExpr.getString();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            stringBuffer.append("(");
        }
        AQjmsOracleDebug.println("promoteExpression: IN: " + string);
        while ((n2 = string.indexOf(JMS_PROPERTY_DELIMETER, n2)) >= 0) {
            stringBuffer.append(string.substring(n3, n2));
            n3 = string.indexOf(JMS_PROPERTY_DELIMETER, n2 += JMS_PROPERTY_DELIMETER.length());
            string2 = string.substring(n2, n3);
            n3 += JMS_PROPERTY_DELIMETER.length();
            if (this.dest_pload_type == 4) {
                stringBuffer.append(this.toRulesSyntaxJmsSharded(string2, n, USER_PROP));
            } else {
                stringBuffer.append(this.toRulesSyntax(string2, n));
            }
            n2 = n3;
        }
        String string3 = string.substring(n3, string.length());
        if (string2 != null && string2.equals("JMS_OracleDeliveryMode")) {
            string3 = string3.replaceAll("'PERSISTENT'", "2");
            string3 = string3.replaceAll("'NON_PERSISTENT'", "1");
        }
        stringBuffer.append(string3);
        if (bl) {
            stringBuffer.append(") = 1");
        }
        if (stringBuffer.toString().startsWith("enqueue_time") || stringBuffer.toString().startsWith("enq_time")) {
            String string4 = stringBuffer.toString();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string5 = stringTokenizer.nextToken();
                long l = 0L;
                if (string5.matches(".*\\d.*")) {
                    try {
                        l = Long.parseLong(string5);
                        string5 = this.convertEnqueueTimeToTimestamp(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid JMSTimestamp in selector");
                    }
                }
                stringBuffer2.append(string5 + " ");
            }
            aQjmsParserExpr.setString(stringBuffer2.toString().trim());
        } else {
            aQjmsParserExpr.setString(stringBuffer.toString());
        }
        AQjmsOracleDebug.println("promoteExpression: RETURN expr: " + aQjmsParserExpr.getString());
    }

    private String convertEnqueueTimeToTimestamp(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = "to_timestamp_tz('" + simpleDateFormat.format(new Date(l)) + " UTC', 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD')";
        return string;
    }

    public final String SequenceOfStatements() throws ParseException {
        Object object = new String("");
        String string = null;
        block3: while (true) {
            string = this.SubscriberRule();
            object = (String)object + string + "\n";
            this.jj_consume_token(32);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 36: 
                case 37: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        return object;
    }

    public final String SubscriberRule() throws ParseException {
        AQjmsParserExpr aQjmsParserExpr = null;
        aQjmsParserExpr = this.SQLExpression();
        this.jj_consume_token(32);
        AQjmsOracleDebug.println("SubscriberRule: \n" + aQjmsParserExpr.getString());
        return aQjmsParserExpr.getString();
    }

    public final AQjmsParserExpr SQLExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        AQjmsParserExpr aQjmsParserExpr3 = null;
        aQjmsParserExpr2 = this.SQLAndExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            object = (String)object + " OR ";
            aQjmsParserExpr.setTypeBoolean();
            aQjmsParserExpr3 = this.SQLAndExpression();
            object = (String)object + aQjmsParserExpr3.getString();
        }
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        aQjmsParserExpr.setString((String)object);
        AQjmsOracleDebug.println("SQLExpression: " + (String)object + " Type: " + aQjmsParserExpr.getType());
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLAndExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        AQjmsParserExpr aQjmsParserExpr3 = null;
        aQjmsParserExpr2 = this.SQLUnaryLogicalExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            object = (String)object + " AND ";
            aQjmsParserExpr.setTypeBoolean();
            aQjmsParserExpr3 = this.SQLUnaryLogicalExpression();
            object = (String)object + aQjmsParserExpr3.getString();
        }
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLUnaryLogicalExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                object = (String)object + " NOT ";
                aQjmsParserExpr.setTypeBoolean();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        aQjmsParserExpr2 = this.SQLRelationalExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setString((String)object);
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLRelationalExpression() throws ParseException {
        boolean bl = false;
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        AQjmsParserExpr aQjmsParserExpr3 = null;
        AQjmsParserExpr aQjmsParserExpr4 = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(33);
            object = (String)object + "(";
            aQjmsParserExpr2 = this.SQLExpressionList(false);
            object = (String)object + aQjmsParserExpr2.getString();
            aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
            this.jj_consume_token(35);
            object = (String)object + ")";
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 36: 
                case 37: {
                    aQjmsParserExpr2 = this.SQLSimpleExpression();
                    object = (String)object + aQjmsParserExpr2.getString();
                    if ("tab.msgid".equals(aQjmsParserExpr2.getString())) {
                        bl = true;
                    }
                    aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        aQjmsParserExpr4 = this.Relop();
                        object = (String)object + aQjmsParserExpr4.getString();
                        aQjmsParserExpr3 = this.SQLSimpleExpression();
                        if (bl) {
                            aQjmsParserExpr3.setString(this.trimIDPrefix(aQjmsParserExpr3.getString()));
                        }
                        object = (String)object + aQjmsParserExpr3.getString();
                        if (this.doStrongTypeChecking && (aQjmsParserExpr.isString() || aQjmsParserExpr.isBoolean() || aQjmsParserExpr3.isString() || aQjmsParserExpr3.isBoolean()) && !aQjmsParserExpr4.isEqualOperator() && !aQjmsParserExpr4.isNotEqualOperator()) {
                            throw new ParseException("String and Boolean can only use \"=\" and \"<>\" operators");
                        }
                        if (!this.doStrongTypeChecking || aQjmsParserExpr.isVariable() || aQjmsParserExpr3.isVariable() || aQjmsParserExpr.getType() == aQjmsParserExpr3.getType()) break block3;
                        throw new ParseException("Operand type mismatch: " + aQjmsParserExpr.getType() + " and " + aQjmsParserExpr3.getType());
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        if (this.jj_2_2(2)) {
                            aQjmsParserExpr3 = this.SQLInClause(bl);
                            object = (String)object + aQjmsParserExpr3.getString();
                            break block3;
                        }
                        if (this.jj_2_3(2)) {
                            aQjmsParserExpr3 = this.SQLBetweenClause(bl);
                            object = (String)object + aQjmsParserExpr3.getString();
                            break block3;
                        }
                        if (this.jj_2_4(2)) {
                            aQjmsParserExpr3 = this.SQLLikeClause(bl);
                            object = (String)object + aQjmsParserExpr3.getString();
                            break block3;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 9: {
                                aQjmsParserExpr4 = new AQjmsParserExpr();
                                String string = this.IsNullClause(aQjmsParserExpr4);
                                object = (String)object + string;
                                aQjmsParserExpr3 = new AQjmsParserExpr();
                                aQjmsParserExpr3.setTypeVariable();
                                break block3;
                            }
                        }
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        int n = 0;
        n = aQjmsParserExpr3 == null ? 4 : (!aQjmsParserExpr3.isVariable() ? aQjmsParserExpr3.getType() : aQjmsParserExpr.getType());
        AQjmsOracleDebug.println("RELEXPR: Gleaned type is " + n + " for: " + (String)object);
        if (this.dest_pload_type == 4 && aQjmsParserExpr2.isVariable() && aQjmsParserExpr3 != null && aQjmsParserExpr3.isVariable()) {
            this.convertComparisonExpression(aQjmsParserExpr, aQjmsParserExpr2, aQjmsParserExpr3, aQjmsParserExpr4, (String)object);
        } else {
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, n, aQjmsParserExpr3 == null && (aQjmsParserExpr.isVariable() || aQjmsParserExpr.isBooleanLiteral()));
        }
        aQjmsParserExpr.setTypeBoolean();
        return aQjmsParserExpr;
    }

    private void convertComparisonExpression(AQjmsParserExpr aQjmsParserExpr, AQjmsParserExpr aQjmsParserExpr2, AQjmsParserExpr aQjmsParserExpr3, AQjmsParserExpr aQjmsParserExpr4, String object) throws ParseException {
        String string;
        String string2;
        String string3;
        if (aQjmsParserExpr4.isEqualOperator() || aQjmsParserExpr4.isNotEqualOperator() || aQjmsParserExpr4.isTypeIsNotNullClauseOperator()) {
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 2, false);
            string3 = aQjmsParserExpr.getString();
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 1, false);
            string2 = aQjmsParserExpr.getString();
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 4, false);
            string = aQjmsParserExpr.getString();
            object = "(" + string3 + " OR " + string2 + " OR " + string + ")";
            aQjmsParserExpr.setString((String)object);
        }
        if (aQjmsParserExpr4.isTypeIsNullClauseOperator()) {
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 2, false);
            string3 = aQjmsParserExpr.getString();
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 1, false);
            string2 = aQjmsParserExpr.getString();
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 4, false);
            string = aQjmsParserExpr.getString();
            object = "(" + string3 + " AND " + string2 + " AND " + string + ")";
            aQjmsParserExpr.setString((String)object);
        } else {
            aQjmsParserExpr.setString((String)object);
            this.promoteExpression(aQjmsParserExpr, 1, false);
        }
    }

    public final AQjmsParserExpr SQLExpressionList(boolean bl) throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        aQjmsParserExpr2 = this.SQLSimpleExpression();
        if (bl) {
            aQjmsParserExpr2.setString(this.trimIDPrefix(aQjmsParserExpr2.getString()));
        }
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(34);
            object = (String)object + ", ";
            aQjmsParserExpr2 = this.SQLSimpleExpression();
            if (bl) {
                aQjmsParserExpr2.setString(this.trimIDPrefix(aQjmsParserExpr2.getString()));
            }
            object = (String)object + aQjmsParserExpr2.getString();
            aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        }
        AQjmsOracleDebug.println("SQLExpressionList: " + (String)object + " Type: " + aQjmsParserExpr.getType());
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLInClause(boolean bl) throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                object = (String)object + " NOT ";
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        object = (String)object + " IN ";
        this.jj_consume_token(33);
        object = (String)object + "(";
        aQjmsParserExpr = this.SQLExpressionList(bl);
        object = (String)object + aQjmsParserExpr.getString();
        this.jj_consume_token(35);
        object = (String)object + ")";
        aQjmsParserExpr.setString((String)object);
        if (this.doStrongTypeChecking && !aQjmsParserExpr.isString() && !aQjmsParserExpr.isVariable()) {
            throw new ParseException("[NOT] IN operator can only take string operands, not optype " + aQjmsParserExpr.getType());
        }
        this.promoteToString(aQjmsParserExpr);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLBetweenClause(boolean bl) throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                object = (String)object + " NOT ";
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        object = (String)object + " BETWEEN ";
        aQjmsParserExpr2 = this.SQLSimpleExpression();
        if (this.doStrongTypeChecking && !aQjmsParserExpr2.isVariable() && !aQjmsParserExpr2.isNumeric()) {
            throw new ParseException("Between clause requires numeric arguments");
        }
        if (bl) {
            aQjmsParserExpr2.setString(this.trimIDPrefix(aQjmsParserExpr2.getString()));
        }
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        object = (String)object + aQjmsParserExpr2.getString();
        this.jj_consume_token(6);
        object = (String)object + " AND ";
        aQjmsParserExpr2 = this.SQLSimpleExpression();
        if (this.doStrongTypeChecking && !aQjmsParserExpr2.isVariable() && !aQjmsParserExpr2.isNumeric()) {
            throw new ParseException("Between clause requires numeric arguments");
        }
        if (bl) {
            aQjmsParserExpr2.setString(this.trimIDPrefix(aQjmsParserExpr2.getString()));
        }
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setString((String)object);
        this.promoteToNumeric(aQjmsParserExpr);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLLikeClause(boolean bl) throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                object = (String)object + " NOT ";
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        object = (String)object + " LIKE ";
        aQjmsParserExpr2 = this.SQLSimpleExpression();
        if (bl) {
            aQjmsParserExpr2.setString(this.trimIDPrefix(aQjmsParserExpr2.getString()));
        }
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                object = (String)object + " ESCAPE ";
                aQjmsParserExpr2 = this.SQLSimpleExpression();
                object = (String)object + aQjmsParserExpr2.getString();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        aQjmsParserExpr.setString((String)object);
        if (this.doStrongTypeChecking && !aQjmsParserExpr.isString() && !aQjmsParserExpr.isVariable()) {
            throw new ParseException("[NOT] LIKE operator can only take string operands, not optype " + aQjmsParserExpr.getType());
        }
        this.promoteToString(aQjmsParserExpr);
        return aQjmsParserExpr;
    }

    private final String IsNullClause(AQjmsParserExpr aQjmsParserExpr) throws ParseException {
        Object object = new String("");
        this.jj_consume_token(9);
        object = (String)object + " IS ";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                object = (String)object + " NOT ";
                aQjmsParserExpr.setTypeIsNotNullClauseOperator();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                aQjmsParserExpr.setTypeIsNullClauseOperator();
            }
        }
        this.jj_consume_token(12);
        object = (String)object + " NULL ";
        return object;
    }

    public final AQjmsParserExpr SQLSimpleExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        aQjmsParserExpr2 = this.SQLMultiplicativeExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        while (this.jj_2_5(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    this.jj_consume_token(36);
                    object = (String)object + " + ";
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    object = (String)object + " - ";
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            aQjmsParserExpr2 = this.SQLMultiplicativeExpression();
            object = (String)object + aQjmsParserExpr2.getString();
            aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        }
        AQjmsOracleDebug.println("SQLSimpleExpression: " + (String)object + " Type: " + aQjmsParserExpr.getType());
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLMultiplicativeExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        aQjmsParserExpr2 = this.SQLExponentExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    this.jj_consume_token(38);
                    object = (String)object + "*";
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    object = (String)object + "/";
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            aQjmsParserExpr2 = this.SQLExponentExpression();
            object = (String)object + aQjmsParserExpr2.getString();
            aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        }
        AQjmsOracleDebug.println("SQLMultiplicativeExpression: " + (String)object + " Type: " + aQjmsParserExpr.getType());
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLExponentExpression() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        aQjmsParserExpr2 = this.SQLUnaryExpression();
        object = (String)object + aQjmsParserExpr2.getString();
        aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(40);
            object = (String)object + "**";
            aQjmsParserExpr2 = this.SQLUnaryExpression();
            object = (String)object + aQjmsParserExpr2.getString();
            aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
        }
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLUnaryExpression() throws ParseException {
        Object object = new String("");
        boolean bl = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 37: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        object = (String)object + "+";
                        bl = true;
                        break block0;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        object = (String)object + "-";
                        bl = true;
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        AQjmsParserExpr aQjmsParserExpr = this.SQLPrimaryExpression();
        if (bl && this.doStrongTypeChecking && !aQjmsParserExpr.isNumeric() && !aQjmsParserExpr.isVariable()) {
            throw new ParseException("Operators \"+\" and \"-\" can only be used with numeric operands");
        }
        object = (String)object + aQjmsParserExpr.getString();
        aQjmsParserExpr.setString((String)object);
        if (bl) {
            this.promoteToNumeric(aQjmsParserExpr);
        }
        return aQjmsParserExpr;
    }

    public final AQjmsParserExpr SQLPrimaryExpression() throws ParseException {
        Object object = new String("");
        String string = null;
        Token token = null;
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        AQjmsParserExpr aQjmsParserExpr2 = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            string = this.FunctionCall();
            object = (String)object + string;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 31: {
                    string = this.TableColumn();
                    object = (String)object + string;
                    aQjmsParserExpr.setTypeVariable();
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = this.NumericLiteral();
                    object = (String)object + string;
                    aQjmsParserExpr.setTypeNumeric();
                    break;
                }
                case 30: {
                    token = this.jj_consume_token(30);
                    object = (String)object + this.checkForEscapeChars(token.image);
                    aQjmsParserExpr.setTypeString();
                    break;
                }
                case 15: {
                    token = this.jj_consume_token(15);
                    object = (String)object + " 1 ";
                    aQjmsParserExpr.setTypeBooleanLiteral();
                    break;
                }
                case 16: {
                    token = this.jj_consume_token(16);
                    object = (String)object + " 0 ";
                    aQjmsParserExpr.setTypeBooleanLiteral();
                    break;
                }
                case 33: {
                    this.jj_consume_token(33);
                    object = (String)object + "(";
                    aQjmsParserExpr2 = this.SQLExpression();
                    object = (String)object + aQjmsParserExpr2.getString();
                    aQjmsParserExpr.setType(aQjmsParserExpr2.getType());
                    this.jj_consume_token(35);
                    object = (String)object + ")";
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        AQjmsOracleDebug.println("SQLPrimaryExpression: " + (String)object + " Type: " + aQjmsParserExpr.getType());
        aQjmsParserExpr.setString((String)object);
        return aQjmsParserExpr;
    }

    public final String FunctionCall() throws ParseException {
        AQjmsOracleDebug.println("Before evaluating function: ");
        this.is_func_call = true;
        Object object = new String("");
        String string = null;
        string = this.OracleObjectName();
        object = (String)object + string;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                object = (String)object + ".";
                string = this.OracleObjectName();
                object = (String)object + string;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        object = (String)object + ".";
                        string = this.OracleObjectName();
                        object = (String)object + string;
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        object = (String)object + "(";
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 33: 
                    case 36: 
                    case 37: {
                        string = this.SQLArguments();
                        object = (String)object + string;
                        break block6;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        object = (String)object + "*";
                        break block6;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        this.jj_consume_token(35);
        object = (String)object + ")";
        AQjmsOracleDebug.println("Function: " + (String)object);
        AQjmsOracleDebug.println("After evaluating function: ");
        this.is_func_call = false;
        return object;
    }

    public final String SQLArguments() throws ParseException {
        Object object = new String("");
        AQjmsParserExpr aQjmsParserExpr = null;
        aQjmsParserExpr = this.SQLExpressionList(false);
        object = (String)object + aQjmsParserExpr.getString();
        AQjmsOracleDebug.println("SQL Arguments: " + (String)object);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String TableColumn() throws ParseException {
        Object object = new String("");
        String string = null;
        String string2 = new String("");
        String string3 = null;
        string = this.OracleObjectName();
        object = (String)object + string;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                object = (String)object + ".";
                string = this.OracleObjectName();
                object = (String)object + string;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        object = (String)object + ".";
                        string = this.OracleObjectName();
                        object = (String)object + string;
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        AQjmsOracleDebug.println("TableColumn: " + (String)object);
        if (((String)object).length() >= 13) {
            string3 = ((String)object).substring(0, 13);
            AQjmsOracleDebug.println("TableColumn-substr: " + string3);
        }
        if (string3 != null && string3.equalsIgnoreCase("tab.user_data")) {
            if (this.dest_pload_type != 3) throw new ParseException("invalid object name: " + (String)object);
            return object;
        }
        if (((String)object).indexOf(".") != -1) throw new ParseException("invalid object name: " + (String)object);
        return this.mapJMSStringToColumn((String)object, 10);
    }

    public final String OracleObjectName() throws ParseException {
        Object object = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                Token token = this.jj_consume_token(27);
                object = (String)object + token.image;
                break;
            }
            case 31: {
                Token token = this.jj_consume_token(31);
                object = (String)object + token.image;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("OracleObjectName: " + (String)object);
        return object;
    }

    public final AQjmsParserExpr Relop() throws ParseException {
        AQjmsParserExpr aQjmsParserExpr = new AQjmsParserExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                aQjmsParserExpr.setString(" = ");
                aQjmsParserExpr.setTypeEqualOperator();
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                aQjmsParserExpr.setString(" <> ");
                aQjmsParserExpr.setTypeNotEqualOperator();
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                aQjmsParserExpr.setString(" != ");
                aQjmsParserExpr.setTypeNotEqualOperator();
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                aQjmsParserExpr.setString(" > ");
                aQjmsParserExpr.setTypeOperator();
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                aQjmsParserExpr.setString(" >= ");
                aQjmsParserExpr.setTypeOperator();
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                aQjmsParserExpr.setString(" < ");
                aQjmsParserExpr.setTypeOperator();
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                aQjmsParserExpr.setString(" <= ");
                aQjmsParserExpr.setTypeOperator();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return aQjmsParserExpr;
    }

    public final String NumericLiteral() throws ParseException {
        Object object = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                Token token = this.jj_consume_token(19);
                object = (String)object + token.image.substring(0, token.image.length() - 1);
                break;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                object = (String)object + Long.parseLong(token.image.substring(2, token.image.length()), 16);
                break;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                object = (String)object + Long.parseLong(token.image, 8);
                break;
            }
            case 20: {
                Token token = this.jj_consume_token(20);
                object = (String)object + token.image;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    private final boolean jj_3R_55() {
        Token token;
        if (this.jj_3R_58()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_59());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_14() {
        Token token;
        if (this.jj_3R_19()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_23());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(36);
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_49() {
        Token token;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_56());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_3R_20()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3_5() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = token;
            if (this.jj_3R_13()) {
                return true;
            }
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3R_8() {
        Token token;
        if (this.jj_3R_14()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_45();
    }

    private final boolean jj_3R_45() {
        Token token;
        if (this.jj_3R_8()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_48());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_29() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_35();
    }

    private final boolean jj_3R_22() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_20()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_11() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3_4() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_10();
    }

    private final boolean jj_3R_53() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_42() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_9();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_41() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_52() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_51() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_46();
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_50() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_34() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = token;
            if (this.jj_3R_39()) {
                this.jj_scanpos = token;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_41()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_42()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_43()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_44()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = token;
            if (this.jj_3R_51()) {
                this.jj_scanpos = token;
                if (this.jj_3R_52()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_53()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_64() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = token;
            if (this.jj_3_2()) {
                this.jj_scanpos = token;
                if (this.jj_3_3()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_4()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_66()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_3R_67()) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_74() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_73() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_10() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_72() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_71() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_70() {
        return this.jj_scan_token(43);
    }

    private final boolean jj_3R_69() {
        return this.jj_scan_token(42);
    }

    private final boolean jj_3R_67() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = token;
            if (this.jj_3R_70()) {
                this.jj_scanpos = token;
                if (this.jj_3R_71()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_72()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_73()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_74()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_75()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(36);
    }

    private final boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = token;
            if (this.jj_3R_37()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_8();
    }

    private final boolean jj_3R_24() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_34();
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_45()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_61() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = token;
            if (this.jj_3R_63()) {
                return true;
            }
        }
        token = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_25() {
        return this.jj_scan_token(27);
    }

    private final boolean jj_3R_20() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = token;
            if (this.jj_3R_26()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_9() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_45()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_19() {
        Token token;
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_30());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_58() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_61();
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        return this.jj_3R_19();
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_58();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-937457664, 8192, 64, 2048, -937459712, 0, 512, 3968, 0, 2048, 2048, 2048, 16384, 2048, 0, 0, 0, 0, 0, 0, -937459712, 0, 0, -937459712, -937459712, 0, 0, -2013265920, 0, 0x1E0000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{50, 0, 0, 0, 50, 130048, 0, 130048, 4, 0, 0, 0, 0, 0, 48, 192, 192, 256, 48, 48, 2, 512, 512, 114, 114, 512, 512, 0, 130048, 0};
    }

    public AQjmsParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new JavaCharStream(inputStream, 1, 1);
        this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public AQjmsParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public AQjmsParser(AQjmsParserTokenManager aQjmsParserTokenManager) {
        int n;
        this.token_source = aQjmsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(AQjmsParserTokenManager aQjmsParserTokenManager) {
        int n;
        this.token_source = aQjmsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 30; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[49];
        for (n2 = 0; n2 < 49; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 30; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 49; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        AQjmsParser.jj_la1_0();
        AQjmsParser.jj_la1_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

