/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import oracle.jdbc.driver.json.binary.OsonArrayImpl;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AQjmsSession;
import oracle.jms.JsonMessage;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class AQjmsJsonMessage
extends AQjmsMessage
implements JsonMessage {
    OracleJsonDatum json_payload;

    private AQjmsJsonMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, false);
        this.enqueue_time = 0L;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.priority = 1;
        this.msg_properties = null;
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.header_ext = null;
        this.json_payload = null;
    }

    AQjmsJsonMessage(AQjmsSession aQjmsSession, OracleJsonValue oracleJsonValue) throws JMSException {
        this(aQjmsSession);
        if (oracleJsonValue != null) {
            this.setJsonPayload(oracleJsonValue);
        }
    }

    AQjmsJsonMessage(AQjmsSession aQjmsSession, OracleJsonDatum oracleJsonDatum) throws JMSException {
        this(aQjmsSession);
        this.json_payload = oracleJsonDatum;
    }

    AQjmsJsonMessage(AQjmsSession aQjmsSession, String string) throws JMSException {
        this(aQjmsSession);
        if (string != null) {
            this.setJsonPayload(string);
        }
    }

    @Override
    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    @Override
    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this.message_id.getPartialJMSMessageID();
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        AQjmsError.throwEx(102);
    }

    @Override
    public String getJMSType() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public void setJMSType(String string) throws JMSException {
        AQjmsError.throwEx(102);
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.getEnqueueTime();
    }

    @Override
    public void setJMSTimestamp(long l) throws JMSException {
        this.setEnqueueTime(l);
    }

    @Override
    public boolean propertyExists(String string) throws JMSException {
        if (AQjmsMessage.isSystemProperty(string)) {
            return string.equals("JMSXRcvTimestamp") || string.equals("JMSXRecvTimestamp") || string.equals("JMSXState") || string.equals("JMSXDeliveryCount") || string.equals("JMS_OracleExcpQ") || string.equals("JMS_OracleDelay") || string.equals("JMS_OracleOriginalMessageID");
        }
        return false;
    }

    @Override
    public boolean getBooleanProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return false;
    }

    @Override
    public byte getByteProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return 0;
    }

    @Override
    public short getShortProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return 0;
    }

    @Override
    public int getIntProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Integer.parseInt((String)object);
                    }
                    return ((Datum)object).intValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    @Override
    public long getLongProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0L;
        }
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Long.parseLong((String)object);
                    }
                    return ((Datum)object).longValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0L;
        }
    }

    @Override
    public float getFloatProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return 0.0f;
    }

    @Override
    public double getDoubleProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return 0.0;
    }

    @Override
    public String getStringProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return null;
        }
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return (String)object;
                    }
                    return ((Datum)object).stringValue();
                }
                return null;
            }
            return null;
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return null;
        }
    }

    @Override
    public Object getObjectProperty(String string) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    @Override
    public synchronized Enumeration getPropertyNames() throws JMSException {
        Hashtable<String, AQjmsPropDatum> hashtable = null;
        Enumeration enumeration = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        aQjmsPropDatum = new AQjmsPropDatum(27, (String)null);
        hashtable = new Hashtable<String, AQjmsPropDatum>();
        hashtable.put("JMSXRcvTimestamp", aQjmsPropDatum);
        hashtable.put("JMSXState", aQjmsPropDatum);
        hashtable.put("JMSXDeliveryCount", aQjmsPropDatum);
        hashtable.put("JMS_OracleExcpQ", aQjmsPropDatum);
        hashtable.put("JMS_OracleDelay", aQjmsPropDatum);
        hashtable.put("JMS_OracleOriginalMessageID", aQjmsPropDatum);
        enumeration = hashtable.keys();
        return enumeration;
    }

    @Override
    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setByteProperty(String string, byte by) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setShortProperty(String string, short s) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setIntProperty(String string, int n) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.equals("JMS_OracleDelay")) {
                NUMBER nUMBER = new NUMBER(n);
                this.msg_delay = nUMBER.intValue();
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, sQLException);
        }
    }

    @Override
    public void setLongProperty(String string, long l) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.equals("JMS_OracleTimestamp")) {
                NUMBER nUMBER = new NUMBER(l);
                this.setEnqueueTime(nUMBER.longValue());
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    @Override
    public void setFloatProperty(String string, float f) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setDoubleProperty(String string, double d) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void setStringProperty(String string, String string2) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.equals("JMS_OracleExcpQ")) {
                if (string2 instanceof String) {
                    this.excp_queue = string2;
                } else {
                    AQjmsError.throwEx(153);
                }
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (Exception exception) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, exception);
        }
    }

    @Override
    public void setObjectProperty(String string, Object object) throws JMSException {
        AQjmsError.throwEx(102);
        throw new AQjmsException("User properties not supported on JSON messages", 0);
    }

    @Override
    public void clearBody() throws JMSException {
        this.json_payload = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    Object getSystemProperty(String string) throws SQLException {
        void var2_11;
        Object var2_2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsJsonMessage.getSystemProperty", "entry");
        if (!AQjmsMessage.isSystemProperty(string)) {
            AQjmsOracleDebug.trace(5, "AQjmsJsonMessage.getSystemProperty", "name does not start with JMS, returning null");
            return null;
        }
        if (string.equals("JMSXDeliveryCount")) {
            NUMBER nUMBER = new NUMBER(this.attempts);
        } else if (string.equals("JMSXRcvTimestamp") || string.equals("JMSXRecvTimestamp")) {
            NUMBER nUMBER = new NUMBER(this.recv_time);
        } else if (string.equals("JMSXState")) {
            NUMBER nUMBER = new NUMBER(this.msg_state);
        } else if (string.equals("JMS_OracleExcpQ")) {
            String string2 = this.excp_queue;
        } else if (string.equals("JMS_OracleDelay")) {
            NUMBER nUMBER = new NUMBER(this.msg_delay);
        } else if (string.equals("JMS_OracleOriginalMessageID")) {
            if (this.orig_msg_id == null) {
                Object var2_8 = null;
            } else {
                String string3 = "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
            }
        } else {
            if (!string.equals("JMS_OracleTimestamp")) {
                AQjmsOracleDebug.trace(5, "AQjmsJsonMessage.getSystemProperty", "returning null");
                return null;
            }
            NUMBER nUMBER = new NUMBER(this.getEnqueueTime());
        }
        AQjmsOracleDebug.trace(4, "AQjmsJsonMessage.getSystemProperty", "exit");
        return var2_11;
    }

    @Override
    public void setJsonPayload(OracleJsonDatum oracleJsonDatum) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.json_payload = oracleJsonDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJsonPayload(OracleJsonValue oracleJsonValue) throws JMSException {
        OracleJsonDatum oracleJsonDatum;
        Object object;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OracleJsonGenerator oracleJsonGenerator = null;){
            object = this.session.jsonFactory;
            synchronized (object) {
                oracleJsonGenerator = this.session.jsonFactory.createJsonBinaryGenerator((OutputStream)byteArrayOutputStream);
                if (oracleJsonValue instanceof OracleJsonString) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonString)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonObject) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonObject)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonArray) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonArray)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonTimestamp) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonTimestamp)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonDecimal) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonDecimal)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonDouble) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonDouble)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonFloat) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonFloat)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonTimestampTZ) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonTimestampTZ)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonDate) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonDate)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonBinary) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonBinary)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonIntervalDS) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonIntervalDS)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonIntervalYM) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonIntervalYM)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonValue) {
                    oracleJsonGenerator.write(oracleJsonValue);
                } else if (oracleJsonValue instanceof OracleJsonNumber) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonNumber)oracleJsonValue));
                } else if (oracleJsonValue instanceof OracleJsonStructure) {
                    oracleJsonGenerator.write((OracleJsonValue)((OracleJsonStructure)oracleJsonValue));
                } else {
                    AQjmsError.throwEx(102);
                }
            }
        }
        object = byteArrayOutputStream.toByteArray();
        this.json_payload = oracleJsonDatum = new OracleJsonDatum((byte[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJsonPayload(String string) throws JMSException {
        OracleJsonDatum oracleJsonDatum;
        Object object;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OracleJsonGenerator oracleJsonGenerator = null;){
            object = this.session.jsonFactory;
            synchronized (object) {
                oracleJsonGenerator = this.session.jsonFactory.createJsonBinaryGenerator((OutputStream)byteArrayOutputStream);
                oracleJsonGenerator.write(string);
            }
        }
        object = byteArrayOutputStream.toByteArray();
        this.json_payload = oracleJsonDatum = new OracleJsonDatum((byte[])object);
    }

    @Override
    public OracleJsonDatum getJsonPayload() throws JMSException {
        return this.json_payload;
    }

    @Override
    public String getJsonString() throws JMSException, SQLException {
        Object object = this.json_payload.toJdbc();
        if (object instanceof OracleJsonStringImpl) {
            return ((OracleJsonStringImpl)object).getString();
        }
        if (object instanceof OracleJsonBinaryImpl) {
            return ((OracleJsonBinaryImpl)object).getString();
        }
        if (object instanceof OracleJsonDateImpl) {
            return ((OracleJsonDateImpl)object).getString();
        }
        if (object instanceof OracleJsonDecimalImpl) {
            return ((OracleJsonDecimalImpl)object).getString();
        }
        if (object instanceof OracleJsonDoubleImpl) {
            return ((OracleJsonDoubleImpl)object).getString();
        }
        if (object instanceof OracleJsonFloatImpl) {
            return ((OracleJsonFloatImpl)object).getString();
        }
        if (object instanceof OracleJsonIntervalDSImpl) {
            return ((OracleJsonIntervalDSImpl)object).getString();
        }
        if (object instanceof OracleJsonIntervalYMImpl) {
            return ((OracleJsonIntervalYMImpl)object).getString();
        }
        if (object instanceof OracleJsonStringNumberImpl) {
            return ((OracleJsonStringNumberImpl)object).getString();
        }
        if (object instanceof OracleJsonTimestampImpl) {
            return ((OracleJsonTimestampImpl)object).getString();
        }
        if (object instanceof OracleJsonTimestampTZImpl) {
            return ((OracleJsonTimestampTZImpl)object).getString();
        }
        if (object instanceof OsonObjectImpl) {
            return ((OsonObjectImpl)object).toString();
        }
        if (object instanceof OsonArrayImpl) {
            return ((OsonArrayImpl)object).toString();
        }
        AQjmsError.throwEx(102);
        return null;
    }
}

