/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;

class ResourceMgr {
    private static OracleClob shareClob = null;
    private static OracleBlob shareBlob = null;
    private static Connection db_conn = null;

    ResourceMgr() {
    }

    static Connection getConnection() throws SQLException {
        if (db_conn == null) {
            db_conn = DriverManager.getConnection("jdbc:default:connection:");
        }
        return db_conn;
    }

    static OracleClob getSharedClob() throws SQLException {
        if (shareClob == null) {
            shareClob = (OracleClob)ResourceMgr.getConnection().createClob();
        } else {
            shareClob.truncate(0L);
        }
        return shareClob;
    }

    static OracleBlob getSharedBlob() throws SQLException {
        if (shareBlob == null) {
            shareBlob = (OracleBlob)ResourceMgr.getConnection().createBlob();
        } else {
            shareBlob.truncate(0L);
        }
        return shareBlob;
    }

    static void clean() throws SQLException {
        SQLException sQLException = null;
        if (shareClob != null) {
            try {
                shareClob.free();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            finally {
                shareClob = null;
            }
        }
        if (shareBlob != null) {
            try {
                shareBlob.free();
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
            finally {
                shareBlob = null;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }
}

