/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;
import oracle.jms.AQjmsXAConnection;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsXAConnectionFactory
extends AQjmsConnectionFactory
implements XAConnectionFactory {
    private XADataSource m_xaDS = null;
    private AQjmsXAResourceFactory m_xaresFactory = null;

    AQjmsXAConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        super(string, string2, n, string3);
    }

    AQjmsXAConnectionFactory(String string, Properties properties) throws JMSException {
        super(string, properties);
    }

    AQjmsXAConnectionFactory(DataSource dataSource, AQjmsXAResourceFactory aQjmsXAResourceFactory) throws JMSException {
        super(dataSource);
        this.m_xaresFactory = aQjmsXAResourceFactory;
    }

    AQjmsXAConnectionFactory(DataSource dataSource, String string, Properties properties) throws JMSException {
        super(dataSource, string, properties);
    }

    AQjmsXAConnectionFactory(String string, AQjmsXAResourceFactory aQjmsXAResourceFactory) throws JMSException {
        super(string);
        this.m_xaresFactory = aQjmsXAResourceFactory;
    }

    AQjmsXAConnectionFactory(XADataSource xADataSource) throws JMSException {
        this.m_xaDS = xADataSource;
    }

    AQjmsXAConnectionFactory(String string) throws JMSException {
        this.m_xaDS = (XADataSource)AQjmsUtil.lookupObject(string, XADataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory - constructor", "XA data source name: " + string);
    }

    public AQjmsXAConnectionFactory() {
    }

    public XAConnection createXAConnection() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmXAConnectionFactory.createXAConnection", "enter");
        AQjmsXAConnection aQjmsXAConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsXAConnection = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, 30);
        } else {
            aQjmsXAConnection = this.jdbc_conn_str != null ? new AQjmsXAConnection(this.jdbc_conn_str, this.jdbc_info, 30) : (this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, null, null, 30) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, 30) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 30)));
        }
        aQjmsXAConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmXAConnectionFactory.createXAConnection", "XAConnection created successfully");
        return aQjmsXAConnection;
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory.createXAConnection", "with user/pwd");
        AQjmsXAConnection aQjmsXAConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsXAConnection = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, string, string2, 30);
        } else {
            Properties properties = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (string != null || string2 != null) {
                        properties = (Properties)this.jdbc_info.clone();
                        properties.put("user", string);
                        properties.put("password", string2);
                    } else {
                        properties = this.jdbc_info;
                    }
                    aQjmsXAConnection = new AQjmsXAConnection(this.jdbc_conn_str, properties, 30);
                } else {
                    aQjmsXAConnection = new AQjmsXAConnection(this.jdbc_conn_str, string, string2, 30);
                }
            } else {
                aQjmsXAConnection = this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, string, string2, 30) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, string, string2, 30) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 30));
            }
        }
        aQjmsXAConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory.createXAConnection w/username/password", "XAConnection created successfully");
        return aQjmsXAConnection;
    }
}

