/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.concurrent.ConcurrentHashMap;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUcp;
import oracle.jms.AQjmsUcpDs;

class AQjmsUcpClnT
extends Thread {
    private final AQjmsUcpDs clnPool;
    volatile boolean abort = false;
    int waitBreak = 10;
    int totalWait = 10;

    AQjmsUcpClnT(AQjmsUcpDs aQjmsUcpDs) {
        this.clnPool = aQjmsUcpDs;
        this.totalWait = this.clnPool.getWaitTime();
        try {
            this.waitBreak = Integer.parseInt("10");
        }
        catch (Exception exception) {
            this.waitBreak = 10;
        }
    }

    void abortCleanup() {
        this.abort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = this.totalWait;
        int n2 = this.waitBreak;
        String string = this.clnPool.getPoolDataSource().getConnectionPoolName();
        try {
            while (n > 0) {
                try {
                    n2 = n > this.waitBreak ? this.waitBreak : n;
                    Thread.sleep(n2 * 1000);
                    n -= this.waitBreak;
                    if (!this.abort) continue;
                    AQjmsOracleDebug.trace(3, "AQjmsUcpClnT.run", "Pool with Key = " + string + " back in use. ");
                    return;
                }
                catch (Exception exception) {
                }
            }
            ConcurrentHashMap<String, AQjmsUcpDs> concurrentHashMap = AQjmsUcp.poolMap;
            synchronized (concurrentHashMap) {
                if (this.clnPool.getUseCount() > 0) {
                    return;
                }
                Object object = AQjmsUcp.lockMgr;
                synchronized (object) {
                    if (this.clnPool.getUseCount() > 0) {
                        return;
                    }
                    AQjmsOracleDebug.trace(3, "AQjmsUcpClnT.run", "Deleting Pool with Key = " + this.clnPool.getPoolDataSource().getConnectionPoolName());
                    AQjmsUcp.deletePool(string);
                }
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsUcpClnT.run Exception while Self Destroying Pool, UcpKey  " + string, exception);
        }
    }
}

