/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms.plsql;

import oracle.jakarta.jms.plsql.ExceptionHandler;
import oracle.jakarta.jms.plsql.MsgStore;
import oracle.jakarta.jms.plsql.ResourceMgr;
import oracle.jakarta.jms.plsql.StreamMsgEntity;
import oracle.jakarta.jms.plsql.TypeConversion;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleStruct;
import oracle.sql.NUMBER;

public class StreamMsgHandler {
    private static MsgStore msgStore = new MsgStore(2);

    public static int prepare(int id, int[] new_id, byte[] bytes_raw, OracleBlob bytes_lob) {
        try {
            byte[] data = null;
            if (bytes_raw != null) {
                data = bytes_raw;
            } else if (bytes_lob != null) {
                data = bytes_lob.getBytes(1L, (int)bytes_lob.length());
            }
            new_id[0] = id < 0 ? msgStore.createMsgEntity(data) : msgStore.createMsgEntity(id, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clear_body(int id, int[] new_id) {
        try {
            new_id[0] = id < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int get_mode(int id, int[] mode) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            mode[0] = entity.getMode();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int reset(int id) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            entity.reset();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int flush(int id, int[] bytes_len, byte[][] bytes_raw, OracleBlob[] bytes_blob) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            byte[] data = entity.flush();
            bytes_len[0] = data.length;
            if (data.length > 2000) {
                if (bytes_blob[0] == null) {
                    bytes_blob[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    bytes_blob[0].truncate(0L);
                }
                bytes_blob[0].setBytes(1L, data);
            } else {
                bytes_raw[0] = data;
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean(int id) {
        try {
            msgStore.cleanMsgEntity(id);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_object(int id, OracleStruct[] value, int[] nullInd) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.readObject();
            TypeConversion.objToJmsValue(objValue, value, nullInd);
            return 0;
        }
        catch (Throwable t) {
            try {
                nullInd[0] = 1;
                value[0] = TypeConversion.getNullSTRUCT();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_number(int id, NUMBER[] value, int type) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.readObject(type);
            value[0] = TypeConversion.objToNumber(objValue, type);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_bytes(int id, OracleBlob[] value) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.readObject(9);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            byte[] data = (byte[])objValue;
            if (value[0] == null) {
                value[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
            } else {
                value[0].truncate(0L);
            }
            value[0].setBytes(1L, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_char(int id, String[] value) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.readObject(7);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            value[0] = ((Character)objValue).toString();
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int read_string(int id, OracleClob[] value) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            Object objValue = entity.readObject(8);
            if (objValue == null) {
                value[0] = null;
                return 0;
            }
            String data = (String)objValue;
            if (value[0] == null) {
                value[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                value[0].truncate(0L);
            }
            value[0].setString(1L, data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_number(int id, NUMBER value, int type) {
        try {
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            entity.writeObject(TypeConversion.numberToObj(value, type));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_bytes(int id, byte[] value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            if (offset == 0 && length == value.length) {
                entity.writeObject(value);
            } else {
                byte[] new_value = new byte[length];
                System.arraycopy(value, offset, new_value, 0, length);
                entity.writeObject(new_value);
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_bytes(int id, OracleBlob value, int offset, int length) {
        try {
            if (value == null) {
                return 0;
            }
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            if ((long)(offset + length) > value.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = value.getBytes((long)(offset + 1), length);
            entity.writeObject(data);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_char(int id, String value) {
        try {
            if (value != null && value.length() > 0) {
                StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
                entity.writeObject(new Character(value.charAt(0)));
            }
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_string(int id, String value) {
        try {
            if (value == null) {
                return 0;
            }
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            entity.writeObject(value);
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }

    public static int write_string(int id, OracleClob value) {
        try {
            if (value == null) {
                return 0;
            }
            StreamMsgEntity entity = (StreamMsgEntity)msgStore.getMsgEntity(id);
            entity.writeObject(value.getSubString(1L, (int)value.length()));
            return 0;
        }
        catch (Throwable t) {
            return ExceptionHandler.getErrorCode(t);
        }
    }
}

