/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms.plsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import oracle.jakarta.jms.plsql.JmsPlsException;
import oracle.jdbc.OracleStruct;

public class ExceptionHandler {
    private static Throwable lastExp = null;
    private static Connection db_conn = null;
    private static Object[] nullAttribs = new Object[]{null, null, null, null};
    private static int errNum = 0;

    public static int get_exception(OracleStruct[] exp, int[] nullInd) {
        try {
            if (lastExp == null) {
                nullInd[0] = 1;
                exp[0] = (OracleStruct)db_conn.createStruct("SYS.AQ$_JMS_EXCEPTION", nullAttribs);
            } else {
                nullInd[0] = 0;
                Integer id = new Integer(0);
                String clsName = lastExp.getClass().getName();
                String errorMsg = lastExp.getMessage();
                StringWriter sw = new StringWriter();
                lastExp.printStackTrace(new PrintWriter(sw));
                String stack = sw.toString();
                Object[] attribs = new Object[]{id, clsName, errorMsg, stack};
                exp[0] = (OracleStruct)db_conn.createStruct("SYS.AQ$_JMS_EXCEPTION", attribs);
            }
            return 0;
        }
        catch (Throwable t) {
            try {
                nullInd[0] = 1;
                exp[0] = (OracleStruct)db_conn.createStruct("SYS.AQ$_JMS_EXCEPTION", nullAttribs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -24197;
        }
    }

    public static int getErrorCode(Throwable t) {
        if (t instanceof JmsPlsException) {
            errNum = ((JmsPlsException)t).getErrorCode();
            return errNum;
        }
        lastExp = t;
        errNum = -24197;
        return errNum;
    }

    public static String getErrorText() {
        Object errText = "";
        if (lastExp != null) {
            errText = "Error code " + errNum + ", " + lastExp.toString() + ", Caused by " + lastExp.getCause().toString();
        }
        return errText;
    }
}

