/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import oracle.jakarta.jms.AQjmsAdtMessage;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsBytesMessage;
import oracle.jakarta.jms.AQjmsBytesMessage_C;
import oracle.jakarta.jms.AQjmsBytesMessages_C;
import oracle.jakarta.jms.AQjmsClientSubscriberMap;
import oracle.jakarta.jms.AQjmsConnection;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGenMessage_C;
import oracle.jakarta.jms.AQjmsGenMessages_C;
import oracle.jakarta.jms.AQjmsJsonMessage;
import oracle.jakarta.jms.AQjmsListenerWorker;
import oracle.jakarta.jms.AQjmsMapMessage;
import oracle.jakarta.jms.AQjmsMapMessage_C;
import oracle.jakarta.jms.AQjmsMapMessages_C;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsMessageHeaderExt;
import oracle.jakarta.jms.AQjmsMessageProperties;
import oracle.jakarta.jms.AQjmsMessageProperty;
import oracle.jakarta.jms.AQjmsNtfRegistration;
import oracle.jakarta.jms.AQjmsObject;
import oracle.jakarta.jms.AQjmsObjectMessage;
import oracle.jakarta.jms.AQjmsObjectMessage_C;
import oracle.jakarta.jms.AQjmsObjectMessages_C;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsPropertyList;
import oracle.jakarta.jms.AQjmsQueueReceiver;
import oracle.jakarta.jms.AQjmsSelector;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsSignature;
import oracle.jakarta.jms.AQjmsStreamMessage;
import oracle.jakarta.jms.AQjmsStreamMessage_C;
import oracle.jakarta.jms.AQjmsStreamMessages_C;
import oracle.jakarta.jms.AQjmsTextMessage;
import oracle.jakarta.jms.AQjmsTextMessage_C;
import oracle.jakarta.jms.AQjmsTextMessages_C;
import oracle.jakarta.jms.AQjmsTopicReceiver;
import oracle.jakarta.jms.AQjmsTopicSubscriber;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jakarta.jms.DispatchScheduler;
import oracle.jakarta.jms.ThreadProxy;
import oracle.jakarta.jms.WebLogicHelper;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.ANYDATA;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.TIMESTAMP;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonFactory;
import oracle.xdb.XMLType;

public class AQjmsConsumer
extends AQjmsObject
implements AQjmsQueueReceiver,
AQjmsTopicSubscriber,
AQjmsTopicReceiver {
    AQjmsSession jms_sess;
    AQjmsSelector selector;
    AQjmsDestination cons_dest;
    int dest_type;
    int deq_mode;
    int navig_mode;
    int visibility;
    String cons_name;
    volatile boolean first_receive;
    boolean nolocal;
    boolean xml_receive;
    CustomDatumFactory cd_factory;
    OracleDataFactory od_factory;
    ORADataFactory orad_factory;
    OracleJsonFactory ora_json_factory;
    private OracleCallableStatement deq_stmt;
    private String transfxm;
    private String client_id;
    private boolean hasInfo = true;
    private boolean durable = true;
    AQjmsListenerWorker m_lsnrWorker = null;
    private int partition = -1;
    private AQjmsNtfRegistration ntfReg = null;

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, Object payload_fact) throws JMSException {
        this(session, destination, dest_type, deq_mode, consumer_name, payload_fact, null, null, false);
    }

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, Object payload_fact, AQjmsSelector selector, String transformation) throws JMSException {
        this(session, destination, dest_type, deq_mode, consumer_name, payload_fact, selector, transformation, false);
    }

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, Object payload_fact, AQjmsSelector selector, String transformation, boolean noLocal) throws JMSException {
        super("MessageConsumer", session);
        String ptype = null;
        Map typemap = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "entry");
        if (destination == null) {
            AQjmsError.throwEx(200);
        }
        this.jms_sess = session;
        this.cons_dest = (AQjmsDestination)destination;
        this.dest_type = dest_type;
        this.deq_stmt = null;
        int payload_obj_type = this.cons_dest.getPloadType();
        if (destination instanceof AQjmsDestination && ((AQjmsDestination)destination).isTemp() && this.jms_sess.getJmsConnection() != AQjmsConnection.getJmsConnection((AQjmsDestination)destination)) {
            AQjmsError.throwEx(231);
        }
        if (deq_mode == 1 || deq_mode == 2 || deq_mode == 3 || deq_mode == 4 || deq_mode == 5) {
            this.deq_mode = deq_mode;
        } else {
            AQjmsError.throwEx(124);
        }
        this.navig_mode = AQjmsConstants.getNavigationMode();
        this.visibility = 2;
        if (dest_type == 20 && consumer_name == null) {
            AQjmsError.throwEx(116);
        }
        this.cons_name = consumer_name;
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "dest_type: " + dest_type);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "cons_dest: " + this.cons_dest.getCompleteName());
        if (this.cons_name != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "consumer_name: " + this.cons_name);
        }
        ptype = this.cons_dest.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "p_type: " + ptype);
        if (this.cons_dest.isJson()) {
            if (payload_fact == null) {
                this.ora_json_factory = session.getJsonFactory();
            } else if (payload_fact instanceof OracleJsonFactory) {
                this.ora_json_factory = (OracleJsonFactory)payload_fact;
            } else {
                AQjmsError.throwEx(222);
            }
        } else if (!this.cons_dest.isSharded() || this.cons_dest.isSharded() && payload_obj_type == 1) {
            if (!this.cons_dest.isSharded() && (ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE"))) {
                if (payload_fact != null) {
                    AQjmsError.throwEx(136);
                }
                this.cd_factory = null;
                this.od_factory = null;
                this.orad_factory = null;
                this.ora_json_factory = null;
            } else if (ptype.equalsIgnoreCase("SYS.ANYDATA")) {
                if (payload_fact != null) {
                    AQjmsError.throwEx(223);
                }
                typemap = this.jms_sess.getTypeMap();
                try {
                    typemap.put("SYS.AQ$_JMS_TEXT_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsTextMessage_C"));
                    typemap.put("SYS.AQ$_JMS_BYTES_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsBytesMessage_C"));
                    typemap.put("SYS.AQ$_JMS_STREAM_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsStreamMessage_C"));
                    typemap.put("SYS.AQ$_JMS_MAP_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsMapMessage_C"));
                    typemap.put("SYS.AQ$_JMS_OBJECT_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsObjectMessage_C"));
                }
                catch (Exception ex) {
                    AQjmsOracleDebug.traceEx(5, "AQjmsConsumer-constructor-typemap-ex", ex);
                }
            } else {
                if (payload_fact == null) {
                    AQjmsError.throwEx(137);
                }
                this.cd_factory = null;
                this.od_factory = null;
                this.orad_factory = null;
                if (payload_fact instanceof CustomDatumFactory) {
                    this.cd_factory = (CustomDatumFactory)payload_fact;
                } else if (payload_fact instanceof OracleDataFactory) {
                    this.od_factory = (OracleDataFactory)payload_fact;
                } else if (payload_fact instanceof ORADataFactory) {
                    this.orad_factory = (ORADataFactory)payload_fact;
                } else {
                    AQjmsError.throwEx(222);
                }
            }
        }
        this.selector = selector;
        if (selector != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "selector: " + selector.getSelectorString());
        }
        this.nolocal = noLocal;
        this.first_receive = true;
        this.transfxm = transformation;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "exit");
        this.client_id = this.jms_sess.jms_conn.getClientIDForce();
        session.attach(this);
        if (this.cons_dest.isTemp()) {
            this.cons_dest.addConsForTempDest();
        }
    }

    AQjmsConsumer(AQjmsSession session, Destination destination, int dest_type, int deq_mode, String consumer_name, Object payload_fact, AQjmsSelector selector, String transformation, boolean noLocal, boolean hasInfo) throws JMSException {
        this(session, destination, dest_type, deq_mode, consumer_name, payload_fact, selector, transformation, noLocal);
        this.hasInfo = hasInfo;
    }

    private AQjmsMessage ocideqSQ(String qname, String consname, int nav_mode, int deq_mode, String corr_id, String deq_cond, byte[] deq_msg_id, int visib, int deliveryMode, long wait_time, boolean xml_recv, long[] ocihandles, long context, String transformation, AQjmsSession session) throws Exception {
        Object[] result = new Object[8];
        this.ocideq2(qname, consname, nav_mode, deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, xml_recv, ocihandles, context, transformation, session, result);
        Integer type = (Integer)result[0];
        byte[] payload = (byte[])result[1];
        String headerProperties = (String)result[2];
        String userProperties = (String)result[3];
        byte[] msgid = (byte[])result[4];
        Integer priority = (Integer)result[5];
        String corrId = (String)result[6];
        Integer expiration = (Integer)result[7];
        return AQjmsConsumer.convertToAQjmsMessages(session, type, payload, headerProperties, userProperties, msgid, priority, corrId, expiration);
    }

    static AQjmsMessage convertToAQjmsMessages(AQjmsSession session, int type, byte[] payload, String headerProperties, String userProperties, byte[] msgid, int priority, String corrId, int expiration) throws JMSException {
        return AQjmsConsumer.convertToAQjmsMessages(session, type, payload, headerProperties, userProperties, msgid, priority, corrId, expiration, false);
    }

    static AQjmsMessage convertToAQjmsMessages(AQjmsSession session, int type, byte[] payload, String headerProperties, String userProperties, byte[] msgid, int priority, String corrId, int expiration, boolean isStreamingDequeue) throws JMSException {
        AQjmsMessage message = null;
        switch (type) {
            case 0: {
                try {
                    String strPayload = payload == null ? null : new String(payload, "UTF8");
                    message = new AQjmsTextMessage(session, strPayload);
                }
                catch (UnsupportedEncodingException unseExp) {
                    AQjmsError.throwEx("Failed to convert payload to String", (Throwable)unseExp);
                }
                break;
            }
            case 1: {
                message = new AQjmsBytesMessage(session, payload);
                break;
            }
            case 2: {
                if (isStreamingDequeue) {
                    message = new AQjmsStreamMessage(session, payload, true);
                    break;
                }
                message = new AQjmsStreamMessage(session, payload);
                break;
            }
            case 3: {
                message = new AQjmsMapMessage(session, payload);
                break;
            }
            case 4: {
                message = new AQjmsObjectMessage(session, payload, false);
                break;
            }
            case 100: {
                message = new AQjmsMessage(session, true);
                break;
            }
            default: {
                throw new JMSException("Unknow message type: " + type);
            }
        }
        message.setAccessMode(2);
        message.setJmsHeaders(headerProperties);
        message.setUserProperties(userProperties);
        message.setJMSMessageID(msgid);
        message.setJMSPriority(priority);
        message.setJMSCorrelationID(corrId);
        message.setAccessMode(0);
        message.setJMSExpiration(expiration);
        return message;
    }

    private native AQjmsMessage ocideq2(String var1, String var2, int var3, int var4, String var5, String var6, byte[] var7, int var8, int var9, long var10, boolean var12, long[] var13, long var14, String var16, AQjmsSession var17, Object[] var18) throws Exception;

    private native AQjmsMessage ocideq(String var1, String var2, int var3, boolean var4, int var5, int var6, String var7, String var8, byte[] var9, int var10, int var11, long var12, boolean var14, long[] var15, long var16, String var18, AQjmsSession var19) throws Exception;

    public synchronized String getMessageSelector() throws JMSException {
        this.checkClosed("getMessageSelector");
        if (!this.hasInfo) {
            AQjmsError.throwEx(233);
        }
        if (this.selector != null) {
            return this.selector.getSelectorString();
        }
        return null;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        this.checkClosed("getMessageListener");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (AQjmsConstants.useJmsNotification() && this.cons_dest.isSharded() && AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin")) {
            if (this.ntfReg != null) {
                return this.ntfReg.getMessageListener();
            }
        } else if (this.m_lsnrWorker != null) {
            return this.m_lsnrWorker.getMessageListener();
        }
        return null;
    }

    synchronized AQjmsSelector getAQjmsSelector() throws JMSException {
        this.checkClosed("getAQjmsSelector");
        return this.selector;
    }

    Message receiveForListener() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveForListener", "entry");
        Message msg = null;
        if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.returnXMLType(this.cons_dest)) {
            int payload_obj_type = this.cons_dest.getPloadType();
            long deqWait = AQjmsConstants.getListenerDequeueWait();
            msg = this.cons_dest.isSharded() && payload_obj_type != 1 && payload_obj_type != 4 ? this.jdbcDequeueSh(this.cons_dest, deqWait, this.cons_name, 1, 3, true, this.visibility, 1) : this.jdbcDequeue(this.cons_dest, deqWait, this.cons_name, 1, 3, true, this.visibility, 1);
        } else {
            msg = this.dequeue(this.cons_dest, 0L, this.cons_name, 1, 3, null, true, this.visibility, 1);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveForListener", "exit");
        return msg;
    }

    private void doCommit(AQjmsSession jms_sess) throws JMSException {
        try {
            int ackMode = jms_sess.getAcknowledgeMode();
            if (ackMode == 1 || ackMode == 3) {
                jms_sess.commitNoCheck();
                AQjmsOracleDebug.trace(3, "AQjmsConsumer.doCommit", "acknowledged one message received by committing the database connection");
            }
        }
        catch (Exception e) {
            AQjmsError.throwEx(120, (Throwable)e);
        }
    }

    public synchronized void setMessageListener(MessageListener myListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setMessageListener(MessageListener)");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (AQjmsConstants.useJmsNotification() && this.cons_dest.isSharded() && AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin")) {
            this.setMessageListenerForNotification(myListener);
        } else if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(myListener);
            if (myListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, myListener);
            this.m_lsnrWorker.launch();
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    synchronized void setPrivilegedMessageListener(MessageListener myListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setPrivilegedMessageListener(MessageListener)");
        if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(myListener);
            if (myListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, myListener);
            this.m_lsnrWorker.launch();
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public synchronized void setMessageListener(MessageListener myListener, DispatchScheduler scheduler, ThreadProxy proxy) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setMessageListener(MessageListener, DispatchScheduler");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(myListener, scheduler);
            if (myListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, myListener, scheduler);
            this.m_lsnrWorker.launch(proxy);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public synchronized Thread getListenerWorkerThread() {
        if (this.m_lsnrWorker != null) {
            return this.m_lsnrWorker.getListenerWorkerThread();
        }
        return null;
    }

    public Message receive() throws JMSException {
        return this.receiveFromAQ(-1L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receiveFromAQ(0L);
    }

    public Message receive(long timeout) throws JMSException {
        if (timeout == 0L) {
            timeout = -1L;
        }
        return this.receiveFromAQ(timeout);
    }

    @Override
    public Message receive(AQjmsSignature signature) throws JMSException {
        return this.receiveFromAQ(-1L, signature);
    }

    @Override
    public Message receive(long timeout, AQjmsSignature signature) throws JMSException {
        if (timeout == 0L) {
            timeout = -1L;
        }
        return this.receiveFromAQ(timeout, signature);
    }

    public Message bufferReceive() throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        return this.receiveFromAQ(-1L, null, 1, 3);
    }

    public Message bufferReceiveNoWait() throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceiveNoWait");
        }
        return this.receiveFromAQ(0L, null, 1, 3);
    }

    public Message bufferReceive(long timeout) throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        return this.bufferReceive(timeout, null);
    }

    public Message bufferReceive(long timeout, AQjmsSignature signature) throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        if (timeout == 0L) {
            timeout = -1L;
        }
        return this.receiveFromAQ(timeout, signature, 1, 3);
    }

    Message receiveFromAQ(long timeout) throws JMSException {
        return this.receiveFromAQ(timeout, null);
    }

    Message receiveFromAQ(long timeout, AQjmsSignature signature) throws JMSException {
        return this.receiveFromAQ(timeout, signature, this.visibility, 1);
    }

    Message receiveFromAQ(long timeout, AQjmsSignature signature, int visibilityMode, int deliveryMode) throws JMSException {
        Message ret_message = null;
        AQjmsConnection jms_conn = null;
        String errorCode = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "entry");
        if (!this.lockReceive("receiveFromAQ(sig)", timeout)) {
            return null;
        }
        try {
            int navigation_mode;
            this.CheckConnClosed("receiveFromAQ");
            this.jms_sess.checkConnectionClosed();
            jms_conn = this.jms_sess.getJmsConnection();
            if (this.jms_sess.getMessageListener() != null) {
                AQjmsError.throwEx(198);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.receive-2", "timeout(millisecs): " + timeout);
            this.jms_sess.checkForGlobalTxn();
            if (this.first_receive) {
                navigation_mode = 1;
                this.first_receive = false;
            } else {
                navigation_mode = this.navig_mode;
            }
            if (this.cons_dest.isTopic() && this.jms_sess.diffSubName(this.cons_name) || WebLogicHelper.runningInWLServer() && this.jms_sess.isInGlobalTransaction() && this.jms_sess.wlsXaTopicNextDisabled) {
                navigation_mode = 1;
            }
            if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.returnXMLType(this.cons_dest)) {
                AQjmsOracleDebug.trace(2, "AQjmsConsumer.receiveFromAQ", "taking jdbc AQ dequeue code path");
                int payload_obj_type = this.cons_dest.getPloadType();
                ret_message = this.cons_dest.isSharded() && payload_obj_type != 1 && payload_obj_type != 4 ? this.jdbcDequeueCommonSh(this.cons_dest, timeout, this.cons_name, navigation_mode, this.deq_mode, false, visibilityMode, deliveryMode) : this.jdbcDequeueCommon(this.cons_dest, timeout, this.cons_name, navigation_mode, this.deq_mode, false, visibilityMode, deliveryMode);
            } else {
                AQjmsOracleDebug.trace(2, "AQjmsConsumer.receiveFromAQ", "taking PL/SQL dequeue code path");
                ret_message = this.dequeue(this.cons_dest, timeout, this.cons_name, navigation_mode, this.deq_mode, signature, false, visibilityMode, deliveryMode);
            }
        }
        catch (JMSException ex) {
            int errCodeInt = 0;
            try {
                errCodeInt = Integer.parseInt(ex.getErrorCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Integer.toString(257).equals(ex.getErrorCode())) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.receiveFromAQ", "jdbcReadTimeout: " + AQjmsConstants.getJdbcReadTimeOut() + ", jmsNetworkTimeout: " + AQjmsConstants.getNetworkTimeOut() + ", networkTimeoutFactor: " + AQjmsConstants.getNetworkTimeOutFactor() + ", receiveTimeout: " + timeout);
                errorCode = Integer.toString(257);
            }
            Object excpMsg = ex.getMessage();
            if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                excpMsg = (String)excpMsg + ". JDBC Connection Info:" + this.jms_sess.jdbcConnInfo.toString();
            }
            AQjmsException newEx = new AQjmsException((String)excpMsg, errCodeInt, ex);
            throw newEx;
        }
        finally {
            this.unlock("receiveFromAQ(sig)");
            if (Integer.toString(257).equals(errorCode)) {
                try {
                    jms_conn.close();
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return ret_message;
    }

    private boolean returnXMLType(AQjmsDestination dest) throws JMSException {
        String returnType = this.transfxm == null ? dest.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), dest, this.transfxm).getDestType();
        return "SYS.XMLTYPE".equalsIgnoreCase(returnType);
    }

    Message jdbcDequeue(AQjmsDestination dest, long timeout, String consumerName, int navigationMode, int dequeueMode, boolean inListener, int visibility, int deliveryMode) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "entry");
        this.checkClosed("jdbcDequeue");
        Message returnMessage = this.jdbcDequeueCommon(dest, timeout, consumerName, navigationMode, dequeueMode, inListener, visibility, deliveryMode);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "exit");
        return returnMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message jdbcDequeueCommon(AQjmsDestination dest, long timeout, String consumerName, int navigationMode, int dequeueMode, boolean inListener, int visibility, int deliveryMode) throws JMSException {
        oracle.jdbc.OracleConnection dbConn = null;
        try {
            dbConn = (oracle.jdbc.OracleConnection)this.jms_sess.getDBConnection();
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", ex);
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "After getDbConnection");
        AQjmsMessage returnMessage = null;
        int existingNetworkTimeOut = 0;
        try {
            AQMessage aqMessage;
            String returnDataType;
            block104: {
                int idx;
                String destName;
                AQDequeueOptions deqopt = new AQDequeueOptions();
                deqopt.setRetrieveMessageId(true);
                if (dest == null) {
                    AQjmsError.throwEx(200);
                }
                if ((destName = dest.getCompleteName()) == null) {
                    AQjmsError.throwEx(200);
                }
                returnDataType = null;
                returnDataType = dest.isJson() ? "JSON" : (this.transfxm == null ? dest.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), dest, this.transfxm).getDestType());
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "destination name: " + destName + "  destination data type: " + returnDataType);
                deqopt.setConsumerName(consumerName);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "consumer name: " + consumerName);
                if (this.selector != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector: " + String.valueOf(this.selector));
                    if (this.selector.getSelectorType() == 30) {
                        deqopt.setDequeueMessageId(this.selector.getSelectorMessageId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        deqopt.setCorrelation(this.selector.getSelectorCorrelationId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector correlation: " + this.selector.getSelectorCorrelationId());
                    } else if (this.selector.getSelectorType() == 50) {
                        deqopt.setCondition(this.selector.getRule());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector dequeue condition: " + this.selector.getRule());
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "dequeue mode: " + dequeueMode + " navigation: " + navigationMode);
                deqopt.setDequeueMode(AQjmsConstants.toDequeueModeEnum(dequeueMode));
                deqopt.setNavigation(AQjmsConstants.toNavigationEnum(navigationMode));
                if (visibility != 1) {
                    deliveryMode = 1;
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "visibility : " + visibility + " delivery mode: " + deliveryMode);
                deqopt.setVisibility(AQjmsConstants.toDequeueVisibilityEnum(visibility));
                deqopt.setDeliveryFilter(AQjmsConstants.toDeliveryFilterEnum(deliveryMode));
                deqopt.setTransformation(this.transfxm);
                long[] results = this.calculateValuesForTimeout(timeout);
                long timeoutInSecond = results[0];
                long interval = results[1];
                long iterations = results[2];
                long lastInterval = results[3];
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Timeout: " + timeoutInSecond + " seconds.  Iterations: " + iterations + " Interval: " + interval + " Last interval: " + lastInterval);
                deqopt.setWait((int)interval);
                aqMessage = null;
                if (timeoutInSecond != -1L) {
                    if (this.jms_sess.isNetworkTimeoutRequired() && timeout != 0L) {
                        try {
                            existingNetworkTimeOut = dbConn.getNetworkTimeout();
                            if (AQjmsConstants.getNetworkTimeOut() != -1 && (long)AQjmsConstants.getNetworkTimeOut() > timeout) {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + AQjmsConstants.getNetworkTimeOut());
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), AQjmsConstants.getNetworkTimeOut());
                            } else {
                                AQjmsOracleDebug.trace(5, "TESTING AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(timeout * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), new Long(timeout * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                            }
                        }
                        catch (Exception sqlExp) {
                            // empty catch block
                        }
                    }
                    idx = 0;
                } else {
                    while (true) {
                        try {
                            do {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "wait time: " + interval);
                            } while ((aqMessage = this.jdbcConnectionDequeueCheck25242(dbConn, destName, deqopt, returnDataType)) == null);
                            break block104;
                        }
                        catch (SQLException sqlExp) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", sqlExp);
                            if (sqlExp.getErrorCode() == 25228) continue;
                            if (sqlExp.getErrorCode() != 25263) throw sqlExp;
                            if (!this.isClosed()) continue;
                            Message message = null;
                            if (existingNetworkTimeOut == 0) return message;
                            if (dbConn == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                        break;
                    }
                }
                while ((long)idx < iterations) {
                    block105: {
                        try {
                            if ((long)idx == iterations - 1L) {
                                deqopt.setWait((int)lastInterval);
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "wait time: " + lastInterval);
                            aqMessage = this.jdbcConnectionDequeueCheck25242(dbConn, destName, deqopt, returnDataType);
                            if (aqMessage != null) {
                                break;
                            }
                        }
                        catch (SQLException sqlExp) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", sqlExp);
                            if (sqlExp.getErrorCode() != 25228) {
                                if (sqlExp.getErrorCode() != 25263) throw sqlExp;
                            }
                            if (!this.isClosed()) break block105;
                            Message message = null;
                            if (existingNetworkTimeOut == 0) return message;
                            if (dbConn == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                    }
                    ++idx;
                }
            }
            if (aqMessage == null || dequeueMode == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "remove no data");
                Message idx = null;
                return idx;
            }
            ANYDATA anydata = null;
            OracleStruct payloadStruct = null;
            OracleJsonDatum jsonPayloadDatum = null;
            int payloadTypeCode = 0;
            if (aqMessage.isANYDATAPayload()) {
                anydata = aqMessage.getANYDATAPayload();
            } else if (aqMessage.isSTRUCTPayload()) {
                payloadStruct = (OracleStruct)aqMessage.getStructPayload();
                payloadTypeCode = payloadStruct.getOracleMetaData().getTypeCode();
            } else if (aqMessage.isJSONPayload()) {
                jsonPayloadDatum = aqMessage.getJSONPayload();
            } else {
                AQjmsError.throwEx(122, "invalid message payload type");
            }
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "payload type:" + returnDataType + "payload type code:" + payloadTypeCode);
            if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                AQjmsGenMessage_C gen_msg_c = (AQjmsGenMessage_C)AQjmsGenMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                int msgType = gen_msg_c.getMessageType();
                switch (msgType) {
                    case 0: {
                        returnMessage = new AQjmsTextMessage(this.jms_sess, gen_msg_c);
                        break;
                    }
                    case 1: {
                        returnMessage = new AQjmsBytesMessage(this.jms_sess, gen_msg_c);
                        break;
                    }
                    case 2: {
                        returnMessage = new AQjmsStreamMessage(this.jms_sess, gen_msg_c);
                        break;
                    }
                    case 3: {
                        returnMessage = new AQjmsMapMessage(this.jms_sess, gen_msg_c);
                        break;
                    }
                    case 4: {
                        returnMessage = new AQjmsObjectMessage(this.jms_sess, gen_msg_c);
                        break;
                    }
                    default: {
                        AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + msgType + " is not valid JMS message type");
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "general payload messaeg retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                AQjmsTextMessage_C text_msg_c = (AQjmsTextMessage_C)AQjmsTextMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                returnMessage = new AQjmsTextMessage(this.jms_sess, text_msg_c);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "text_message retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                AQjmsBytesMessage_C bytes_msg_c = (AQjmsBytesMessage_C)AQjmsBytesMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                returnMessage = new AQjmsBytesMessage(this.jms_sess, bytes_msg_c);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "bytes_message retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                AQjmsMapMessage_C map_msg_c = (AQjmsMapMessage_C)AQjmsMapMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                returnMessage = new AQjmsMapMessage(this.jms_sess, map_msg_c);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "map_message retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                AQjmsObjectMessage_C obj_msg_c = (AQjmsObjectMessage_C)AQjmsObjectMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                returnMessage = new AQjmsObjectMessage(this.jms_sess, obj_msg_c, this.xml_receive);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "object_message retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsStreamMessage_C stream_msg_c = (AQjmsStreamMessage_C)AQjmsStreamMessage_C.getFactory().create((Object)payloadStruct, payloadTypeCode);
                returnMessage = new AQjmsStreamMessage(this.jms_sess, stream_msg_c);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "stream_message retrieved");
            } else if (returnDataType.equalsIgnoreCase("SYS.ANYDATA")) {
                returnMessage = this.convertAnydataToMessage(anydata);
            } else {
                OracleData oraData;
                if (this.od_factory != null) {
                    oraData = this.od_factory.create((Object)payloadStruct, payloadTypeCode);
                    returnMessage = new AQjmsAdtMessage(this.jms_sess, oraData);
                } else if (this.cd_factory != null) {
                    CustomDatum custDataum = this.cd_factory.create((Datum)payloadStruct, payloadTypeCode);
                    returnMessage = new AQjmsAdtMessage(this.jms_sess, custDataum);
                } else if (this.orad_factory != null) {
                    oraData = this.orad_factory.create((Datum)payloadStruct, payloadTypeCode);
                    returnMessage = new AQjmsAdtMessage(this.jms_sess, (ORAData)oraData);
                } else if (jsonPayloadDatum != null) {
                    returnMessage = new AQjmsJsonMessage(this.jms_sess, jsonPayloadDatum);
                } else {
                    AQjmsError.throwEx(129);
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "adt message retrieved");
            }
            AQMessageProperties msgProps = aqMessage.getMessageProperties();
            long enqTime = msgProps.getEnqueueTime().getTime();
            returnMessage.setEnqueueTime(enqTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "set AQ enqueue time as " + enqTime);
            returnMessage.setMessageState(msgProps.getState().getCode());
            byte[] msgId = aqMessage.getMessageId();
            returnMessage.setJMSMessageID(msgId);
            String corrId = msgProps.getCorrelation();
            returnMessage.setJMSCorrelationID(corrId);
            int priority = msgProps.getPriority();
            returnMessage.setJMSPriority(priority);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "msg_id: " + RepConversion.bArray2String((byte[])msgId) + " corrid: " + corrId + " priority: " + priority);
            int msgDelay = msgProps.getDelay();
            returnMessage.setDelay(msgDelay);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "msg_delay(secs): " + msgDelay);
            int expTime = msgProps.getExpiration();
            returnMessage.setJMSExpiration(expTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "exptime(secs): " + expTime);
            int attempts = msgProps.getDequeueAttemptsCount();
            returnMessage.setAttempts(attempts);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "attempts: " + attempts);
            if (attempts > 0) {
                returnMessage.setJMSRedelivered(true);
            } else {
                returnMessage.setJMSRedelivered(false);
            }
            String exceptionQueue = msgProps.getExceptionQueue();
            returnMessage.setExceptionQueue(exceptionQueue);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "exception queue: " + exceptionQueue);
            AQAgent jdbcAQAgent = msgProps.getSender();
            if (jdbcAQAgent != null && jdbcAQAgent.getName() != null && !jdbcAQAgent.getName().equals("")) {
                AQjmsAgent sender = new AQjmsAgent(jdbcAQAgent.getName(), jdbcAQAgent.getAddress(), jdbcAQAgent.getProtocol());
                returnMessage.setSenderID(sender);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Sender: " + String.valueOf(sender));
            }
            returnMessage.setOriginalMessageId(msgProps.getPreviousQueueMessageId());
            if (returnMessage.isJMSBody() && this.jms_sess.getCompliant()) {
                returnMessage.setJMSPriority(AQjmsMessage.toJMSPriority(returnMessage.getJMSPriority()));
            }
            if (!(returnMessage instanceof AQjmsAdtMessage) && !(returnMessage instanceof AQjmsJsonMessage)) {
                AQjmsMessageHeaderExt headerExt = returnMessage.getMessageHeaderExt();
                AQjmsPropertyList propList = headerExt == null ? null : headerExt.getProperties();
                Hashtable props = null;
                props = propList == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(propList);
                returnMessage.setPropertiesHashtable(props);
                if (props != null && props.get("JMS_OracleHeaderOnly") != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", " Header only, Copying to generic msg");
                    returnMessage = new AQjmsMessage(returnMessage);
                    returnMessage.setHeaderOnly();
                }
                if (props != null && props.get("JMS_OracleDeliveryMode") != null) {
                    returnMessage.setJMSDeliveryMode(returnMessage.getIntProperty("JMS_OracleDeliveryMode"));
                }
            }
            if (returnMessage.getJMSExpiration() <= 0L) {
                returnMessage.setJMSExpiration(0L);
            } else {
                returnMessage.setJMSExpiration(returnMessage.getJMSExpiration() * 1000L + returnMessage.getJMSTimestamp());
            }
            long recvTime = System.currentTimeMillis();
            returnMessage.setReceiveTime(recvTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "recv_time: " + recvTime);
            returnMessage.setPropReadOnly(true);
            returnMessage.setAccessMode(0);
            returnMessage.setJMSDestination((Destination)dest);
            if (inListener) return returnMessage;
            this.doCommit(this.jms_sess);
            return returnMessage;
        }
        catch (SQLException sqlExp) {
            if (sqlExp.getErrorCode() == 1013) {
                Message message = null;
                return message;
            }
            if (sqlExp.getErrorCode() == 17002) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.jdbcDequeue", "Err ORA-17002 caused JMS-257");
                AQjmsError.throwEx(257, (Throwable)sqlExp);
            }
            AQjmsError.throwEx(120, (Throwable)sqlExp);
            return returnMessage;
        }
        catch (Exception exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", exp);
            AQjmsError.throwEx(120, (Throwable)exp);
            return returnMessage;
        }
        finally {
            if (existingNetworkTimeOut != 0 && dbConn != null) {
                try {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                    dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Message jdbcDequeueSh(AQjmsDestination dest, long timeout, String consumerName, int navigationMode, int dequeueMode, boolean inListener, int visibility, int deliveryMode) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "entry");
        this.checkClosed("jdbcDequeueSh");
        Message returnMessage = this.jdbcDequeueCommonSh(dest, timeout, consumerName, navigationMode, dequeueMode, inListener, visibility, deliveryMode);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "exit");
        return returnMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message jdbcDequeueCommonSh(AQjmsDestination dest, long timeout, String consumerName, int navigationMode, int dequeueMode, boolean inListener, int visibility, int deliveryMode) throws JMSException {
        OracleConnection dbConn = null;
        try {
            dbConn = (OracleConnection)this.jms_sess.getDBConnection();
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", ex);
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "After getDbConnection");
        AQjmsMessage returnMessage = null;
        int existingNetworkTimeOut = 0;
        try {
            JMSMessage jmsMessage;
            block68: {
                int idx;
                String destName;
                JMSDequeueOptions jmsDeqOpt = new JMSDequeueOptions();
                jmsDeqOpt.setRetrieveMessageId(true);
                if (dest == null) {
                    AQjmsError.throwEx(200);
                }
                if ((destName = dest.getCompleteName()) == null) {
                    AQjmsError.throwEx(200);
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "destination name: " + destName);
                jmsDeqOpt.setConsumerName(consumerName);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "consumer name: " + consumerName);
                if (this.partition != -1) {
                    jmsDeqOpt.setShardNum(this.partition);
                }
                if (this.selector != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector: " + String.valueOf(this.selector));
                    if (this.selector.getSelectorType() == 30) {
                        jmsDeqOpt.setDequeueMessageId(this.selector.getSelectorMessageId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        jmsDeqOpt.setCorrelation(this.selector.getSelectorCorrelationId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector correlation: " + this.selector.getSelectorCorrelationId());
                    } else if (this.selector.getSelectorType() == 50) {
                        jmsDeqOpt.setCondition(this.selector.getRule());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector dequeue condition: " + this.selector.getRule());
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "dequeue mode: " + dequeueMode + " navigation: " + navigationMode);
                jmsDeqOpt.setDequeueMode(AQjmsConstants.toJmsDequeueModeEnum(dequeueMode));
                deliveryMode = 3;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "visibility : " + visibility + " delivery mode: " + deliveryMode);
                jmsDeqOpt.setVisibility(AQjmsConstants.toJmsDequeueVisibilityEnum(visibility));
                jmsDeqOpt.setDeliveryMode(AQjmsConstants.toJmsDeliveryFilterEnum(deliveryMode));
                long[] results = this.calculateValuesForTimeout(timeout);
                long timeoutInSecond = results[0];
                long interval = results[1];
                long iterations = results[2];
                long lastInterval = results[3];
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Timeout: " + timeoutInSecond + " seconds.  Iterations: " + iterations + " Interval: " + interval + " Last interval: " + lastInterval);
                jmsDeqOpt.setWait((int)interval);
                if (AQjmsConstants.useJmsStreaming() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !inListener && (this.jms_sess.getAcknowledgeMode() == 2 || this.jms_sess.getAcknowledgeMode() == 0)) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Streaming is enabled by the client");
                    jmsDeqOpt.setStreamingMode(JMSDequeueOptions.StreamingMode.DEQ_STREAMING_FLAG_GET_LOB_LOCATOR);
                }
                jmsMessage = null;
                if (timeoutInSecond != -1L) {
                    if (this.jms_sess.isNetworkTimeoutRequired() && timeout != 0L) {
                        try {
                            existingNetworkTimeOut = dbConn.getNetworkTimeout();
                            if (AQjmsConstants.getNetworkTimeOut() != -1 && (long)AQjmsConstants.getNetworkTimeOut() > timeout) {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(timeout * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), AQjmsConstants.getNetworkTimeOut());
                            } else {
                                AQjmsOracleDebug.trace(5, "TESTING AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(timeout * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), new Long(timeout * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                            }
                        }
                        catch (Exception sqlExp) {
                            // empty catch block
                        }
                    }
                    idx = 0;
                } else {
                    while (true) {
                        try {
                            do {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "wait time: " + interval);
                            } while ((jmsMessage = this.jdbcConnectionDequeueCheck25242Sh(dbConn, destName, jmsDeqOpt)) == null);
                            break block68;
                        }
                        catch (SQLException sqlExp) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", sqlExp);
                            if (sqlExp.getErrorCode() == 25228) continue;
                            if (sqlExp.getErrorCode() != 25263) throw sqlExp;
                            if (!this.isClosed()) continue;
                            Message message = null;
                            if (existingNetworkTimeOut == 0) return message;
                            if (dbConn == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                        break;
                    }
                }
                while ((long)idx < iterations) {
                    block69: {
                        try {
                            if ((long)idx == iterations - 1L) {
                                jmsDeqOpt.setWait((int)lastInterval);
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "wait time: " + lastInterval);
                            jmsMessage = this.jdbcConnectionDequeueCheck25242Sh(dbConn, destName, jmsDeqOpt);
                            if (jmsMessage != null) {
                                break;
                            }
                        }
                        catch (SQLException sqlExp) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", sqlExp);
                            if (sqlExp.getErrorCode() != 25228) {
                                if (sqlExp.getErrorCode() != 25263) throw sqlExp;
                            }
                            if (!this.isClosed()) break block69;
                            Message message = null;
                            if (existingNetworkTimeOut == 0) return message;
                            if (dbConn == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                                dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                    }
                    ++idx;
                }
            }
            if (jmsMessage == null || dequeueMode == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "remove no data");
                Message idx = null;
                return idx;
            }
            byte[] msgId = jmsMessage.getMessageId();
            byte[] payload = jmsMessage.getPayload();
            JMSMessageProperties jmsMsgProps = jmsMessage.getJMSMessageProperties();
            String headerProperties = jmsMsgProps.getHeaderProperties();
            String userProperties = jmsMsgProps.getUserProperties();
            JMSMessageProperties.JMSMessageType msgType = jmsMsgProps.getJMSMessageType();
            int type = msgType.getCode();
            AQMessageProperties aqMsgProps = jmsMessage.getAQMessageProperties();
            int priority = aqMsgProps.getPriority();
            String corrId = aqMsgProps.getCorrelation();
            int expiration = aqMsgProps.getExpiration();
            long bodyLength = 0L;
            boolean isStreamingDequeue = false;
            int index = 0;
            index = userProperties.lastIndexOf(",23,JMS_OracleMessageLength");
            if (index >= 1) {
                bodyLength = Long.parseLong(userProperties.substring(userProperties.lastIndexOf(",") + 1).trim());
                userProperties = userProperties.substring(0, index);
                String countString = userProperties.substring(0, userProperties.indexOf(","));
                userProperties = userProperties.replaceFirst(countString, Long.toString(Long.parseLong(countString) - 1L));
                isStreamingDequeue = true;
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "msg_id: " + RepConversion.bArray2String((byte[])msgId) + " type: " + type + " corrid: " + corrId + " priority: " + priority + " headerProperties: " + headerProperties + " userProperties: " + userProperties);
            returnMessage = AQjmsConsumer.convertToAQjmsMessages(this.jms_sess, type, payload, headerProperties, userProperties, msgId, priority, corrId, expiration, isStreamingDequeue);
            long enqTime = aqMsgProps.getEnqueueTime().getTime();
            returnMessage.setEnqueueTime(enqTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "set AQ enqueue time as " + enqTime);
            returnMessage.setMessageState(aqMsgProps.getState().getCode());
            int msgDelay = aqMsgProps.getDelay();
            returnMessage.setDelay(msgDelay);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "msg_delay(secs): " + msgDelay);
            int expTime = aqMsgProps.getExpiration();
            returnMessage.setJMSExpiration(expTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "exptime(secs): " + expTime);
            int attempts = aqMsgProps.getDequeueAttemptsCount();
            returnMessage.setAttempts(attempts);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "attempts: " + attempts);
            if (attempts > 0) {
                returnMessage.setJMSRedelivered(true);
            } else {
                returnMessage.setJMSRedelivered(false);
            }
            String exceptionQueue = aqMsgProps.getExceptionQueue();
            returnMessage.setExceptionQueue(exceptionQueue);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "exception queue: " + exceptionQueue);
            AQAgent jdbcAQAgent = aqMsgProps.getSender();
            if (jdbcAQAgent != null && jdbcAQAgent.getName() != null && !jdbcAQAgent.getName().equals("")) {
                AQjmsAgent sender = new AQjmsAgent(jdbcAQAgent.getName(), jdbcAQAgent.getAddress(), jdbcAQAgent.getProtocol());
                returnMessage.setSenderID(sender);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Sender: " + String.valueOf(sender));
            }
            returnMessage.setOriginalMessageId(aqMsgProps.getPreviousQueueMessageId());
            if (returnMessage.getJMSExpiration() <= 0L) {
                returnMessage.setJMSExpiration(0L);
            } else {
                returnMessage.setJMSExpiration(returnMessage.getJMSExpiration() * 1000L + returnMessage.getJMSTimestamp());
            }
            long recvTime = System.currentTimeMillis();
            returnMessage.setReceiveTime(recvTime);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "recv_time: " + recvTime);
            returnMessage.setPropReadOnly(true);
            returnMessage.setJMSDestination((Destination)dest);
            if (isStreamingDequeue) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "bodyLength : " + bodyLength);
                returnMessage.setBodyLength(bodyLength);
                returnMessage.setLargeBody(true);
                returnMessage.setLobLocator(payload);
                return returnMessage;
            }
            if (inListener) return returnMessage;
            this.doCommit(this.jms_sess);
            return returnMessage;
        }
        catch (SQLException sqlExp) {
            if (sqlExp.getErrorCode() == 1013) {
                Message message = null;
                return message;
            }
            if (sqlExp.getErrorCode() == 17002) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.jdbcDequeue", "Err ORA-17002 caused JMS-257");
                AQjmsError.throwEx(257, (Throwable)sqlExp);
            }
            AQjmsError.throwEx(120, (Throwable)sqlExp);
            return returnMessage;
        }
        catch (Exception exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", exp);
            AQjmsError.throwEx(120, (Throwable)exp);
            return returnMessage;
        }
        finally {
            if (existingNetworkTimeOut != 0 && dbConn != null) {
                try {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + existingNetworkTimeOut);
                    dbConn.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), existingNetworkTimeOut);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void executeDequeueSqlCheck25242(int navigationParamPos) throws SQLException {
        try {
            this.deq_stmt.execute();
        }
        catch (SQLException e) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && e.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.executeDequeueSqlCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                this.deq_stmt.setObject(navigationParamPos, (Object)1, 4);
                this.deq_stmt.execute();
            }
            throw e;
        }
    }

    private AQjmsMessage executeOciDequeueCheck25242(String qname, String consname, int mtype, boolean gen_pload, int[] ociNavigationMode, int deq_mode, String corr_id, String deq_cond, byte[] deq_msg_id, int visib, int deliveryMode, long wait_time, long[] ocihandles, long context, boolean isSharded) throws Exception {
        try {
            return this.syncedOCIDeq(qname, consname, mtype, gen_pload, ociNavigationMode[0], deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, this.xml_receive, ocihandles, context, this.transfxm, this.jms_sess, isSharded);
        }
        catch (SQLException e) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && e.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.executeOciDequeueCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                ociNavigationMode[0] = 1;
                return this.syncedOCIDeq(qname, consname, mtype, gen_pload, ociNavigationMode[0], deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, this.xml_receive, ocihandles, context, this.transfxm, this.jms_sess, isSharded);
            }
            throw e;
        }
    }

    private AQMessage jdbcConnectionDequeueCheck25242(oracle.jdbc.OracleConnection dbConn, String destName, AQDequeueOptions deqopt, String returnDataType) throws SQLException {
        try {
            return dbConn.dequeue(destName, deqopt, returnDataType);
        }
        catch (SQLException e) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && e.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcConnectionDequeueCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                deqopt.setNavigation(AQDequeueOptions.NavigationOption.FIRST_MESSAGE);
                return dbConn.dequeue(destName, deqopt, returnDataType);
            }
            throw e;
        }
    }

    private JMSMessage jdbcConnectionDequeueCheck25242Sh(OracleConnection dbConn, String destName, JMSDequeueOptions jmsDeqOpt) throws SQLException {
        try {
            return dbConn.jmsDequeue(destName, jmsDeqOpt);
        }
        catch (SQLException e) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && e.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcConnectionDequeueCheck25242Sh", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                return null;
            }
            throw e;
        }
    }

    private AQjmsMessage convertAnydataToMessage(ANYDATA anydata) throws JMSException, SQLException {
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "entry");
        Datum datum = anydata.accessDatum();
        if (datum == null) {
            AQjmsError.throwEx(224);
        }
        Object anydataPayload = datum.toJdbc();
        AQjmsMessage returnMessage = null;
        if (anydataPayload instanceof OracleData || anydataPayload instanceof ORAData) {
            if (anydataPayload instanceof AQjmsTextMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "text_message retrieved from anydata");
                returnMessage = new AQjmsTextMessage(this.jms_sess, (AQjmsTextMessage_C)anydataPayload);
            } else if (anydataPayload instanceof AQjmsBytesMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "bytes_message retrieved from anydata");
                returnMessage = new AQjmsBytesMessage(this.jms_sess, (AQjmsBytesMessage_C)anydataPayload);
            } else if (anydataPayload instanceof AQjmsMapMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "map_message retrieved from anydata");
                returnMessage = new AQjmsMapMessage(this.jms_sess, (AQjmsMapMessage_C)anydataPayload);
            } else if (anydataPayload instanceof AQjmsObjectMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "object_message retrieved from anydata");
                returnMessage = new AQjmsObjectMessage(this.jms_sess, (AQjmsObjectMessage_C)anydataPayload, this.xml_receive);
            } else if (anydataPayload instanceof AQjmsStreamMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "stream_message retrieved from anydata");
                returnMessage = new AQjmsStreamMessage(this.jms_sess, (AQjmsStreamMessage_C)anydataPayload);
            } else {
                returnMessage = anydataPayload instanceof XMLType || anydataPayload instanceof ORAData ? new AQjmsAdtMessage(this.jms_sess, (ORAData)anydataPayload) : new AQjmsAdtMessage(this.jms_sess, (OracleData)anydataPayload);
            }
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "anydata-invalid obj");
            if (anydataPayload != null) {
                AQjmsOracleDebug.trace(3, "AQjmsConsumer.dequeue", "anydata-invalid obj class:" + anydataPayload.getClass().getName());
            }
            AQjmsError.throwEx(224);
        }
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "exit");
        return returnMessage;
    }

    synchronized void purgeSeen(Hashtable msgIds, int dest_pload_type) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "entry");
        if (msgIds != null) {
            AQjmsSelector old_sel = this.selector;
            int old_deq = this.deq_mode;
            this.deq_mode = 3;
            JMSException ex = null;
            Enumeration me = msgIds.elements();
            while (me.hasMoreElements()) {
                try {
                    String id = (String)me.nextElement();
                    String sel = "JMSMessageID = '" + id + "'";
                    this.selector = new AQjmsSelector(sel, 10, dest_pload_type, this.jms_sess.dbversion, this.jms_sess.getCompliant());
                    this.receiveNoData(0L);
                }
                catch (JMSException ex1) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.purgeSeen", ex1);
                    ex = ex1;
                    break;
                }
            }
            this.selector = old_sel;
            this.deq_mode = old_deq;
            if (ex != null) {
                throw ex;
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "exit");
    }

    Message dequeue(AQjmsDestination dest_queue, long timeout, String consumer_name, int navigation_mode, int msg_dequeue_mode, AQjmsSignature signature, boolean in_listener) throws JMSException {
        return this.dequeue(dest_queue, timeout, consumer_name, navigation_mode, msg_dequeue_mode, signature, in_listener, this.visibility, 1);
    }

    Message dequeue(AQjmsDestination dest_queue, long timeout, String consumer_name, int navigation_mode, int msg_dequeue_mode, AQjmsSignature signature, boolean in_listener, int visib, int deliveryMode) throws JMSException {
        OracleDataFactory payload_fact = null;
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        String q_name = "";
        AQjmsGenMessage_C gen_msg_c = null;
        AQjmsTextMessage_C text_msg_c = null;
        AQjmsTextMessage text_msg = null;
        AQjmsBytesMessage_C bytes_msg_c = null;
        AQjmsBytesMessage bytes_msg = null;
        AQjmsMapMessage_C map_msg_c = null;
        AQjmsMapMessage map_msg = null;
        AQjmsObjectMessage_C obj_msg_c = null;
        AQjmsObjectMessage obj_msg = null;
        AQjmsStreamMessage_C stream_msg_c = null;
        AQjmsStreamMessage stream_msg = null;
        AQjmsMessage ret_msg = null;
        CustomDatum cust_data = null;
        OracleData ora_data = null;
        ORAData oRa_data = null;
        AQjmsAdtMessage adt_msg = null;
        AQjmsPropertyList prop_list = null;
        AQjmsMessageHeaderExt header_ext = null;
        Hashtable props_ht = null;
        Map<String, Class<?>> map = null;
        byte[] msg_id = null;
        byte[] sel_msg_id = null;
        String sel_deq_cnd = null;
        String sel_corr_id = null;
        String s_name = null;
        AQjmsAgent sender = null;
        TIMESTAMP ts = null;
        Timestamp etime = null;
        int msg_delay = 0;
        int interval = 0;
        long iterations = 1L;
        long last_interval = 0L;
        int idx = 0;
        boolean retry = false;
        long sec_timeout = 0L;
        long exp_time = 0L;
        int attempts = 0;
        int mtype = -1;
        boolean gen_pload = false;
        long[] oci_handles = null;
        int[] oci_navig_mode = null;
        boolean use_ociaq_lib = false;
        long cntxt = 0L;
        String consumerNameInCaps = consumer_name == null ? null : consumer_name.toUpperCase();
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "entry");
        this.checkClosed("dequeue");
        sec_timeout = timeout >= 0L ? (timeout + 999L) / 1000L : -1L;
        interval = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "sec_timeout: " + sec_timeout + "  close_check_interval: " + interval);
        if (sec_timeout > (long)interval) {
            iterations = sec_timeout / (long)interval;
            last_interval = sec_timeout % (long)interval;
            if (last_interval > 0L) {
                ++iterations;
            } else {
                last_interval = interval;
            }
        } else {
            iterations = 1L;
            last_interval = sec_timeout;
        }
        AQjmsOracleDebug.println("Timeout: " + sec_timeout + " Iterations: " + iterations + " Interval: " + interval + " Last_interval: " + last_interval);
        long wt_time = interval;
        if (dest_queue == null || dest_queue.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        jms_conn = this.jms_sess.getJmsConnection();
        try {
            db_conn = this.jms_sess.getDBConnection();
            map = db_conn.getTypeMap();
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue", ex);
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "After getDbConnection");
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
        }
        catch (Exception ex2) {
            AQjmsError.throwEx(146);
        }
        try {
            boolean isSharded;
            String p_data_type;
            block124: {
                p_data_type = this.transfxm == null ? dest_queue.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), dest_queue, this.transfxm).getDestType();
                q_name = dest_queue.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "q_name: " + q_name + "  p_data_type: " + p_data_type);
                isSharded = dest_queue.isSharded();
                if (!isSharded) {
                    if (visib != 1) {
                        deliveryMode = 1;
                    }
                    if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                        gen_pload = true;
                        payload_fact = AQjmsGenMessage_C.getFactory();
                        mtype = 0;
                    } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                        payload_fact = AQjmsTextMessage_C.getFactory();
                        mtype = 0;
                    } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                        payload_fact = AQjmsBytesMessage_C.getFactory();
                        mtype = 1;
                    } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                        payload_fact = AQjmsStreamMessage_C.getFactory();
                        mtype = 2;
                    } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                        payload_fact = AQjmsMapMessage_C.getFactory();
                        mtype = 3;
                    } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                        payload_fact = AQjmsObjectMessage_C.getFactory();
                        mtype = 4;
                    } else if (p_data_type.equalsIgnoreCase("SYS.ANYDATA")) {
                        payload_fact = null;
                    } else if (this.cd_factory != null || this.od_factory != null || this.orad_factory != null) {
                        payload_fact = this.cd_factory != null ? this.cd_factory : (this.od_factory != null ? this.od_factory : this.orad_factory);
                    } else {
                        AQjmsError.throwEx(129, p_data_type);
                    }
                } else {
                    deliveryMode = 3;
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "visibility : " + visib + " delivery mode: " + deliveryMode);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Payload type" + mtype);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + String.valueOf(this.selector));
                    if (this.selector.getSelectorType() == 30) {
                        sel_msg_id = this.selector.getSelectorMessageId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        sel_corr_id = this.selector.getSelectorCorrelationId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector corr_id: " + sel_corr_id);
                    } else if (this.selector.getSelectorType() == 50) {
                        sel_deq_cnd = this.selector.getRule();
                        AQjmsOracleDebug.println("AQjmsConsumer selector deq_cnd: " + sel_deq_cnd);
                    }
                }
                if (this.jms_sess.hasOciAQContext() && this.cd_factory == null && this.od_factory == null && this.orad_factory == null && (p_data_type == null ? isSharded : !p_data_type.equalsIgnoreCase("SYS.ANYDATA"))) {
                    oci_handles = this.jms_sess.getOCIHandles();
                    cntxt = this.jms_sess.oci_aq_cntxt;
                    oci_navig_mode = new int[]{navigation_mode};
                    use_ociaq_lib = true;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = true");
                } else {
                    use_ociaq_lib = false;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = false");
                    this.deq_stmt = this.jms_sess.getDequeueStmt();
                    this.deq_stmt.setString(1, q_name);
                    this.deq_stmt.setString(2, consumer_name);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + consumer_name);
                    if (this.selector != null) {
                        AQjmsOracleDebug.println("AQjmsConsumer selector: " + String.valueOf(this.selector));
                        if (this.selector.getSelectorType() == 30) {
                            sel_msg_id = this.selector.getSelectorMessageId();
                            this.deq_stmt.setBytes(3, sel_msg_id);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                        } else if (this.selector.getSelectorType() == 20) {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, sel_corr_id);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + sel_corr_id);
                        } else if (this.selector.getSelectorType() == 50) {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, sel_deq_cnd);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-condition: " + sel_deq_cnd);
                        } else {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                        }
                    } else {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, null);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, null);
                        }
                    }
                    this.deq_stmt.setObject(5, (Object)msg_dequeue_mode, 4);
                    this.deq_stmt.setObject(6, (Object)navigation_mode, 4);
                    this.deq_stmt.setObject(7, (Object)visib, 4);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "dq_mode: " + msg_dequeue_mode + " navig: " + navigation_mode + " visibility: " + visib);
                    this.deq_stmt.setLong(8, wt_time);
                    this.deq_stmt.registerOutParameter(9, 93);
                    this.deq_stmt.registerOutParameter(10, 4);
                    this.deq_stmt.registerOutParameter(11, -2);
                    this.deq_stmt.registerOutParameter(12, 12);
                    this.deq_stmt.registerOutParameter(13, 4);
                    this.deq_stmt.registerOutParameter(14, 4);
                    this.deq_stmt.registerOutParameter(15, 4);
                    this.deq_stmt.registerOutParameter(16, 4);
                    this.deq_stmt.registerOutParameter(17, 12);
                    this.deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
                    this.deq_stmt.registerOutParameter(19, 12);
                    this.deq_stmt.registerOutParameter(20, 12);
                    this.deq_stmt.registerOutParameter(21, 4);
                    this.deq_stmt.registerOutParameter(22, -2);
                    this.deq_stmt.setObject(23, (Object)1, 4);
                    this.deq_stmt.registerOutParameter(24, -2);
                    if (p_data_type.equalsIgnoreCase("SYS.XMLTYPE") || p_data_type.equalsIgnoreCase("SYS.ANYDATA")) {
                        this.deq_stmt.registerOutParameter(25, 2007, p_data_type);
                    } else {
                        this.deq_stmt.registerOutParameter(25, 2002, p_data_type);
                    }
                    if (this.jms_sess.is82compatible()) {
                        if (signature != null) {
                            this.deq_stmt.setObject(27, (Object)signature);
                        } else {
                            this.deq_stmt.setNull(27, 2002, "SYS.AQ$_SIG_PROP");
                        }
                        this.deq_stmt.registerOutParameter(28, 2002, "SYS.AQ$_SIG_PROP");
                        this.deq_stmt.setString(29, this.transfxm);
                    }
                    if (this.jms_sess.is102compatible()) {
                        this.deq_stmt.setObject(30, (Object)deliveryMode, 4);
                        this.deq_stmt.registerOutParameter(31, 4);
                    }
                }
                if (sec_timeout == -1L) {
                    while (true) {
                        retry = false;
                        try {
                            AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + wt_time);
                            if (use_ociaq_lib) {
                                ret_msg = this.executeOciDequeueCheck25242(q_name, consumerNameInCaps, mtype, gen_pload, oci_navig_mode, msg_dequeue_mode, sel_corr_id, sel_deq_cnd, sel_msg_id, visib, deliveryMode, wt_time, oci_handles, cntxt, isSharded);
                            } else {
                                this.executeDequeueSqlCheck25242(6);
                            }
                        }
                        catch (SQLException sql_ex) {
                            AQjmsOracleDebug.println("SQL excpetion-1:" + sql_ex.getErrorCode());
                            if (sql_ex.getErrorCode() == 25228 || sql_ex.getErrorCode() == 25263) {
                                if (this.isClosed()) {
                                    return null;
                                }
                                retry = true;
                            }
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-sqlex", sql_ex);
                            throw sql_ex;
                        }
                        AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                        if (retry) {
                            Thread.yield();
                            continue;
                        }
                        break block124;
                        break;
                    }
                }
                idx = 0;
                while ((long)idx < iterations) {
                    retry = false;
                    try {
                        if ((long)idx == iterations - 1L) {
                            wt_time = last_interval;
                        }
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + wt_time);
                        if (use_ociaq_lib) {
                            ret_msg = this.executeOciDequeueCheck25242(q_name, consumerNameInCaps, mtype, gen_pload, oci_navig_mode, msg_dequeue_mode, sel_corr_id, sel_deq_cnd, sel_msg_id, visib, deliveryMode, wt_time, oci_handles, cntxt, isSharded);
                        } else {
                            if ((long)idx == iterations - 1L) {
                                this.deq_stmt.setLong(8, wt_time);
                            }
                            this.executeDequeueSqlCheck25242(6);
                        }
                    }
                    catch (SQLException sql_ex) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sql_ex.getErrorCode());
                        if ((long)idx < iterations - 1L && (sql_ex.getErrorCode() == 25228 || sql_ex.getErrorCode() == 25263)) {
                            if (this.isClosed()) {
                                return null;
                            }
                            retry = true;
                        }
                        throw sql_ex;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                    if (!retry) break;
                    Thread.yield();
                    ++idx;
                }
            }
            if (msg_dequeue_mode == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            if (use_ociaq_lib) {
                if (ret_msg == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsConsumer.dequeue", "Encounter null message and the dequeue mode is not DEQUEUE_REMOVE_NODATA");
                    throw new AQjmsException("Encounter null message with dequeue mode not DEQUEUE_REMOVE_NODATA", 122);
                }
                attempts = ret_msg.getAttempts();
            } else {
                if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    gen_msg_c = (AQjmsGenMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    int msg_type = gen_msg_c.getMessageType();
                    switch (msg_type) {
                        case 0: {
                            ret_msg = new AQjmsTextMessage(this.jms_sess, gen_msg_c);
                            break;
                        }
                        case 1: {
                            ret_msg = new AQjmsBytesMessage(this.jms_sess, gen_msg_c);
                            break;
                        }
                        case 2: {
                            ret_msg = new AQjmsStreamMessage(this.jms_sess, gen_msg_c);
                            break;
                        }
                        case 3: {
                            ret_msg = new AQjmsMapMessage(this.jms_sess, gen_msg_c);
                            break;
                        }
                        case 4: {
                            ret_msg = new AQjmsObjectMessage(this.jms_sess, gen_msg_c);
                            break;
                        }
                        default: {
                            AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + msg_type + " is not valid JMS message type");
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "general payload messaeg retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    text_msg_c = (AQjmsTextMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    text_msg = new AQjmsTextMessage(this.jms_sess, text_msg_c);
                    ret_msg = text_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "text_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    bytes_msg_c = (AQjmsBytesMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    bytes_msg = new AQjmsBytesMessage(this.jms_sess, bytes_msg_c);
                    ret_msg = bytes_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "bytes_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    map_msg_c = (AQjmsMapMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    map_msg = new AQjmsMapMessage(this.jms_sess, map_msg_c);
                    ret_msg = map_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "map_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    obj_msg_c = (AQjmsObjectMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    obj_msg = new AQjmsObjectMessage(this.jms_sess, obj_msg_c, this.xml_receive);
                    ret_msg = obj_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "object_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    stream_msg_c = (AQjmsStreamMessage_C)this.deq_stmt.getObject(25, payload_fact);
                    stream_msg = new AQjmsStreamMessage(this.jms_sess, stream_msg_c);
                    ret_msg = stream_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "stream_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.ANYDATA")) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "before receiving anydata message");
                    ret_msg = this.convertAnydataToMessage((ANYDATA)this.deq_stmt.getObject(25));
                } else {
                    if (payload_fact instanceof CustomDatumFactory) {
                        cust_data = (CustomDatum)this.deq_stmt.getCustomDatum(25, (CustomDatumFactory)payload_fact);
                        adt_msg = new AQjmsAdtMessage(this.jms_sess, cust_data);
                    } else if (payload_fact instanceof ORADataFactory) {
                        oRa_data = (ORAData)this.deq_stmt.getORAData(25, (ORADataFactory)payload_fact);
                        adt_msg = new AQjmsAdtMessage(this.jms_sess, oRa_data);
                    } else {
                        ora_data = (OracleData)this.deq_stmt.getObject(25, payload_fact);
                        adt_msg = new AQjmsAdtMessage(this.jms_sess, ora_data);
                    }
                    ret_msg = adt_msg;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "adt_message retrieved");
                }
                ts = this.deq_stmt.getTIMESTAMP(9);
                etime = ts.timestampValue();
                long secs = etime.getTime();
                ret_msg.setEnqueueTime(secs);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "set AQ enqueue_time as " + secs);
                ret_msg.setMessageState(this.deq_stmt.getInt(10));
                msg_id = this.deq_stmt.getBytes(11);
                ret_msg.setJMSMessageID(msg_id);
                ret_msg.setJMSCorrelationID(this.deq_stmt.getString(12));
                ret_msg.setJMSPriority(this.deq_stmt.getInt(13));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_id: " + RepConversion.bArray2String((byte[])msg_id) + " corrid: " + this.deq_stmt.getString(12) + " priority: " + this.deq_stmt.getInt(13));
                msg_delay = this.deq_stmt.getInt(14);
                ret_msg.setDelay(msg_delay);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_delay(secs): " + msg_delay);
                exp_time = this.deq_stmt.getLong(15);
                ret_msg.setJMSExpiration(exp_time);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "exptime(secs): " + exp_time);
                attempts = this.deq_stmt.getInt(16);
                ret_msg.setAttempts(attempts);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "attempts: " + attempts);
                ret_msg.setExceptionQueue(this.deq_stmt.getString(17));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "excp_q: " + this.deq_stmt.getString(17));
                s_name = this.deq_stmt.getString(19);
                if (s_name != null && !s_name.equals("")) {
                    sender = new AQjmsAgent();
                    sender.setName(s_name);
                    sender.setAddress(this.deq_stmt.getString(20));
                    sender.setProtocol(this.deq_stmt.getInt(21));
                    ret_msg.setSenderID(sender);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Sender" + String.valueOf(sender));
                }
                ret_msg.setOriginalMessageId(this.deq_stmt.getBytes(22));
                if (this.jms_sess.is82compatible()) {
                    ret_msg.setSignature((AQjmsSignature)this.deq_stmt.getObject(28, AQjmsSignature.getFactory()));
                }
            }
            if (!isSharded) {
                if (ret_msg.isJMSBody() && this.jms_sess.getCompliant()) {
                    ret_msg.setJMSPriority(AQjmsMessage.toJMSPriority(ret_msg.getJMSPriority()));
                }
                if (!(ret_msg instanceof AQjmsAdtMessage)) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-0 " + String.valueOf(ret_msg));
                    header_ext = ret_msg.getMessageHeaderExt();
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-1");
                    prop_list = header_ext.getProperties();
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-2");
                    props_ht = prop_list == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(prop_list);
                    ret_msg.setPropertiesHashtable(props_ht);
                }
                if (props_ht != null && props_ht.get("JMS_OracleHeaderOnly") != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", " Header only, Copying to generic msg");
                    AQjmsMessage hdronly_msg = new AQjmsMessage(ret_msg);
                    ret_msg = null;
                    ret_msg = hdronly_msg;
                    ret_msg.setHeaderOnly();
                }
                if (props_ht != null && props_ht.get("JMS_OracleDeliveryMode") != null) {
                    ret_msg.setJMSDeliveryMode(Integer.parseInt(ret_msg.getStringProperty("JMS_OracleDeliveryMode")));
                }
            }
            if (ret_msg.getJMSExpiration() <= 0L) {
                ret_msg.setJMSExpiration(0L);
            } else {
                ret_msg.setJMSExpiration(ret_msg.getJMSExpiration() * 1000L + ret_msg.getJMSTimestamp());
            }
            Date recv_time = new Date();
            ret_msg.setReceiveTime(recv_time.getTime());
            if (attempts > 0) {
                ret_msg.setJMSRedelivered(true);
            } else {
                ret_msg.setJMSRedelivered(false);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "recv_time: " + String.valueOf(recv_time));
            ret_msg.setPropReadOnly(true);
            ret_msg.setAccessMode(0);
            ret_msg.setJMSDestination((Destination)dest_queue);
            if (!in_listener) {
                this.doCommit(this.jms_sess);
            }
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sql_ex2) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if ((sql_ex2.getErrorCode() == 25228 || sql_ex2.getErrorCode() == 25263) && msg_dequeue_mode != 4) {
                ret_msg = null;
            } else if (sql_ex2.getErrorCode() == 1013) {
                ret_msg = null;
            } else {
                AQjmsError.throwEx(120, (Throwable)sql_ex2);
            }
        }
        catch (JMSException ex3) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-ex3", ex3);
            AQjmsError.throwEx(120, (Throwable)ex3);
        }
        catch (Exception ex3) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-ex3", ex3);
            AQjmsError.throwEx(120, (Throwable)ex3);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-2");
        return ret_msg;
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    void markClosed() {
        super.markClosed();
        if (this.jms_sess != null && this.isInUse()) {
            this.jms_sess.cancelBlockingReceive();
        }
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.localClose", "entry");
        this.closeConsumerResources();
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit");
    }

    synchronized void closeConsumerResources() {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeConsumerResources", "entry");
        this.jms_sess.removeConsumer(this);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deq_stmt closed");
        if (this.isDurable() && this.jms_sess.getCompliant() && this.hasInfo && this.cons_name != null && !this.cons_name.equals("") && this.client_id != null) {
            boolean succ = AQjmsClientSubscriberMap.deactivateClientSubscriber(this.client_id, this.cons_name);
            if (succ) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber " + this.cons_name + " success.");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber, " + this.cons_name + " not found.");
            }
        }
        if (this.cons_dest.isTemp()) {
            this.cons_dest.removeConsForTempDest();
        }
        this.selector = null;
        this.cons_dest = null;
        this.cd_factory = null;
        this.od_factory = null;
        this.orad_factory = null;
        this.jms_sess = null;
        this.deq_stmt = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.localClose", "exit-2");
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkClosed("getQueue");
        if (this.dest_type == 10) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "TopicSubscriber");
        return null;
    }

    @Override
    public synchronized Topic getTopic() throws JMSException {
        this.checkClosed("getTopic");
        if (this.dest_type == 20) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized boolean getNoLocal() throws JMSException {
        this.checkClosed("getNoLocal");
        if (this.dest_type == 10) {
            AQjmsError.throwEx(107, "QueueReceiver");
        }
        if (!this.hasInfo) {
            AQjmsError.throwEx(233);
        }
        return this.nolocal;
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int pNum) {
        this.partition = pNum;
    }

    @Override
    public synchronized int getNavigationMode() throws JMSException {
        this.checkClosed("getNavigationMode");
        return this.navig_mode;
    }

    @Override
    public synchronized void setNavigationMode(int mode) throws JMSException {
        this.checkClosed("setNavigationMode");
        if (mode == 1 || mode == 3 || mode == 2) {
            this.navig_mode = mode;
        } else {
            AQjmsError.throwEx(128);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.setNavigationMode", "navig_mode: " + mode);
    }

    @Override
    public synchronized void setTransformation(String transformation) {
        this.transfxm = transformation;
    }

    @Override
    public synchronized String getTransformation() {
        return this.transfxm;
    }

    boolean isDurable() {
        return this.durable;
    }

    void setDurable(boolean durable) {
        this.durable = durable;
    }

    @Override
    public synchronized void receiveNoData() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "entry");
        this.receiveNoData(-1L);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receiveNoData(long timeout) throws JMSException {
        int navigation_mode;
        Message ret_message = null;
        AQjmsConnection jms_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveNoData", "timeout: " + timeout);
        this.checkClosed("receiveNoData");
        jms_conn = this.jms_sess.getJmsConnection();
        if (!jms_conn.isStarted()) {
            AQjmsError.throwEx(113);
        }
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            navigation_mode = 1;
            this.first_receive = false;
        } else {
            navigation_mode = this.navig_mode;
        }
        if (!this.lockReceive("receiveNoData", timeout)) {
            return;
        }
        try {
            if (this.dest_type == 10) {
                ret_message = this.dequeue(this.cons_dest, timeout, null, navigation_mode, 4, null, false);
            } else if (this.dest_type == 20) {
                ret_message = this.dequeue(this.cons_dest, timeout, this.cons_name, navigation_mode, 4, null, false);
            }
        }
        finally {
            this.unlock("receiveNoData");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "exit");
    }

    @Override
    public Message receiveSignature() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-1", "entry");
        return this.receiveSignature(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Message receiveSignature(long timeout) throws JMSException {
        int navigation_mode;
        Message ret_message = null;
        AQjmsConnection jms_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveSignature-2", "timeout: " + timeout);
        this.checkClosed("receiveSignature");
        jms_conn = this.jms_sess.getJmsConnection();
        if (!jms_conn.isStarted()) {
            AQjmsError.throwEx(113);
        }
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            navigation_mode = 1;
            this.first_receive = false;
        } else {
            navigation_mode = this.navig_mode;
        }
        if (!this.lockReceive("receiveSignature", timeout)) {
            return null;
        }
        try {
            if (this.dest_type == 10) {
                ret_message = this.dequeue(this.cons_dest, timeout, null, navigation_mode, 5, null, false);
            } else if (this.dest_type == 20) {
                ret_message = this.dequeue(this.cons_dest, timeout, this.cons_name, navigation_mode, 5, null, false);
            }
        }
        finally {
            this.unlock("receiveSignature");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "exit");
        return ret_message;
    }

    public void setXmlReceive(boolean flag) {
        this.xml_receive = flag;
    }

    public Message browse(long timeout, boolean locked) throws JMSException {
        if (timeout == 0L) {
            timeout = -1L;
        }
        this.deq_mode = locked ? 2 : 1;
        return this.receiveFromAQ(timeout);
    }

    public Message browseNoWait(boolean locked) throws JMSException {
        this.deq_mode = locked ? 2 : 1;
        return this.receiveFromAQ(0L);
    }

    void restart() {
        this.first_receive = true;
    }

    @Override
    public void finalize() {
        AQjmsOracleDebug.println("AQjmsConsumer.finalize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AQjmsMessage syncedOCIDeq(String qname, String consname, int mtype, boolean gen_pload, int nav_mode, int deq_mode, String corr_id, String deq_cond, byte[] deq_msg_id, int visib, int deliveryMode, long wait_time, boolean xml_recv, long[] ocihandles, long context, String transformation, AQjmsSession session, boolean isSharded) throws Exception {
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "Calling Native Deq-2");
        AQjmsOracleDebug.println("Context: " + context);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "msg_dequeue_mode: " + deq_mode);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "consumer_name: " + consname);
        AQjmsSession aqsess = this.jms_sess;
        AQjmsMessage retmsg = null;
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "ENTRY");
        try {
            Connection db_conn = aqsess.getDBConnection();
            Connection pconn = ((oracle.jdbc.OracleConnection)db_conn)._getPC();
            if (pconn != null) {
                Connection connection = pconn;
                synchronized (connection) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "in connection sync block, conn= " + String.valueOf(db_conn) + ", pc-conn=" + String.valueOf(pconn));
                    if (pconn.isClosed()) {
                        AQjmsMessage aQjmsMessage = null;
                        return aQjmsMessage;
                    }
                    retmsg = isSharded ? this.ocideqSQ(qname, consname, nav_mode, deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, xml_recv, ocihandles, context, transformation, session) : this.ocideq(qname, consname, mtype, gen_pload, nav_mode, deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, xml_recv, ocihandles, context, transformation, session);
                    return retmsg;
                }
            }
            if (!db_conn.isClosed()) {
                if (isSharded) {
                    retmsg = this.ocideqSQ(qname, consname, nav_mode, deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, xml_recv, ocihandles, context, transformation, session);
                    return retmsg;
                }
                retmsg = this.ocideq(qname, consname, mtype, gen_pload, nav_mode, deq_mode, corr_id, deq_cond, deq_msg_id, visib, deliveryMode, wait_time, xml_recv, ocihandles, context, transformation, session);
                return retmsg;
            }
            AQjmsOracleDebug.trace(1, "AQjmsConsumer.syncedOCIDeq", "WARNING!!: Physical connection is null");
            AQjmsError.throwEx(112, "db connection is closed");
            return retmsg;
        }
        catch (IllegalStateException illegalStateException) {
            return retmsg;
        }
        finally {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "EXIT: retmsg=" + String.valueOf(retmsg));
        }
    }

    public Message[] bulkReceive(int batchsize) throws JMSException {
        return this.bulkReceiveFromAQ(-1L, batchsize, null);
    }

    public Message[] bulkReceive(int batchsize, long timeout) throws JMSException {
        return this.bulkReceiveFromAQ(timeout, batchsize, null);
    }

    public Message[] bulkReceiveNoWait(int batchsize) throws JMSException {
        return this.bulkReceiveFromAQ(0L, batchsize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message[] bulkReceiveFromAQ(long timeout, int batchsize, AQjmsSignature signature) throws JMSException {
        int navigation_mode;
        Message[] ret_messages = null;
        AQjmsConnection jms_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.batchReceivefromAQ", "entry");
        this.checkClosed("bulkReceiveFromAQ");
        jms_conn = this.jms_sess.getJmsConnection();
        if (!jms_conn.isStarted()) {
            return null;
        }
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.batchReceiveFromAQ", "timeout(millisecs): " + timeout);
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            navigation_mode = 1;
            this.first_receive = false;
        } else {
            navigation_mode = this.navig_mode;
        }
        if (!this.lockReceive("batchReceiveFromAQ(sig)", timeout)) {
            return null;
        }
        try {
            if (this.dest_type == 10) {
                ret_messages = this.bulkDequeue(this.cons_dest, timeout, batchsize, null, navigation_mode, this.deq_mode, signature, false);
            } else if (this.dest_type == 20) {
                ret_messages = this.bulkDequeue(this.cons_dest, timeout, batchsize, this.cons_name, navigation_mode, this.deq_mode, signature, false);
            }
        }
        finally {
            this.unlock("bulkReceiveFromAQ(sig)");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return ret_messages;
    }

    Message[] bulkDequeue(AQjmsDestination dest_queue, long timeout, int batchsize, String consumer_name, int navigation_mode, int msg_dequeue_mode, AQjmsSignature signature, boolean in_listener) throws JMSException {
        int num_dequeued = 0;
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        String q_name = "";
        AQjmsGenMessages_C gen_msgs_c = null;
        AQjmsGenMessage_C[] gen_msgs = null;
        AQjmsTextMessages_C text_msgs_c = null;
        AQjmsTextMessage_C[] text_msgs = null;
        AQjmsBytesMessages_C bytes_msgs_c = null;
        AQjmsBytesMessage_C[] bytes_msgs = null;
        AQjmsMapMessages_C map_msgs_c = null;
        AQjmsMapMessage_C[] map_msgs = null;
        AQjmsObjectMessages_C object_msgs_c = null;
        AQjmsObjectMessage_C[] obj_msgs = null;
        AQjmsStreamMessages_C stream_msgs_c = null;
        AQjmsStreamMessage_C[] stream_msgs = null;
        Message[] messages = null;
        AQjmsPropertyList prop_list = null;
        AQjmsMessageHeaderExt header_ext = null;
        Hashtable props_ht = null;
        Map<String, Class<?>> map = null;
        byte[][] msgids = null;
        byte[] sel_msg_id = null;
        String sel_deq_cnd = null;
        String sel_corr_id = null;
        Timestamp etime = null;
        int msg_delay = 0;
        int interval = 0;
        long iterations = 1L;
        long last_interval = 0L;
        int idx = 0;
        boolean retry = false;
        long sec_timeout = 0L;
        long exp_time = 0L;
        int attempts = 0;
        Object anyd_msg = null;
        boolean anyd_jms = false;
        AQjmsMessageProperty[] msgprops = null;
        AQjmsMessageProperties msgprops_c = null;
        OracleArray msgids_array = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "entry");
        if (dest_queue.isSharded()) {
            dest_queue.setAdtType("SYS.AQ$_JMS_MESSAGE");
            navigation_mode = 1;
        }
        this.checkClosed("bulkDequeue");
        sec_timeout = timeout >= 0L ? (timeout + 999L) / 1000L : -1L;
        interval = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "sec_timeout: " + sec_timeout + "  close_check_interval: " + interval);
        if (sec_timeout > (long)interval) {
            iterations = sec_timeout / (long)interval;
            last_interval = sec_timeout % (long)interval;
            if (last_interval > 0L) {
                ++iterations;
            } else {
                last_interval = interval;
            }
        } else {
            iterations = 1L;
            last_interval = sec_timeout;
        }
        AQjmsOracleDebug.println("Timeout: " + sec_timeout + " Iterations: " + iterations + " Interval: " + interval + " Last_interval: " + last_interval);
        if (dest_queue == null || dest_queue.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        jms_conn = this.jms_sess.getJmsConnection();
        try {
            db_conn = this.jms_sess.getDBConnection();
            map = db_conn.getTypeMap();
        }
        catch (Exception ex) {
            AQjmsError.throwEx(112, (Throwable)ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "After getDbConnection");
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            map.put("SYS.AQ$_SIG_PROP", Class.forName("oracle.jakarta.jms.AQjmsSignature"));
            map.put("SYS.AQ$_RECIPIENTS", Class.forName("oracle.jakarta.jms.AQjmsRecipients"));
            map.put("SYS.AQ$_JMS_MESSAGE_PROPERTY", Class.forName("oracle.jakarta.jms.AQjmsMessageProperty"));
            map.put("SYS.AQ$_JMS_TEXT_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsTextMessage_C"));
            map.put("SYS.AQ$_JMS_BYTES_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsBytesMessage_C"));
            map.put("SYS.AQ$_JMS_STREAM_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsStreamMessage_C"));
            map.put("SYS.AQ$_JMS_MAP_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsMapMessage_C"));
            map.put("SYS.AQ$_JMS_OBJECT_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsObjectMessage_C"));
            map.put("SYS.AQ$_JMS_MESSAGE", Class.forName("oracle.jakarta.jms.AQjmsGenMessage_C"));
        }
        catch (Exception ex2) {
            AQjmsError.throwEx(146);
        }
        try {
            String p_data_type;
            block95: {
                long wt_time;
                p_data_type = this.transfxm == null ? dest_queue.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), dest_queue, this.transfxm).getDestType();
                q_name = dest_queue.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "q_name: " + q_name + "  p_data_type: " + p_data_type);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + String.valueOf(this.selector));
                    if (this.selector.getSelectorType() == 30) {
                        sel_msg_id = this.selector.getSelectorMessageId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        sel_corr_id = this.selector.getSelectorCorrelationId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector corr_id: " + sel_corr_id);
                    } else if (this.selector.getSelectorType() == 50) {
                        sel_deq_cnd = this.selector.getRule();
                        AQjmsOracleDebug.println("AQjmsConsumer selector deq_cnd: " + sel_deq_cnd);
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "use_ociaq_lib = false");
                this.deq_stmt = this.jms_sess.getArrayDequeueStmt(p_data_type);
                this.deq_stmt.setString(1, q_name);
                this.deq_stmt.setObject(2, (Object)batchsize, 4);
                this.deq_stmt.setString(3, consumer_name);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "consumer_name: " + consumer_name);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + String.valueOf(this.selector));
                    if (this.selector.getSelectorType() == 20) {
                        this.deq_stmt.setString(8, sel_corr_id);
                        this.deq_stmt.setString(9, null);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + sel_corr_id);
                    } else if (this.selector.getSelectorType() == 50) {
                        this.deq_stmt.setString(8, null);
                        this.deq_stmt.setString(9, sel_deq_cnd);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-condition: " + sel_deq_cnd);
                    } else {
                        this.deq_stmt.setString(8, null);
                        this.deq_stmt.setString(9, null);
                    }
                } else {
                    this.deq_stmt.setString(8, null);
                    this.deq_stmt.setString(9, null);
                }
                this.deq_stmt.setObject(4, (Object)msg_dequeue_mode, 4);
                this.deq_stmt.setObject(5, (Object)navigation_mode, 4);
                this.deq_stmt.setObject(6, (Object)this.visibility, 4);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "dq_mode: " + msg_dequeue_mode + "navig: " + navigation_mode + "visibility: " + this.visibility);
                this.deq_stmt.registerOutParameter(12, 2003, "SYS.AQ$_JMS_MESSAGE_PROPERTIES");
                if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_MESSAGES");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_TEXT_MESSAGES");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_BYTES_MESSAGES");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_STREAM_MESSAGES");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_MAP_MESSAGES");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_BYTES_MESSAGES");
                } else {
                    AQjmsError.throwInvalidDestEx(127);
                }
                this.deq_stmt.registerOutParameter(14, 2003, "SYS.AQ$_JMS_ARRAY_MSGIDS");
                this.deq_stmt.registerOutParameter(15, 4);
                if (signature != null) {
                    this.deq_stmt.setObject(10, (Object)signature);
                } else {
                    this.deq_stmt.setNull(10, 2002, "SYS.AQ$_SIG_PROP");
                }
                this.deq_stmt.setString(11, this.transfxm);
                if (sec_timeout == -1L) {
                    while (true) {
                        retry = false;
                        try {
                            wt_time = interval;
                            AQjmsOracleDebug.println("AQjmsConsumer.bulkDequeue: wt_time: " + wt_time);
                            this.deq_stmt.setLong(7, wt_time);
                            this.executeDequeueSqlCheck25242(5);
                        }
                        catch (SQLException sql_ex) {
                            AQjmsOracleDebug.println("SQL excpetion-1:" + sql_ex.getErrorCode());
                            if (sql_ex.getErrorCode() == 25228 || sql_ex.getErrorCode() == 25263) {
                                retry = true;
                            }
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.bulkDequeue-sqlex", sql_ex);
                            throw sql_ex;
                        }
                        AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                        if (this.isClosed()) {
                            AQjmsOracleDebug.println("Session closed: return");
                            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                                this.jms_sess.destroyStmt(this.deq_stmt);
                            }
                            return null;
                        }
                        if (retry) {
                            Thread.yield();
                            continue;
                        }
                        break block95;
                        break;
                    }
                }
                idx = 0;
                while ((long)idx < iterations) {
                    retry = false;
                    try {
                        wt_time = (long)idx == iterations - 1L ? last_interval : (long)interval;
                        AQjmsOracleDebug.println("AQjmsConsumer.bulkDequeue: wt_time: " + wt_time);
                        this.deq_stmt.setLong(7, wt_time);
                        this.executeDequeueSqlCheck25242(5);
                    }
                    catch (SQLException sql_ex) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sql_ex.getErrorCode());
                        if ((long)idx < iterations - 1L && (sql_ex.getErrorCode() == 25228 || sql_ex.getErrorCode() == 25263)) {
                            retry = true;
                        }
                        throw sql_ex;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + retry);
                    if (this.isClosed()) {
                        AQjmsOracleDebug.println("Session closed: return");
                        if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                            this.jms_sess.destroyStmt(this.deq_stmt);
                        }
                        return null;
                    }
                    if (!retry) break;
                    Thread.yield();
                    ++idx;
                }
            }
            if (msg_dequeue_mode == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            num_dequeued = this.deq_stmt.getInt(15);
            if (num_dequeued > 0) {
                if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    gen_msgs_c = (AQjmsGenMessages_C)this.deq_stmt.getObject(13, AQjmsGenMessages_C.getOracleDataFactory());
                    gen_msgs = gen_msgs_c.getArray();
                    messages = new Message[gen_msgs.length];
                    block20: for (int i = 0; i < gen_msgs.length; ++i) {
                        int msg_type = gen_msgs[i].getMessageType();
                        switch (msg_type) {
                            case 0: {
                                messages[i] = new AQjmsTextMessage(this.jms_sess, gen_msgs[i]);
                                continue block20;
                            }
                            case 1: {
                                messages[i] = new AQjmsBytesMessage(this.jms_sess, gen_msgs[i]);
                                continue block20;
                            }
                            case 2: {
                                messages[i] = new AQjmsStreamMessage(this.jms_sess, gen_msgs[i]);
                                continue block20;
                            }
                            case 3: {
                                messages[i] = new AQjmsMapMessage(this.jms_sess, gen_msgs[i]);
                                continue block20;
                            }
                            case 4: {
                                messages[i] = new AQjmsObjectMessage(this.jms_sess, gen_msgs[i]);
                                continue block20;
                            }
                            default: {
                                AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + msg_type + " is not valid JMS message type");
                            }
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "general payload messaeg retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    text_msgs_c = (AQjmsTextMessages_C)this.deq_stmt.getObject(13, AQjmsTextMessages_C.getOracleDataFactory());
                    text_msgs = text_msgs_c.getArray();
                    messages = new Message[text_msgs.length];
                    for (int i = 0; i < text_msgs.length; ++i) {
                        messages[i] = new AQjmsTextMessage(this.jms_sess, text_msgs[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "text_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    bytes_msgs_c = (AQjmsBytesMessages_C)this.deq_stmt.getObject(13, AQjmsBytesMessages_C.getOracleDataFactory());
                    bytes_msgs = bytes_msgs_c.getArray();
                    messages = new Message[bytes_msgs.length];
                    for (int i = 0; i < bytes_msgs.length; ++i) {
                        messages[i] = new AQjmsBytesMessage(this.jms_sess, bytes_msgs[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "bytes_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    map_msgs_c = (AQjmsMapMessages_C)this.deq_stmt.getObject(13, AQjmsMapMessages_C.getOracleDataFactory());
                    map_msgs = map_msgs_c.getArray();
                    messages = new Message[map_msgs.length];
                    for (int i = 0; i < map_msgs.length; ++i) {
                        messages[i] = new AQjmsMapMessage(this.jms_sess, map_msgs[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "map_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    object_msgs_c = (AQjmsObjectMessages_C)this.deq_stmt.getObject(13, AQjmsObjectMessages_C.getOracleDataFactory());
                    obj_msgs = object_msgs_c.getArray();
                    messages = new Message[obj_msgs.length];
                    for (int i = 0; i < obj_msgs.length; ++i) {
                        messages[i] = new AQjmsObjectMessage(this.jms_sess, obj_msgs[i], this.xml_receive);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "object_message retrieved");
                } else if (p_data_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    stream_msgs_c = (AQjmsStreamMessages_C)this.deq_stmt.getObject(13, AQjmsStreamMessages_C.getOracleDataFactory());
                    stream_msgs = stream_msgs_c.getArray();
                    messages = new Message[stream_msgs.length];
                    for (int i = 0; i < stream_msgs.length; ++i) {
                        messages[i] = new AQjmsStreamMessage(this.jms_sess, stream_msgs[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "stream_message retrieved");
                } else {
                    AQjmsError.throwInvalidDestEx(127);
                }
                msgprops_c = (AQjmsMessageProperties)this.deq_stmt.getObject(12, AQjmsMessageProperties.getOracleDataFactory());
                msgprops = msgprops_c.getArray();
                msgids_array = (OracleArray)this.deq_stmt.getArray(14);
                if (msgids_array != null) {
                    msgids = (byte[][])msgids_array.getArray();
                }
                for (int i = 0; i < messages.length; ++i) {
                    etime = msgprops[i].getEnqueueTime();
                    long secs = etime.getTime();
                    ((AQjmsMessage)messages[i]).setEnqueueTime(secs);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "set AQ enqueue_time as " + secs);
                    ((AQjmsMessage)messages[i]).setMessageState(msgprops[i].getState());
                    ((AQjmsMessage)messages[i]).setJMSMessageID(msgids[i]);
                    messages[i].setJMSCorrelationID(msgprops[i].getCorrelation());
                    messages[i].setJMSPriority(msgprops[i].getPriority().intValue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "msg_id: " + messages[i].getJMSMessageID() + " corrid: " + msgprops[i].getCorrelation() + " priority: " + msgprops[i].getPriority());
                    ((AQjmsMessage)messages[i]).setDelay(msgprops[i].getDelay());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "msg_delay(secs): " + msg_delay);
                    messages[i].setJMSExpiration(msgprops[i].getExpiration().longValue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "exptime(secs): " + exp_time);
                    ((AQjmsMessage)messages[i]).setAttempts(msgprops[i].getAttempts());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "attempts: " + msgprops[i].getAttempts());
                    ((AQjmsMessage)messages[i]).setExceptionQueue(msgprops[i].getExceptionQueue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "excp_q: " + msgprops[i].getExceptionQueue());
                    ((AQjmsMessage)messages[i]).setSenderID(msgprops[i].getSenderId());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "Sender" + String.valueOf(msgprops[i].getSenderId()));
                    ((AQjmsMessage)messages[i]).setOriginalMessageId(msgprops[i].getOriginalMsgid());
                    ((AQjmsMessage)messages[i]).setSignature(msgprops[i].getSignature());
                    if (!dest_queue.isSharded() && ((AQjmsMessage)messages[i]).isJMSBody() && this.jms_sess.getCompliant()) {
                        messages[i].setJMSPriority(AQjmsMessage.toJMSPriority(messages[i].getJMSPriority()));
                    }
                    if (this.cd_factory == null && this.od_factory == null && this.orad_factory == null && anyd_msg == null || anyd_jms) {
                        header_ext = ((AQjmsMessage)messages[i]).getMessageHeaderExt();
                        prop_list = header_ext.getProperties();
                        props_ht = prop_list == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(prop_list);
                        ((AQjmsMessage)messages[i]).setPropertiesHashtable(props_ht);
                    }
                    if (props_ht != null && props_ht.get("JMS_OracleHeaderOnly") != null) {
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", " Header only, Copying to generic msg");
                        AQjmsMessage hdronly_msg = new AQjmsMessage((AQjmsMessage)messages[i]);
                        messages[i] = null;
                        messages[i] = hdronly_msg;
                        ((AQjmsMessage)messages[i]).setHeaderOnly();
                    }
                    if (props_ht != null && props_ht.get("JMS_OracleDeliveryMode") != null) {
                        messages[i].setJMSDeliveryMode(Integer.parseInt(messages[i].getStringProperty("JMS_OracleDeliveryMode")));
                    }
                    if (messages[i].getJMSExpiration() <= 0L) {
                        messages[i].setJMSExpiration(0L);
                    } else {
                        messages[i].setJMSExpiration(messages[i].getJMSExpiration() * 1000L + messages[i].getJMSTimestamp());
                    }
                    Date recv_time = new Date();
                    ((AQjmsMessage)messages[i]).setReceiveTime(recv_time.getTime());
                    if (attempts > 0) {
                        messages[i].setJMSRedelivered(true);
                    } else {
                        messages[i].setJMSRedelivered(false);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "recv_time: " + String.valueOf(recv_time));
                    ((AQjmsMessage)messages[i]).setPropReadOnly(true);
                    ((AQjmsMessage)messages[i]).setAccessMode(0);
                    messages[i].setJMSDestination((Destination)dest_queue);
                }
            }
            if (!in_listener) {
                this.doCommit(this.jms_sess);
            }
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sql_ex2) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if ((sql_ex2.getErrorCode() == 25228 || sql_ex2.getErrorCode() == 25263) && msg_dequeue_mode != 4) {
                messages = null;
            } else {
                AQjmsError.throwEx(120, (Throwable)sql_ex2);
            }
        }
        catch (Exception ex3) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.bulkDequeue-ex3", ex3);
            AQjmsError.throwEx(120, (Throwable)ex3);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "exit-2");
        return messages;
    }

    private long[] calculateValuesForTimeout(long timeout) {
        long timeoutInSecond = 0L;
        if (timeout == 0L) {
            timeoutInSecond = 0L;
        } else if (timeout > 0L) {
            timeoutInSecond = timeout / 1000L;
            if (timeoutInSecond == 0L) {
                timeoutInSecond = 1L;
            }
        } else {
            timeoutInSecond = -1L;
        }
        long interval = this.jms_sess.getCloseCheckInterval();
        long iterations = 0L;
        long lastInterval = 0L;
        if (timeoutInSecond != -1L) {
            if (timeoutInSecond > interval) {
                iterations = timeoutInSecond / interval;
                lastInterval = timeoutInSecond % interval;
                if (lastInterval <= 0L) {
                    lastInterval = interval;
                }
            } else {
                iterations = 1L;
                lastInterval = timeoutInSecond;
            }
        }
        long[] results = new long[]{timeoutInSecond, interval, ++iterations, lastInterval};
        return results;
    }

    AQjmsNtfRegistration getNtfReg() {
        return this.ntfReg;
    }

    private synchronized void setMessageListenerForNotification(MessageListener msgListener) throws JMSException {
        if (this.ntfReg == null) {
            AQjmsNtfRegistration reg = new AQjmsNtfRegistration(this, this.jms_sess, msgListener);
            try {
                reg.registerJdbcNotification();
                this.ntfReg = reg;
                this.attach(this.ntfReg);
                this.jms_sess.usedJMSRegistration = true;
            }
            catch (JMSException exp) {
                AQjmsOracleDebug.traceEx(5, "setMessageListenerForNotification", exp);
                throw exp;
            }
        } else {
            this.ntfReg.setMessageListener(msgListener);
            if (msgListener == null) {
                this.ntfReg = null;
            }
        }
    }

    @Override
    void startJMSNotification() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.startJMSNotification", "starting JMS Notification");
            this.ntfReg.startJMSNotification();
        }
    }

    @Override
    void stopJMSNotification() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.stopJMSNotification", "stopping JMS Notification");
            this.ntfReg.stopJMSNotification();
        }
    }

    boolean isRegistrationDisabled() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.isRegistrationDisabled", "check the status of the registration");
            return this.ntfReg.isRegistrationDisabled();
        }
        return true;
    }

    void disableConsumerExceptionListener() {
        if (this.ntfReg == null) {
            return;
        }
        this.ntfReg.disableConsumerExceptionListener();
    }
}

