/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.HIGH_AVAILABILITY})
public abstract class FailoverDriver {
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final LinkedList<Event> recentHAEvents = new LinkedList();
    private static final long EVENT_AGE_OUT_PERIOD = 120000L;
    private UCPTimerTaskImpl delayedPlannedDownTimerTask = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private static final String FAN_STATUS_FIELD = "status";
    private static final Pattern ff_pg1;
    private static final Pattern ff_pg2;
    private static final Pattern ff_pg3;
    private static final Pattern ff_pg4;
    private static final Pattern ff_pg5;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    FailoverDriver() {
        this(UniversalConnectionPoolManagerBase.getTaskManager());
    }

    FailoverDriver(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    protected abstract ConnectionSource.FailoverCallback.Result onEvent(Event var1, Selector var2, Selector var3, boolean var4, boolean var5);

    protected abstract Service service();

    private Task<Object> prepareTask(final ONSDriver onsDriver) {
        return new UCPTaskBase<Object>(){
            Subscriber subscriber = null;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public boolean isCritical() {
                return true;
            }

            @Override
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            public void run() {
                try {
                    this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Subscriber run() throws UniversalConnectionPoolException {
                            try {
                                return onsDriver.createSubscriber("((%\"eventType=database/event/service\")&($%'service=" + FailoverDriver.this.service().name() + "'))|(%\"eventType=database/event/host\")");
                            }
                            catch (Exception e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                                throw new UniversalConnectionPoolException(e);
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (null == this.subscriber) {
                        return;
                    }
                    this.handleNotifications();
                }
                catch (PrivilegedActionException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    if (null != this.subscriber) {
                        this.subscriber.close();
                        this.subscriber = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            private void handleNotifications() {
                FailoverDriver.this.terminate.set(false);
                while (true) {
                    if (Thread.currentThread().isInterrupted() || FailoverDriver.this.terminate.get()) {
                        ClioSupport.ilogFine(null, null, null, null, "terminated");
                        return;
                    }
                    try {
                        abstract class XSelector
                        implements Selector {
                            final /* synthetic */ Event.EventType val$eventType;
                            final /* synthetic */ String val$instname;
                            final /* synthetic */ String val$service;
                            final /* synthetic */ String val$hostname;
                            final /* synthetic */ String val$database;
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            XSelector() {
                                this.val$eventType = eventType;
                                this.val$instname = string;
                                this.val$service = string2;
                                this.val$hostname = string3;
                                this.val$database = string4;
                            }

                            protected boolean toHandle(CoreConnection conn) {
                                ServiceMember inst = conn.serviceMember();
                                if (null == inst) {
                                    return false;
                                }
                                if (Event.EventType.INSTANCE == this.val$eventType || Event.EventType.SERVICEMEMBER == this.val$eventType) {
                                    return inst.name().equals(this.val$instname) && inst.service().equals(this.val$service) && inst.host().equals(this.val$hostname) && inst.database().equals(this.val$database);
                                }
                                if (Event.EventType.SERVICE == this.val$eventType) {
                                    return inst.service().equals(this.val$service) && inst.database().equals(this.val$database);
                                }
                                if (Event.EventType.NODE == this.val$eventType) {
                                    return inst.host().equals(this.val$hostname);
                                }
                                return false;
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = XSelector.class.getDeclaredConstructor(1.class, Event.EventType.class, String.class, String.class, String.class, String.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = XSelector.class.getDeclaredMethod("toHandle", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        }
                        ServiceMember inst;
                        Notification notification = this.subscriber.receive(true);
                        FailoverDriver.this.service().fdStats.currentEvent.set(null);
                        if (notification == null) {
                            ClioSupport.ilogFine(null, null, null, null, "empty notification");
                            continue;
                        }
                        String nType = notification.type();
                        ClioSupport.ilogFinest(null, null, null, null, nType.toString());
                        String nBody = new String(notification.body());
                        ClioSupport.ilogFinest(null, null, null, null, nBody.toString());
                        final Event event = notification.get(FailoverDriver.FAN_STATUS_FIELD) != null ? FailoverDriver.this.createEvent(notification) : FailoverDriver.this.parseNotification(nType.toLowerCase(), nBody.toLowerCase());
                        final String service = event.serviceName();
                        final String database = event.database();
                        final String hostname = event.host();
                        final Event.EventType eventType = event.event_type();
                        FailoverDriver.this.service().fdStats.currentEvent.set(event);
                        if ((Event.EventType.INSTANCE == eventType || Event.EventType.SERVICEMEMBER == eventType || Event.EventType.SERVICE == eventType) && (null == service || service.equals("") || null == database || database.equals(""))) {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid service event: not processed");
                            FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                            continue;
                        }
                        if (Event.EventType.NODE == eventType && (null == hostname || hostname.equals(""))) {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid host down event: not processed");
                            FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                            continue;
                        }
                        if (FailoverDriver.this.filtered(event)) continue;
                        FailoverDriver.this.recentEvent = event;
                        FailoverDriver.this.service().markup(event);
                        ClioSupport.ilogFinest(null, null, null, null, event.toString());
                        Event.Status status = event.status();
                        final boolean planned = event.isPlanned();
                        final String instname = event.instance();
                        ServiceMember serviceMember = inst = Event.EventType.SERVICEMEMBER == eventType || Event.EventType.INSTANCE == eventType ? FailoverDriver.this.service().getMember(instname, event.database(), event.host(), event.serviceName()) : null;
                        if (Event.Status.DOWN == status || Event.Status.NOT_RESTARTING == status || Event.Status.RESTART_FAILED == status) {
                            int drainTotal;
                            int estPoolSize = FailoverDriver.this.service().activeCount() + FailoverDriver.this.service().borrowedCount();
                            final int drainingPeriod = event.drain_timeout() > 0 ? event.drain_timeout() : (estPoolSize <= 5 ? 0 : Util.getPlannedDrainingPeriod());
                            FailoverDriver.this.service().setLastDrainTimeout(drainingPeriod);
                            boolean noOtherInstanceUp = FailoverDriver.this.service().activeMembersCount() == 0;
                            TimerManager timerMngr = UniversalConnectionPoolManagerBase.getTimerManager();
                            int n = noOtherInstanceUp ? FailoverDriver.this.service().activeCount() : (drainTotal = null == inst ? 0 : inst.activeCount.get());
                            if (planned && drainingPeriod > 0 && timerMngr.isRunning()) {
                                final UCPTimerTaskImpl drainingTimerTask = new UCPTimerTaskImpl(){
                                    final int drainIntervals;
                                    final int countToDrainPerInterval;
                                    int countDrainedThisInterval;
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        this.drainIntervals = (drainingPeriod + Util.PLANNED_DRAINING_INTERVAL - 1) / Util.PLANNED_DRAINING_INTERVAL;
                                        this.countToDrainPerInterval = (drainTotal + this.drainIntervals - 1) / this.drainIntervals;
                                        this.countDrainedThisInterval = 0;
                                    }

                                    @Override
                                    @DefaultLogger(value="oracle.ucp.common")
                                    @Supports(value={Feature.HIGH_AVAILABILITY})
                                    public void run() {
                                        this.countDrainedThisInterval = 0;
                                        FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                            private static Executable $$$methodRef$$$0;
                                            private static Logger $$$loggerRef$$$0;
                                            private static Executable $$$methodRef$$$1;
                                            private static Logger $$$loggerRef$$$1;
                                            {
                                                super(this, eventType2, string4, string3, string2, string);
                                            }

                                            @Override
                                            public boolean selected(CoreConnection conn) {
                                                if (!conn.available()) {
                                                    return false;
                                                }
                                                if (countDrainedThisInterval >= countToDrainPerInterval) {
                                                    return false;
                                                }
                                                boolean retValue = this.toHandle(conn);
                                                if (retValue) {
                                                    ++countDrainedThisInterval;
                                                }
                                                return retValue;
                                            }

                                            static {
                                                try {
                                                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(2.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                                try {
                                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            }
                                        }, new XSelector(){
                                            private static Executable $$$methodRef$$$0;
                                            private static Logger $$$loggerRef$$$0;
                                            private static Executable $$$methodRef$$$1;
                                            private static Logger $$$loggerRef$$$1;
                                            {
                                                super(this, eventType2, string4, string3, string2, string);
                                            }

                                            @Override
                                            public boolean selected(CoreConnection conn) {
                                                if (conn.available()) {
                                                    return false;
                                                }
                                                if (countDrainedThisInterval >= countToDrainPerInterval) {
                                                    return false;
                                                }
                                                if (!conn.normal()) {
                                                    return false;
                                                }
                                                boolean retValue = this.toHandle(conn);
                                                if (retValue) {
                                                    ++countDrainedThisInterval;
                                                }
                                                return retValue;
                                            }

                                            static {
                                                try {
                                                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(2.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                                try {
                                                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            }
                                        }, true, false));
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(1.class, Integer.TYPE, Integer.TYPE, Event.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                };
                                if (noOtherInstanceUp) {
                                    FailoverDriver.this.delayedPlannedDownTimerTask = drainingTimerTask;
                                } else {
                                    UniversalConnectionPoolManagerBase.getTimerManager().schedule(drainingTimerTask, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                    UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){
                                        private static Executable $$$methodRef$$$0;
                                        private static Logger $$$loggerRef$$$0;
                                        private static Executable $$$methodRef$$$1;
                                        private static Logger $$$loggerRef$$$1;

                                        @Override
                                        public void run() {
                                            drainingTimerTask.cancel();
                                            if (FailoverDriver.this.isGDS()) {
                                                FailoverDriver.this.agingOutEvents();
                                            }
                                        }

                                        static {
                                            try {
                                                $$$methodRef$$$1 = 3.class.getDeclaredConstructor(1.class, UCPTimerTaskImpl.class);
                                            }
                                            catch (Throwable throwable) {}
                                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            try {
                                                $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                                            }
                                            catch (Throwable throwable) {}
                                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        }
                                    }, drainingPeriod * 1000 + 100, 0L);
                                }
                            } else {
                                FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        super(this, eventType2, string4, string3, string2, string);
                                    }

                                    @Override
                                    public boolean selected(CoreConnection conn) {
                                        if (planned && !conn.available()) {
                                            return false;
                                        }
                                        if (!planned && conn.reconnecting()) {
                                            return false;
                                        }
                                        return this.toHandle(conn);
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 4.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, new XSelector(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        super(this, eventType2, string4, string3, string2, string);
                                    }

                                    @Override
                                    public boolean selected(CoreConnection conn) {
                                        if (!planned || conn.available()) {
                                            return false;
                                        }
                                        if (!conn.normal()) {
                                            return false;
                                        }
                                        return this.toHandle(conn);
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 5.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 5.class.getDeclaredMethod("selected", CoreConnection.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, false, false));
                            }
                        } else if (Event.Status.UP == status) {
                            FailoverDriver.this.service().markConnCreationBrokerOperable();
                            if (0 == FailoverDriver.this.service().activeMembersCount()) {
                                FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, Selectors.NONE, Selectors.NONE, false, false));
                                continue;
                            }
                            int drainingPeriod = FailoverDriver.this.service().getLastDrainTimeout();
                            if (FailoverDriver.this.delayedPlannedDownTimerTask != null) {
                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(FailoverDriver.this.delayedPlannedDownTimerTask, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;

                                    @Override
                                    public void run() {
                                        FailoverDriver.this.delayedPlannedDownTimerTask.cancel();
                                        if (FailoverDriver.this.isGDS()) {
                                            FailoverDriver.this.agingOutEvents();
                                        }
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 6.class.getDeclaredConstructor(1.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 6.class.getDeclaredMethod("run", new Class[0]);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, drainingPeriod * 1000 + 100, 0L);
                                FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, Selectors.NONE, Selectors.NONE, false, false));
                                continue;
                            }
                            int total = FailoverDriver.this.service().connectionSource().totalCount().get();
                            int members = FailoverDriver.this.service().activeMembersCount();
                            final int averageCount = total / members;
                            final int[] count = new int[]{total - (members - 1) * averageCount};
                            ClioSupport.ilogFinest(null, null, null, null, "total=" + total + ", members=" + members + ", averageCount=" + averageCount + ", count=" + count[0]);
                            FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string4, string3, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection conn) {
                                    if (!conn.available()) {
                                        return false;
                                    }
                                    if (!this.toHandle(conn) && conn.serviceMember().activeCount.get() > averageCount) {
                                        int n = count[0];
                                        count[0] = n - 1;
                                        return n > 0;
                                    }
                                    return false;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Integer.TYPE, int[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string4, string3, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection conn) {
                                    if (conn.available()) {
                                        return false;
                                    }
                                    if (!this.toHandle(conn) && conn.serviceMember().activeCount.get() > averageCount) {
                                        int n = count[0];
                                        count[0] = n - 1;
                                        return n > 0;
                                    }
                                    return false;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 8.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Integer.TYPE, int[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, false, true));
                        } else if (Event.Status.NODEDOWN == status) {
                            FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string4, string3, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection conn) {
                                    if (planned && !conn.available()) {
                                        return false;
                                    }
                                    if (!planned && conn.reconnecting()) {
                                        return false;
                                    }
                                    return this.toHandle(conn);
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 9.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 9.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string4, string3, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection conn) {
                                    if (!planned || conn.available()) {
                                        return false;
                                    }
                                    if (!conn.normal()) {
                                        return false;
                                    }
                                    return this.toHandle(conn);
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 10.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 10.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, false, false));
                        } else {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid event");
                        }
                        if (!FailoverDriver.this.isGDS()) continue;
                        FailoverDriver.this.agingOutEvents();
                        continue;
                    }
                    catch (Throwable e) {
                        ClioSupport.ilogFine(null, null, null, null, e.toString());
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                        continue;
                    }
                    finally {
                        ClioSupport.ilogFine(null, null, null, null, "event processed, snapshot:" + FailoverDriver.this.service().getAllMembers().toString());
                        continue;
                    }
                    break;
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(FailoverDriver.class, ONSDriver.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("handleNotifications", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isCritical", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private ConnectionSource.FailoverCallback.Result onEventX(Event event, Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
        this.service().pendingRebalance.getAndSet(new ConnectionSource.RebalanceCallback.Result()).terminate();
        return this.onEvent(event, cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
    }

    private Event createEvent(Notification n) {
        return new EventImpl(n);
    }

    Event parseNotification(String nTypeLowerCase, String nBodyLowerCase) {
        Matcher mg3;
        Properties props = new Properties();
        Matcher mg1 = ff_pg1.matcher(nBodyLowerCase);
        while (mg1.find()) {
            props.setProperty(mg1.group(1), mg1.group(2));
        }
        Matcher mg2 = ff_pg2.matcher(nBodyLowerCase);
        if (mg2.find()) {
            if (ff_pg4.matcher(mg2.group(2)).find()) {
                props.setProperty(mg2.group(1), mg2.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + mg2.group(2));
            }
        }
        if ((mg3 = ff_pg3.matcher(nBodyLowerCase)).find()) {
            if (ff_pg5.matcher(mg3.group(2)).find()) {
                props.setProperty(mg3.group(1), mg3.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + mg3.group(2));
            }
        }
        return new EventImpl(props, nTypeLowerCase);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo cri) {
        Event event = this.recentEvent;
        if (null == event) {
            return null;
        }
        ServiceMember underloadedInstance = null;
        int maxdiff = 0;
        for (ServiceMember instance : this.service().getAllMembers(cri, true)) {
            int diff;
            int desiredCount;
            int actualCount;
            if (!instance.active() || (actualCount = instance.activeCount.get()) >= (desiredCount = this.service().activeCount() / this.service().activeMembersCount()) || (diff = desiredCount - actualCount) <= maxdiff) continue;
            maxdiff = diff;
            underloadedInstance = instance;
        }
        return underloadedInstance;
    }

    public boolean start(ONSDriver onsDriver) {
        if (this.task.compareAndSet(null, this.prepareTask(onsDriver))) {
            this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
            ClioSupport.ilogFinest(null, null, null, null, "started");
        }
        return true;
    }

    public void stop() {
        Task t = this.task.getAndSet(null);
        if (null != t) {
            block4: {
                t.release();
                this.terminate.set(true);
                try {
                    TaskHandle th = this.taskHandle.getAndSet(null);
                    if (null != th) {
                        th.get(100000L);
                    }
                }
                catch (TaskManagerException e) {
                    if (e.getCause() instanceof CancellationException) break block4;
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }
            ClioSupport.ilogFinest(null, null, null, null, "stopped");
        }
    }

    private boolean filtered(Event newEvent) {
        if (this.recentEvent != null && newEvent.timestamp().before(this.recentEvent.timestamp())) {
            ClioSupport.ilogWarning(null, null, null, null, "Out-of-order HA event received and ignored");
            this.service().fdStats.update(Stats.OUTOFORDER_EVENT_PROC_RESULT);
            return true;
        }
        if (newEvent.event_type() != Event.EventType.NODE && newEvent.event_type() != Event.EventType.UNKNOWN && !newEvent.serviceName().equals(this.service().name())) {
            ClioSupport.ilogWarning(null, null, null, null, "Non-Applicable HA event received and ignored: different service name");
            return true;
        }
        if (!this.isGDS()) {
            return false;
        }
        Iterator<Event> iterator = this.recentHAEvents.descendingIterator();
        boolean foundRedundant = false;
        Event.EventType newType = newEvent.event_type();
        String newSvc = newEvent.serviceName();
        String newInst = newEvent.instance();
        String newDb = newEvent.database();
        String newHst = newEvent.host();
        Event.Status newStat = newEvent.status();
        if (Event.EventType.INSTANCE == newType || Event.EventType.SERVICEMEMBER == newType || Event.EventType.SERVICE == newType) {
            String nextInstName = null;
            while (iterator.hasNext()) {
                Event nextEvent = iterator.next();
                nextInstName = nextEvent.instance();
                if (newStat == null || !newStat.equals((Object)nextEvent.status()) || newSvc == null || !newSvc.equals(nextEvent.serviceName()) || newDb == null || !newDb.equals(nextEvent.database()) || newHst == null || !newHst.equals(nextEvent.host()) || !(newInst == null && nextInstName == null || newInst == null && nextInstName != null && (newStat == Event.Status.DOWN && this.service().activeMembersCount() < 1 || newStat == Event.Status.UP && this.service().activeMembersCount() <= 1)) && (newInst == null || nextInstName != null && !newInst.equals(nextInstName))) continue;
                foundRedundant = true;
                ClioSupport.ilogWarning(null, null, null, null, "Redundant HA service event received and ignored: the event with the same set of instance, database, host and service has already arrived in less than 120000 milliseconds");
                break;
            }
        } else if (Event.EventType.NODE == newType) {
            while (iterator.hasNext()) {
                Event nextEvent = iterator.next();
                if (newHst == null || !newHst.equals(nextEvent.host())) continue;
                foundRedundant = true;
                ClioSupport.ilogFinest(null, null, null, null, "Redundant HA host event received and ignored");
                break;
            }
        }
        if (!foundRedundant) {
            this.recentHAEvents.addLast(newEvent);
        } else {
            this.service().fdStats.update(Stats.REDUNDANT_EVENT_PROC_RESULT);
        }
        return foundRedundant;
    }

    private boolean isGDS() {
        Service service = this.service();
        if (null == service) {
            return false;
        }
        String serviceName = service.name();
        if (null == serviceName) {
            return false;
        }
        return serviceName.contains("%");
    }

    private void agingOutEvents() {
        if (this.recentEvent != null) {
            Event nextEvent;
            long recentMilli = this.recentEvent.timestamp().getTime();
            while ((nextEvent = this.recentHAEvents.peekFirst()) != null && recentMilli > nextEvent.timestamp().getTime() + 120000L) {
                this.recentHAEvents.removeFirst();
            }
        }
    }

    static {
        try {
            $$$methodRef$$$11 = FailoverDriver.class.getDeclaredConstructor(TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = FailoverDriver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = FailoverDriver.class.getDeclaredMethod("agingOutEvents", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = FailoverDriver.class.getDeclaredMethod("isGDS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = FailoverDriver.class.getDeclaredMethod("filtered", Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = FailoverDriver.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = FailoverDriver.class.getDeclaredMethod("start", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = FailoverDriver.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = FailoverDriver.class.getDeclaredMethod("parseNotification", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = FailoverDriver.class.getDeclaredMethod("createEvent", Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = FailoverDriver.class.getDeclaredMethod("onEventX", Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = FailoverDriver.class.getDeclaredMethod("prepareTask", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        ff_pg1 = Pattern.compile("(version|event_type|service|instance|database|db_domain|host|status|reason|card|drain_timeout)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
        ff_pg2 = Pattern.compile("(timestamp)=\\s*(\\S+\\s\\S+)");
        ff_pg3 = Pattern.compile("(timezone)=(.*)");
        ff_pg4 = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}");
        ff_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
    }

    @DisableTrace
    public static class Stats
    extends RingBuffer<StatsOne> {
        final AtomicReference<Event> currentEvent = new AtomicReference<Object>(null);
        static final ConnectionSource.FailoverCallback.Result INVALID_EVENT_PROC_RESULT;
        static final ConnectionSource.FailoverCallback.Result REDUNDANT_EVENT_PROC_RESULT;
        static final ConnectionSource.FailoverCallback.Result OUTOFORDER_EVENT_PROC_RESULT;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        void update(ConnectionSource.FailoverCallback.Result newResult) {
            Event evt = this.currentEvent.get();
            if (evt != null && newResult != null) {
                this.addItem(new StatsOne(evt, newResult));
            }
        }

        public String toStringProcessedOnly() {
            StringBuilder sb = new StringBuilder();
            List<StatsOne> list = this.getAsList();
            list.forEach(p -> {
                ConnectionSource.FailoverCallback.Result r = p.getResult();
                if (ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED != r.type && ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED != r.type && ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED != r.type) {
                    sb.append(p.toString());
                }
            });
            return sb.toString();
        }

        static {
            try {
                $$$methodRef$$$3 = Stats.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Stats.class.getDeclaredMethod("lambda$toStringProcessedOnly$0", StringBuilder.class, StatsOne.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Stats.class.getDeclaredMethod("toStringProcessedOnly", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Stats.class.getDeclaredMethod("update", ConnectionSource.FailoverCallback.Result.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            INVALID_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED);
            REDUNDANT_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED);
            OUTOFORDER_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED);
        }
    }

    @DisableTrace
    static class StatsOne {
        Event eventToProcess = null;
        ConnectionSource.FailoverCallback.Result procResult = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        StatsOne(Event evt, ConnectionSource.FailoverCallback.Result rslt) {
            this.eventToProcess = evt;
            this.procResult = rslt;
        }

        private Event getEvent() {
            if (null == this.eventToProcess) {
                throw new IllegalStateException();
            }
            return this.eventToProcess;
        }

        private ConnectionSource.FailoverCallback.Result getResult() {
            if (null == this.procResult) {
                throw new IllegalStateException();
            }
            return this.procResult;
        }

        private String reason() {
            Event.EventType type;
            Event event = this.getEvent();
            String reason = event.reason();
            if (!("".equals(reason) || Event.Status.DOWN != event.status() || (type = event.event_type()) != Event.EventType.SERVICE && type != Event.EventType.SERVICEMEMBER && type != Event.EventType.NODE && type != Event.EventType.INSTANCE)) {
                return " <Reason:" + reason + ">";
            }
            return "";
        }

        private String targets() {
            Event event = this.getEvent();
            Event.Status status = event.status();
            return Event.EventType.NODE == event.event_type() && (Event.Status.NODEDOWN == status || Event.Status.NODEUP == status) ? " <Host:\"" + event.host() + "\">" : " <Service:\"" + event.serviceName() + "\">" + " <Instance:\"" + event.instance() + "\">" + " <Db:\"" + event.database() + "\">";
        }

        private String counts() {
            ConnectionSource.FailoverCallback.Result r = this.getResult();
            return " Connections:" + "(Available=" + r.availConns + " Opened=" + r.availOpened + " FailedToProcess=" + r.availFailedToProcess + " MarkedDown=" + r.availMarkedDown + " Closed=" + r.availClosed + ")" + "(Borrowed=" + r.borrowedConns + " FailedToProcess=" + r.borrowedFailedToProcess + " MarkedDown=" + r.borrowedMarkedDown + " Closed=" + r.borrowedClosed + ")";
        }

        private String type() {
            Event event = this.getEvent();
            Event.EventType et = event.event_type();
            Event.Status status = event.status();
            Object type = Event.EventType.SERVICE == et || Event.EventType.SERVICEMEMBER == et ? (Event.Status.DOWN == status ? "SERVICE_DOWN" : "SERVICE_UP") : (Event.EventType.NODE == et ? (Event.Status.NODEDOWN == status ? "HOST_DOWN" : "HOST_UP") : (Event.EventType.INSTANCE == et ? (Event.Status.DOWN == status ? "INSTANCE_DOWN" : "INSTANCE_UP") : et.toString() + "_" + status.toString()));
            return " <Type:" + (String)type + ">";
        }

        @DisableTrace
        public String toString() {
            Event event = this.getEvent();
            ConnectionSource.FailoverCallback.Result r = this.getResult();
            switch (r.type) {
                case INVALID_NOT_PROCESSED: 
                case REDUNDANT_NOT_PROCESSED: 
                case OUTOFORDER_NOT_PROCESSED: {
                    return DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)r.type) + this.reason() + this.type() + this.targets();
                }
            }
            return "{" + DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)r.type) + this.reason() + this.type() + this.targets() + this.counts() + "}\n";
        }

        static {
            try {
                $$$methodRef$$$7 = StatsOne.class.getDeclaredConstructor(Event.class, ConnectionSource.FailoverCallback.Result.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = StatsOne.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = StatsOne.class.getDeclaredMethod("type", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = StatsOne.class.getDeclaredMethod("counts", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = StatsOne.class.getDeclaredMethod("targets", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = StatsOne.class.getDeclaredMethod("reason", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = StatsOne.class.getDeclaredMethod("getResult", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = StatsOne.class.getDeclaredMethod("getEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.HIGH_AVAILABILITY})
    static class EventImpl
    implements Event {
        private final String version;
        private final String service;
        private Event.EventType event_type;
        private final String database;
        private final String instance;
        private final String host;
        private final String db_domain;
        private final String reason;
        private final Event.Status status;
        private final boolean isPlanned;
        private final boolean isTypeHost;
        private final boolean isTypeService;
        private final int cardinality;
        private final int drain_timeout;
        private Date timestamp;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;

        EventImpl(Notification n) {
            this.version = n.get("VERSION");
            this.service = EventImpl.toLowerCase(n.get("service"));
            String etype = EventImpl.toLowerCase(n.get("event_type"));
            this.event_type = Event.EventType.parse(etype == null ? "UNKNOWN" : etype);
            this.database = EventImpl.toLowerCase(n.get("database"));
            this.instance = EventImpl.toLowerCase(n.get("instance"));
            this.host = EventImpl.toLowerCase(n.get("host"));
            this.db_domain = EventImpl.toLowerCase(n.get("db_domain"));
            String r = EventImpl.toLowerCase(n.get("reason"));
            this.reason = r == null ? "" : r;
            String stat = EventImpl.toLowerCase(n.get(FailoverDriver.FAN_STATUS_FIELD));
            this.status = Event.Status.parse(stat == null ? "down" : stat);
            String nTypeLowerCase = EventImpl.toLowerCase(n.type());
            this.isPlanned = "user".equalsIgnoreCase(this.reason);
            this.isTypeHost = "database/event/host".equals(nTypeLowerCase);
            this.isTypeService = "database/event/service".equals(nTypeLowerCase);
            String card = n.get("card");
            this.cardinality = Integer.parseInt(card == null ? "0" : card);
            String timeout = n.get("drain_timeout");
            this.drain_timeout = Integer.parseInt(timeout == null ? "0" : timeout);
            this.checkEventType();
            String tsprop = n.get("timestamp");
            String ts = tsprop == null ? "" : tsprop;
            String tzprop = n.get("timezone");
            String tz = tzprop == null ? "" : tzprop;
            this.initializeTimestamp(ts, tz);
        }

        EventImpl(Properties props, String nTypeLowerCase) {
            this.version = props.getProperty("version");
            this.service = props.getProperty("service");
            this.event_type = Event.EventType.parse(props.getProperty("event_type", "UNKNOWN"));
            this.database = props.getProperty("database");
            this.instance = props.getProperty("instance");
            this.host = props.getProperty("host");
            this.db_domain = props.getProperty("db_domain");
            this.reason = props.getProperty("reason", "");
            this.status = Event.Status.parse(props.getProperty(FailoverDriver.FAN_STATUS_FIELD, "down"));
            this.isPlanned = "user".equals(this.reason);
            this.isTypeHost = "database/event/host".equals(nTypeLowerCase);
            this.isTypeService = "database/event/service".equals(nTypeLowerCase);
            this.cardinality = Integer.parseInt(props.getProperty("card", "0"));
            this.drain_timeout = Integer.parseInt(props.getProperty("drain_timeout", "0"));
            this.checkEventType();
            String ts = props.getProperty("timestamp", "");
            String tz = props.getProperty("timezone", "");
            this.initializeTimestamp(ts, tz);
        }

        private void checkEventType() {
            if (this.event_type == Event.EventType.UNKNOWN) {
                if (this.isTypeHost) {
                    this.event_type = Event.EventType.NODE;
                } else if (this.isTypeService) {
                    this.event_type = null == this.instance ? Event.EventType.SERVICE : Event.EventType.SERVICEMEMBER;
                }
                ClioSupport.ilogFinest(null, null, null, null, "derived event type is " + this.event_type);
            }
            if (!(this.event_type != Event.EventType.SERVICEMEMBER && this.event_type != Event.EventType.INSTANCE || null != this.version && null != this.service && null != this.host && null != this.database && null != this.instance)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type == Event.EventType.SERVICE && (null == this.version || null == this.service || null == this.host || null == this.database)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type == Event.EventType.NODE && (null == this.version || null == this.host)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
        }

        private void initializeTimestamp(String ts, String tz) {
            if ("".equals(ts) && !"".equals(tz)) {
                throw new IllegalStateException("single timezone (without timestamp) is not allowed");
            }
            if ("".equals(ts)) {
                this.timestamp = new Date();
            } else {
                try {
                    this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(ts + " GMT" + tz);
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private static String toLowerCase(String s) {
            return null == s ? null : s.toLowerCase();
        }

        @DisableTrace
        public String toString() {
            return "isTypeService=" + this.isTypeService + ", version=" + this.version() + ", service=" + this.serviceName() + ", event_type=" + (Object)((Object)this.event_type()) + ", db_domain=" + this.db_domain() + ", instance=" + this.instance() + ", host=" + this.host() + ", database=" + this.database() + ", status=" + (Object)((Object)this.status()) + ", isPlanned=" + this.isPlanned() + ", cardinality=" + this.cardinality() + ", drain_timeout=" + this.drain_timeout() + ", timestamp=" + this.timestamp();
        }

        @Override
        @DisableTrace
        public String version() {
            return this.version;
        }

        @Override
        @DisableTrace
        public String serviceName() {
            return this.service;
        }

        @Override
        @DisableTrace
        public Event.EventType event_type() {
            return this.event_type;
        }

        @Override
        @DisableTrace
        public String database() {
            return this.database;
        }

        @Override
        @DisableTrace
        public String instance() {
            return this.instance;
        }

        @Override
        @DisableTrace
        public String host() {
            return this.host;
        }

        @Override
        @DisableTrace
        public String db_domain() {
            return this.db_domain;
        }

        @Override
        @DisableTrace
        public String reason() {
            return this.reason;
        }

        @Override
        @DisableTrace
        public Event.Status status() {
            return this.status;
        }

        @Override
        @DisableTrace
        public boolean isPlanned() {
            return this.isPlanned;
        }

        @Override
        @DisableTrace
        public int cardinality() {
            return this.cardinality;
        }

        @Override
        @DisableTrace
        public Date timestamp() {
            return this.timestamp;
        }

        @Override
        @DisableTrace
        public int drain_timeout() {
            return this.drain_timeout;
        }

        static {
            try {
                $$$methodRef$$$18 = EventImpl.class.getDeclaredConstructor(Properties.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$17 = EventImpl.class.getDeclaredConstructor(Notification.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$16 = EventImpl.class.getDeclaredMethod("drain_timeout", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$15 = EventImpl.class.getDeclaredMethod("timestamp", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$14 = EventImpl.class.getDeclaredMethod("cardinality", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$13 = EventImpl.class.getDeclaredMethod("isPlanned", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$12 = EventImpl.class.getDeclaredMethod(FailoverDriver.FAN_STATUS_FIELD, new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = EventImpl.class.getDeclaredMethod("reason", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = EventImpl.class.getDeclaredMethod("db_domain", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = EventImpl.class.getDeclaredMethod("host", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = EventImpl.class.getDeclaredMethod("instance", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = EventImpl.class.getDeclaredMethod("database", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = EventImpl.class.getDeclaredMethod("event_type", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = EventImpl.class.getDeclaredMethod("serviceName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = EventImpl.class.getDeclaredMethod("version", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = EventImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = EventImpl.class.getDeclaredMethod("toLowerCase", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = EventImpl.class.getDeclaredMethod("initializeTimestamp", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = EventImpl.class.getDeclaredMethod("checkEventType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    public static interface Event {
        public static final String NTYPE_SERVICE = "database/event/service";
        public static final String NTYPE_HOST = "database/event/host";

        public String version();

        public String database();

        public String serviceName();

        public EventType event_type();

        public String instance();

        public String host();

        public String db_domain();

        public Status status();

        public boolean isPlanned();

        public String reason();

        public int cardinality();

        public Date timestamp();

        public int drain_timeout();

        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status DOWN;
            public static final /* enum */ Status NOT_RESTARTING;
            public static final /* enum */ Status RESTART_FAILED;
            public static final /* enum */ Status UP;
            public static final /* enum */ Status NODEDOWN;
            public static final /* enum */ Status NODEUP;
            private static final /* synthetic */ Status[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String name) {
                return Enum.valueOf(Status.class, name);
            }

            static Status parse(String status) {
                for (Status s : Status.values()) {
                    if (!s.toString().toLowerCase().equals(status)) continue;
                    return s;
                }
                throw new IllegalStateException("unknown status " + status);
            }

            static {
                try {
                    $$$methodRef$$$3 = Status.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Status.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Status.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Status.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                DOWN = new Status();
                NOT_RESTARTING = new Status();
                RESTART_FAILED = new Status();
                UP = new Status();
                NODEDOWN = new Status();
                NODEUP = new Status();
                $VALUES = new Status[]{DOWN, NOT_RESTARTING, RESTART_FAILED, UP, NODEDOWN, NODEUP};
            }
        }

        public static final class EventType
        extends Enum<EventType> {
            public static final /* enum */ EventType DATABASE;
            public static final /* enum */ EventType INSTANCE;
            public static final /* enum */ EventType SERVICE;
            public static final /* enum */ EventType SERVICEMEMBER;
            public static final /* enum */ EventType NODE;
            public static final /* enum */ EventType UNKNOWN;
            private static final /* synthetic */ EventType[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static EventType[] values() {
                return (EventType[])$VALUES.clone();
            }

            public static EventType valueOf(String name) {
                return Enum.valueOf(EventType.class, name);
            }

            static EventType parse(String eventType) {
                for (EventType e : EventType.values()) {
                    if (!e.toString().toLowerCase().equals(eventType)) continue;
                    return e;
                }
                return UNKNOWN;
            }

            static {
                try {
                    $$$methodRef$$$3 = EventType.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = EventType.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = EventType.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = EventType.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                DATABASE = new EventType();
                INSTANCE = new EventType();
                SERVICE = new EventType();
                SERVICEMEMBER = new EventType();
                NODE = new EventType();
                UNKNOWN = new EventType();
                $VALUES = new EventType[]{DATABASE, INSTANCE, SERVICE, SERVICEMEMBER, NODE, UNKNOWN};
            }
        }
    }
}

