/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.tuners")
@Supports(value={Feature.ADMIN})
public class PoolSizeTuner {
    public static long TUNEUP_TIMEOUT;
    public static int TURN_RING_TIMEOUT;
    public static long SINGLE_RUN_TIMEOUT;
    private static final AtomicBoolean inProgress;
    private static volatile long giveUpTime;
    private static final AtomicBoolean tunedUp;
    private static List<Tunable> listTunable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public static void trigger() {
        if (!Util.isSelfTunerEnabled()) {
            return;
        }
        giveUpTime = Clock.clock() + SINGLE_RUN_TIMEOUT;
        if (inProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(PoolSizeTuner.getTunerTask());
            }
            catch (RuntimeException e) {
                inProgress.set(false);
            }
        }
    }

    private static UCPTaskBase<Object> getTunerTask() {
        return new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            @DefaultLogger(value="oracle.ucp.tuners")
            @Supports(value={Feature.ADMIN})
            public void run() {
                ClioSupport.ilogFinest(null, null, null, null, "started");
                while (Clock.clock() < giveUpTime) {
                    for (int i = 0; i < TURN_RING_TIMEOUT; ++i) {
                        if (!Util.isSelfTunerEnabled()) {
                            return;
                        }
                        try {
                            Thread.sleep(TUNEUP_TIMEOUT);
                        }
                        catch (InterruptedException e) {
                            ClioSupport.ilogThrowing(null, null, null, null, e);
                        }
                        PoolSizeTuner.tuneUp();
                    }
                    PoolSizeTuner.turnRing();
                }
                inProgress.set(false);
                ClioSupport.ilogFinest(null, null, null, null, "ended");
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
            }
        };
    }

    private static void turnRing() {
        listTunable.forEach(p -> PoolSizeTuner.turnRing(p));
        ClioSupport.ilogFinest(null, null, null, null, "ring turned");
    }

    private static void turnRing(Tunable tunable) {
        tunable.getAvailableRegistry().turnRing();
        tunable.getBorrowedRegistry().turnRing();
        tunable.getCreatedRegistry().turnRing();
    }

    private static void tuneUp() {
        listTunable.forEach(p -> PoolSizeTuner.tuneUp(p));
    }

    private static void tuneUp(Tunable tunable) {
        HistogramRegistry availableRegistry = tunable.getAvailableRegistry().collect();
        HistogramRegistry borrowedRegistry = tunable.getBorrowedRegistry().collect();
        HistogramRegistry createdRegistry = tunable.getCreatedRegistry().collect();
        availableRegistry.forEach((cri, availHist) -> PoolSizeTuner.tuneUp(cri, availHist, borrowedRegistry.getHistogram((ConnectionRetrievalInfo)cri), createdRegistry.getHistogram((ConnectionRetrievalInfo)cri), tunable));
    }

    private static void tuneUp(ConnectionRetrievalInfo cri, Histogram availHist, Histogram borrowHist, Histogram createHist, Tunable tunable) {
        Pair<Long, Long> availER = availHist.computeEffectiveRange();
        Pair<Long, Long> borrowedER = borrowHist.computeEffectiveRange();
        Pair<Long, Long> createdER = createHist.computeEffectiveRange();
        boolean availGrowsInProgress = tunable.availableGrowsInProgress();
        int neverUsedConnCount = tunable.getNeverUsedConnectionsCounter().getCounter(cri).get();
        int totalConnsCount = tunable.getTotalConnectionsCount(cri);
        String msgEnter = "cri=" + cri + ", availER=" + availER + ", borrowER=" + borrowedER + ", createdER=" + createdER + ", availGrowsInProgress=" + availGrowsInProgress + ", neverUsedConnCount=" + neverUsedConnCount + ", totalConnsCount=" + totalConnsCount;
        ClioSupport.ilogFinest(null, null, null, null, msgEnter);
        if (availER.get1st() >= borrowedER.get1st() || availER.get2nd() > borrowedER.get2nd()) {
            long midAvail = availER.get2nd() + availER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToReduce = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midAvail - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToReduce) {
                tunable.getConnectionReducer().reduce(cri);
                ++i;
            }
            String msgReduce = "attempted to reduce " + countToReduce + " connection(s) for CRI=" + cri;
            ClioSupport.ilogFinest(null, null, null, null, msgReduce);
            tunedUp.set(true);
        } else if (!(availGrowsInProgress || 0 != neverUsedConnCount || createdER.get1st() <= borrowedER.get1st() && createdER.get2nd() <= borrowedER.get2nd())) {
            long midCreated = createdER.get2nd() + createdER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToGrow = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midCreated - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToGrow) {
                tunable.getConnectionGrower().grow(cri);
                ++i;
            }
            String msgGrow = "attempted to grow " + countToGrow + " connection(s) for CRI=" + cri;
            ClioSupport.ilogFinest(null, null, null, null, msgGrow);
            tunedUp.set(true);
        } else {
            tunedUp.set(false);
        }
    }

    private PoolSizeTuner() {
    }

    public static void plug(Tunable poolSizeTunerMetadata) {
        listTunable.add(poolSizeTunerMetadata);
    }

    static {
        try {
            $$$methodRef$$$15 = PoolSizeTuner.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$14 = PoolSizeTuner.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$13 = PoolSizeTuner.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$12 = PoolSizeTuner.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$11 = PoolSizeTuner.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$10 = PoolSizeTuner.class.getDeclaredMethod("lambda$turnRing$0", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$9 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$1", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$8 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$2", HistogramRegistry.class, HistogramRegistry.class, Tunable.class, ConnectionRetrievalInfo.class, Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$7 = PoolSizeTuner.class.getDeclaredMethod("plug", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$6 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", ConnectionRetrievalInfo.class, Histogram.class, Histogram.class, Histogram.class, Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$5 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$4 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$3 = PoolSizeTuner.class.getDeclaredMethod("turnRing", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$2 = PoolSizeTuner.class.getDeclaredMethod("turnRing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$1 = PoolSizeTuner.class.getDeclaredMethod("getTunerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$0 = PoolSizeTuner.class.getDeclaredMethod("trigger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        TUNEUP_TIMEOUT = 5000L;
        TURN_RING_TIMEOUT = 5;
        SINGLE_RUN_TIMEOUT = 600000L;
        inProgress = new AtomicBoolean(false);
        giveUpTime = 0L;
        tunedUp = new AtomicBoolean(false);
        listTunable = new ArrayList<Tunable>();
    }
}

