/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCPManifestReader {
    public static void main(String[] args) {
        try {
            System.out.println(UCPManifestReader.formatUCPVersionDetails(new JarFile(UCPManifestReader.findUcpPath(UCPManifestReader.readClassPath())).getManifest().getMainAttributes()));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static List<String> readClassPath() {
        final ArrayList<String> classPath = new ArrayList<String>();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] cp;
                for (String s : cp = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                    classPath.add(s);
                }
                return null;
            }
        });
        return classPath;
    }

    static File findUcpPath(List<String> classPath) {
        String ucpName = "ucp.jar";
        File jarF = new File("ucp.jar");
        for (String s : classPath) {
            File f = new File(s);
            if (!f.getName().equalsIgnoreCase("ucp.jar")) continue;
            jarF = f;
            break;
        }
        return jarF;
    }

    static String formatUCPVersionDetails(Attributes attrs) {
        String implementationTitle = attrs.getValue("Implementation-Title");
        String implementationVersion = attrs.getValue("Implementation-Version");
        String buildInfo = attrs.getValue("Build-Info");
        return new StringBuffer().append(implementationTitle).append("  (Version : ").append(implementationVersion).append(")  (Build : ").append(buildInfo == null ? "N/A" : buildInfo).append(')').toString();
    }
}

