/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.logging.UCPLoggerFactory;

class ReplayableRACManagerImpl
extends RACManagerImpl
implements RACManager,
Failoverable {
    private static final Logger logger = UCPLoggerFactory.createLogger(ReplayableRACManagerImpl.class.getCanonicalName());

    public ReplayableRACManagerImpl(TaskManager taskManager, TimerManager timerManager) throws UniversalConnectionPoolException {
        super(taskManager, timerManager);
    }

    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}", new Object[]{pc, isAvailableConnection, isPlannedDownEvent, actionFlag});
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    if (!isAvailableConnection) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        result = FailoverActionResult.MARKED_BAD;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "setting status failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                if (pc.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD && pc.getStatus() != UniversalPooledConnectionStatus.STATUS_RECONNECTING) {
                    logger.finest("AC replugging already happened - no FCF cleanup");
                    break;
                }
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    logger.log(Level.FINEST, "aborting connection failed: ", this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "closing connection failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }
}

