/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UniversalConnectionPoolManagerHelper {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolManagerHelper.class.getCanonicalName());
    private final UniversalConnectionPool m_connectionPool;
    private static UniversalConnectionPoolManagerImpl m_mgrImpl;

    public UniversalConnectionPoolManagerHelper(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "UniversalConnectionPoolManagerHelper", ucpe);
            throw ucpe;
        }
        this.m_connectionPool = connectionPool;
        m_mgrImpl = (UniversalConnectionPoolManagerImpl)UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
    }

    public void setManagerPoolID(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_mgrImpl.setManagerPoolID(this.m_connectionPool.getName(), poolName);
    }

    public String getManagerPoolID() throws UniversalConnectionPoolException {
        return m_mgrImpl.getManagerPoolID(this.m_connectionPool.getName());
    }

    public void setMetricConsole(DMSConsole metricConsole) {
        m_mgrImpl.setMetricConsole(metricConsole);
    }

    public void setMetricParentNoun(NounIntf metricParentNoun) {
        m_mgrImpl.setMetricParentNoun(this.m_connectionPool.getName(), metricParentNoun);
    }

    public StateIntf getStateMetric(UniversalConnectionPoolManagerBase.UCPMetric ucpMetric) {
        return m_mgrImpl.getStateMetric(this.m_connectionPool.getName(), ucpMetric);
    }
}

