/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.babelfish.BabelfishCallableStatement;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.babelfish.BabelfishPreparedStatement;
import oracle.jdbc.babelfish.BabelfishStatement;
import oracle.jdbc.babelfish.TranslationManager;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleDiagnosabilityMBean;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EZConnectResolver;
import oracle.security.pki.OraclePKIProvider;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONNECT})
public class OracleDriver
implements Driver {
    public static final String oracle_string = "oracle";
    public static final String jdbc_string = "jdbc";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    private final String SIMPLE_URL_FORMAT = "jdbc:oracle:(thin|oci|oci8|kprb):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames;
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    public static final Map<String, Class> systemTypeMap;
    private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
    protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
    private static ObjectName diagnosticMBeanObjectName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    @DisableTrace
    public static void registerMBeans() {
        block14: {
            try {
                Object object;
                Object object2;
                MBeanServer mBeanServer = null;
                try {
                    object2 = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    object = ((Class)object2).newInstance();
                    Method method = ((Class)object2).getMethod("getMBeanServer", new Class[0]);
                    mBeanServer = (MBeanServer)method.invoke(object, new Object[0]);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", noSuchMethodException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", instantiationException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", illegalAccessException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", invocationTargetException);
                    mBeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                if (mBeanServer != null) {
                    object2 = OracleDriver.class.getClassLoader();
                    object = object2 == null ? "nullLoader" : object2.getClass().getName();
                    int n2 = 0;
                    while (true) {
                        String string = object + "@" + Integer.toHexString((object2 == null ? 0 : object2.hashCode()) + n2++);
                        diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + string);
                        try {
                            mBeanServer.registerMBean(new OracleDiagnosabilityMBean(), diagnosticMBeanObjectName);
                            break block14;
                        }
                        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException jMException) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", jMException);
            }
            catch (Throwable throwable) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", throwable);
            }
        }
    }

    @Supports(value={Feature.PLATFORM})
    public static void unRegisterMBeans() {
        try {
            Object object;
            Object object2;
            MBeanServer mBeanServer = null;
            try {
                object2 = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                object = ((Class)object2).newInstance();
                Method method = ((Class)object2).getMethod("getMBeanServer", new Class[0]);
                mBeanServer = (MBeanServer)method.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (mBeanServer != null) {
                try {
                    object2 = OracleDriver.class.getClassLoader();
                    object = object2 == null ? "nullLoader" : object2.getClass().getName();
                    int n2 = 0;
                    String string = object + "@" + Integer.toHexString((object2 == null ? 0 : object2.hashCode()) + n2++);
                    diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + string);
                    mBeanServer.unregisterMBean(diagnosticMBeanObjectName);
                }
                catch (Throwable throwable) {
                    Logger.getLogger("oracle.jdbc").log(Level.INFO, "Unabled to unregister Oracle JDBC Diagnosability MBean: " + throwable.getMessage());
                }
            } else {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer to unregister Oracle JDBC Diagnosability MBean.");
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while unregistering Oracle JDBC Diagnosability MBean.", throwable);
        }
    }

    @Supports(value={Feature.PLATFORM})
    private static void deregister() {
        OracleDriver.unRegisterMBeans();
        OracleTimeoutThreadPerVM.stopWatchdog();
        BlockSource.ThreadedCachingBlockSource.stopBlockReleaserThread();
        HAManager.shutdownAll();
        TimeoutInterruptHandler.stopTimer();
        TxnFailoverManagerImpl.cleanup();
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String string, Properties properties, GSSCredential gSSCredential) throws SQLException {
        Object object;
        Object object2;
        int n2;
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
        }
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string2 = "jdbc:oracle:kprb";
            int n3 = string.length();
            string = n3 > 23 ? string2.concat(string.substring(23, string.length())) : string2.concat(":");
            string2 = null;
        }
        if ((n2 = OracleDriver.oracleDriverExtensionTypeFromURL(string)) == -2) {
            return null;
        }
        if (n2 == -3) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        if (n2 != 0 && gSSCredential != null) {
            throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
        }
        OracleDriverExtension oracleDriverExtension = null;
        oracleDriverExtension = this.driverExtensions[n2];
        if (oracleDriverExtension == null) {
            try {
                object2 = this;
                synchronized (object2) {
                    if (oracleDriverExtension == null) {
                        this.driverExtensions[n2] = oracleDriverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[n2]).newInstance();
                    } else {
                        oracleDriverExtension = this.driverExtensions[n2];
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (!string.matches("jdbc:oracle:(thin|oci|oci8|kprb):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+")) {
            object2 = EZConnectResolver.newInstance(string);
            properties.putAll((Map<?, ?>)((EZConnectResolver)object2).getProperties());
            if (((EZConnectResolver)object2).getResolvedUrl() != null) {
                string = ((EZConnectResolver)object2).getResolvedUrl();
            }
        }
        object2 = DriverManager.getDrivers();
        while (object2.hasMoreElements() && !((object = (Driver)object2.nextElement()) instanceof OracleDriver)) {
        }
        while (object2.hasMoreElements()) {
            object = (Driver)object2.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction((Driver)object){
                    final /* synthetic */ Driver val$driverobj;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.val$driverobj = driver;
                    }

                    public Object run() throws SQLException {
                        DriverManager.deregisterDriver(this.val$driverobj);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(OracleDriver.class, Driver.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (SQLException)privilegedActionException.getException();
            }
        }
        object = null;
        if (n2 != 2 || !properties.containsKey("connection_pool") || !properties.getProperty("connection_pool").equals("connection_pool")) {
            String string3 = null;
            if (properties != null) {
                string3 = properties.getProperty("oracle.jdbc.sqlTranslationProfile");
            }
            if (string3 == null) {
                string3 = PhysicalConnection.getSystemPropertySqlTranslationProfile();
            }
            if (string3 != null) {
                object = this.babelfishConnect(properties, string3, string, oracleDriverExtension, n2);
            } else {
                object = n2 == 0 ? (PhysicalConnection)oracleDriverExtension.getConnection(string, properties, gSSCredential) : (PhysicalConnection)oracleDriverExtension.getConnection(string, properties);
                ((PhysicalConnection)object).protocolId = n2;
            }
        } else {
            object = (PhysicalConnection)oracleDriverExtension.getConnection(string, properties);
            ((PhysicalConnection)object).protocolId = n2;
        }
        return object;
    }

    @Supports(value={Feature.SQL_TRANSLATION})
    private Connection babelfishConnect(Properties properties, String string, String string2, OracleDriverExtension oracleDriverExtension, int n2) throws SQLException {
        Object object;
        properties.put("oracle.jdbc.sqlTranslationProfile", string);
        string = null;
        if (properties != null) {
            string = properties.getProperty("oracle.jdbc.sqlErrorTranslationFile");
        }
        if (string == null) {
            string = System.getProperty("oracle.jdbc.sqlErrorTranslationFile", null);
        }
        if (string != null) {
            properties.put("oracle.jdbc.sqlErrorTranslationFile", string);
        }
        string = null;
        if (properties != null && (string = properties.getProperty(user_string)) == null) {
            string = properties.getProperty("oracle.jdbc.user");
        }
        if (string == null) {
            string = System.getProperty("oracle.jdbc.user", null);
        }
        if (string == null) {
            object = PhysicalConnection.parseUrl(string2);
            string = (String)((Hashtable)object).get(user_string);
        }
        properties.put(user_string, string);
        object = ProxyFactory.createJDBCProxyFactory(BabelfishGenericProxy.class, BabelfishConnection.class, BabelfishStatement.class, BabelfishPreparedStatement.class, BabelfishCallableStatement.class);
        Translator translator = TranslationManager.getTranslator(string2, properties.getProperty(user_string), properties.getProperty("oracle.jdbc.sqlTranslationProfile"), properties.getProperty("oracle.jdbc.sqlErrorTranslationFile"));
        try {
            PhysicalConnection physicalConnection = (PhysicalConnection)oracleDriverExtension.getConnection(string2, properties);
            physicalConnection.protocolId = n2;
            Connection connection = ((ProxyFactory)object).proxyFor(physicalConnection);
            ((BabelfishConnection)((Object)connection)).setTranslator(translator);
            translator.activateServerTranslation(physicalConnection);
            return connection;
        }
        catch (SQLException sQLException) {
            throw translator.translateError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection defaultConnection() throws SQLException {
        if (defaultConn != null && !defaultConn.isClosed()) return defaultConn;
        Class<OracleDriver> clazz = OracleDriver.class;
        synchronized (OracleDriver.class) {
            if (defaultConn != null && !defaultConn.isClosed()) return defaultConn;
            defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultConn;
        }
    }

    static final int oracleDriverExtensionTypeFromURL(String string) {
        int n2;
        int n3 = string.indexOf(58);
        if (n3 == -1) {
            return -2;
        }
        if (!string.regionMatches(true, 0, jdbc_string, 0, n3)) {
            return -2;
        }
        if ((n2 = string.indexOf(58, ++n3)) == -1) {
            return -2;
        }
        if (!string.regionMatches(true, n3, oracle_string, 0, n2 - n3)) {
            return -2;
        }
        int n4 = string.indexOf(58, ++n2);
        String string2 = null;
        if (n4 == -1) {
            return -3;
        }
        string2 = string.substring(n2, n4);
        if (string2.equals("thin")) {
            return 0;
        }
        if (string2.equals("oci8") || string2.equals("oci")) {
            return 2;
        }
        return -3;
    }

    @Override
    @Supports(value={Feature.PLATFORM})
    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
        }
        if (string.startsWith("jdbc:oracle:")) {
            return OracleDriver.oracleDriverExtensionTypeFromURL(string) > -2;
        }
        return false;
    }

    @Override
    @Supports(value={Feature.METADATA})
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2;
        Object object;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.jdbc.OracleConnection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int n2 = 0;
        String[] stringArray = new String[150];
        String[] stringArray2 = new String[150];
        Field[] fieldArray = clazz.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            if (!fieldArray[i2].getName().startsWith("CONNECTION_PROPERTY_") || fieldArray[i2].getName().endsWith("_DEFAULT") || fieldArray[i2].getName().endsWith("_ACCESSMODE")) continue;
            try {
                object = (String)fieldArray[i2].get(null);
                Field field = clazz.getField(fieldArray[i2].getName() + "_DEFAULT");
                string2 = (String)field.get(null);
                if (n2 == stringArray.length) {
                    String[] stringArray3 = new String[stringArray.length * 2];
                    String[] stringArray4 = new String[stringArray.length * 2];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray.length);
                    stringArray = stringArray3;
                    stringArray2 = stringArray4;
                }
                stringArray[n2] = object;
                stringArray2[n2] = string2;
                ++n2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Hashtable hashtable = PhysicalConnection.parseUrl(string);
        object = new DriverPropertyInfo[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            string2 = stringArray[i3];
            object[i3] = hashtable.containsKey(string2) ? new DriverPropertyInfo(string2, (String)hashtable.get(string2)) : new DriverPropertyInfo(stringArray[i3], stringArray2[i3]);
        }
        return object;
    }

    @Override
    @Supports(value={Feature.METADATA})
    public int getMajorVersion() {
        return OracleDatabaseMetaData.getDriverMajorVersionInfo();
    }

    @Override
    @Supports(value={Feature.METADATA})
    public int getMinorVersion() {
        return OracleDatabaseMetaData.getDriverMinorVersionInfo();
    }

    @Override
    @Supports(value={Feature.METADATA})
    public boolean jdbcCompliant() {
        return true;
    }

    @Supports(value={Feature.PLATFORM})
    public String processSqlEscapes(String string) throws SQLException {
        OracleSql oracleSql = new OracleSql(null);
        oracleSql.initialize(string);
        return oracleSql.parse(string);
    }

    @Supports(value={Feature.METADATA})
    public static String getCompileTime() {
        return BuildInfo.getBuildDate();
    }

    @Supports(value={Feature.METADATA})
    public static String getSystemPropertyFastConnectionFailover(String string) {
        return PhysicalConnection.getSystemPropertyFastConnectionFailover(string);
    }

    @Supports(value={Feature.METADATA})
    public static boolean getSystemPropertyDateZeroTime() {
        String string = PhysicalConnection.getSystemPropertyDateZeroTime("false");
        return string.equalsIgnoreCase("true");
    }

    @Override
    @Supports(value={Feature.PLATFORM})
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(oracle_string);
    }

    static {
        Object object;
        try {
            $$$methodRef$$$17 = OracleDriver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleDriver.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleDriver.class.getDeclaredMethod("getSystemPropertyDateZeroTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleDriver.class.getDeclaredMethod("getSystemPropertyFastConnectionFailover", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleDriver.class.getDeclaredMethod("getCompileTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleDriver.class.getDeclaredMethod("processSqlEscapes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleDriver.class.getDeclaredMethod("jdbcCompliant", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleDriver.class.getDeclaredMethod("getMinorVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleDriver.class.getDeclaredMethod("getMajorVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleDriver.class.getDeclaredMethod("getPropertyInfo", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDriver.class.getDeclaredMethod("acceptsURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDriver.class.getDeclaredMethod("oracleDriverExtensionTypeFromURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDriver.class.getDeclaredMethod("defaultConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDriver.class.getDeclaredMethod("babelfishConnect", Properties.class, String.class, String.class, OracleDriverExtension.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDriver.class.getDeclaredMethod("connect", String.class, Properties.class, GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDriver.class.getDeclaredMethod("connect", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDriver.class.getDeclaredMethod("deregister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDriver.class.getDeclaredMethod("unRegisterMBeans", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
        defaultConn = null;
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver, OracleDriver::deregister);
            }
            AccessController.doPrivileged(new PrivilegedAction(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
            object = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", sQLException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", runtimeException);
        }
        try {
            object = new OraclePKIProvider();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        systemTypeMap = new Hashtable<String, Class>(2);
        try {
            systemTypeMap.put("SYS.ANYDATA", Class.forName("oracle.sql.AnyDataFactory"));
            systemTypeMap.put("SYS.ANYTYPE", Class.forName("oracle.sql.TypeDescriptorFactory"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DEFAULT_CONNECTION_PROPERTIES = new Properties();
        try {
            object = PhysicalConnection.class.getResourceAsStream(DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME);
            if (object != null) {
                DEFAULT_CONNECTION_PROPERTIES.load((InputStream)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        diagnosticMBeanObjectName = null;
    }
}

