/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.lang.reflect.Executable;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.pooling.Pool;
import oracle.jdbc.pooling.PoolIterator;
import oracle.jdbc.pooling.PoolIteratorQueue;
import oracle.jdbc.pooling.RevisitQueue;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();
    private final AtomicReference<Element> fillRef = new AtomicReference<Element>(this.listHead);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T t2) {
        Element element = this.fillRef.get();
        Element element2 = null;
        while (true) {
            if (element.tryReserve()) {
                try {
                    if (element.data == null) {
                        element.data = t2;
                        this.fillRef.set(element);
                        return;
                    }
                }
                finally {
                    element.release();
                }
            }
            if (element.next.get() == null && element2 == null) {
                element2 = new Element(t2);
            }
            if (element.next.compareAndSet(null, element2)) {
                this.fillRef.set(element2);
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
        }
    }

    @Override
    public PoolIterator<T> iterator(final boolean bl) {
        final Thread thread = Thread.currentThread();
        return new PoolIterator<T>(){
            volatile Element listElement;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final RevisitQueue<Element> revisitQueue;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            {
                this.listElement = LinkedListPool.this.listHead;
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new RevisitQueue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && thread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (thread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Element reserveNext() {
                while (this.listElement != null) {
                    if (this.listElement.tryReserve()) {
                        if (this.listElement.data != null) {
                            Element element = this.listElement;
                            this.listElement = (Element)this.listElement.next.get();
                            return element;
                        }
                        this.listElement.release();
                    } else if (this.preReserved(this.listElement)) {
                        if (this.listElement.data != null) {
                            Element element = this.listElement;
                            this.listElement = (Element)this.listElement.next.get();
                            this.outerReservation = true;
                            return element;
                        }
                    } else if (bl) {
                        this.listElement.poolIteratorQueue.enqueue(this);
                        this.revisitQueue.enqueue(this.listElement);
                    }
                    this.listElement = (Element)this.listElement.next.get();
                }
                Element element = null;
                Element element2;
                while ((element2 = this.revisitQueue.dequeue()) != null) {
                    if (element2 == element) {
                        element = null;
                        try {
                            this.sleeping = true;
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.sleeping = false;
                        }
                    }
                    if (null == element) {
                        element = element2;
                    }
                    if (element2.poolIteratorQueue.peek(this)) {
                        if (element2.tryReserve()) {
                            element2.poolIteratorQueue.disable(this);
                            if (element2.data != null) {
                                return element2;
                            }
                            element2.release();
                            continue;
                        }
                        this.revisitQueue.enqueue(element2);
                        continue;
                    }
                    this.revisitQueue.enqueue(element2);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public T next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    Object t2 = this.currentElement.data;
                    this.nextReserved = false;
                    return t2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement != null) {
                    this.currentElement.data = null;
                    if (this.currentElement.id < ((Element)LinkedListPool.this.fillRef.get()).id) {
                        LinkedListPool.this.fillRef.set(this.currentElement);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$9 = 1.class.getDeclaredConstructor(LinkedListPool.class, Thread.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$8 = 1.class.getDeclaredMethod("release", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$7 = 1.class.getDeclaredMethod("remove", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$6 = 1.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$5 = 1.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = 1.class.getDeclaredMethod("reserveNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("preReserved", Element.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("throwIfWrongThread", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("isSleeping", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isAlive", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$7 = LinkedListPool.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LinkedListPool.class.getDeclaredMethod("access$1000", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LinkedListPool.class.getDeclaredMethod("access$600", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LinkedListPool.class.getDeclaredMethod("access$000", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LinkedListPool.class.getDeclaredMethod("iterator", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LinkedListPool.class.getDeclaredMethod("put", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LinkedListPool.class.getDeclaredMethod("listLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LinkedListPool.class.getDeclaredMethod("elementsInstantiated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private final class Element {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;
        private final PoolIteratorQueue<T> poolIteratorQueue = new PoolIteratorQueue();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;

        private Element() {
            this((Object)null);
        }

        private Element(T t2) {
            this.data = t2;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread thread = Thread.currentThread();
            if (!this.reserved.compareAndSet(thread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + thread);
            }
        }

        static {
            try {
                $$$methodRef$$$11 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = Element.class.getDeclaredConstructor(LinkedListPool.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = Element.class.getDeclaredConstructor(LinkedListPool.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Element.class.getDeclaredMethod("access$900", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Element.class.getDeclaredMethod("access$800", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Element.class.getDeclaredMethod("access$700", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Element.class.getDeclaredMethod("access$400", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Element.class.getDeclaredMethod("access$300", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Element.class.getDeclaredMethod("access$200", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Element.class.getDeclaredMethod("release", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Element.class.getDeclaredMethod("tryReserve", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

