/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class AggregateByteArray
extends SimpleByteArray {
    protected ByteArray extension;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    AggregateByteArray(byte[] byArray, ByteArray byteArray) {
        super(byArray);
        this.extension = byteArray;
    }

    @Override
    long length() {
        return (long)this.bytes.length + this.extension.length();
    }

    @Override
    void put(long l2, byte by) {
        if (l2 < (long)this.bytes.length) {
            super.put(l2, by);
        } else {
            this.extension.put(l2 - (long)this.bytes.length, by);
        }
    }

    @Override
    byte get(long l2) {
        if (l2 < (long)this.bytes.length) {
            return super.get(l2);
        }
        return this.extension.get(l2 - (long)this.bytes.length);
    }

    @Override
    void put(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 < (long)this.bytes.length == l2 + (long)n3 <= (long)this.bytes.length) : "offset:" + l2 + " length:" + n3 + " bytes.length:" + this.bytes.length;
        if (l2 < (long)this.bytes.length) {
            super.put(l2, byArray, n2, n3);
        } else {
            this.extension.put(l2 - (long)this.bytes.length, byArray, n2, n3);
        }
    }

    @Override
    void get(long l2, byte[] byArray, int n2, int n3) {
        assert (l2 < (long)this.bytes.length == l2 + (long)n3 <= (long)this.bytes.length) : "offset:" + l2 + " length:" + n3 + " bytes.length:" + this.bytes.length;
        if (l2 < (long)this.bytes.length) {
            super.get(l2, byArray, n2, n3);
        } else {
            this.extension.get(l2 - (long)this.bytes.length, byArray, n2, n3);
        }
    }

    @Override
    char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        assert (l2 < (long)this.bytes.length == l2 + (long)n2 <= (long)this.bytes.length) : "offset:" + l2 + " lengthInBytes:" + n2 + " bytes.length:" + this.bytes.length;
        if (l2 < (long)this.bytes.length) {
            return super.getChars(l2, n2, characterSet, nArray);
        }
        return this.extension.getChars(l2 - (long)this.bytes.length, n2, characterSet, nArray);
    }

    @Override
    long updateChecksum(long l2, int n2, CRC64 cRC64, long l3) {
        assert (l2 < (long)this.bytes.length == l2 + (long)n2 <= (long)this.bytes.length) : "offset:" + l2 + " length:" + n2 + " bytes.length:" + this.bytes.length;
        if (l2 < (long)this.bytes.length) {
            return super.updateChecksum(l2, n2, cRC64, l3);
        }
        return this.extension.updateChecksum(l2 - (long)this.bytes.length, n2, cRC64, l3);
    }

    @Override
    byte[] getBlockBasic(long l2, int[] nArray) {
        if (l2 < (long)this.bytes.length) {
            return super.getBlockBasic(l2, nArray);
        }
        return this.extension.getBlockBasic(l2, nArray);
    }

    @Override
    void free() {
        super.free();
        this.extension.free();
    }

    static {
        try {
            $$$methodRef$$$9 = AggregateByteArray.class.getDeclaredConstructor(byte[].class, ByteArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AggregateByteArray.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AggregateByteArray.class.getDeclaredMethod("getBlockBasic", Long.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AggregateByteArray.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE, CRC64.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AggregateByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AggregateByteArray.class.getDeclaredMethod("get", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AggregateByteArray.class.getDeclaredMethod("put", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AggregateByteArray.class.getDeclaredMethod("get", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AggregateByteArray.class.getDeclaredMethod("put", Long.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AggregateByteArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

