/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

import java.util.HashSet;
import java.util.StringJoiner;

public class CommaListBuilder
extends HashSet<String> {
    public static CommaListBuilder from(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        String cleanedSource = source.replaceAll("\\s", "");
        if (cleanedSource.length() == 0) {
            throw new IllegalArgumentException("source must not be empty nor blank");
        }
        int last = cleanedSource.lastIndexOf(41);
        if (cleanedSource.charAt(0) != '(' || last <= 0) {
            throw new IllegalArgumentException("Unexpected format for source");
        }
        CommaListBuilder set = new CommaListBuilder();
        for (String s : cleanedSource.substring(1, last).split(",")) {
            set.add(s);
        }
        return set;
    }

    public String format() {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        this.stream().forEach(t -> joiner.add((CharSequence)t));
        return joiner.toString();
    }
}

