/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.logging.Level;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

@Deprecated
public class OracleClob
extends DatumWithConnection
implements oracle.jdbc.internal.OracleClob {
    private static final String CLASS_NAME = OracleClob.class.getName();
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    public static final int OLD_WRONG_DURATION_SESSION = 1;
    public static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize = -1;
    private short csform;
    boolean isFree = false;
    boolean fromObject = false;
    long cachedLengthOfClobInChars = -1L;
    private OracleLargeObject.PrefetchData<char[]> prefetchData;
    boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    transient CharacterSet dilCharacterSet = null;
    protected Object acProxy;

    public OracleClob() {
    }

    public OracleClob(OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.fromObject = fromObject;
    }

    public void setCsform(short csform) {
        this.csform = csform;
    }

    public short getCsform() {
        return this.csform;
    }

    public void setFromobject(boolean fromObject) {
        this.fromObject = fromObject;
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        if (lob_descriptor != null) {
            this.csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "OracleClob", "csform={0}. ", (String)null, (Throwable)null, (Object)this.csform);
        OracleClob.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            this.dbaccess = ((oracle.jdbc.internal.OracleConnection)conn).createClobDBAccess();
            this.dbaccess.incrementTempLobReferenceCount(lob_descriptor);
            if (lob_descriptor != null && !this.isTemporaryInternal(this.dbaccess)) {
                ((oracle.jdbc.internal.OracleConnection)conn).addLargeObject(this);
            }
        }
    }

    public OracleClob(OracleConnection conn, byte[] lob_descriptor, short csform) throws SQLException {
        this(conn, lob_descriptor);
        short tmp_csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
        if (tmp_csform != -1) {
            if (csform != tmp_csform) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
            }
            this.csform = tmp_csform;
        } else {
            this.csform = csform;
        }
    }

    @Override
    public boolean isNCLOB() {
        return this.csform == 2;
    }

    @Override
    public long length() throws SQLException {
        return this.lengthInternal();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        long ret = this.activePrefetch && this.cachedLengthOfClobInChars != -1L ? this.cachedLengthOfClobInChars : (this.canReadBasicLobDataInLocator() ? (long)this.dilGetChars().length : this.getDBAccess().length(this));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String ret = this.getSubStringLocal(pos, length);
        if (ret == null) {
            char[] charBuffer = this.getDBAccess().getCharBufferSync(length);
            try {
                int readLength = this.getChars(pos, length, charBuffer);
                ret = readLength > 0 ? new String(charBuffer, 0, readLength) : new String();
            }
            finally {
                this.getDBAccess().cacheBufferSync(charBuffer);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubStringLocal(long pos, int length) throws SQLException {
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetSubString(pos, length);
        }
        if (length == 0 || this.activePrefetch && (this.cachedLengthOfClobInChars == 0L || this.cachedLengthOfClobInChars > 0L && pos - 1L >= this.cachedLengthOfClobInChars)) {
            return new String();
        }
        if (this.prefetchData != null && this.prefetchData.length() > 0 && this.cachedLengthOfClobInChars == (long)this.prefetchData.length() && pos + (long)length - 1L <= this.cachedLengthOfClobInChars) {
            char[] charBuffer = this.getDBAccess().getCharBufferSync(length);
            try {
                this.prefetchData.copy((int)(pos - 1L), charBuffer, 0, length);
                String string = new String(charBuffer, 0, length);
                return string;
            }
            finally {
                this.getDBAccess().cacheBufferSync(charBuffer);
            }
        }
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(1L);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getAsciiStream(false);
    }

    public InputStream getAsciiStream(boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(1L);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L, isInternal);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleClob)this, searchstr, start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleClob)this, (oracle.jdbc.internal.OracleClob)searchstr, start);
    }

    @Override
    public int getChars(long pos, int length, char[] buffer) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getChars(this, pos, length, buffer);
    }

    @Override
    @Deprecated
    public Writer getCharacterOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setCharacterStream(1L);
    }

    @Override
    @Deprecated
    public OutputStream getAsciiOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setAsciiStream(1L);
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] locator) {
        super.setBytes(locator);
    }

    @Override
    public int putChars(long pos, char[] chars) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, 0, chars != null ? chars.length : 0);
    }

    public int putChars(long pos, char[] chars, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, 0, length);
    }

    @Override
    public int putChars(long pos, char[] chars, int offset, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putChars(this, pos, chars, offset, length);
    }

    @Override
    @Deprecated
    public int putString(long pos, String str) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setString(pos, str);
    }

    @Override
    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    @Override
    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return OracleClob.computeBufferSize(this.getChunkSize());
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return ret;
    }

    @Override
    @Deprecated
    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, false);
    }

    @Override
    @Deprecated
    public Writer getCharacterOutputStream(long pos) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), pos, false);
    }

    @Override
    public InputStream getAsciiStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetAsciiStream(pos);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), pos);
    }

    @Override
    public Reader getCharacterStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(pos);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), pos);
    }

    @Override
    @Deprecated
    public void trim(long newlen) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.truncate(newlen);
    }

    @Override
    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.freeTemporaryInternal(this.getDBAccess());
    }

    private void freeTemporaryInternal(ClobDBAccess myDBAccess) throws SQLException {
        int refCnt = myDBAccess.decrementTempLobReferenceCount(this.shareBytes());
        if (refCnt == 0) {
            myDBAccess.freeTemporary(this, this, this.fromObject);
        }
    }

    @Override
    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isTemporaryInternal(this.getDBAccess());
    }

    private boolean isTemporaryInternal(ClobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isTemporary(this);
    }

    @Override
    public short getDuration() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getDuration(this);
    }

    @Override
    public void openLob(LargeObjectAccessMode mode) throws SQLException {
        this.openLob(mode.getCode());
    }

    public void openLob(int mode) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.getDBAccess().openLob(this, mode);
    }

    @Override
    public void closeLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.closeLobInternal(this.getDBAccess());
    }

    private void closeLobInternal(ClobDBAccess myDBAccess) throws SQLException {
        myDBAccess.closeLob(this);
    }

    @Override
    public boolean isOpenLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isOpenLobInternal(this.getDBAccess());
    }

    private boolean isOpenLobInternal(ClobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isOpenLob(this);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1").fillInStackTrace();
        }
        int ret = 0;
        if (str != null && str.length() != 0) {
            ret = this.putChars(pos, str.toCharArray());
        }
        return ret;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1").fillInStackTrace();
        }
        if (offset < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0").fillInStackTrace();
        }
        if (offset + len > str.length()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ").fillInStackTrace();
        }
        int ret = 0;
        if (str != null && str.length() != 0) {
            ret = this.putChars(pos, str.toCharArray(), offset, len);
        }
        return ret;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, true);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), pos, true);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (len < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0").fillInStackTrace();
        }
        this.getDBAccess().trim(this, len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public String stringValue() throws SQLException {
        Reader r = this.getCharacterStream();
        int size = this.getBufferSize();
        int length = 0;
        StringWriter w = new StringWriter(size);
        char[] buffer = new char[size];
        try {
            while ((length = r.read(buffer)) != -1) {
                w.write(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        return w.getBuffer().substring(0);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new CLOB[arraySize];
    }

    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        oracle.jdbc.internal.OracleConnection connPhys = this.getPhysicalConnection();
        if (connPhys != null && connPhys.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98).fillInStackTrace();
            }
            try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
                this.dbaccess = this.getInternalConnection().createClobDBAccess();
            }
        }
        return this.dbaccess;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _cachedLengthOfClobInChars) {
        this.cachedLengthOfClobInChars = _cachedLengthOfClobInChars;
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.dbChunkSize = _dbChunkSize;
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<char[]> prefetchData) {
        this.prefetchData = prefetchData;
    }

    @Override
    public final OracleLargeObject.PrefetchData<char[]> getPrefetchData() {
        return this.prefetchData;
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        if (this.activePrefetch && !_activePrefetch) {
            this.clearCachedData();
        }
        this.activePrefetch = _activePrefetch;
    }

    @Override
    public final void clearCachedData() {
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    int dilGetCharSetId() throws SQLException {
        byte msb = this.shareBytes()[32];
        byte lsb = this.shareBytes()[33];
        int result = (msb & 0xFF) << 8 | lsb & 0xFF;
        return result;
    }

    boolean isMigratedAL16UTF16LE() {
        int kol_field4 = this.shareBytes()[7] & 0xFF;
        return (kol_field4 & 0x40) == 64;
    }

    boolean isVariableWidth() {
        int lvar;
        int kol_field3 = this.shareBytes()[6] & 0xFF;
        return (kol_field3 & (lvar = 128)) == lvar;
    }

    void dilGetCharacterSet() throws SQLException {
        if (this.dilCharacterSet == null) {
            if (this.isMigratedAL16UTF16LE()) {
                this.dilCharacterSet = CharacterSet.make(2002);
            } else if (this.isVariableWidth()) {
                this.dilCharacterSet = CharacterSet.make(2000);
            } else {
                int id = this.dilGetCharSetId();
                this.dilCharacterSet = CharacterSet.make(id);
            }
        }
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    char[] dilGetChars() throws SQLException {
        int dilByteLength = this.dilLength();
        byte[] dilBytes = new byte[dilByteLength];
        System.arraycopy(this.shareBytes(), 102, dilBytes, 0, dilByteLength);
        String dilString = this.dilCharacterSet.toStringWithReplacement(dilBytes, 0, dilByteLength);
        char[] dilChars = dilString.toCharArray();
        return dilChars;
    }

    InputStream dilGetAsciiStream(long pos) throws SQLException {
        byte[] dilBytes;
        char[] dilChars = this.dilGetChars();
        if (pos - 1L > (long)dilChars.length) {
            byte[] dilBytes2 = new byte[]{};
            return new ByteArrayInputStream(dilBytes2);
        }
        if (this.dilGetCharSetId() == 1) {
            dilBytes = new byte[dilChars.length];
            for (int i = 0; i < dilChars.length; ++i) {
                dilBytes[i] = (byte)dilChars[i];
            }
        } else {
            CharacterSet asciiCharSet = CharacterSet.make(1);
            dilBytes = asciiCharSet.convertWithReplacement(new String(dilChars));
        }
        return new ByteArrayInputStream(dilBytes);
    }

    Reader dilGetCharacterStream(long pos) throws SQLException {
        char[] dilChars = this.dilGetChars();
        int lobLen = dilChars.length;
        if (pos - 1L > (long)lobLen) {
            char[] dilNilChar = new char[]{};
            return new CharArrayReader(dilNilChar);
        }
        return new CharArrayReader(dilChars, (int)(pos - 1L), Integer.MAX_VALUE);
    }

    String dilGetSubString(long pos, int length) throws SQLException {
        char[] dilChars = this.dilGetChars();
        if ((int)pos > dilChars.length) {
            return "";
        }
        int lengthAvailable = (int)Math.min((long)length, (long)dilChars.length - (pos - 1L));
        if (lengthAvailable == 0) {
            return "";
        }
        return new String(dilChars, (int)(pos - 1L), lengthAvailable);
    }

    Reader dilGetCharacterStream(long pos, long length) throws SQLException {
        if (pos < 1L || length < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        char[] dilChars = this.dilGetChars();
        long lobLen = dilChars.length;
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return new CharArrayReader(dilChars, (int)(pos - 1L), (int)length);
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        byte[] loc = this.shareBytes();
        if (loc == null || loc.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int kol_field3 = loc[6] & 0xFF;
        int kol_field4 = loc[7] & 0xFF;
        boolean hasDILBit = (kol_field3 & 8) == 8;
        boolean hasLocalBit = (kol_field4 & 0xFFFFFF80) == -128;
        boolean hasKdfBit = false;
        if (hasDILBit && !hasLocalBit) {
            int kdf_field = loc[88] & 0xFF;
            hasKdfBit = (kdf_field & 8) == 8;
        }
        boolean hasDILData = hasDILBit && !hasLocalBit && hasKdfBit;
        boolean canUseDILData = false;
        if (hasDILData) {
            this.dilGetCharacterSet();
            canUseDILData = !this.dilCharacterSet.isUnknown();
        }
        return canUseDILData;
    }

    @Override
    public void freeLOB() throws SQLException {
        this.freeInternal();
    }

    @Override
    public void free() throws SQLException {
        this.freeInternal();
    }

    private void freeInternal() throws SQLException {
        if (this.isFree) {
            return;
        }
        if (this.isOpenLob()) {
            this.closeLob();
        }
        this.freeLocal();
    }

    private void freeLocal() throws SQLException {
        if (this.isTemporary()) {
            this.freeTemporary();
        }
        this.getPhysicalConnection().removeLargeObject(this);
        this.isFree = true;
        this.dbaccess = null;
        this.prefetchData = null;
    }

    @Override
    public boolean isFree() {
        return this.isFree;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos == 0L) {
            if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                pos = 1L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetCharacterStream(pos, length);
        }
        long lobLen = this.length();
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return this.getDBAccess().newReader(this, this.getChunkSize(), pos, length);
    }

    @Override
    public void setBytes(byte[] locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        return null;
    }

    @Override
    public SQLXML toSQLXML(String schemaURL) throws SQLException {
        return null;
    }

    private static int computeBufferSize(int chunkSize) {
        if (chunkSize >= 32768 || chunkSize <= 0) {
            return 32768;
        }
        return 32768 / chunkSize * chunkSize;
    }
}

