/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.jdbc.driver.json.tree.OracleJsonVectorImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonVector;

public final class OsonGeneratorImpl
extends AbstractGenerator
implements OracleJsonGenerator {
    private static boolean DEFAULT_SIMPLE_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_SIMPLE_VALUE_SHARING", "false"));
    private static boolean DEFAULT_LAST_VALUE_SHARING = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_LAST_VALUE_SHARING", "false"));
    private static boolean DEFAULT_RELATIVE_OFFSETS = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_RELATIVE_OFFSETS", "false"));
    private static boolean DEFAULT_TINYNODE = "true".equals(System.getProperty("oracle.jdbc.driver.json.binary.DEFAULT_TINYNODE", "true"));
    private static final DuplicateKeyMode DEFAULT_DUPLICATE_KEY_MODE;
    private static int INITIAL_OPS;
    private static int OUT_BUFFER_SIZE;
    private static int SEEN_HASH_THRESHOLD;
    private static byte[] ONE;
    private static byte[] ZERO;
    private OsonGeneratorState state;

    public OsonGeneratorImpl(OsonGeneratorStatePool pool, OutputStream out) {
        this.state = pool != null ? pool.getState(out) : new OsonGeneratorState(null, out);
        this.state.reset(out);
    }

    public void reset(OutputStream out) {
        this.state.reset(out);
    }

    public void setTinyNodeStat(boolean value) {
        this.state.setTinyNodeStat(value);
    }

    public void setUseRelativeOffsets(boolean value) {
        this.state.setUseRelativeOffsets(value);
    }

    public void setSimpleValueSharing(boolean value) {
        this.state.setSimpleValueSharing(value);
    }

    public void setLastValueSharing(boolean value) {
        this.state.setLastValueSharing(value);
    }

    public boolean getLastValueSharing() {
        return this.state.lastValueSharing;
    }

    public boolean getSimpleValuesharing() {
        return this.state.simpleValueSharing;
    }

    public boolean getRelativeOffsets() {
        return this.state.relativeOffsets;
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.state.writeStartObject();
        return this;
    }

    public OracleJsonGenerator writeStartObject(boolean sort) {
        if (sort) {
            this.state.writeStartObject();
        } else {
            this.state.writeStartObjectNoSort();
        }
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String key) {
        this.state.writeKey(key);
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.state.writeStartArray();
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        this.state.writeEnd();
        return this;
    }

    @Override
    public OracleJsonGenerator write(String value) {
        this.state.writeString(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigDecimal value) {
        this.state.writeDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger value) {
        this.state.writeDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int value) {
        this.state.writeSB4(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long value) {
        this.state.writeSB8(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double value) {
        this.state.writeDouble(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean value) {
        this.state.writeBoolean(value);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.state.writeNull();
        return this;
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.close();
            if (this.state.pool != null) {
                this.state.pool.putState(this.state);
            }
            this.state = null;
        }
    }

    @Override
    public OracleJsonGenerator write(String key, byte[] value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, LocalDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, OffsetDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] bytes) {
        this.state.writeBytes(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator writeId(byte[] bytes) {
        this.state.writeId(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float value) {
        this.state.writeFloat(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime local) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestamp(this.state.getExceptionFactory(), local);
        this.state.writeTimestamp(bytes);
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime offset) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestampTZ(this.state.getExceptionFactory(), offset);
        this.state.writeTimestampTZ(bytes);
        return this;
    }

    public OracleJsonGenerator writeIntervalDS(Duration value) {
        byte[] bytes = OsonPrimitiveConversions.durationToIntervalDS(value);
        this.state.writeIntervalDS(bytes);
        return this;
    }

    public OracleJsonGenerator writeIntervalYM(Period value) {
        byte[] bytes = OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), value);
        this.state.writeIntervalYM(bytes);
        return this;
    }

    public OracleJsonGenerator writeNumberAsString(BigDecimal bd) {
        this.state.writeNumberAsString(bd);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary value) {
        byte[] bytes = value.getBytes();
        if (value.isId()) {
            this.state.writeId(bytes);
        } else {
            this.state.writeBytes(bytes);
        }
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble value) {
        return this.write(value.doubleValue());
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat value) {
        return this.write(value.floatValue());
    }

    public void writeDecimal(BigDecimal value) {
        this.state.writeDecimal(value);
    }

    public void writeSB4(int value) {
        this.state.writeSB4(value);
    }

    public void writeSB8(long value) {
        this.state.writeSB8(value);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal value) {
        this.state.writeOraNumber(value);
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp value) {
        this.state.writeTimestamp(((OracleJsonTimestampImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ value) {
        this.state.writeTimestampTZ(((OracleJsonTimestampTZImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate value) {
        this.state.writeDate(((OracleJsonDateImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS value) {
        this.state.writeIntervalDS(((OracleJsonIntervalDSImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM value) {
        this.state.writeIntervalYM(((OracleJsonIntervalYMImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeVector(OracleJsonVector value) {
        this.state.writeVector(((OracleJsonVectorImpl)value).raw());
        return this;
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString value) {
        return this.write(value.getString());
    }

    @Override
    public void flush() {
    }

    @Override
    public OracleJsonGenerator write(Period p) {
        this.state.writeIntervalYM(OsonPrimitiveConversions.periodToIntervalYM(this.state.getExceptionFactory(), p));
        return this;
    }

    @Override
    public OracleJsonGenerator write(Duration d) {
        this.state.writeIntervalDS(OsonPrimitiveConversions.durationToIntervalDS(d));
        return this;
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser parser) {
        if (parser instanceof OsonParserImpl) {
            OsonParserImpl oparser = (OsonParserImpl)parser;
            byte[] arr = oparser.getContext().b.buffer.array();
            this.state.writeUTF8String(arr, oparser.getCurrentStringPos(), oparser.getCurrentStringLen());
        } else {
            this.state.writeString(parser.getString());
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser parser) {
        this.write(parser.getValue());
    }

    public void setDuplicateKeyMode(DuplicateKeyMode mode) {
        this.state.duplicateKeyMode = mode;
    }

    static /* synthetic */ int access$100() {
        return INITIAL_OPS;
    }

    static /* synthetic */ int access$200() {
        return OUT_BUFFER_SIZE;
    }

    static {
        INITIAL_OPS = 64;
        OUT_BUFFER_SIZE = 8192;
        SEEN_HASH_THRESHOLD = 64;
        ONE = OsonPrimitiveConversions.toNumber(1);
        ZERO = OsonPrimitiveConversions.toNumber(0);
        String modeStr = System.getProperty("oracle.jdbc.driver.json.binary.OsonGeneratorImpl.DEFAULT_DUPLICATE_KEY_MODE");
        DuplicateKeyMode mode = null;
        mode = modeStr == null ? DuplicateKeyMode.DISALLOW : DuplicateKeyMode.valueOf(modeStr);
        DEFAULT_DUPLICATE_KEY_MODE = mode;
    }

    public static final class OsonGeneratorStatePool {
        private volatile WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue;

        private OsonGeneratorState getState(OutputStream out) {
            ConcurrentLinkedQueue<OsonGeneratorState> list = this.getQueue();
            OsonGeneratorState result = null;
            if (list != null) {
                result = list.poll();
            }
            if (result == null) {
                result = new OsonGeneratorState(this, out);
            }
            return result;
        }

        private void putState(OsonGeneratorState state) {
            ConcurrentLinkedQueue<OsonGeneratorState> list = this.getQueue();
            if (list == null) {
                list = new ConcurrentLinkedQueue();
                list.offer(state);
                this.queue = new WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>>(list);
            } else {
                list.offer(state);
            }
        }

        private ConcurrentLinkedQueue<OsonGeneratorState> getQueue() {
            WeakReference<ConcurrentLinkedQueue<OsonGeneratorState>> queue = this.queue;
            return queue == null ? null : (ConcurrentLinkedQueue)queue.get();
        }
    }

    private static class BigKey
    implements Comparable<BigKey> {
        byte[] key;
        int hash;

        public BigKey(String key) {
            this.key = key.getBytes(StandardCharsets.UTF_8);
            this.hash = OsonHeader.ohash(key, null);
        }

        @Override
        public int compareTo(BigKey o) {
            if (o.hash != this.hash) {
                return this.hash - o.hash;
            }
            if (this.key.length != o.key.length) {
                return this.key.length - o.key.length;
            }
            for (int i = 0; i < this.key.length; ++i) {
                int res = Byte.compare(this.key[i], o.key[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }

    private static final class OsonGeneratorState {
        private int[][] keys = new int[256][];
        private int[][] keysLastSeenValue;
        private boolean keysNeedReset = true;
        int[] seenHash = new int[OsonGeneratorImpl.access$000()];
        int seenHashSize;
        int keyI;
        int keyJ;
        private String[] distinctKeys = new String[16];
        private int distinctKeysSize;
        private byte[] keyHeap;
        private int keyHeapSize;
        private int[] keyHeapOffsets;
        private int[] fidMap;
        TreeMap<BigKey, Integer> bigKeys;
        int bigKeysHeapSize = 0;
        AtomicInteger keylen = new AtomicInteger();
        private int numOps;
        private short[] ops = new short[OsonGeneratorImpl.access$100()];
        private int[] nextSiblings = new int[OsonGeneratorImpl.access$100()];
        private int[] fieldIDs = new int[OsonGeneratorImpl.access$100()];
        private short[] depths = new short[OsonGeneratorImpl.access$100()];
        private int[] valueIndex = new int[OsonGeneratorImpl.access$100()];
        private int[] numChildren = new int[OsonGeneratorImpl.access$100()];
        private int[] offsets;
        private int treeSegmentSize;
        private byte[] valueHeap = new byte[1024];
        private int valueHeapSize;
        private int tinyNodeCount;
        short headerFlags;
        private int[] opStack = new int[2];
        private int depth;
        private int previousSiblingIdx;
        private int[] temporaryIntArray;
        private long[] temporaryLongArray;
        private final StreamContext ctx = new StreamContext(null);
        private OutputStream out;
        private byte[] outBuffer = new byte[OsonGeneratorImpl.access$200()];
        private int outBufferPos;
        public boolean relativeOffsets;
        public boolean simpleValueSharing;
        public boolean lastValueSharing;
        int opNull;
        int opTrue;
        int opFalse;
        int opZero;
        int opOne;
        int opEmptyString;
        int opEmptyObject;
        int opEmptyArray;
        int opLastValue;
        private OsonGeneratorStatePool pool;
        private DuplicateKeyMode duplicateKeyMode = OsonGeneratorImpl.access$300();

        private OsonGeneratorState(OsonGeneratorStatePool pool, OutputStream out) {
            this.pool = pool;
            this.out = out;
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void writeNumber(byte[] bytes) {
            if (bytes.length <= 8) {
                int op = bytes.length - 1 | OsonConstants.MASK_ORANUM_16;
                if (this.simpleValueSharing) {
                    if (Arrays.equals(ONE, bytes)) {
                        this.addOpAndValueNoPostOp(op, bytes);
                        if (this.opOne == -1) {
                            this.opOne = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opOne);
                        }
                        this.postOp(false);
                        return;
                    }
                    if (Arrays.equals(ZERO, bytes)) {
                        this.addOpAndValueNoPostOp(op, bytes);
                        if (this.opZero == -1) {
                            this.opZero = this.numOps - 1;
                        } else {
                            this.headerFlags = (short)(this.headerFlags | 0x20);
                            this.markDuplicate(this.numOps - 1, this.opZero);
                        }
                        this.postOp(false);
                        return;
                    }
                }
                this.addOpAndValue(op, bytes);
            } else if (bytes.length < 256) {
                this.addOpAndValue(52, bytes);
            }
        }

        private void push(int opIndex) {
            if (this.ctx.depth >= this.opStack.length) {
                this.opStack = Arrays.copyOf(this.opStack, this.opStack.length * 2);
            }
            this.opStack[this.depth] = opIndex;
            ++this.depth;
            if (this.depth >= 65536) {
                throw OracleJsonExceptions.NEST_DEPTH_EXCEEDED.create(this.getExceptionFactory(), 65536);
            }
            this.previousSiblingIdx = -1;
        }

        private void addOp(int op) {
            int thisOp = this.numOps++;
            this.ops[thisOp] = (short)op;
            this.depths[thisOp] = (short)this.depth;
            if (this.previousSiblingIdx != -1) {
                this.nextSiblings[this.previousSiblingIdx] = thisOp;
            }
            this.nextSiblings[thisOp] = -1;
            if (this.depth > 0) {
                int n = this.opStack[this.depth - 1];
                this.numChildren[n] = this.numChildren[n] + 1;
            }
            this.previousSiblingIdx = thisOp;
        }

        private void expandOp() {
            int l = this.ops.length * 2;
            this.ops = Arrays.copyOf(this.ops, l);
            this.nextSiblings = Arrays.copyOf(this.nextSiblings, l);
            this.fieldIDs = Arrays.copyOf(this.fieldIDs, l);
            this.depths = Arrays.copyOf(this.depths, l);
            this.numChildren = Arrays.copyOf(this.numChildren, l);
            this.valueIndex = Arrays.copyOf(this.valueIndex, l);
        }

        private void preOp() {
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.numChildren[this.numOps] = 0;
        }

        private void postOp(boolean shareable) {
            if (this.lastValueSharing && this.keyI != -1 && this.keyJ != -1) {
                this.initKeysLastSeenValue(this.keyI);
                int idx = this.numOps - 1;
                if (this.numChildren[idx] >= 0 && shareable) {
                    this.keysLastSeenValue[this.keyI][this.keyJ] = idx;
                }
                this.keyJ = -1;
                this.keyI = -1;
            }
            this.opLastValue = -1;
        }

        private void addValue(byte[] bytes) {
            this.expandValueHeap(bytes.length);
            this.addValueNoCheck(bytes);
        }

        private void addValueNoCheck(byte[] bytes) {
            this.valueIndex[this.numOps] = this.valueHeapSize;
            System.arraycopy(bytes, 0, this.valueHeap, this.valueHeapSize, bytes.length);
            this.valueHeapSize += bytes.length;
        }

        private boolean equals(byte[] a1, int a1Start, byte[] a2, int a2Start, int len) {
            for (int i = 0; i < len; ++i) {
                if (a1[a1Start] != a2[a2Start]) {
                    return false;
                }
                ++a1Start;
                ++a2Start;
            }
            return true;
        }

        private void expandValueHeap(int len) {
            if (len + this.valueHeapSize >= this.valueHeap.length) {
                int newSize = (len + this.valueHeapSize) * 2;
                if (newSize <= 0) {
                    throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
                }
                this.valueHeap = Arrays.copyOf(this.valueHeap, newSize);
            }
        }

        private void initializeKeyHeap() throws UnsupportedEncodingException {
            if (this.keyHeap == null) {
                this.keyHeap = new byte[this.distinctKeysSize * 15];
            }
            if (this.keyHeapOffsets == null || this.keyHeapOffsets.length < this.distinctKeysSize) {
                this.keyHeapOffsets = new int[this.distinctKeysSize];
            }
            this.keyHeapSize = 0;
            for (int i = 0; i < this.distinctKeysSize; ++i) {
                this.keyHeapOffsets[i] = this.keyHeapSize;
                String key = this.distinctKeys[i];
                int maxBytesAdded = 1 + key.length() * 4;
                if (maxBytesAdded + this.keyHeapSize >= this.keyHeap.length) {
                    this.keyHeap = Arrays.copyOf(this.keyHeap, (this.keyHeap.length + maxBytesAdded) * 2);
                }
                int result = this.writeString(key, this.keyHeap, this.keyHeapSize + 1);
                int len = result - this.keyHeapSize - 1;
                this.keyHeap[this.keyHeapSize] = (byte)len;
                this.keyHeapSize = result;
            }
        }

        public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
            return OracleJsonExceptions.ORACLE_FACTORY;
        }

        private int writeString(String value, byte[] destination, int destinationPos) {
            int ct = destinationPos;
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u007f') {
                    return this.slowWriteString(value, destination, destinationPos);
                }
                destination[ct++] = (byte)c;
            }
            return ct;
        }

        private int writeUTF8String(byte[] source, int sourceOffset, int len, byte[] destination, int destinationPos) {
            int ct = destinationPos;
            for (int i = 0; i < len; ++i) {
                destination[ct++] = source[sourceOffset++];
            }
            return ct;
        }

        private int slowWriteString(String value, byte[] destination, int destinationPos) {
            byte[] result = value.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < result.length; ++i) {
                destination[destinationPos++] = result[i];
            }
            return destinationPos;
        }

        private void writeHeader() throws IOException {
            if (this.bigKeys == null) {
                this.writeInt(-11904511);
            } else {
                this.writeInt(-11904509);
            }
            if (this.distinctKeysSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 8);
            } else if (this.distinctKeysSize >= 256) {
                this.headerFlags = (short)(this.headerFlags | 0x400);
            }
            if (this.distinctKeysSize > 0) {
                this.headerFlags = (short)(this.headerFlags | 0x100);
            }
            if (this.keyHeapSize >= 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x800);
            }
            if (this.treeSegmentSize > 65536) {
                this.headerFlags = (short)(this.headerFlags | 0x1000);
            }
            if (this.relativeOffsets) {
                this.headerFlags = (short)(this.headerFlags | 1);
            }
            if (this.numOps == 1 && !this.isObject(this.ops[0]) && !this.isArray(this.ops[0])) {
                int flags = this.headerFlags;
                flags &= 0xFFFFDFFF;
                this.writeShort(flags |= 0x10);
                this.writeTreeSegmentSize();
                return;
            }
            this.writeShort(this.headerFlags);
            if (this.distinctKeysSize >= 65536) {
                this.writeInt(this.distinctKeysSize);
            } else if (this.distinctKeysSize >= 256) {
                this.writeShort(this.distinctKeysSize);
            } else {
                this.writeByte(this.distinctKeysSize);
            }
            if (this.keyHeapSize >= 65536) {
                this.writeInt(this.keyHeapSize);
            } else {
                this.writeShort(this.keyHeapSize);
            }
            if (this.bigKeys != null) {
                for (BigKey bk : this.bigKeys.keySet()) {
                    this.bigKeysHeapSize += bk.key.length;
                }
                this.bigKeysHeapSize += this.bigKeys.size() * 2;
                if (this.bigKeysHeapSize < 65536) {
                    this.writeShort(256);
                } else {
                    this.writeShort(0);
                }
                this.writeInt(this.bigKeys.size());
                this.writeInt(this.bigKeysHeapSize);
            }
            this.writeTreeSegmentSize();
            if ((this.headerFlags & 0x2000) != 0) {
                this.writeShort(this.tinyNodeCount);
            } else {
                this.writeShort(0);
            }
        }

        private void writeTreeSegmentSize() throws IOException {
            if (this.treeSegmentSize > 65536) {
                this.writeInt(this.treeSegmentSize);
            } else {
                this.writeShort(this.treeSegmentSize);
            }
        }

        private void writeNameDictionary() throws IOException {
            if (this.fidMap == null || this.fidMap.length < this.distinctKeysSize + (this.bigKeys == null ? 0 : this.bigKeys.size())) {
                this.fidMap = new int[this.distinctKeysSize + (this.bigKeys == null ? 0 : this.bigKeys.size())];
            }
            this.initTemporaryIntArray(this.distinctKeysSize);
            if (this.seenHashSize < SEEN_HASH_THRESHOLD) {
                Arrays.sort(this.seenHash, 0, this.seenHashSize);
                int offIdx = 0;
                for (int k = 0; k < this.seenHashSize; ++k) {
                    int i = this.seenHash[k];
                    offIdx = this.processBucket(offIdx, i);
                }
            } else {
                int offIdx = 0;
                for (int i = 0; i < this.keys.length; ++i) {
                    if (this.keys[i] == null) continue;
                    offIdx = this.processBucket(offIdx, i);
                }
            }
            this.keysNeedReset = false;
            if (this.keyHeapSize >= 65536) {
                this.writeUb4Array(this.temporaryIntArray, this.distinctKeysSize);
            } else {
                this.writeUb2Array(this.temporaryIntArray, this.distinctKeysSize);
            }
            this.write(this.keyHeap, 0, this.keyHeapSize);
        }

        private int processBucket(int offIdx, int hash) throws IOException {
            int off;
            int[] bucket = this.keys[hash];
            int[] lastValuesBucket = this.lastValueSharing ? this.keysLastSeenValue[hash] : null;
            this.sortBucket(bucket);
            for (int j = 0; j < bucket.length && (off = bucket[j] - 1) != -1; ++j) {
                this.writeByte(hash);
                bucket[j] = 0;
                if (this.lastValueSharing) {
                    lastValuesBucket[j] = 0;
                }
                this.fidMap[off] = offIdx;
                this.temporaryIntArray[offIdx++] = this.keyHeapOffsets[off];
            }
            return offIdx;
        }

        private void sortBucket(int[] bucket) {
            for (int i = 0; i < bucket.length && bucket[i] != 0; ++i) {
                for (int j = i + 1; j < bucket.length && bucket[j] != 0; ++j) {
                    int keyHeapOff2 = this.keyHeapOffsets[bucket[j] - 1];
                    int l2 = this.keyHeap[keyHeapOff2] & 0xFF;
                    int keyHeapOff1 = this.keyHeapOffsets[bucket[i] - 1];
                    int l1 = this.keyHeap[keyHeapOff1] & 0xFF;
                    if (l2 >= l1 && (l2 != l1 || this.memcmp(keyHeapOff2 + 1, keyHeapOff1 + 1, l1) >= 0)) continue;
                    int tmp = bucket[i];
                    bucket[i] = bucket[j];
                    bucket[j] = tmp;
                }
            }
        }

        private int memcmp(int i, int j, int length) {
            for (int k = 0; k < length; ++k) {
                int d = (this.keyHeap[i + k] & 0xFF) - (this.keyHeap[j + k] & 0xFF);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        private void writeNameDictionary2() throws IOException {
            int i = 0;
            for (Map.Entry<BigKey, Integer> e : this.bigKeys.entrySet()) {
                this.fidMap[this.distinctKeysSize + e.getValue().intValue() - 1] = this.distinctKeysSize + i++;
                this.writeShort(e.getKey().hash);
            }
            int offset = 0;
            for (BigKey bk : this.bigKeys.keySet()) {
                if (this.bigKeysHeapSize < 65536) {
                    this.writeShort(offset);
                } else {
                    this.writeInt(offset);
                }
                offset += 2 + bk.key.length;
            }
            for (BigKey bk : this.bigKeys.keySet()) {
                this.writeShort(bk.key.length);
                this.write(bk.key, 0, bk.key.length);
            }
        }

        private void writeTreeNodeSegment() throws IOException {
            block21: for (int index = 0; index < this.numOps; ++index) {
                int i;
                int childCt;
                int parentOffset;
                short op = this.ops[index];
                if (this.isShared(index)) continue;
                if (this.isArray(op)) {
                    parentOffset = this.offsets[index];
                    childCt = this.numChildren[index];
                    this.writeByte(this.flagObjectOrArray(op, childCt));
                    if (childCt < 256) {
                        this.writeByte(childCt);
                    } else if (childCt < 65536) {
                        this.writeShort(childCt);
                    } else {
                        this.writeInt(childCt);
                    }
                    this.initTemporaryIntArray(childCt);
                    int childIdx = index + 1;
                    for (i = 0; i < childCt; ++i) {
                        this.temporaryIntArray[i] = this.offsets[childIdx];
                        childIdx = this.nextSiblings[childIdx];
                    }
                    this.writeChildOffsets(childCt, this.temporaryIntArray, parentOffset);
                    continue;
                }
                if (this.isObject(op)) {
                    parentOffset = this.offsets[index];
                    childCt = this.numChildren[index];
                    this.writeByte(this.flagObject(op, childCt));
                    this.initTemporaryLongArray(childCt);
                    if (this.sharesFields(op)) {
                        int firstChild = this.firstChild(index);
                        int delagateIdx = this.fieldIDs[firstChild];
                        int delagate = this.offsets[delagateIdx];
                        this.fieldIDs[firstChild] = this.fieldIDs[this.firstChild(delagateIdx)];
                        if (this.treeSegmentSize < 65536) {
                            this.writeShort(delagate);
                        } else {
                            this.writeInt(delagate);
                        }
                        this.packOffsets(index, childCt, this.temporaryLongArray);
                        if (childCt > 10 && (op & 4) == 0) {
                            Arrays.sort(this.temporaryLongArray, 0, childCt);
                        }
                        this.writeChildOffsets(childCt, this.temporaryLongArray, parentOffset);
                        continue;
                    }
                    this.packOffsets(index, childCt, this.temporaryLongArray);
                    if (childCt > 10 && (op & 4) == 0) {
                        Arrays.sort(this.temporaryLongArray, 0, childCt);
                    } else if (this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                        this.checkDuplicateKeys(this.temporaryLongArray, childCt);
                    }
                    if (childCt < 256) {
                        this.writeByte(childCt);
                    } else if (childCt < 65536) {
                        this.writeShort(childCt);
                    } else {
                        this.writeInt(childCt);
                    }
                    int lastFid = -1;
                    for (i = 0; i < childCt; ++i) {
                        int fid = this.unpackFid(this.temporaryLongArray[i]);
                        if (fid == lastFid && this.duplicateKeyMode == DuplicateKeyMode.DISALLOW) {
                            throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), this.reverseFidMap(fid));
                        }
                        lastFid = fid;
                        if (this.distinctKeysSize >= 65536) {
                            this.writeInt(fid);
                            continue;
                        }
                        if (this.distinctKeysSize >= 256) {
                            this.writeShort(fid);
                            continue;
                        }
                        this.writeByte(fid);
                    }
                    this.writeChildOffsets(childCt, this.temporaryLongArray, parentOffset);
                    continue;
                }
                if (op <= 31) {
                    this.writeOpAndData(op, this.valueHeap, this.valueIndex[index], op);
                    continue;
                }
                if (OsonConstants.isSB4(op) || OsonConstants.isSB8(op) || OsonConstants.isOraNum16(op) || OsonConstants.isDec_16(op)) {
                    this.writeByte(op);
                    this.write(this.valueHeap, this.valueIndex[index], this.numChildren[index]);
                    continue;
                }
                switch (op) {
                    case 49: {
                        this.writeByte(op);
                        continue block21;
                    }
                    case 50: {
                        this.writeByte(op);
                        continue block21;
                    }
                    case 48: {
                        this.writeByte(op);
                        continue block21;
                    }
                    case 51: 
                    case 52: 
                    case 116: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 55: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeShort(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 56: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeInt(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 54: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 8);
                        continue block21;
                    }
                    case 127: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 4);
                        continue block21;
                    }
                    case 126: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 58: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeShort(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 59: {
                        this.writeByte(op);
                        int size = this.numChildren[index];
                        this.writeInt(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 57: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMP);
                        continue block21;
                    }
                    case 125: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC);
                        continue block21;
                    }
                    case 124: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_TIMESTAMPTZ);
                        continue block21;
                    }
                    case 60: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], OsonPrimitiveConversions.SIZE_DATE);
                        continue block21;
                    }
                    case 62: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 11);
                        continue block21;
                    }
                    case 61: {
                        this.writeByte(op);
                        this.write(this.valueHeap, this.valueIndex[index], 5);
                        continue block21;
                    }
                    case 53: {
                        int size = this.numChildren[index];
                        if (size == 0) continue block21;
                        this.writeByte(op);
                        this.writeByte(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    case 31489: {
                        int size = this.numChildren[index];
                        this.writeShort(op);
                        this.writeInt(size);
                        this.write(this.valueHeap, this.valueIndex[index], size);
                        continue block21;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(op));
                    }
                }
            }
        }

        private String reverseFidMap(int fid) {
            for (int i = 0; i < this.distinctKeysSize; ++i) {
                if (this.fidMap[i] != fid - 1) continue;
                return this.distinctKeys[i];
            }
            return "";
        }

        private void packOffsets(int index, int childCt, long[] packedArray) {
            int childIdx = index + 1;
            for (int i = 0; i < childCt; ++i) {
                int childKeyIdx = this.fieldIDs[childIdx];
                if (childKeyIdx < 0) {
                    childKeyIdx = this.distinctKeysSize + Math.abs(childKeyIdx) - 1;
                }
                long fid = this.fidMap[childKeyIdx] + 1;
                packedArray[i] = fid << 32 | (long)this.offsets[childIdx];
                childIdx = this.nextSiblings[childIdx];
            }
        }

        private boolean sharesFields(int op) {
            return (op & 0x18) == 24;
        }

        private boolean isReferredTo(int op) {
            return (op & 2) == 2;
        }

        private void tryFieldIdSharing(int primaryIndex) {
            int siblingIndex = this.nextSiblings[primaryIndex];
            while (siblingIndex != -1) {
                if (this.sameFieldIds(primaryIndex, siblingIndex)) {
                    int n = siblingIndex;
                    this.ops[n] = (short)(this.ops[n] | 0x18);
                    int n2 = primaryIndex;
                    this.ops[n2] = (short)(this.ops[n2] | 2);
                    int firstChild = this.firstChild(siblingIndex);
                    this.fieldIDs[firstChild] = primaryIndex;
                }
                siblingIndex = this.nextSiblings[siblingIndex];
            }
        }

        private int firstChild(int index) {
            if (index + 1 >= this.numOps) {
                return -1;
            }
            int nextDepth = this.depths[index + 1] & 0xFFFF;
            int thisDepth = this.depths[index] & 0xFFFF;
            if (nextDepth == thisDepth + 1) {
                return index + 1;
            }
            return -1;
        }

        private boolean sameFieldIds(int p1, int p2) {
            if (!this.isObject(this.ops[p1]) || !this.isObject(this.ops[p2]) || this.numChildren[p1] != this.numChildren[p2] || this.numChildren[p1] == 0 || (this.ops[p1] & 4) != 0 || (this.ops[p2] & 4) != 0) {
                return false;
            }
            int child1 = this.firstChild(p1);
            int child2 = this.firstChild(p2);
            do {
                if (this.fieldIDs[child1] != this.fieldIDs[child2]) {
                    return false;
                }
                child1 = this.nextSiblings[child1];
                child2 = this.nextSiblings[child2];
                if (child1 != -1) continue;
                return child2 == -1;
            } while (child2 != -1);
            return false;
        }

        private boolean isArray(int op) {
            return (op & 0xC0) == 192;
        }

        private boolean isObject(int op) {
            return (op & 0xC0) == 128;
        }

        private boolean isStructure(int op) {
            return (byte)op < 0;
        }

        private void writeChildOffsets(int childCt, long[] arr, int fixedOffset) throws IOException {
            int delta;
            int n = delta = this.relativeOffsets ? fixedOffset : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i = 0; i < childCt; ++i) {
                    short off = (short)(arr[i] & 0xFFFFL);
                    off = (short)(off - delta);
                    this.writeShort(off);
                }
            } else {
                for (int i = 0; i < childCt; ++i) {
                    int off = (int)(arr[i] & 0xFFFFFFFFFFFFFFFFL);
                    this.writeInt(off -= delta);
                }
            }
        }

        private void writeChildOffsets(int childCt, int[] arr, int fixedOffset) throws IOException {
            int delta;
            int n = delta = this.relativeOffsets ? fixedOffset : 0;
            if (this.treeSegmentSize < 65536) {
                for (int i = 0; i < childCt; ++i) {
                    short off = (short)(arr[i] & 0xFFFF);
                    this.writeShort(off - delta);
                }
            } else {
                for (int i = 0; i < childCt; ++i) {
                    int off = arr[i];
                    this.writeInt(off - delta);
                }
            }
        }

        private void initTemporaryLongArray(int ct) {
            if (this.temporaryLongArray == null || this.temporaryLongArray.length < ct) {
                this.temporaryLongArray = new long[ct];
            }
        }

        private int unpackFid(long packed) {
            return (int)(packed >>> 32);
        }

        public void checkDuplicateKeys(long[] children, int count) {
            for (int i = 0; i < count; ++i) {
                int fid = this.unpackFid(children[i]);
                for (int j = i + 1; j < count; ++j) {
                    if (this.unpackFid(children[j]) != fid) continue;
                    String key = fid <= this.distinctKeysSize ? this.reverseFidMap(fid) : this.getBigKeyByFid(fid);
                    throw OracleJsonExceptions.DUPLICATE_KEY.create(this.getExceptionFactory(), key);
                }
            }
        }

        private String getBigKeyByFid(int fid) {
            int fieldId = -1;
            for (int k = 0; k < this.fidMap.length; ++k) {
                if (this.fidMap[k] != fid) continue;
                fieldId = k;
                break;
            }
            for (Map.Entry<BigKey, Integer> k : this.bigKeys.entrySet()) {
                if (k.getValue() != fieldId) continue;
                return new String(k.getKey().key);
            }
            return "";
        }

        private void initTemporaryIntArray(int ct) {
            if (this.temporaryIntArray == null || this.temporaryIntArray.length < ct) {
                this.temporaryIntArray = new int[ct];
            }
        }

        private void computeOffsets() {
            int size;
            int i;
            if (this.offsets == null || this.numOps > this.offsets.length) {
                this.offsets = new int[this.numOps];
            }
            int offset = 0;
            this.tinyNodeCount = 0;
            for (i = 0; i < this.numOps; ++i) {
                if (this.isShared(i)) {
                    this.offsets[i] = this.offsets[-this.numChildren[i]];
                    continue;
                }
                this.offsets[i] = offset;
                if (this.isFirstChildObjectOfArray(i)) {
                    this.tryFieldIdSharing(i);
                }
                size = this.sizeOfOp(i, 2);
                this.countTiny(i, size);
                if ((offset += size) < 65536) continue;
                offset = -1;
                break;
            }
            if (offset != -1) {
                this.treeSegmentSize = offset;
                return;
            }
            offset = 0;
            this.tinyNodeCount = 0;
            for (i = 0; i < this.numOps; ++i) {
                if (this.isShared(i)) {
                    this.offsets[i] = this.offsets[-this.numChildren[i]];
                    continue;
                }
                this.offsets[i] = offset;
                if (this.isFirstChildObjectOfArray(i)) {
                    this.tryFieldIdSharing(i);
                }
                size = this.sizeOfOp(i, 4);
                this.countTiny(i, size);
                if ((offset += size) >= 0) continue;
                throw OracleJsonExceptions.IMAGE_TOO_BIG.create(this.getExceptionFactory(), new Object[0]);
            }
            this.treeSegmentSize = offset;
        }

        private boolean isShared(int opIndex) {
            return this.numChildren[opIndex] < 0;
        }

        private void countTiny(int i, int size) {
            if (this.isStructure(this.ops[i]) && (size < 5 || this.isObject(this.ops[i]) && this.isReferredTo(this.ops[i]))) {
                ++this.tinyNodeCount;
            }
        }

        private boolean isFirstChildObjectOfArray(int i) {
            return this.isObject(this.ops[i]) && i > 0 && this.firstChild(i - 1) == i && this.isArray(this.ops[i - 1]);
        }

        private int sizeOfOp(int index, int offsetSize) {
            short op = this.ops[index];
            if (this.isShared(index)) {
                return 0;
            }
            if (this.isArray(op)) {
                int numOfChildren = this.numChildren[index];
                int bytesForNumChildren = this.bytesForNum(numOfChildren);
                int size = 1 + bytesForNumChildren;
                return size += offsetSize * numOfChildren;
            }
            if (this.isObject(op)) {
                int numOfChildren = this.numChildren[index];
                if (this.sharesFields(op)) {
                    return 1 + offsetSize + numOfChildren * offsetSize;
                }
                int bytesForNumChildren = this.bytesForNum(numOfChildren);
                int fidArraySize = numOfChildren;
                if (this.distinctKeysSize >= 65536) {
                    fidArraySize *= 4;
                } else if (this.distinctKeysSize >= 256) {
                    fidArraySize *= 2;
                }
                int size = 1 + bytesForNumChildren + fidArraySize;
                return size += numOfChildren * offsetSize;
            }
            if (op <= 31) {
                return 1 + op;
            }
            if (OsonConstants.isSB4(op) || OsonConstants.isSB8(op) || OsonConstants.isOraNum16(op) || OsonConstants.isDec_16(op)) {
                return 1 + this.numChildren[index];
            }
            switch (op) {
                case 49: {
                    return 1;
                }
                case 50: {
                    return 1;
                }
                case 48: {
                    return 1;
                }
                case 51: {
                    return 2 + this.numChildren[index];
                }
                case 55: {
                    return 3 + this.numChildren[index];
                }
                case 56: {
                    return 5 + this.numChildren[index];
                }
                case 52: 
                case 116: {
                    return 2 + this.numChildren[index];
                }
                case 54: {
                    return 9;
                }
                case 127: {
                    return 5;
                }
                case 58: {
                    return 3 + this.numChildren[index];
                }
                case 59: {
                    return 5 + this.numChildren[index];
                }
                case 126: {
                    return 2 + this.numChildren[index];
                }
                case 57: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP + 1;
                }
                case 125: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC + 1;
                }
                case 124: {
                    return OsonPrimitiveConversions.SIZE_TIMESTAMPTZ + 1;
                }
                case 60: {
                    return OsonPrimitiveConversions.SIZE_DATE + 1;
                }
                case 62: {
                    return 12;
                }
                case 61: {
                    return 6;
                }
                case 53: {
                    int size = this.numChildren[index];
                    return size == 0 ? 0 : 2 + size;
                }
                case 31489: {
                    return 6 + this.numChildren[index];
                }
            }
            throw new UnsupportedOperationException(String.valueOf(op));
        }

        private int bytesForNum(int i) {
            if (i < 256) {
                return 1;
            }
            if (i < 65536) {
                return 2;
            }
            return 4;
        }

        private int flagObject(int op, int numChildren) {
            if (numChildren <= 10) {
                return this.flagObjectOrArray(op, numChildren) | 4;
            }
            return this.flagObjectOrArray(op, numChildren);
        }

        private int flagObjectOrArray(int op, int numChildren) {
            if (numChildren >= 256) {
                op = numChildren < 65536 ? (op |= 8) : (op |= 0x10);
            }
            if (this.treeSegmentSize > 65536) {
                op |= 0x20;
            }
            return op;
        }

        private void writeUb2Array(int[] arr, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.writeShort(arr[i]);
            }
        }

        private void writeUb4Array(int[] arr, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.writeInt(arr[i]);
            }
        }

        private final void writeInt(int value) throws IOException {
            if (this.outBufferPos + 3 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 24 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 16 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 0 & 0xFF);
        }

        private final void writeShort(int value) throws IOException {
            if (this.outBufferPos + 1 >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 8 & 0xFF);
            this.outBuffer[this.outBufferPos++] = (byte)(value >>> 0 & 0xFF);
        }

        private final void writeByte(int b) throws IOException {
            if (this.outBufferPos >= this.outBuffer.length) {
                this.flushBuffer();
            }
            this.outBuffer[this.outBufferPos++] = (byte)b;
        }

        private void flushBuffer() throws IOException {
            this.out.write(this.outBuffer, 0, this.outBufferPos);
            this.outBufferPos = 0;
        }

        private final void write(byte[] bytes, int start, int len) throws IOException {
            if (this.outBufferPos + len > this.outBuffer.length) {
                this.flushBuffer();
                if (len >= this.outBuffer.length) {
                    this.out.write(bytes, start, len);
                    return;
                }
            }
            System.arraycopy(bytes, start, this.outBuffer, this.outBufferPos, len);
            this.outBufferPos += len;
        }

        private final void writeOpAndData(int op, byte[] bytes, int start, int len) throws IOException {
            if (this.outBufferPos + (len + 1) > this.outBuffer.length) {
                this.flushBuffer();
                if (len + 1 >= this.outBuffer.length) {
                    this.out.write(op);
                    this.out.write(bytes, start, len);
                    return;
                }
            }
            this.outBuffer[this.outBufferPos++] = (byte)op;
            System.arraycopy(bytes, start, this.outBuffer, this.outBufferPos, len);
            this.outBufferPos += len;
        }

        private void reset(OutputStream out) {
            this.out = out;
            this.valueHeapSize = 0;
            this.numOps = 0;
            this.distinctKeysSize = 0;
            this.seenHashSize = 0;
            this.headerFlags = (short)8198;
            this.bigKeys = null;
            this.bigKeysHeapSize = 0;
            this.setUseRelativeOffsets(DEFAULT_RELATIVE_OFFSETS);
            this.setTinyNodeStat(DEFAULT_TINYNODE);
            this.setSimpleValueSharing(DEFAULT_SIMPLE_VALUE_SHARING);
            this.setLastValueSharing(DEFAULT_LAST_VALUE_SHARING);
            if (this.keysNeedReset) {
                for (int i = 0; i < this.keys.length; ++i) {
                    for (int j = 0; this.keys[i] != null && j < this.keys[i].length && this.keys[i][j] != 0; ++j) {
                        this.keys[i][j] = 0;
                        if (!this.lastValueSharing) continue;
                        this.keysLastSeenValue[i][j] = 0;
                    }
                }
            }
            this.opLastValue = -1;
            this.keysNeedReset = true;
            this.depth = 0;
            this.outBufferPos = 0;
            this.tinyNodeCount = 0;
            this.duplicateKeyMode = DEFAULT_DUPLICATE_KEY_MODE;
            this.opEmptyArray = -1;
            this.opEmptyObject = -1;
            this.opEmptyString = -1;
            this.opOne = -1;
            this.opZero = -1;
            this.opNull = -1;
            this.opFalse = -1;
            this.opTrue = -1;
            this.keyJ = -1;
            this.keyI = -1;
            this.ctx.init();
            this.ctx.setExceptionFactory(this.getExceptionFactory());
        }

        private void initKeysLastSeenValue(int i) {
            if (this.keysLastSeenValue == null) {
                this.keysLastSeenValue = new int[256][];
            }
            if (this.keysLastSeenValue[i] == null) {
                this.keysLastSeenValue[i] = new int[this.keys[i].length];
            } else if (this.keysLastSeenValue[i].length < this.keys[i].length) {
                this.keysLastSeenValue[i] = Arrays.copyOf(this.keysLastSeenValue[i], this.keys[i].length);
            }
        }

        public void setTinyNodeStat(boolean value) {
            this.headerFlags = value ? (short)(this.headerFlags | 0x2000) : (short)(this.headerFlags & 0xFFFFDFFF);
        }

        public void setUseRelativeOffsets(boolean value) {
            this.relativeOffsets = value;
        }

        public void setSimpleValueSharing(boolean value) {
            this.simpleValueSharing = value;
        }

        public void setLastValueSharing(boolean value) {
            this.lastValueSharing = value;
        }

        private void writeTimestamp(byte[] raw) {
            if (raw.length == OsonPrimitiveConversions.SIZE_TIMESTAMP) {
                this.fixedBinary(57, raw.length, raw);
            } else {
                this.fixedBinary(125, raw.length, raw);
            }
        }

        public void writeTimestampTZ(byte[] raw) {
            OsonPrimitiveConversions.assertNoRegionTimestampTZ(this.getExceptionFactory(), raw);
            this.fixedBinary(124, raw.length, raw);
        }

        private void writeDate(byte[] raw) {
            this.fixedBinary(60, OsonPrimitiveConversions.SIZE_DATE, raw);
        }

        private void writeIntervalYM(byte[] raw) {
            this.fixedBinary(61, 5, raw);
        }

        private void writeIntervalDS(byte[] raw) {
            this.fixedBinary(62, 11, raw);
        }

        public void writeVector(byte[] raw) {
            this.fixedBinary(31489, raw.length, raw);
        }

        private void fixedBinary(int op, int len, byte[] bytes) {
            if (len != bytes.length) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(op, bytes);
        }

        public void close() {
            this.ctx.close();
            try {
                this.initializeKeyHeap();
                this.computeOffsets();
                this.writeHeader();
                this.writeNameDictionary();
                if (this.bigKeys != null) {
                    this.writeNameDictionary2();
                }
                this.writeTreeNodeSegment();
                this.flushBuffer();
                this.out.close();
            }
            catch (IOException e) {
                throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
            }
        }

        private void writeString(String value) {
            this.preOp();
            this.expandValueHeap(value.length() * 4);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            int newPos = this.writeString(value, this.valueHeap, this.valueHeapSize);
            int len = newPos - this.valueHeapSize;
            this.valueHeapSize = newPos;
            this.writeStringOp(newPos, len);
            boolean duplicate = this.checkStringDuplicate(len);
            this.postOp(!duplicate);
        }

        private boolean checkStringDuplicate(int len) {
            if (this.lastValueSharing && this.opLastValue != -1 && this.ops[this.numOps - 1] == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == len && this.equals(this.valueHeap, this.valueIndex[this.numOps - 1], this.valueHeap, this.valueIndex[this.opLastValue], len)) {
                this.markDuplicate(this.numOps - 1, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            if (len == 0 && this.simpleValueSharing) {
                if (this.opEmptyString == -1) {
                    this.opEmptyString = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opEmptyString);
                }
                return true;
            }
            return false;
        }

        private void writeUTF8String(byte[] array, int offset, int len) {
            int newPos;
            this.preOp();
            this.expandValueHeap(len);
            this.valueIndex[this.numOps] = this.valueHeapSize;
            this.valueHeapSize = newPos = this.writeUTF8String(array, offset, len, this.valueHeap, this.valueHeapSize);
            this.writeStringOp(newPos, len);
            this.checkStringDuplicate(len);
            this.postOp(true);
        }

        private void writeStringOp(int newPos, int len) {
            if (len <= 31) {
                this.addOp(len);
            } else if (len < 256) {
                this.addOp(51);
            } else if (len < 65536) {
                this.addOp(55);
            } else {
                this.addOp(56);
            }
            this.numChildren[this.numOps - 1] = len;
            this.ctx.primitive();
        }

        private void writeStartObject() {
            this.preOp();
            this.addOp(128);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartObjectNoSort() {
            this.preOp();
            this.addOp(132);
            this.push(this.numOps - 1);
            this.ctx.startObject();
            this.postOp(false);
        }

        private void writeStartArray() {
            this.preOp();
            this.addOp(192);
            this.push(this.numOps - 1);
            this.ctx.startArray();
            this.postOp(false);
        }

        public void writeEnd() {
            this.ctx.end();
            --this.depth;
            this.previousSiblingIdx = this.opStack[this.depth];
            if (this.simpleValueSharing && this.numChildren[this.opStack[this.depth]] == 0) {
                int index = this.opStack[this.depth];
                if (this.isArray(this.ops[index])) {
                    if (this.opEmptyArray == -1) {
                        this.opEmptyArray = index;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(index, this.opEmptyArray);
                    }
                } else if (this.opEmptyObject == -1) {
                    this.opEmptyObject = index;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(index, this.opEmptyObject);
                }
            }
        }

        private void writeDouble(double value) {
            byte[] bytes = OsonPrimitiveConversions.doubleToCanonicalFormatBytes(value);
            this.addOpAndValue(54, bytes);
        }

        private void writeBoolean(boolean value) {
            this.preOp();
            if (value) {
                this.addOp(49);
                if (this.simpleValueSharing) {
                    if (this.opTrue == -1) {
                        this.opTrue = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opTrue);
                    }
                }
            } else {
                this.addOp(50);
                if (this.simpleValueSharing) {
                    if (this.opFalse == -1) {
                        this.opFalse = this.numOps - 1;
                    } else {
                        this.headerFlags = (short)(this.headerFlags | 0x20);
                        this.markDuplicate(this.numOps - 1, this.opFalse);
                    }
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }

        private void writeOraNumber(OracleJsonDecimal value) {
            OracleJsonDecimalImpl impl = (OracleJsonDecimalImpl)value;
            if (impl.isDec()) {
                this.writeDecimal(impl.bigDecimalValue());
            } else if (impl.isSB4()) {
                this.writeSB4(impl.intValue());
            } else if (impl.isSB8()) {
                this.writeSB8(impl.longValue());
            } else {
                this.writeNumber(impl.raw());
            }
        }

        private void writeDecimal(BigDecimal value) {
            byte[] bytes = OsonPrimitiveConversions.toNumber(value);
            this.writeDecimal(bytes);
        }

        private void writeDecimal(byte[] bytes) {
            if (bytes.length <= 8) {
                this.addOpAndValue(bytes.length - 1 | OsonConstants.MASK_DEC_16, bytes);
            } else if (bytes.length < 256) {
                this.addOpAndValue(116, bytes);
            }
        }

        private void writeDecimal(BigInteger value) {
            this.writeDecimal(OsonPrimitiveConversions.toNumber(value));
        }

        private void writeSB4(int value) {
            byte[] raw = OsonPrimitiveConversions.toNumber(value);
            int op = raw.length | OsonConstants.MASK_SB4;
            this.addOpAndValue(op, raw);
        }

        private void markDuplicate(int index, int replacingIndex) {
            this.numChildren[index] = -replacingIndex;
        }

        private boolean tryMarkDuplicate(int op, byte[] bytes) {
            if (this.lastValueSharing && this.opLastValue != -1 && op == this.ops[this.opLastValue] && this.numChildren[this.opLastValue] == bytes.length && this.equals(bytes, 0, this.valueHeap, this.valueIndex[this.opLastValue], bytes.length)) {
                this.markDuplicate(this.numOps, this.opLastValue);
                this.headerFlags = (short)(this.headerFlags | 0x40);
                return true;
            }
            return false;
        }

        private void addOpAndValue(int op, byte[] raw) {
            this.addOpAndValueNoPostOp(op, raw);
            this.postOp(true);
        }

        private void addOpAndValueNoPostOp(int op, byte[] raw) {
            this.preOp();
            if (!this.tryMarkDuplicate(op, raw)) {
                this.addValue(raw);
                this.numChildren[this.numOps] = raw.length;
            }
            this.addOp(op);
            this.ctx.primitive();
        }

        public void writeSB8(long value) {
            byte[] raw = OsonPrimitiveConversions.toNumber(value);
            this.addOpAndValue(raw.length | OsonConstants.MASK_SB8, raw);
        }

        private void writeNumberAsString(BigDecimal bd) {
            byte[] bytes = bd.toString().getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 256) {
                throw new IllegalArgumentException();
            }
            this.addOpAndValue(53, bytes);
        }

        private void writeBytes(byte[] bytes) {
            int op = bytes.length < 65536 ? 58 : 59;
            this.addOpAndValue(op, bytes);
        }

        protected void writeId(byte[] bytes) {
            if (bytes.length > 16) {
                throw new UnsupportedOperationException();
            }
            this.addOpAndValue(126, bytes);
        }

        private void writeFloat(float value) {
            byte[] bytes = OsonPrimitiveConversions.floatToCanonicalFormatBytes(value);
            this.addOpAndValue(127, bytes);
        }

        private void writeKey(String key) {
            int fid;
            this.ctx.pendingKey();
            if (this.numOps >= this.ops.length) {
                this.expandOp();
            }
            this.keyI = OsonHeader.ohash(key, this.keylen);
            if (this.keylen.get() > OsonConstants.MAX_SMALL_KEY_LENGTH) {
                BigKey bigKey;
                Integer fid2;
                if (this.keylen.get() > OsonConstants.MAX_BIG_KEY_LENGTH) {
                    throw OracleJsonExceptions.KEY_TOO_LONG.create(this.getExceptionFactory(), new Object[0]);
                }
                if (this.bigKeys == null) {
                    this.bigKeys = new TreeMap();
                }
                if ((fid2 = this.bigKeys.get(bigKey = new BigKey(key))) == null) {
                    fid2 = this.bigKeys.size() + 1;
                    this.bigKeys.put(bigKey, fid2);
                }
                this.fieldIDs[this.numOps] = -fid2.intValue();
                return;
            }
            int[] fids = this.keys[this.keyI];
            if (fids == null) {
                this.keys[this.keyI] = new int[2];
                fids = this.keys[this.keyI];
            }
            this.keyJ = 0;
            while (this.keyJ < fids.length && (fid = fids[this.keyJ] - 1) != -1) {
                if (this.distinctKeys[fid].equals(key)) {
                    this.fieldIDs[this.numOps] = fid;
                    if (this.lastValueSharing) {
                        this.opLastValue = this.keysLastSeenValue[this.keyI][this.keyJ];
                    }
                    return;
                }
                ++this.keyJ;
            }
            if (this.keyJ >= fids.length) {
                this.keys[this.keyI] = Arrays.copyOf(this.keys[this.keyI], this.keys[this.keyI].length * 2);
                fids = this.keys[this.keyI];
            } else if (this.keyJ == 0 && this.seenHashSize < SEEN_HASH_THRESHOLD) {
                this.seenHash[this.seenHashSize++] = this.keyI;
            }
            if (this.distinctKeysSize + 1 >= this.distinctKeys.length) {
                this.distinctKeys = Arrays.copyOf(this.distinctKeys, this.distinctKeys.length * 2);
            }
            this.fieldIDs[this.numOps] = this.distinctKeysSize;
            this.distinctKeys[this.distinctKeysSize++] = key;
            fids[this.keyJ] = this.distinctKeysSize;
        }

        private void writeNull() {
            this.preOp();
            this.addOp(48);
            if (this.simpleValueSharing) {
                if (this.opNull == -1) {
                    this.opNull = this.numOps - 1;
                } else {
                    this.headerFlags = (short)(this.headerFlags | 0x20);
                    this.markDuplicate(this.numOps - 1, this.opNull);
                }
            }
            this.ctx.primitive();
            this.postOp(true);
        }
    }

    public static enum DuplicateKeyMode {
        ALLOW,
        DISALLOW;

    }
}

