/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    private static final String CLASS_NAME = TcpsConfigure.class.getName();

    private TcpsConfigure() {
    }

    public static void configure(SSLEngine sslEngine, Properties socketOptions, Diagnosable diagnosable) throws NetException {
        String disabledVersions;
        String[] tlsVersions = TcpsConfigure.getTLSVersions(socketOptions, sslEngine, diagnosable);
        Object[] cipherSuites = TcpsConfigure.getCipherSuites(socketOptions, diagnosable);
        if (tlsVersions != null) {
            try {
                sslEngine.setEnabledProtocols(tlsVersions);
            }
            catch (IllegalArgumentException e) {
                throw (NetException)new NetException(17951).initCause(e);
            }
        }
        if ((disabledVersions = (String)socketOptions.get(53)) != null && !disabledVersions.isEmpty()) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Disabled TLS Versions = {0}", (String)null, null, (Object)disabledVersions);
            String[] finalEnabledVersions = TcpsConfigure.removeExcludedVersions(sslEngine.getEnabledProtocols(), disabledVersions);
            sslEngine.setEnabledProtocols(finalEnabledVersions);
        }
        diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Enabled TLS Versions = {0}", (String)null, null, (Object)Arrays.toString(sslEngine.getEnabledProtocols()));
        if (cipherSuites != null) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Configuring SSL CipherSuites = {0}", (String)null, null, (Object)Arrays.toString(cipherSuites));
            try {
                sslEngine.setEnabledCipherSuites((String[])cipherSuites);
            }
            catch (IllegalArgumentException e) {
                throw (NetException)new NetException(17953).initCause(e);
            }
        }
    }

    private static String[] getCipherSuites(Properties socketOptions, Diagnosable diagnosable) throws NetException {
        String cipherSuites = (String)socketOptions.getOrDefault((Object)7, OracleConnection.CONNECTION_PROPERTY_THIN_SSL_CIPHER_SUITES_DEFAULT);
        if (cipherSuites == null) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getCipherSuites", "No SSL CipherSuites configured", null, null);
            return null;
        }
        if ((cipherSuites = cipherSuites.trim()).startsWith("(") && cipherSuites.endsWith(")")) {
            cipherSuites = cipherSuites.substring(1, cipherSuites.length() - 1);
        }
        return cipherSuites.split("\\s*,\\s*");
    }

    private static String[] getTLSVersions(Properties socketOptions, SSLEngine engine, Diagnosable diagnosable) throws NetException {
        String versionStr = (String)socketOptions.getOrDefault((Object)6, OracleConnection.CONNECTION_PROPERTY_THIN_SSL_VERSION_DEFAULT);
        if (versionStr == null) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "No TLS versions configured. Using the default supported versions.", null, null);
            return engine.getEnabledProtocols();
        }
        versionStr = versionStr.trim();
        diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version = {0}", (String)null, null, (Object)versionStr);
        if (versionStr.startsWith("{") && versionStr.endsWith("}")) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version config value in new format.", null, null);
            return versionStr.substring(1, versionStr.length() - 1).split("\\s*,\\s*");
        }
        if (versionStr.startsWith("(") && versionStr.endsWith(")")) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version config value in primitive format.", null, null);
            versionStr = versionStr.substring(1, versionStr.length() - 1).trim();
        }
        if (versionStr.equals("0") || versionStr.equals("undetermined")) {
            return new String[0];
        }
        versionStr = versionStr.replaceAll(" or ", ",");
        String[] versions = versionStr.split("\\s*,\\s*");
        HashSet<String> versionsToBeUsed = new HashSet<String>();
        for (String version : versions) {
            TcpsConfigure.addVersion(engine, version, versionsToBeUsed);
        }
        return versionsToBeUsed.toArray(new String[0]);
    }

    private static void addVersion(SSLEngine engine, String versionStr, Set<String> versionsToBeUsed) throws NetException {
        if (versionStr.endsWith("+")) {
            versionsToBeUsed.addAll(TcpsConfigure.allVersionsEqualAndAbove(engine, versionStr));
        } else if (versionStr.startsWith("TLSv")) {
            versionsToBeUsed.add(versionStr);
        } else if (versionStr.matches("[1]\\.[0-9]")) {
            versionsToBeUsed.add("TLSv" + versionStr);
        } else {
            throw new NetException(17950);
        }
    }

    private static List<String> allVersionsEqualAndAbove(SSLEngine engine, String minVersionStr) throws NetException {
        float minVersion;
        if (minVersionStr.equals("3.0+")) {
            minVersion = 1.0f;
        } else if (minVersionStr.matches("TLSv1\\.[0-9]\\+")) {
            minVersion = Float.parseFloat(minVersionStr.substring(4, 7));
        } else if (minVersionStr.matches("1\\.[0-9]\\+")) {
            minVersion = Float.parseFloat(minVersionStr.substring(0, 3));
        } else {
            throw new NetException(17950);
        }
        return Arrays.stream(engine.getEnabledProtocols()).filter(version -> version.startsWith("TLSv") && Float.parseFloat(version.substring(4)) >= minVersion).collect(Collectors.toList());
    }

    private static String[] removeExcludedVersions(String[] enabledVersions, String versionsRemoved) throws NetException {
        if ((versionsRemoved = versionsRemoved.trim()).startsWith("(") && versionsRemoved.endsWith(")")) {
            versionsRemoved = versionsRemoved.substring(1, versionsRemoved.length() - 1);
        }
        Set disabledVersions = Arrays.stream(versionsRemoved.split("\\s*,\\s*")).map(ver -> ver.matches("1\\.[0-9]") ? "TLSv" + ver : ver).collect(Collectors.toSet());
        return (String[])Arrays.stream(enabledVersions).filter(version -> !disabledVersions.contains(version)).toArray(String[]::new);
    }
}

