/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] jmsConnectionId = null;
    boolean isMarshalOver = false;
    boolean needToBeClosed = false;
    OracleConnection conn = null;
    T4CTTIkpdnrnf notificationHeader = null;
    T4CTTIkpdnrmp messageProperties = null;
    T4CTTIkpdnrpay payload = null;
    NTFManager ntfManager = null;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    boolean isDCNConnection = false;
    CharacterSet charset = null;
    NTFDCNConnection dcnConn = null;

    T4CTTIoaqnfy(T4CConnection t4CConnection, String string, boolean bl) throws SQLException {
        this(t4CConnection, string);
        this.isDCNConnection = bl;
        this.charset = CharacterSet.make(this.conn.getDbCsId());
    }

    T4CTTIoaqnfy(T4CConnection t4CConnection, String string) throws SQLException {
        super(t4CConnection, (byte)3);
        assert (t4CConnection != null && string != null) : "connection is " + t4CConnection + ", jmsConnectionId is " + string;
        this.setFunCode((short)187);
        this.conn = t4CConnection;
        this.mar = t4CConnection.mare;
        this.jmsConnectionId = this.mar.conv.StringToCharBytes(string);
    }

    @Override
    void marshal() throws IOException {
        T4CTTIkpdnrreq t4CTTIkpdnrreq = new T4CTTIkpdnrreq((T4CConnection)this.conn);
        t4CTTIkpdnrreq.send(this.jmsConnectionId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
        this.isMarshalOver = true;
        if (this.dcnConn != null) {
            this.dcnConn.signalConnectionStarted();
        }
    }

    @Override
    void readOAC() throws SQLException, IOException {
        this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
        this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
        this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
        while (true) {
            this.notificationHeader.receive();
            if (this.notificationHeader.messageType != 4) {
                this.messageProperties.receive();
                this.payload.receive();
                if (this.isDCNConnection) {
                    this.createAndGenerateDCNEvent();
                    continue;
                }
                this.createAndGenerateEvent();
                continue;
            }
            if (this.isDCNConnection) continue;
            this.throwException(this.notificationHeader.errorCode);
        }
    }

    private void throwException(int n2) {
        try {
            int n3 = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
            NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n3);
            switch (n2) {
                case 24035: {
                    nTFJMSRegistration.raiseException(2);
                    break;
                }
                case 24010: {
                    nTFJMSRegistration.raiseException(3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createAndGenerateDCNEvent() throws SQLException {
        long l2 = this.notificationHeader.getRegistrationId();
        NTFDCNRegistration nTFDCNRegistration = PhysicalConnection.ntfManager.getDCNRegistration(l2);
        NTFDCNEvent nTFDCNEvent = new NTFDCNEvent(l2, this.payload.getRawPayload(), nTFDCNRegistration.getDatabaseVersion(), this.charset.getOracleId());
        nTFDCNRegistration.notify(nTFDCNEvent);
    }

    public void createAndGenerateEvent() throws SQLException {
        try {
            int n2 = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
            NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n2);
            NTFJMSEvent nTFJMSEvent = new NTFJMSEvent(this);
            nTFJMSEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
            nTFJMSEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
            nTFJMSEvent.setMessageId(this.messageProperties.getMessageId());
            nTFJMSEvent.setPayload(this.payload.getRawPayload());
            nTFJMSEvent.setConsumerName(this.notificationHeader.getConsumerName());
            nTFJMSEvent.setQueueName(this.notificationHeader.getNotificationQueue());
            nTFJMSEvent.setRegistration(this.notificationHeader.getNotificationQueue());
            nTFJMSRegistration.notify(nTFJMSEvent);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void stopListening() {
        while (!this.isMarshalOver) {
        }
        this.needToBeClosed = true;
    }

    public void setDCNConnection(NTFDCNConnection nTFDCNConnection) {
        this.dcnConn = nTFDCNConnection;
    }
}

