/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.TypeDescriptor;

class TypeDescriptorFactory
implements ORADataFactory,
OracleDataFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    TypeDescriptorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData create(Datum datum, int n2) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (n2 == 2007) {
            OPAQUE oPAQUE = (OPAQUE)datum;
            byte[] byArray = oPAQUE.getBytesValue();
            short[] sArray = new short[1];
            TypeDescriptor typeDescriptor = TypeDescriptor.unpickleOpaqueTypeImage(new PickleContext(byArray, 0L), oPAQUE.getPhysicalConnection(), sArray);
            return typeDescriptor;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TypeDescriptorFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleData create(Object object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        if (n2 == 2007) {
            OPAQUE oPAQUE = (OPAQUE)object;
            byte[] byArray = oPAQUE.getBytesValue();
            short[] sArray = new short[1];
            TypeDescriptor typeDescriptor = TypeDescriptor.unpickleOpaqueTypeImage(new PickleContext(byArray, 0L), oPAQUE.getPhysicalConnection(), sArray);
            return typeDescriptor;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TypeDescriptorFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TypeDescriptorFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

