/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.OracleProxy;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.STRUCT;

public class ARRAY
extends DatumWithConnection
implements OracleArray {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor descriptor;
    Object objArray;
    Datum[] datumArray;
    byte[] locator;
    byte prefixFlag;
    byte[] prefixSegment;
    int numElems = -1;
    boolean enableBuffering = false;
    boolean enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int accessDirection = 3;
    long lastIndex;
    long lastOffset;
    long[] indexArray;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(arrayDescriptor) + ", " + OracleLog.argument(connection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY.assertNotNull(arrayDescriptor);
            this.descriptor = arrayDescriptor;
            ARRAY.assertNotNull(connection);
            if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct ARRAY instance + " + "invalid connection");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            arrayDescriptor.setConnection(connection);
            this.setPhysicalConnectionOf(connection);
            this.datumArray = object == null ? new Datum[0] : this.descriptor.toOracleArray(object, 1L, -1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        ARRAY.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        ARRAY.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct ARRAY instance + " + "invalid connection");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
        this.locator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ARRAY toARRAY(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        ARRAY aRRAY = null;
        if (object != null) {
            if (object instanceof ARRAY) {
                aRRAY = (ARRAY)object;
            } else if (object instanceof ORAData) {
                aRRAY = (ARRAY)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof OracleData) {
                Object object2 = ((OracleData)object).toJDBCObject(oracleConnection);
                if (object2 instanceof OracleProxy) {
                    final OracleProxy oracleProxy = (OracleProxy)object2;
                    object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ProxyFactory.extractDelegate(oracleProxy);
                        }
                    });
                }
                aRRAY = (ARRAY)object2;
            } else if (object instanceof CustomDatum) {
                aRRAY = (ARRAY)oracleConnection.physicalConnectionWithin().toDatum((CustomDatum)object);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.SEVERE, "         Throwing SQLException: 59" + object);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaseTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = this.descriptor.getBaseName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseType() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = this.descriptor.getBaseType();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object[] objectArray2 = this.descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getArray(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object[] objectArray2 = this.descriptor.toJavaArray(this, 1L, -1, map, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 1L || n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "Invalid arguments + 'index' should be >= 1 " + "and 'count' >= 0. An exception is thrown.");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Object[] objectArray2 = this.descriptor.toJavaArray(this, l2, n2, this.getMap(), false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getArray(long l2, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 1L || n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "Invalid arguments + 'index' should be >= 1 " + "and 'count' >= 0. An exception is thrown.");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Object[] objectArray2 = this.descriptor.toJavaArray(this, l2, n2, map, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ResultSet resultSet2 = this.getResultSet(this.getInternalConnection().getTypeMap());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ResultSet resultSet2 = this.descriptor.toResultSet(this, 1L, -1, map, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ResultSet resultSet2 = this.getResultSet(l2, n2, this.getInternalConnection().getTypeMap());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(long l2, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            ResultSet resultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 1L || n2 < -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getResultSet()");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getResultSet()");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ResultSet resultSet2 = this.descriptor.toResultSet(this, l2, n2, map, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                resultSet = resultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOracleArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Datum[] datumArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum[] datumArray2 = this.descriptor.toOracleArray(this, 1L, -1, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datumArray = datumArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int length() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = this.descriptor.toLength(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOracleArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Datum[] datumArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 1L || n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getOracleArray()");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getOracleArray()");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Datum[] datumArray2 = this.descriptor.toOracleArray(this, l2, n2, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datumArray = datumArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = null;
                if (this.descriptor == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ARRAY.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 61 + "ARRAY");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "ARRAY");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                string2 = this.descriptor.getName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    @Override
    public Map getMap() throws SQLException {
        return this.getInternalConnection().getTypeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = this.getDescriptor();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + arrayDescriptor);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor2 = arrayDescriptor;
            return arrayDescriptor2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayDescriptor getDescriptor() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.descriptor);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = this.descriptor;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toBytes(this, this.enableBuffering);
        }
    }

    @Override
    public void setDatumArray(Datum[] datumArray) {
        this.datumArray = datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjArray(Object object) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (object == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Invalid argument + 'oarray' should not be " + "null. An exception is thrown.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid argument,'oarray' should not be null. An exception is thrown.");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.objArray = object;
        }
    }

    @Override
    public void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.locator = byArray;
        }
    }

    @Override
    public void setPrefixSegment(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.prefixSegment = byArray;
        }
    }

    @Override
    public void setPrefixFlag(byte by) {
        this.prefixFlag = by;
    }

    @Override
    public byte[] getLocator() {
        return this.locator;
    }

    @Override
    public void setLength(int n2) {
        this.numElems = n2;
    }

    @Override
    public boolean hasDataSeg() {
        return this.locator == null;
    }

    @Override
    public boolean isInline() {
        return (this.prefixFlag & 1) == 1;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleTo(Class clazz) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2][];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIntArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            int[] nArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int[] nArray2 = (int[])this.descriptor.toNumericArray(this, 1L, -1, 4, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nArray = nArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIntArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            int[] nArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int[] nArray2 = (int[])this.descriptor.toNumericArray(this, l2, n2, 4, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nArray = nArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getDoubleArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            double[] dArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                double[] dArray2 = (double[])this.descriptor.toNumericArray(this, 1L, -1, 5, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dArray = dArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getDoubleArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            double[] dArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                double[] dArray2 = (double[])this.descriptor.toNumericArray(this, l2, n2, 5, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dArray = dArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getShortArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            short[] sArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                short[] sArray2 = (short[])this.descriptor.toNumericArray(this, 1L, -1, 8, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sArray = sArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getShortArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            short[] sArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                short[] sArray2 = (short[])this.descriptor.toNumericArray(this, l2, n2, 8, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sArray = sArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getLongArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            long[] lArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long[] lArray2 = (long[])this.descriptor.toNumericArray(this, 1L, -1, 7, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                lArray = lArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getLongArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            long[] lArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument() + ", " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long[] lArray2 = (long[])this.descriptor.toNumericArray(this, l2, n2, 7, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                lArray = lArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFloatArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            float[] fArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                float[] fArray2 = (float[])this.descriptor.toNumericArray(this, 1L, -1, 6, this.enableBuffering);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + fArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                fArray = fArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return fArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFloatArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            float[] fArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                float[] fArray2 = (float[])this.descriptor.toNumericArray(this, l2, n2, 6, false);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + fArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                fArray = fArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return fArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoBuffering(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.enableBuffering = bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoBuffering() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.enableBuffering);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.enableBuffering;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoIndexing(boolean bl, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl) + ", " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.enableIndexing = bl;
                this.accessDirection = n2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoIndexing(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.enableIndexing = bl;
                this.accessDirection = 3;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoIndexing() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.enableIndexing);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.enableIndexing;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAccessDirection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(this.accessDirection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.accessDirection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.accessDirection;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void setLastIndexOffset(long l2, long l3) throws SQLException {
        this.lastIndex = l2;
        this.lastOffset = l3;
    }

    @Override
    public void setIndexOffset(long l2, long l3) throws SQLException {
        if (this.indexArray == null) {
            this.indexArray = new long[this.numElems];
        }
        this.indexArray[(int)l2 - 1] = l3;
    }

    @Override
    public long getLastIndex() throws SQLException {
        return this.lastIndex;
    }

    @Override
    public long getLastOffset() throws SQLException {
        return this.lastOffset;
    }

    @Override
    public long getOffset(long l2) throws SQLException {
        long l3 = -1L;
        if (this.indexArray != null) {
            l3 = this.indexArray[(int)l2 - 1];
        }
        return l3;
    }

    @Override
    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    @Override
    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = STRUCT.dump(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringValue() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = this.getOracleArray();
            String string = "[";
            for (int i2 = 0; i2 < datumArray.length; ++i2) {
                if (i2 != 0) {
                    string = string + ", ";
                }
                string = datumArray[i2] == null ? string + "null" : string + datumArray[i2].stringValue();
            }
            string = string + "]";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    static void dump(ARRAY aRRAY, PrintWriter printWriter, int n2) throws SQLException {
        int n3;
        if (n2 > 0) {
            printWriter.println();
        }
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("name = " + arrayDescriptor.getName());
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("max length = " + arrayDescriptor.getMaxLength());
        Object[] objectArray = (Object[])aRRAY.getArray();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        int n4 = objectArray.length;
        printWriter.println("length = " + n4);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print(' ');
            }
            printWriter.print("element[" + n3 + "] = ");
            STRUCT.dump(objectArray[n3], printWriter, n2 + 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ARRAY.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.ARRAY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

