/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.jdbc.driver.DMSFactory;
import oracle.net.nt.MetricsEnabledSSLSocketWrapper;

class MetricsEnabledSSLSocketFactoryWrapper
extends SSLSocketFactory {
    NounIntf base;
    NounIntf waitnoun;
    PhaseEventIntf waitEvent;
    SSLSocketFactory factory;

    MetricsEnabledSSLSocketFactoryWrapper() {
        this.factory = null;
    }

    MetricsEnabledSSLSocketFactoryWrapper(SSLSocketFactory sSLSocketFactory, NounIntf nounIntf) {
        this.factory = sSLSocketFactory;
        this.waitEvent = DMSFactory.createPhaseEvent(nounIntf, "DBWaitTime", "Time spent waiting for DB");
        this.waitEvent.deriveMetric(511);
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.factory.createSocket();
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(string, n2);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(inetAddress, n2);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Socket socket = this.factory.createSocket(inetAddress, n2, inetAddress2, n3);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        Socket socket = this.factory.createSocket(string, n2, inetAddress, n3);
        return new MetricsEnabledSSLSocketWrapper(socket, this.waitEvent);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        Socket socket2 = this.factory.createSocket(socket, string, n2, bl);
        return new MetricsEnabledSSLSocketWrapper(socket2, this.waitEvent);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

