/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit;
    protected boolean savedXAConnectionAutoCommit;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection;
    protected OracleXAConnection xaconnection;
    protected int timeout;
    protected String dblink;
    private Connection logicalConnection;
    private String synchronizeBeforeRecoverNewCall;
    private String synchronizeBeforeRecoverOldCall;
    private String recoverySqlRows;
    protected boolean canBeMigratablySuspended;
    private boolean isTMRScanStarted;
    private static final Xid[] NO_XID = new Xid[0];
    Xid lastActiveXid;
    protected Xid activeXid;
    protected Hashtable<Xid, XidListEntry> xidHash;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        block13: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        block19: {
            this.savedConnectionAutoCommit = false;
            this.savedXAConnectionAutoCommit = false;
            this.connection = null;
            this.xaconnection = null;
            this.timeout = 60;
            this.dblink = null;
            this.logicalConnection = null;
            this.synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
            this.synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
            this.recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
            this.canBeMigratablySuspended = false;
            this.isTMRScanStarted = false;
            this.lastActiveXid = null;
            this.activeXid = null;
            this.xidHash = new Hashtable(50);
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(oracleXAConnection));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.connection = connection;
                this.xaconnection = oracleXAConnection;
                if (this.connection != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-7);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnection(Connection connection) throws XAException {
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.connection = connection;
                if (this.connection != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -7);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-7);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry xidListEntry = this.xidHash.get(xid);
        return xidListEntry;
    }

    protected final synchronized boolean removeXidFromList(Xid xid) {
        if (this.isSameXid(this.activeXid, xid)) {
            this.activeXid = null;
        }
        return this.xidHash.remove(xid) != null;
    }

    final boolean isSameXid(Xid xid, Xid xid2) {
        return xid == xid2;
    }

    protected final boolean isOnStack(Xid xid) throws XAException {
        return this.xidHash.containsKey(xid);
    }

    protected final synchronized boolean isXidListEmpty() {
        return this.xidHash.isEmpty();
    }

    protected synchronized void createOrUpdateXid(Xid xid, boolean bl, boolean[] blArray) {
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            blArray[0] = true;
            xidListEntry.isSuspended = bl;
        } else {
            xidListEntry = new XidListEntry(xid, bl);
            this.xidHash.put(xid, xidListEntry);
        }
        if (bl) {
            this.lastActiveXid = this.activeXid;
            this.activeXid = null;
        } else {
            this.enterGlobalTxnMode();
            if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                this.lastActiveXid = null;
            }
            this.activeXid = xidListEntry.xid;
        }
    }

    protected synchronized boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = true;
            blArray[0] = true;
            blArray[1] = xidListEntry.isSuspended;
            if (xidListEntry.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return bl;
    }

    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = xidListEntry.isSuspended;
        }
        return bl;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
            xid2 = this.activeXid;
            if (!this.isXidSuspended(this.activeXid)) {
                this.end(this.activeXid, 0x2000000);
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            }
        }
        return xid2;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.start(xid, 0x8000000);
            this.activeXid = xid;
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Xid[] recover(int n2) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((n2 & 0x1800000) != n2) {
                    if (!TRACE) throw new XAException(-5);
                    if (!OracleLog.recursiveEnter()) throw new XAException(-5);
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        throw new XAException(-5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n2 == 0x1000000) {
                    this.isTMRScanStarted = true;
                } else {
                    if (this.isTMRScanStarted && n2 == 0x800000) {
                        this.isTMRScanStarted = false;
                        Xid[] xidArray = NO_XID;
                        return xidArray;
                    }
                    if (this.isTMRScanStarted && n2 == 0) {
                        Xid[] xidArray = NO_XID;
                        return xidArray;
                    }
                }
                Statement statement = null;
                ResultSet resultSet = null;
                ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
                try {
                    statement = this.connection.createStatement();
                    try {
                        statement.execute(this.synchronizeBeforeRecoverNewCall);
                    }
                    catch (Exception exception) {
                        statement.execute(this.synchronizeBeforeRecoverOldCall);
                    }
                    resultSet = statement.executeQuery(this.recoverySqlRows);
                    while (resultSet.next()) {
                        arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
                    }
                }
                catch (SQLException sQLException) {
                    if (!TRACE) throw new XAException(-3);
                    if (!OracleLog.recursiveEnter()) throw new XAException(-3);
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -3);
                        throw new XAException(-3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                int n3 = arrayList.size();
                Xid[] xidArray = new Xid[n3];
                System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xidArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Xid[] xidArray2 = xidArray;
                return xidArray2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.start(xid, 0x8000000);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.start(xid, 0x200000);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.end(xid, 0x2000000);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.timeout = n2;
            this.start(xid, 0x200000);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.timeout = n2;
            this.start(xid, 0x8000000);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            return connection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.timeout);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.timeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xAResource));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = null;
            if (!(xAResource instanceof OracleXAResource)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            connection = ((OracleXAResource)xAResource).getConnection();
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            String string = ((OracleConnection)this.connection).getURL();
            String string2 = ((OracleConnection)this.connection).getProtocolType();
            if (connection != null) {
                boolean bl;
                boolean bl2 = bl = connection.equals(this.connection) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl3 = bl;
                return bl3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-5);
            }
            this.timeout = n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBLink() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dblink);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.dblink;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDBLink(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.dblink = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalConnection(Connection connection) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.logicalConnection = connection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allowGlobalTxnModeOnly(int n2) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new XAException(n2);
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int n2) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XAException xAException = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2);
            xAException.fillInStackTrace();
            throw xAException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(int n2, int n3) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + n2 + n3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XAException xAException = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2, n3);
            xAException.fillInStackTrace();
            throw xAException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkError(SQLException sQLException, int n2) throws XAException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + sQLException + n2);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        XAException xAException = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), sQLException, n2);
        xAException.fillInStackTrace();
        throw xAException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;

        XidListEntry(Xid xid, boolean bl) {
            this.xid = xid;
            this.isSuspended = bl;
        }
    }
}

