/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.WebRowSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl;

public class OracleWebRowSet
extends OracleCachedRowSet
implements WebRowSet {
    static final long serialVersionUID = 617253792409477080L;
    private transient OracleWebRowSetXmlReader xmlReader;
    private transient OracleWebRowSetXmlWriter xmlWriter;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleWebRowSet() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xmlReader = new OracleWebRowSetXmlReaderImpl();
            this.xmlWriter = new OracleWebRowSetXmlWriterImpl();
            this.setReadOnly(false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readXml(Reader reader) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.xmlReader != null) {
                    this.xmlReader.readXML(this, reader);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 355);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 355);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(Writer writer) throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(writer));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.xmlWriter != null) {
                    this.xmlWriter.writeXML(this, writer);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 356);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 356);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet) + ", " + OracleLog.argument(writer));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.populate(resultSet);
            this.writeXml(writer);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readXml(InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.readXml(new InputStreamReader(inputStream));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(OutputStream outputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(outputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.writeXml(new OutputStreamWriter(outputStream));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet) + ", " + OracleLog.argument(outputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.writeXml(resultSet, new OutputStreamWriter(outputStream));
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleWebRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

