/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheEntry;

public class OraclePooledConnection
implements PooledConnection,
Serializable {
    static final long serialVersionUID = -203725628718322873L;
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String isClearMetaData = "stmt_cache_clear_metadata";
    public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
    public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
    public static final String LoginTimeout = "LoginTimeout";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    private Hashtable eventListeners;
    private SQLException sqlException;
    protected boolean autoCommit;
    private ConnectionEventListener iccEventListener;
    protected transient OracleConnection logicalHandle;
    protected transient OracleConnection physicalConn;
    private Hashtable connectionProperty;
    public Properties cachedConnectionAttributes;
    public Properties unMatchedCachedConnAttr;
    public int closeOption;
    private String pcKey;
    private OracleCloseCallback closeCallback;
    private Object privateData;
    private long lastAccessedTime;
    protected String dataSourceInstanceNameKey;
    protected String dataSourceHostNameKey;
    protected String dataSourceDbUniqNameKey;
    protected boolean connectionMarkedDown;
    protected boolean needToAbort;
    protected transient OracleDriver oracleDriver;
    boolean localTxnCommitOnClose;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraclePooledConnection() {
        block13: {
            this((Connection)null);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraclePooledConnection(String string) throws SQLException {
        this.eventListeners = null;
        this.sqlException = null;
        this.autoCommit = true;
        this.iccEventListener = null;
        this.logicalHandle = null;
        this.physicalConn = null;
        this.connectionProperty = null;
        this.cachedConnectionAttributes = null;
        this.unMatchedCachedConnAttr = null;
        this.closeOption = 0;
        this.pcKey = null;
        this.closeCallback = null;
        this.privateData = null;
        this.lastAccessedTime = 0L;
        this.dataSourceInstanceNameKey = null;
        this.dataSourceHostNameKey = null;
        this.dataSourceDbUniqNameKey = null;
        this.connectionMarkedDown = false;
        this.needToAbort = false;
        this.oracleDriver = new OracleDriver();
        this.localTxnCommitOnClose = false;
        try {
            Connection connection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((connection = this.oracleDriver.connect(string, new Properties())) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.initialize(connection);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraclePooledConnection(String string, String string2, String string3) throws SQLException {
        this.eventListeners = null;
        this.sqlException = null;
        this.autoCommit = true;
        this.iccEventListener = null;
        this.logicalHandle = null;
        this.physicalConn = null;
        this.connectionProperty = null;
        this.cachedConnectionAttributes = null;
        this.unMatchedCachedConnAttr = null;
        this.closeOption = 0;
        this.pcKey = null;
        this.closeCallback = null;
        this.privateData = null;
        this.lastAccessedTime = 0L;
        this.dataSourceInstanceNameKey = null;
        this.dataSourceHostNameKey = null;
        this.dataSourceDbUniqNameKey = null;
        this.connectionMarkedDown = false;
        this.needToAbort = false;
        this.oracleDriver = new OracleDriver();
        this.localTxnCommitOnClose = false;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2) + ", " + OracleLog.argument(string3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties = new Properties();
            properties.put("user", string2);
            properties.put("password", string3);
            Connection connection = this.oracleDriver.connect(string, properties);
            if (connection == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.initialize(connection);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraclePooledConnection(Connection connection) {
        this.eventListeners = null;
        this.sqlException = null;
        this.autoCommit = true;
        this.iccEventListener = null;
        this.logicalHandle = null;
        this.physicalConn = null;
        this.connectionProperty = null;
        this.cachedConnectionAttributes = null;
        this.unMatchedCachedConnAttr = null;
        this.closeOption = 0;
        this.pcKey = null;
        this.closeCallback = null;
        this.privateData = null;
        this.lastAccessedTime = 0L;
        this.dataSourceInstanceNameKey = null;
        this.dataSourceHostNameKey = null;
        this.dataSourceDbUniqNameKey = null;
        this.connectionMarkedDown = false;
        this.needToAbort = false;
        this.oracleDriver = new OracleDriver();
        this.localTxnCommitOnClose = false;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initialize(connection);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraclePooledConnection(Connection connection, boolean bl) {
        this(connection);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.autoCommit = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void initialize(Connection connection) {
        this.physicalConn = (OracleConnection)connection;
        this.eventListeners = new Hashtable(10);
        this.closeCallback = null;
        this.privateData = null;
        this.lastAccessedTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                this.eventListeners.put(connectionEventListener, connectionEventListener);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this.physicalConn, this.privateData);
            }
            if (this.physicalConn != null) {
                try {
                    this.physicalConn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.physicalConn = null;
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
            this.lastAccessedTime = 0L;
            this.iccEventListener = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection getConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn == null) {
                this.sqlException = new SQLException("Physical Connection doesn't exist");
                this.callListener(102);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                if (this.logicalHandle != null) {
                    this.logicalHandle.closeInternal(false);
                }
                this.logicalHandle = (OracleConnection)this.physicalConn.getLogicalConnection(this, this.autoCommit);
            }
            catch (SQLException sQLException) {
                this.sqlException = sQLException;
                this.callListener(102);
                this.callImplicitCacheListener(102);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8 + "OraclePooledConnection.getConnection() - SQLException Ocurred:" + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + sQLException.getMessage());
                sQLException2.fillInStackTrace();
                throw sQLException2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.logicalHandle);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.logicalHandle;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getLogicalHandle() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.logicalHandle);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.logicalHandle;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getPhysicalHandle() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.physicalConn);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.physicalConn;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLastAccessedTime(long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.lastAccessedTime = l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessedTime() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.lastAccessedTime);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.lastAccessedTime;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleCloseCallback) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.closeCallback = oracleCloseCallback;
            this.privateData = object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                this.eventListeners.remove(connectionEventListener);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.iccEventListener != null) {
                this.sqlException = new SQLException("Implicit cache listeneralready registered");
            } else {
                this.iccEventListener = connectionEventListener;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logicalCloseForImplicitConnectionCache() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closeOption == 4096) {
                this.callImplicitCacheListener(102);
            } else {
                this.callImplicitCacheListener(101);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logicalClose() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.cachedConnectionAttributes != null) {
                this.logicalCloseForImplicitConnectionCache();
            } else {
                this.callListener(101);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void callListener(int n2) {
        if (this.eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.eventListeners.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.eventListeners.get(connectionEventListener);
            if (n2 == 101) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            if (n2 != 102) continue;
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }

    private void callImplicitCacheListener(int n2) {
        if (this.iccEventListener == null) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.sqlException);
        switch (n2) {
            case 101: {
                this.iccEventListener.connectionClosed(connectionEvent);
                break;
            }
            case 102: {
                this.iccEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.setStmtCacheSize(n2, false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.physicalConn != null) {
                this.physicalConn.setStmtCacheSize(n2, bl);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getStmtCacheSize() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                int n2 = this.physicalConn.getStmtCacheSize();
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatementCacheSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                this.physicalConn.setStatementCacheSize(n2);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatementCacheSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                int n2 = this.physicalConn.getStatementCacheSize();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = n2;
                return n3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = 0;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                this.physicalConn.setImplicitCachingEnabled(bl);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImplicitCachingEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                boolean bl = this.physicalConn.getImplicitCachingEnabled();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                this.physicalConn.setExplicitCachingEnabled(bl);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExplicitCachingEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                boolean bl = this.physicalConn.getExplicitCachingEnabled();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeImplicitCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeImplicitCache();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeExplicitCache() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeExplicitCache();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                PreparedStatement preparedStatement = this.physicalConn.getStatementWithKey(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + preparedStatement);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                PreparedStatement preparedStatement2 = preparedStatement;
                return preparedStatement2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PreparedStatement preparedStatement = null;
            return preparedStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement getCallWithKey(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                CallableStatement callableStatement = this.physicalConn.getCallWithKey(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + callableStatement);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CallableStatement callableStatement2 = callableStatement;
                return callableStatement2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CallableStatement callableStatement = null;
            return callableStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStatementCacheInitialized() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.physicalConn != null) {
                boolean bl = this.physicalConn.isStatementCacheInitialized();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProperties(Hashtable hashtable) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(hashtable));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connectionProperty = hashtable;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUserName(String string, String string2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument("***"));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.pcKey = OraclePooledConnection.generateKey(string, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    static final String generateKey(String string, String string2) {
        return string.toUpperCase() + string2;
    }

    final OracleConnectionCacheEntry addToImplicitCache(HashMap hashMap, OracleConnectionCacheEntry oracleConnectionCacheEntry) {
        return hashMap.put(this.pcKey, oracleConnectionCacheEntry);
    }

    final OracleConnectionCacheEntry removeFromImplictCache(HashMap hashMap) {
        return (OracleConnectionCacheEntry)hashMap.get(this.pcKey);
    }

    final boolean isSameUser(String string, String string2) {
        return string != null && string2 != null && this.pcKey.equalsIgnoreCase(string + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            this.physicalConn.getPropertyForPooledConnection(this);
            if (this.eventListeners != null) {
                this.connectionProperty.put(event_listener_string, this.eventListeners);
            }
            if (this.sqlException != null) {
                this.connectionProperty.put(sql_exception_string, this.sqlException);
            }
            this.connectionProperty.put(pool_auto_commit_string, "" + this.autoCommit);
            if (this.closeCallback != null) {
                this.connectionProperty.put(close_callback_string, this.closeCallback);
            }
            if (this.privateData != null) {
                this.connectionProperty.put(private_data, this.privateData);
            }
            objectOutputStream.writeObject(this.connectionProperty);
            this.physicalConn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        this.connectionProperty = (Hashtable)objectInputStream.readObject();
        try {
            Properties properties = (Properties)this.connectionProperty.get(connection_properties_string);
            String string = properties.getProperty(url_string);
            this.oracleDriver = new OracleDriver();
            Connection connection = this.oracleDriver.connect(string, properties);
            this.initialize(connection);
            this.eventListeners = (Hashtable)this.connectionProperty.get(event_listener_string);
            this.sqlException = (SQLException)this.connectionProperty.get(sql_exception_string);
            this.autoCommit = ((String)this.connectionProperty.get(pool_auto_commit_string)).equals("true");
            this.closeCallback = (OracleCloseCallback)this.connectionProperty.get(close_callback_string);
            this.privateData = this.connectionProperty.get(private_data);
            Map map = (Map)this.connectionProperty.get(object_type_map);
            if (map != null) {
                ((OracleConnection)connection).setTypeMap(map);
            }
            String string2 = properties.getProperty(transaction_isolation);
            connection.setTransactionIsolation(Integer.parseInt(string2));
            string2 = properties.getProperty(statement_cache_size);
            int n2 = Integer.parseInt(string2);
            if (n2 != -1) {
                this.setStatementCacheSize(n2);
                string2 = properties.getProperty(implicit_caching_enabled);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.setImplicitCachingEnabled(true);
                } else {
                    this.setImplicitCachingEnabled(false);
                }
                string2 = properties.getProperty(explicit_caching_enabled);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.setExplicitCachingEnabled(true);
                } else {
                    this.setExplicitCachingEnabled(false);
                }
            }
            this.physicalConn.setAutoCommit(((String)properties.get(connect_auto_commit_string)).equals("true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(statementEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(statementEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OraclePooledConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OraclePooledConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

