/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.Opaqueable;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.DatumWithConnection;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLSAXSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

final class OracleSQLXML
extends DatumWithConnection
implements SQLXML,
Opaqueable {
    private XMLType xdb;
    private boolean isReadable = false;
    private boolean isWriteable = false;
    private DOMResult domResult = null;
    private XMLSAXSerializer serializer = null;
    private ByteArrayOutputStream oStream = null;
    static final int INITIAL_BUFFER_SIZE = 16384;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleSQLXML(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = false;
        this.isWriteable = true;
    }

    OracleSQLXML(Connection connection, OPAQUE oPAQUE) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = oPAQUE instanceof XMLType ? (XMLType)oPAQUE : new XMLType(oPAQUE.getDescriptor(), (Connection)this.getInternalConnection(), (Object)oPAQUE.getBytesValue());
    }

    OracleSQLXML(OpaqueDescriptor opaqueDescriptor, Connection connection, byte[] byArray) throws SQLException {
        this(connection, new OPAQUE(opaqueDescriptor, byArray, connection));
    }

    OracleSQLXML(Connection connection, InputStream inputStream) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = new XMLType((Connection)this.getInternalConnection(), inputStream);
    }

    OracleSQLXML(Connection connection, XMLType xMLType) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = xMLType;
    }

    @Override
    public OPAQUE toOpaque() throws SQLException {
        return this.getXMLTypeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMLType getXMLTypeInternal() throws SQLException {
        Object object;
        if (this.isWriteable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 260);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 260);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.serializer != null) {
            try {
                this.serializer.flush();
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                this.serializer = null;
            }
        }
        if (this.oStream != null) {
            try {
                this.oStream.close();
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.xdb = XMLType.createXML((Connection)this.getInternalConnection(), (InputStream)new ByteArrayInputStream(this.oStream.toByteArray()));
            this.oStream = null;
        } else if (this.domResult != null) {
            object = this.domResult.getNode();
            Document document = null;
            if (object instanceof Document) {
                document = (Document)object;
            } else {
                document = new XMLDocument();
                object = document.importNode((Node)object, true);
                document.insertBefore((Node)object, null);
            }
            this.xdb = XMLType.createXML((Connection)this.getInternalConnection(), (Document)document);
            this.domResult = null;
        }
        if (this.xdb == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 260);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 260);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        return this.xdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleTo(Class clazz) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJdbc() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleSQLXML oracleSQLXML = this;
            return oracleSQLXML;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object makeJdbcArray(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.isReadable = false;
            this.isWriteable = false;
            this.oStream = null;
            this.domResult = null;
            if (this.xdb != null) {
                this.xdb.close();
            }
            this.xdb = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    InputStream getInputStream() throws SQLException {
        return new ByteArrayInputStream(this.xdb.getStringVal().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isReadable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 261);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isReadable = false;
            InputStream inputStream = this.getInputStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isReadable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 261);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isReadable = false;
            StringReader stringReader = new StringReader(this.xdb.getStringVal());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringReader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringReader stringReader2 = stringReader;
            return stringReader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isReadable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 261);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isReadable = false;
            if (clazz == DOMSource.class) {
                Document document = this.xdb.getDocument();
                DOMSource dOMSource = new DOMSource(document);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dOMSource);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                DOMSource dOMSource2 = dOMSource;
                return (T)dOMSource2;
            }
            if (clazz == SAXSource.class) {
                InputSource inputSource = new InputSource(this.getInputStream());
                SAXSource sAXSource = new SAXSource(inputSource);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sAXSource);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SAXSource sAXSource2 = sAXSource;
                return (T)sAXSource2;
            }
            if (clazz == StAXSource.class) {
                try {
                    XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                    XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(this.getInputStream());
                    StAXSource stAXSource = new StAXSource(xMLStreamReader);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stAXSource);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    StAXSource stAXSource2 = stAXSource;
                    return (T)stAXSource2;
                }
                catch (XMLStreamException xMLStreamException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + xMLStreamException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xMLStreamException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            if (clazz == StreamSource.class) {
                StreamSource streamSource = new StreamSource(this.getInputStream());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + streamSource);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                StreamSource streamSource2 = streamSource;
                return (T)streamSource2;
            }
            this.isReadable = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 264);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 264);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isReadable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 261);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isReadable = false;
            String string = this.xdb.getStringVal();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected OutputStream getOutputStream() throws SQLException {
        if (this.oStream != null) {
            throw new SQLException("Internal Error");
        }
        this.oStream = new ByteArrayOutputStream(16384);
        return this.oStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isWriteable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 262);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isWriteable = false;
            OutputStream outputStream = this.getOutputStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + outputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isWriteable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 262);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isWriteable = false;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + outputStreamWriter);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            return outputStreamWriter2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isWriteable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 262);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isWriteable = false;
            if (clazz == DOMResult.class) {
                this.domResult = new DOMResult();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.domResult);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                DOMResult dOMResult = this.domResult;
                return (T)dOMResult;
            }
            if (clazz == SAXResult.class) {
                this.serializer = new XMLSAXSerializer(this.getOutputStream());
                SAXResult sAXResult = new SAXResult((ContentHandler)this.serializer);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sAXResult);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SAXResult sAXResult2 = sAXResult;
                return (T)sAXResult2;
            }
            if (clazz == StAXResult.class) {
                try {
                    XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
                    StAXResult stAXResult = new StAXResult(xMLOutputFactory.createXMLStreamWriter(this.getOutputStream()));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stAXResult);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    StAXResult stAXResult2 = stAXResult;
                    return (T)stAXResult2;
                }
                catch (XMLStreamException xMLStreamException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + xMLStreamException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xMLStreamException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            if (clazz == StreamResult.class) {
                StreamResult streamResult = new StreamResult(this.getOutputStream());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + streamResult);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                StreamResult streamResult2 = streamResult;
                return (T)streamResult2;
            }
            this.isWriteable = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 263);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 263);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String string) throws SQLException {
        if (!this.isWriteable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLXML.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 262);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isWriteable = false;
        this.xdb = new XMLType((Connection)this.getInternalConnection(), string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleSQLXML"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

